# Engine Information System (EIS) simulation by Bea Wolf (D-ECHO) started 02/2024 based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var EIS_display = nil;
var EIS_main = nil;

var state = 0;
var EIS_volts	= props.globals.getNode("/systems/electrical/outputs/eis", 1);

var torque = props.globals.getNode("engines/engine[0]/thruster/torque", 1);
var itt = props.globals.getNode("engines/engine[0]/itt_degf", 1);
var ng = props.globals.getNode("engines/engine[0]/n1", 1);
var oil_press = props.globals.getNode("engines/engine[0]/oil-pressure-psi", 1);
var oil_temp = props.globals.getNode("engines/engine[0]/oil-temperature-degf", 1);

var rpm = props.globals.getNode("engines/engine[0]/rpm", 1);
var oat_degc = props.globals.getNode("environment/temperature-degc", 1);

var fuel = {
	total:	props.globals.getNode("consumables/fuel/total-fuel-lbs", 1),
	flow:		props.globals.getNode("engines/engine[0]/fuel-flow_pph", 1),
	used:		0.0, # TODO
	tank: [
		props.globals.getNode("consumables/fuel/tank[0]/level-norm", 1),
		props.globals.getNode("consumables/fuel/tank[1]/level-norm", 1),
	],
};

var gen = [
	{
		volts:	props.globals.getNode("engines/engine[0]/amp-v", 1),
		amps:		props.globals.getNode("systems/electrical/gen-load[0]", 1),
	},
	{
		volts:	props.globals.getNode("engines/engine[1]/amp-v", 1),
		amps:		props.globals.getNode("systems/electrical/gen-load[1]", 1),
	},
];

var instrument_dir = "Aircraft/pc-12/Models/Interior/Cockpit/Instruments/EIS/";


var canvas_EIS_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if( family == "'Liberation Sans'" ){
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "7-Segment.ttf";
			}
		};
		
		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});
		
		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}
		
		me.page = canvas_group;
		
		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if( EIS_volts.getDoubleValue() > 21.0 ){
			EIS_main.page.show();
			EIS_main.update();
		} else {
			EIS_main.page.hide();
		}
	},
};


var canvas_EIS_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EIS_main , canvas_EIS_base] };
		m.init(canvas_group, file);
		
		return m;
	},
	getKeys: func() {
		return [ "torque.text", "torque.arc.1", "torque.arc.2", "itt.text", "itt.arc.1", "itt.arc.2", "ng.text", "ng.arc.1", "ng.arc.2", "gen1.dc_a", "gen1.dc_v", "gen2.dc_a", "gen2.dc_v", "rpm", "oat", "fuel_qty", "fuel_flow", "fuel_used", "fuel_left_bar", "fuel_right_bar", "oil_press_bar", "oil_temp_bar",];
	},
	update: func {
		# Torque
		me["torque.text"].setText( sprintf("%4.1f", -torque.getDoubleValue() * 0.006944 ) );
		me["torque.arc.1"].setRotation( math.min( -torque.getDoubleValue() * 0.006944 / 35, 1.0 ) * 110 * D2R );
		me["torque.arc.2"].setRotation( math.clamp( ( -torque.getDoubleValue() * 0.006944 - 35 ) / 35, 0.0, 1.0 ) * 110 * D2R );
		
		# ITT
		var itt_degc = (itt.getDoubleValue() - 32 ) * 5 / 9;
		me["itt.text"].setText( sprintf("%4d", math.round( itt_degc * 0.006944 ) ) );
		me["itt.arc.1"].setRotation( math.clamp( ( itt_degc - 400 ) / 400, 0.0, 1.0 ) * 110 * D2R );
		me["itt.arc.2"].setRotation( math.clamp( ( itt_degc - 800 ) / 400, 0.0, 1.0 ) * 110 * D2R );
		
		# NG
		var ng_val = ng.getDoubleValue();
		me["ng.text"].setText( sprintf("%4.1f", ng_val ) );
		me["ng.arc.1"].setRotation( math.min( ng_val / 60, 1.0 ) * 82.5 * D2R );
		me["ng.arc.2"].setRotation( math.clamp( ( ng_val - 60 ) / 50, 0.0, 1.0 ) * 137.5 * D2R );
		
		# Fuel
		me["fuel_qty"].setText( sprintf("%4d", math.round( fuel.total.getDoubleValue() ) ) );
		me["fuel_flow"].setText( sprintf("%4d", math.round( fuel.flow.getDoubleValue() ) ) );
		
		me["fuel_left_bar"].setRotation( -fuel.tank[0].getDoubleValue() * 40 * D2R );
		me["fuel_right_bar"].setRotation( -fuel.tank[1].getDoubleValue() * 40 * D2R );
		
		me["rpm"].setText( sprintf("%3d", math.round( rpm.getDoubleValue() ) ) );
		me["oat"].setText( sprintf("%3d", math.round( oat_degc.getDoubleValue() ) ) );
		
		# Generators
		me["gen1.dc_a"].setText( sprintf("%3d", math.round( gen[0].amps.getDoubleValue() ) ) );
		me["gen1.dc_v"].setText( sprintf("%3.1f", gen[0].volts.getDoubleValue() ) );
		
		me["gen2.dc_a"].setText( sprintf("%3d", math.round( gen[1].amps.getDoubleValue() ) ) );
		me["gen2.dc_v"].setText( sprintf("%3.1f", gen[1].volts.getDoubleValue() ) );
		
		# Engine Oil
		me["oil_press_bar"].setRotation( -oil_press.getDoubleValue() * 0.2 * D2R );
		me["oil_temp_bar"].setRotation( -( oil_temp.getDoubleValue() - 32 ) * 0.1852 * D2R );
		
	},
	
};

var eis_ls = setlistener("sim/signals/fdm-initialized", func {
	EIS_display = canvas.new({
		"name": "EIS",
		"size": [512, 1024],
		"view": [512, 1024],
		"mipmapping": 1,
	});
	EIS_display.addPlacement({"node": "EIS_display"});
	
	EIS_main	= canvas_EIS_main.new(	EIS_display.createGroup(), instrument_dir~"eis.svg");
	
	var base_update = maketimer( 0.2, func {canvas_EIS_base.update();} );
	base_update.start();
	removelistener(eis_ls);
});
