# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.12.10
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX
DEPS="`/devel/src/tml/latest.sh glib atk cairo pango gettext-runtime gettext-tools`"
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
usemsvs6

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

baseverlen=`expr match $VER '[0-9]*\.[0-9]*\.[0-9]*'`
basever=`expr substr $VER 1 $baseverlen`

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/proxy-libintl/include -I/opt/gnuwin32/include -I/opt/misc/include' LDFLAGS='-L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a -L/opt/gnuwin32/lib -L/opt/misc/lib -Wl,--enable-auto-image-base' LIBS=-lintl CFLAGS=-O2 ./configure --with-gdktarget=win32 --enable-debug=yes --enable-explicit-deps=no --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&
unset MY_PKG_CONFIG_PATH &&
PATH=/devel/target/$HEX/bin:.libs:$PATH make -j3 install &&
PATH=$TARGET/bin:$PATH gdk-pixbuf-query-loaders >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&
grep -v -E 'Automatically generated|Created by|LoaderDir =' <$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&
grep -v -E 'Automatically generated|Created by|ModulesPath =' <$TARGET/etc/gtk-2.0/gtk.immodules >$TARGET/etc/gtk-2.0/gtk.immodules.temp &&
mv $TARGET/etc/gtk-2.0/gtk.immodules.temp $TARGET/etc/gtk-2.0/gtk.immodules &&
./gtk-zip.sh &&

( (
[ $VER != $basever ] && {
mv /tmp/$MOD-$basever.zip /tmp/$MOD-$VER.zip &&
mv /tmp/$MOD-dev-$basever.zip /tmp/$MOD-dev-$VER.zip
}
) || true) &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
