/*
 *  This file is part of the KDE libraries
 *  Copyright (C) 2006 Germain Garand <germain@ebooksfrance.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KJS_AUDIO_H
#define KJS_AUDIO_H

#include "ecma/kjs_binding.h"
#include "ecma/kjs_dom.h"

#include <kjs/object.h>

namespace KJS
{

class AudioConstructorImp : public JSObject
{
public:
    AudioConstructorImp(ExecState *exec, DOM::DocumentImpl *d);
    bool implementsConstruct() const Q_DECL_OVERRIDE;
    using KJS::JSObject::construct;
    JSObject *construct(ExecState *exec, const List &args) Q_DECL_OVERRIDE;
private:
    SharedPtr<DOM::DocumentImpl> doc;
};

} // namespace KJS

#endif
