/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import org.dvb.ui.DVBGraphics;
import org.dvb.ui.DVBGraphicsImpl;
import org.dvb.ui.DVBRasterFormatException;

public class DVBBufferedImage
extends Image {
    public static final int TYPE_ADVANCED = 20;
    public static final int TYPE_BASE = 21;
    private int type = 21;
    private BufferedImage bufferedImage;

    public DVBBufferedImage(int width, int height) {
        this(width, height, 21);
    }

    public DVBBufferedImage(int width, int height, int type) {
        this.type = type;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        this.bufferedImage = gc.createCompatibleImage(width, height);
    }

    private DVBBufferedImage(BufferedImage image, int type) {
        this.type = type;
        this.bufferedImage = image;
    }

    public DVBGraphics createGraphics() {
        DVBGraphicsImpl gfx = new DVBGraphicsImpl(this.bufferedImage.createGraphics());
        gfx.type = this.type;
        return gfx;
    }

    public void dispose() {
        this.bufferedImage = null;
    }

    public void flush() {
        this.bufferedImage.flush();
    }

    public Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public int getHeight(ImageObserver observer) {
        return this.bufferedImage.getHeight(observer);
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    public Object getProperty(String name, ImageObserver observer) {
        return this.bufferedImage.getProperty(name, observer);
    }

    public int getRGB(int x, int y) {
        return this.bufferedImage.getRGB(x, y);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.bufferedImage.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public Image getScaledInstance(int width, int height, int hints) {
        return this.bufferedImage.getScaledInstance(width, height, hints);
    }

    public ImageProducer getSource() {
        return this.bufferedImage.getSource();
    }

    public DVBBufferedImage getSubimage(int x, int y, int w, int h) throws DVBRasterFormatException {
        BufferedImage subImage = this.bufferedImage.getSubimage(x, y, w, h);
        return new DVBBufferedImage(subImage, this.type);
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getWidth(ImageObserver observer) {
        return this.bufferedImage.getWidth(observer);
    }

    public void setRGB(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        this.bufferedImage.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public String toString() {
        return new String("DVBBufferedImage");
    }
}

