
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<h1>
    <fmt:message key="servers.adapter.adding">
        <fmt:param value="${server.name}" />
    </fmt:message>
</h1>

<form method="post">
<table>
    <tr>
        <td align="right"><fmt:message key="servers.adapter.add.name" /></td>
        <spring:bind path="serversAdapterAdd.name">
            <td><input type="text" name="name"
                value="<c:out value="${status.value}"/>"></td>
            <td><font color="red"><c:out
                value="${status.errorMessage}" /></font></td>
        </spring:bind>
    </tr>
    <tr>
        <td align="right"><fmt:message key="servers.adapter.add.type" /></td>
        <spring:bind path="serversAdapterAdd.type">
            <td><select name="type"><option>DVB-S</option><option>DVB-T</option><option>Files-Adapter</option></select></td>
            <td><font color="red"><c:out
                value="${status.errorMessage}" /></font></td>
        </spring:bind>
    </tr>
    <tr>
        <td align="right"><fmt:message key="servers.adapter.add.satellite" /></td>
        <spring:bind path="serversAdapterAdd.satellite">
            <td>
                <select name="satellite">
                    <c:forEach items="${satellites}" var="satellite">
                        <option><c:out value="${satellite.name}" /></option>
                    </c:forEach>
                </select>
            </td>
            <td><font color="red"><c:out
                value="${status.errorMessage}" /></font></td>
        </spring:bind>
    </tr>
</table>
<spring:hasBindErrors name="serversAdapterAdd">
    <b><fmt:message key="servers.adapter.add.error.fix" /></b>
</spring:hasBindErrors>
<br />
<input type="submit" value="<fmt:message key="servers.adapter.add.run" />">
</form>
