/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.welcome;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlFilesChannel;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlTNTChannel;

public class WelcomeFormController
implements Controller {
    private IVlData data;

    public ModelAndView handleRequest(HttpServletRequest arg0, HttpServletResponse arg1) throws Exception {
        HashMap<String, List> params = new HashMap<String, List>();
        ArrayList<VlSatChannel> channelsSat = new ArrayList<VlSatChannel>();
        ArrayList<VlSatChannel> channelsTNT = new ArrayList<VlSatChannel>();
        ArrayList<VlSatChannel> fileChannels = new ArrayList<VlSatChannel>();
        for (IVlMedia media : this.data.getMedias()) {
            VlSatChannel channel;
            if (media.getProgram() == null) continue;
            if (media.getClass().equals(VlSatChannel.class)) {
                channel = (VlSatChannel)media;
                channelsSat.add(channel);
                continue;
            }
            if (media.getClass().equals(VlTNTChannel.class)) {
                channel = (VlTNTChannel)media;
                channelsTNT.add(channel);
                continue;
            }
            if (!media.getClass().equals(VlFilesChannel.class)) continue;
            channel = (VlFilesChannel)media;
            fileChannels.add(channel);
        }
        params.put("channelsSat", channelsSat);
        params.put("channelsTNT", channelsTNT);
        params.put("fileChannels", fileChannels);
        params.put("servers", this.data.getServers());
        return new ModelAndView("welcome/welcome", params);
    }

    public IVlData getData() {
        return this.data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }
}

