/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import java.awt.geom.Point2D;

public class Connection {
    private ArcInst arc;
    private PortInst portInst;
    private Point2D location;
    private short flags;
    private static final int SHRINKAGE = 127;
    private static final int NEGATED = 128;

    protected Connection(ArcInst arc, PortInst portInst, Point2D pt) {
        this.arc = arc;
        this.portInst = portInst;
        this.location = (Point2D)pt.clone();
        this.flags = 0;
    }

    public ArcInst getArc() {
        return this.arc;
    }

    public PortInst getPortInst() {
        return this.portInst;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setLocation(Point2D pt) {
        this.location.setLocation(pt.getX(), pt.getY());
    }

    public int getEndShrink() {
        return this.flags & 0x7F;
    }

    public void setEndShrink(int endShrink) {
        this.flags = (short)(this.flags & 0xFFFFFF80 | endShrink & 0x7F);
    }

    public boolean isNegated() {
        return (this.flags & 0x80) != 0;
    }

    public void setNegated(boolean negated) {
        if (negated) {
            PrimitivePort pp;
            if (this.portInst.getNodeInst().getProto() instanceof PrimitiveNode && (pp = (PrimitivePort)this.portInst.getPortProto()).isNegatable()) {
                this.flags = (short)(this.flags | 0x80);
            }
        } else {
            this.flags = (short)(this.flags & 0xFFFFFF7F);
        }
    }

    public boolean isHeadEnd() {
        return this.arc.getHead() == this;
    }

    public String toString() {
        return "Connection";
    }
}

