/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import [Ljava.lang.Integer;;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DRC
extends Listener {
    public static DRC tool = new DRC();
    private static HashMap prefDRCOverride = new HashMap();
    public static final Variable.Key WIDE_LIMIT = ElectricObject.newKey("DRC_wide_limit");
    public static final Variable.Key MIN_CONNECTED_DISTANCES = ElectricObject.newKey("DRC_min_connected_distances");
    public static final Variable.Key MIN_CONNECTED_DISTANCES_RULE = ElectricObject.newKey("DRC_min_connected_distances_rule");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES = ElectricObject.newKey("DRC_min_unconnected_distances");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES_RULE = ElectricObject.newKey("DRC_min_unconnected_distances_rule");
    public static final Variable.Key MIN_CONNECTED_DISTANCES_WIDE = ElectricObject.newKey("DRC_min_connected_distances_wide");
    public static final Variable.Key MIN_CONNECTED_DISTANCES_WIDE_RULE = ElectricObject.newKey("DRC_min_connected_distances_wide_rule");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES_WIDE = ElectricObject.newKey("DRC_min_unconnected_distances_wide");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES_WIDE_RULE = ElectricObject.newKey("DRC_min_unconnected_distances_wide_rule");
    public static final Variable.Key MIN_CONNECTED_DISTANCES_MULTI = ElectricObject.newKey("DRC_min_connected_distances_multi");
    public static final Variable.Key MIN_CONNECTED_DISTANCES_MULTI_RULE = ElectricObject.newKey("DRC_min_connected_distances_multi_rule");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES_MULTI = ElectricObject.newKey("DRC_min_unconnected_distances_multi");
    public static final Variable.Key MIN_UNCONNECTED_DISTANCES_MULTI_RULE = ElectricObject.newKey("DRC_min_unconnected_distances_multi_rule");
    public static final Variable.Key MIN_EDGE_DISTANCES = ElectricObject.newKey("DRC_min_edge_distances");
    public static final Variable.Key MIN_EDGE_DISTANCES_RULE = ElectricObject.newKey("DRC_min_edge_distances_rule");
    public static final Variable.Key MIN_WIDTH = ElectricObject.newKey("DRC_min_width");
    public static final Variable.Key MIN_WIDTH_RULE = ElectricObject.newKey("DRC_min_width_rule");
    public static final Variable.Key MIN_NODE_SIZE = ElectricObject.newKey("DRC_min_node_size");
    public static final Variable.Key MIN_NODE_SIZE_RULE = ElectricObject.newKey("DRC_min_node_size_rule");
    public static final Variable.Key LAST_GOOD_DRC = ElectricObject.newKey("DRC_last_good_drc");
    private static HashMap cellsToCheck = new HashMap();
    private static boolean incrementalRunning = false;
    private static Rules currentRules = null;
    private static Technology currentTechnology = null;
    private static Pref cacheIncrementalDRCOn = Pref.makeBooleanPref("IncrementalDRCOn", DRC.tool.prefs, true);
    private static Pref cacheOneErrorPerCell = Pref.makeBooleanPref("OneErrorPerCell", DRC.tool.prefs, false);
    private static Pref cacheUseMultipleThreads = Pref.makeBooleanPref("UseMultipleThreads", DRC.tool.prefs, false);
    private static Pref cacheNumberOfThreads = Pref.makeIntPref("NumberOfThreads", DRC.tool.prefs, 2);
    private static Pref cacheIgnoreCenterCuts = Pref.makeBooleanPref("IgnoreCenterCuts", DRC.tool.prefs, false);
    public static final Variable.Key POSTSCRIPT_FILEDATE;

    private DRC() {
        super("drc");
    }

    public void init() {
        this.setOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void includeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet<Geometric> cellSet = (HashSet<Geometric>)cellsToCheck.get(cell);
            if (cellSet == null) {
                cellSet = new HashSet<Geometric>();
                cellsToCheck.put(cell, cellSet);
            }
            cellSet.add(geom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet cellSet = (HashSet)cellsToCheck.get(cell);
            if (cellSet != null) {
                cellSet.remove(geom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalDRCTask() {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        if (incrementalRunning) {
            return;
        }
        Library curLib = Library.getCurrent();
        if (curLib == null) {
            return;
        }
        Cell cellToCheck = curLib.getCurCell();
        HashSet cellSet = null;
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            if (cellToCheck != null) {
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet == null && cellsToCheck.size() > 0) {
                cellToCheck = (Cell)cellsToCheck.keySet().iterator().next();
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet != null) {
                cellsToCheck.remove(cellToCheck);
            }
        }
        if (cellToCheck != null && !cellToCheck.isLinked()) {
            return;
        }
        if (cellSet != null) {
            Geometric[] objectsToCheck = new Geometric[cellSet.size()];
            int i = 0;
            Iterator it = cellSet.iterator();
            while (it.hasNext()) {
                objectsToCheck[i++] = (Geometric)it.next();
            }
            CheckLayoutIncrementally job = new CheckLayoutIncrementally(cellToCheck, objectsToCheck);
        }
    }

    public void endBatch() {
        DRC.doIncrementalDRCTask();
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        DRC.includeGeometric(ni);
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        for (int i = 0; i < nis.length; ++i) {
            DRC.includeGeometric(nis[i]);
        }
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        DRC.includeGeometric(ai);
    }

    public void newObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.includeGeometric((Geometric)obj);
        }
    }

    public void killObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.removeGeometric((Geometric)obj);
        }
    }

    public static void checkHierarchically() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (curCell.getView() == View.SCHEMATIC || curCell.getTechnology() == Schematics.tech) {
            CheckSchematicHierarchically job = new CheckSchematicHierarchically(curCell, false);
        } else {
            CheckLayoutHierarchically checkLayoutHierarchically = new CheckLayoutHierarchically(curCell, false);
        }
    }

    public static void checkAreaHierarchically() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (curCell.getView() == View.SCHEMATIC || curCell.getTechnology() == Schematics.tech) {
            CheckSchematicHierarchically job = new CheckSchematicHierarchically(curCell, true);
        } else {
            CheckLayoutHierarchically checkLayoutHierarchically = new CheckLayoutHierarchically(curCell, true);
        }
    }

    public static void resetDRCDates() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Variable var = cell.getVar(LAST_GOOD_DRC);
                if (var == null) continue;
                cell.delVar(LAST_GOOD_DRC);
            }
        }
    }

    public static Rules getRules(Technology tech) {
        if (currentRules != null && tech == currentTechnology) {
            return currentRules;
        }
        currentRules = tech.getFactoryDesignRules();
        if (currentRules != null) {
            StringBuffer override = DRC.getDRCOverrides(tech);
            DRC.applyDRCOverrides(override.toString(), currentRules, tech);
        }
        currentTechnology = tech;
        return currentRules;
    }

    public static void setRules(Technology tech, Rules newRules) {
        Rules factoryRules = tech.getFactoryDesignRules();
        StringBuffer changes = DRC.getRuleDifferences(tech, factoryRules, newRules);
        StringBuffer override = DRC.getDRCOverrides(tech);
        if (changes.toString().equals(override.toString())) {
            return;
        }
        DRC.setDRCOverrides(changes, tech);
        Variable var = tech.newVar(WIDE_LIMIT, (Object)newRules.wideLimit);
        var = tech.newVar(MIN_CONNECTED_DISTANCES, (Object)newRules.conList);
        if (var != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_CONNECTED_DISTANCES_RULE, (Object)newRules.conListRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES, (Object)newRules.unConList)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES_RULE, (Object)newRules.unConListRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_CONNECTED_DISTANCES_WIDE, (Object)newRules.conListWide)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_CONNECTED_DISTANCES_WIDE_RULE, (Object)newRules.conListWideRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES_WIDE, (Object)newRules.unConListWide)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES_WIDE_RULE, (Object)newRules.unConListWideRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_CONNECTED_DISTANCES_MULTI, (Object)newRules.conListMulti)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_CONNECTED_DISTANCES_MULTI_RULE, (Object)newRules.conListMultiRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES_MULTI, (Object)newRules.unConListMulti)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_UNCONNECTED_DISTANCES_MULTI_RULE, (Object)newRules.unConListMultiRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_EDGE_DISTANCES, (Object)newRules.edgeList)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_EDGE_DISTANCES_RULE, (Object)newRules.edgeListRules)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_WIDTH, (Object)newRules.minWidth)) != null) {
            var.setDontSave();
        }
        if ((var = tech.newVar(MIN_WIDTH_RULE, (Object)newRules.minWidthRules)) != null) {
            var.setDontSave();
        }
        int j = 0;
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            np.setMinSize(newRules.minNodeSize[j * 2], newRules.minNodeSize[j * 2 + 1], newRules.minNodeSizeRules[j]);
            ++j;
        }
        if (currentTechnology == tech) {
            currentTechnology = null;
        }
    }

    public static Rules makeSimpleRules(Technology tech, double[] conDist, double[] unConDist) {
        int i;
        Rules rules = new Rules(tech);
        if (conDist != null) {
            for (i = 0; i < conDist.length; ++i) {
                rules.conList[i] = new Double(conDist[i]);
            }
        }
        if (unConDist != null) {
            for (i = 0; i < unConDist.length; ++i) {
                rules.unConList[i] = new Double(unConDist[i]);
            }
        }
        return rules;
    }

    public static double getWorstSpacingDistance(Technology tech) {
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        double worstInteractionDistance = 0.0;
        for (int i = 0; i < rules.uTSize; ++i) {
            double dist = rules.unConList[i];
            if (dist > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if ((dist = rules.unConListWide[i].doubleValue()) > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if (!((dist = rules.unConListMulti[i].doubleValue()) > worstInteractionDistance)) continue;
            worstInteractionDistance = dist;
        }
        return worstInteractionDistance;
    }

    public static double getMaxSurround(Layer layer) {
        Technology tech = layer.getTechnology();
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        double worstLayerRule = -1.0;
        int layerIndex = layer.getIndex();
        int tot = tech.getNumLayers();
        for (int i = 0; i < tot; ++i) {
            int pIndex = DRC.getIndex(tech, layerIndex, i);
            double dist = rules.unConList[pIndex];
            if (!(dist > worstLayerRule)) continue;
            worstLayerRule = dist;
        }
        return worstLayerRule;
    }

    public static Rule getEdgeRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        int pIndex = DRC.getIndex(tech, layer1.getIndex(), layer2.getIndex());
        double dist = rules.edgeList[pIndex];
        if (dist < 0.0) {
            return null;
        }
        return new Rule(dist, rules.edgeListRules[pIndex]);
    }

    public static double getWideLimit(Technology tech) {
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        return rules.wideLimit;
    }

    public static Rule getSpacingRule(Layer layer1, Layer layer2, boolean connected, boolean wide, boolean multiCut) {
        double dist;
        Technology tech = layer1.getTechnology();
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        int pIndex = DRC.getIndex(tech, layer1.getIndex(), layer2.getIndex());
        double bestDist = -1.0;
        String rule = null;
        if (connected) {
            dist = rules.conList[pIndex];
            if (dist >= 0.0) {
                bestDist = dist;
                rule = rules.conListRules[pIndex];
            }
        } else {
            dist = rules.unConList[pIndex];
            if (dist >= 0.0) {
                bestDist = dist;
                rule = rules.unConListRules[pIndex];
            }
        }
        if (wide) {
            if (connected) {
                dist = rules.conListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = rules.conListWideRules[pIndex];
                }
            } else {
                dist = rules.unConListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = rules.unConListWideRules[pIndex];
                }
            }
        }
        if (multiCut) {
            if (connected) {
                dist = rules.conListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = rules.conListMultiRules[pIndex];
                }
            } else {
                dist = rules.unConListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist = dist;
                    rule = rules.unConListMultiRules[pIndex];
                }
            }
        }
        if (bestDist < 0.0) {
            return null;
        }
        return new Rule(bestDist, rule);
    }

    public static boolean isAnyRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        int pIndex = DRC.getIndex(tech, layer1.getIndex(), layer2.getIndex());
        if (rules.conList[pIndex] >= 0.0) {
            return true;
        }
        if (rules.unConList[pIndex] >= 0.0) {
            return true;
        }
        if (rules.conListWide[pIndex] >= 0.0) {
            return true;
        }
        if (rules.unConListWide[pIndex] >= 0.0) {
            return true;
        }
        if (rules.conListMulti[pIndex] >= 0.0) {
            return true;
        }
        if (rules.unConListMulti[pIndex] >= 0.0) {
            return true;
        }
        return rules.edgeList[pIndex] >= 0.0;
    }

    public static Rule getMinWidth(Layer layer) {
        Technology tech = layer.getTechnology();
        Rules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        int index = layer.getIndex();
        double dist = rules.minWidth[index];
        if (dist < 0.0) {
            return null;
        }
        return new Rule(dist, rules.minWidthRules[index]);
    }

    public static NodeSizeRule getMinSize(NodeProto np) {
        if (np instanceof Cell) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        if (pnp.getMinWidth() < 0.0 && pnp.getMinHeight() < 0.0) {
            return null;
        }
        return new NodeSizeRule(pnp.getMinWidth(), pnp.getMinHeight(), pnp.getMinSizeRule());
    }

    private static StringBuffer getDRCOverrides(Technology tech) {
        Pref pref = (Pref)prefDRCOverride.get(tech);
        if (pref == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pref.getString());
        return sb;
    }

    private static void setDRCOverrides(StringBuffer sb, Technology tech) {
        Pref pref;
        if (sb.length() >= 8192) {
            System.out.println("Warning: Design rule overrides are too complex to be saved (are " + sb.length() + " long which is more than the limit of " + 8192 + ")");
        }
        if ((pref = (Pref)prefDRCOverride.get(tech)) == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        pref.setString(sb.toString());
    }

    private static int getIndex(Technology tech, int layer1Index, int layer2Index) {
        if (layer1Index > layer2Index) {
            int temp = layer1Index;
            layer1Index = layer2Index;
            layer2Index = temp;
        }
        int pIndex = (layer1Index + 1) * (layer1Index / 2) + (layer1Index & 1) * ((layer1Index + 1) / 2);
        pIndex = layer2Index + tech.getNumLayers() * layer1Index - pIndex;
        return pIndex;
    }

    private static StringBuffer getRuleDifferences(Technology tech, Rules origRules, Rules newRules) {
        StringBuffer changes = new StringBuffer();
        if (!newRules.wideLimit.equals(origRules.wideLimit)) {
            changes.append("w:" + newRules.wideLimit + ";");
        }
        for (int l1 = 0; l1 < tech.getNumLayers(); ++l1) {
            for (int l2 = 0; l2 <= l1; ++l2) {
                int i = DRC.getIndex(tech, l2, l1);
                if (!newRules.conList[i].equals(origRules.conList[i])) {
                    changes.append("c:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conList[i] + ";");
                }
                if (!newRules.conListRules[i].equals(origRules.conListRules[i])) {
                    changes.append("cr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conListRules[i] + ";");
                }
                if (!newRules.unConList[i].equals(origRules.unConList[i])) {
                    changes.append("u:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConList[i] + ";");
                }
                if (!newRules.unConListRules[i].equals(origRules.unConListRules[i])) {
                    changes.append("ur:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConListRules[i] + ";");
                }
                if (!newRules.conListWide[i].equals(origRules.conListWide[i])) {
                    changes.append("cw:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conListWide[i] + ";");
                }
                if (!newRules.conListWideRules[i].equals(origRules.conListWideRules[i])) {
                    changes.append("cwr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conListWideRules[i] + ";");
                }
                if (!newRules.unConListWide[i].equals(origRules.unConListWide[i])) {
                    changes.append("uw:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConListWide[i] + ";");
                }
                if (!newRules.unConListWideRules[i].equals(origRules.unConListWideRules[i])) {
                    changes.append("uwr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConListWideRules[i] + ";");
                }
                if (!newRules.conListMulti[i].equals(origRules.conListMulti[i])) {
                    changes.append("cm:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conListMulti[i] + ";");
                }
                if (!newRules.conListMultiRules[i].equals(origRules.conListMultiRules[i])) {
                    changes.append("cmr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.conListMultiRules[i] + ";");
                }
                if (!newRules.unConListMulti[i].equals(origRules.unConListMulti[i])) {
                    changes.append("um:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConListMulti[i] + ";");
                }
                if (!newRules.unConListMultiRules[i].equals(origRules.unConListMultiRules[i])) {
                    changes.append("umr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.unConListMultiRules[i] + ";");
                }
                if (!newRules.edgeList[i].equals(origRules.edgeList[i])) {
                    changes.append("e:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.edgeList[i] + ";");
                }
                if (newRules.edgeListRules[i].equals(origRules.edgeListRules[i])) continue;
                changes.append("er:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + newRules.edgeListRules[i] + ";");
            }
        }
        for (int i = 0; i < newRules.numLayers; ++i) {
            if (!newRules.minWidth[i].equals(origRules.minWidth[i])) {
                changes.append("m:" + tech.getLayer(i).getName() + "=" + newRules.minWidth[i] + ";");
            }
            if (newRules.minWidthRules[i].equals(origRules.minWidthRules[i])) continue;
            changes.append("mr:" + tech.getLayer(i).getName() + "=" + newRules.minWidthRules[i] + ";");
        }
        int j = 0;
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (!newRules.minNodeSize[j * 2].equals(origRules.minNodeSize[j * 2]) || !newRules.minNodeSize[j * 2 + 1].equals(origRules.minNodeSize[j * 2 + 1])) {
                changes.append("n:" + np.getName() + "=" + newRules.minNodeSize[j * 2] + "/" + newRules.minNodeSize[j * 2 + 1] + ";");
            }
            if (!newRules.minNodeSizeRules[j].equals(origRules.minNodeSizeRules[j])) {
                changes.append("nr:" + np.getName() + "=" + newRules.minNodeSizeRules[j] + ";");
            }
            ++j;
        }
        return changes;
    }

    private static void applyDRCOverrides(String override, Rules rules, Technology tech) {
        int startKey;
        int endKey;
        int pos = 0;
        int len = override.length();
        while (pos < len && (endKey = override.indexOf(58, startKey = pos)) >= 0) {
            int index;
            String key = override.substring(startKey, endKey);
            if (key.equals("c") || key.equals("cr") || key.equals("u") || key.equals("ur") || key.equals("cw") || key.equals("cwr") || key.equals("uw") || key.equals("uwr") || key.equals("cm") || key.equals("cmr") || key.equals("um") || key.equals("umr") || key.equals("e") || key.equals("er")) {
                Layer layer2;
                startKey = endKey + 1;
                Layer layer1 = DRC.getLayerFromOverride(override, startKey, '/', tech);
                if (layer1 == null || (startKey = override.indexOf(47, startKey)) < 0 || (layer2 = DRC.getLayerFromOverride(override, startKey + 1, '=', tech)) == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                index = DRC.getIndex(tech, layer1.getIndex(), layer2.getIndex());
                if (key.equals("c")) {
                    rules.conList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cr")) {
                    rules.conListRules[index] = newValue;
                } else if (key.equals("u")) {
                    rules.unConList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("ur")) {
                    rules.unConListRules[index] = newValue;
                } else if (key.equals("cw")) {
                    rules.conListWide[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cwr")) {
                    rules.conListWideRules[index] = newValue;
                } else if (key.equals("uw")) {
                    rules.unConListWide[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("uwr")) {
                    rules.unConListWideRules[index] = newValue;
                } else if (key.equals("cm")) {
                    rules.conListMulti[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("cmr")) {
                    rules.conListMultiRules[index] = newValue;
                } else if (key.equals("um")) {
                    rules.unConListMulti[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("umr")) {
                    rules.unConListMultiRules[index] = newValue;
                } else if (key.equals("e")) {
                    rules.edgeList[index] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("er")) {
                    rules.edgeListRules[index] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("m") || key.equals("mr")) {
                startKey = endKey + 1;
                Layer layer = DRC.getLayerFromOverride(override, startKey, '=', tech);
                if (layer == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                int index2 = layer.getIndex();
                if (key.equals("m")) {
                    rules.minWidth[index2] = new Double(TextUtils.atof(newValue));
                } else if (key.equals("mr")) {
                    rules.minWidthRules[index2] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("n") || key.equals("nr")) {
                PrimitiveNode oNp;
                String nodeName;
                PrimitiveNode np;
                startKey = endKey + 1;
                int endPos = override.indexOf(61, startKey);
                if (endPos < 0 || (np = tech.findNodeProto(nodeName = override.substring(startKey, endPos))) == null) break;
                index = 0;
                Iterator it = tech.getNodes();
                while (it.hasNext() && (oNp = (PrimitiveNode)it.next()) != np) {
                    ++index;
                }
                if (key.equals("n")) {
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(47, startKey)) < 0) break;
                    String newValue1 = override.substring(startKey + 1, endKey);
                    int otherEndKey = override.indexOf(59, startKey);
                    if (otherEndKey < 0) break;
                    String newValue2 = override.substring(endKey + 1, otherEndKey);
                    rules.minNodeSize[index * 2] = new Double(TextUtils.atof(newValue1));
                    rules.minNodeSize[index * 2 + 1] = new Double(TextUtils.atof(newValue2));
                } else if (key.equals("nr")) {
                    String newValue;
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                    rules.minNodeSizeRules[index] = newValue = override.substring(startKey + 1, endKey);
                }
                pos = endKey + 1;
                continue;
            }
            if (!key.equals("w")) continue;
            startKey = endKey + 1;
            if ((endKey = override.indexOf(59, startKey)) < 0) break;
            String newValue = override.substring(startKey, endKey);
            rules.wideLimit = new Double(TextUtils.atof(newValue));
            pos = endKey + 1;
        }
    }

    private static Layer getLayerFromOverride(String override, int startPos, char endChr, Technology tech) {
        int endPos = override.indexOf(endChr, startPos);
        if (endPos < 0) {
            return null;
        }
        String layerName = override.substring(startPos, endPos);
        Layer layer = tech.findLayer(layerName);
        return layer;
    }

    public static boolean isIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBoolean();
    }

    public static void setIncrementalDRCOn(boolean on) {
        cacheIncrementalDRCOn.setBoolean(on);
    }

    public static boolean isOneErrorPerCell() {
        return cacheOneErrorPerCell.getBoolean();
    }

    public static void setOneErrorPerCell(boolean on) {
        cacheOneErrorPerCell.setBoolean(on);
    }

    public static boolean isUseMultipleThreads() {
        return cacheUseMultipleThreads.getBoolean();
    }

    public static void setUseMultipleThreads(boolean on) {
        cacheUseMultipleThreads.setBoolean(on);
    }

    public static int getNumberOfThreads() {
        return cacheNumberOfThreads.getInt();
    }

    public static void setNumberOfThreads(int th) {
        cacheNumberOfThreads.setInt(th);
    }

    public static boolean isIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBoolean();
    }

    public static void setIgnoreCenterCuts(boolean on) {
        cacheIgnoreCenterCuts.setBoolean(on);
    }

    public static Date getLastDRCDate(Cell cell) {
        Variable varDate = cell.getVar(LAST_GOOD_DRC, Integer;.class);
        if (varDate == null) {
            return null;
        }
        Integer[] lastDRCDateAsInts = (Integer[])varDate.getObject();
        long lastDRCDateInSecondsHigh = lastDRCDateAsInts[0].intValue();
        long lastDRCDateInSecondsLow = lastDRCDateAsInts[1].intValue();
        long lastDRCDateInSeconds = lastDRCDateInSecondsHigh << 32 | lastDRCDateInSecondsLow & 0xFFFFFFFFL;
        Date lastDRCDate = new Date(lastDRCDateInSeconds);
        return lastDRCDate;
    }

    public static void setLastDRCDate(Cell cell, Date date) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        cell.newVar(LAST_GOOD_DRC, (Object)dateArray);
    }

    static {
        cacheIgnoreCenterCuts.attachToObject(tool, "Tools/DRC tab", "DRC ignores center cuts in large contacts");
        POSTSCRIPT_FILEDATE = ElectricObject.newKey("IO_postscript_filedate");
    }

    private static class CheckSchematicHierarchically
    extends Job {
        Cell cell;
        boolean justArea;

        protected CheckSchematicHierarchically(Cell cell, boolean justArea) {
            super("Design-Rule Check", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.justArea = justArea;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            Schematic.doCheck(this.cell);
            long endTime = System.currentTimeMillis();
            int errorcount = ErrorLogger.getCurrent().numErrors();
            System.out.println(errorcount + " errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    private static class CheckLayoutHierarchically
    extends Job {
        Cell cell;
        boolean justArea;

        protected CheckLayoutHierarchically(Cell cell, boolean justArea) {
            super("Design-Rule Check", tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.justArea = justArea;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            int errorsFound = Quick.checkDesignRules(this.cell, 0, null, null, this.justArea);
            long endTime = System.currentTimeMillis();
            System.out.println(errorsFound + " errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    private static class CheckLayoutIncrementally
    extends Job {
        Cell cell;
        Geometric[] objectsToCheck;

        protected CheckLayoutIncrementally(Cell cell, Geometric[] objectsToCheck) {
            super("DRC in cell " + cell.describe(), tool, Job.Type.EXAMINE, null, null, Job.Priority.ANALYSIS);
            this.cell = cell;
            this.objectsToCheck = objectsToCheck;
            this.startJob();
        }

        public boolean doIt() {
            incrementalRunning = true;
            long startTime = System.currentTimeMillis();
            int errorsFound = Quick.checkDesignRules(this.cell, this.objectsToCheck.length, this.objectsToCheck, null, false);
            long endTime = System.currentTimeMillis();
            if (errorsFound > 0) {
                System.out.println("Incremental DRC found " + errorsFound + " errors in cell " + this.cell.describe());
            }
            incrementalRunning = false;
            DRC.doIncrementalDRCTask();
            return true;
        }
    }

    public static class NodeSizeRule {
        public double sizeX;
        public double sizeY;
        public String rule;

        NodeSizeRule(double sizeX, double sizeY, String rule) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.rule = rule;
        }
    }

    public static class Rule {
        public double distance;
        public String rule;

        Rule(double distance, String rule) {
            this.distance = distance;
            this.rule = rule;
        }
    }

    public static class Rules {
        public String techName;
        public int numLayers;
        public int uTSize;
        public Double wideLimit;
        public String[] layerNames;
        public Double[] minWidth;
        public String[] minWidthRules;
        public Double[] conList;
        public String[] conListRules;
        public Double[] unConList;
        public String[] unConListRules;
        public Double[] conListWide;
        public String[] conListWideRules;
        public Double[] unConListWide;
        public String[] unConListWideRules;
        public Double[] conListMulti;
        public String[] conListMultiRules;
        public Double[] unConListMulti;
        public String[] unConListMultiRules;
        public Double[] edgeList;
        public String[] edgeListRules;
        public int numNodes;
        public String[] nodeNames;
        public Double[] minNodeSize;
        public String[] minNodeSizeRules;

        public Rules() {
        }

        public Rules(Technology tech) {
            int i;
            PrimitiveNode np;
            this.numLayers = tech.getNumLayers();
            this.numNodes = tech.getNumNodes();
            this.uTSize = (this.numLayers * this.numLayers + this.numLayers) / 2;
            this.wideLimit = new Double(0.0);
            this.techName = tech.getTechName();
            this.layerNames = new String[this.numLayers];
            int j = 0;
            Iterator it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                this.layerNames[j++] = layer.getName();
            }
            this.nodeNames = new String[this.numNodes];
            j = 0;
            it = tech.getNodes();
            while (it.hasNext()) {
                np = (PrimitiveNode)it.next();
                this.nodeNames[j++] = np.getName();
            }
            this.conList = new Double[this.uTSize];
            this.conListRules = new String[this.uTSize];
            this.unConList = new Double[this.uTSize];
            this.unConListRules = new String[this.uTSize];
            this.conListWide = new Double[this.uTSize];
            this.conListWideRules = new String[this.uTSize];
            this.unConListWide = new Double[this.uTSize];
            this.unConListWideRules = new String[this.uTSize];
            this.conListMulti = new Double[this.uTSize];
            this.conListMultiRules = new String[this.uTSize];
            this.unConListMulti = new Double[this.uTSize];
            this.unConListMultiRules = new String[this.uTSize];
            this.edgeList = new Double[this.uTSize];
            this.edgeListRules = new String[this.uTSize];
            this.minWidth = new Double[this.numLayers];
            this.minWidthRules = new String[this.numLayers];
            for (i = 0; i < this.uTSize; ++i) {
                this.conList[i] = new Double(-1.0);
                this.conListRules[i] = "";
                this.unConList[i] = new Double(-1.0);
                this.unConListRules[i] = "";
                this.conListWide[i] = new Double(-1.0);
                this.conListWideRules[i] = "";
                this.unConListWide[i] = new Double(-1.0);
                this.unConListWideRules[i] = "";
                this.conListMulti[i] = new Double(-1.0);
                this.conListMultiRules[i] = "";
                this.unConListMulti[i] = new Double(-1.0);
                this.unConListMultiRules[i] = "";
                this.edgeList[i] = new Double(-1.0);
                this.edgeListRules[i] = "";
            }
            for (i = 0; i < this.numLayers; ++i) {
                this.minWidth[i] = new Double(-1.0);
                this.minWidthRules[i] = "";
            }
            this.minNodeSize = new Double[this.numNodes * 2];
            this.minNodeSizeRules = new String[this.numNodes];
            j = 0;
            it = tech.getNodes();
            while (it.hasNext()) {
                np = (PrimitiveNode)it.next();
                this.minNodeSize[j * 2] = new Double(np.getMinWidth());
                this.minNodeSize[j * 2 + 1] = new Double(np.getMinHeight());
                this.minNodeSizeRules[j] = np.getMinSizeRule();
                ++j;
            }
        }
    }
}

