/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.logicaleffort.LEInst;
import java.util.HashMap;
import java.util.Map;

class GenerateLayoutForGatesInSchematic
extends HierarchyEnumerator.Visitor {
    private final StdCellParams stdCell;
    private final boolean DEBUG = false;
    private final boolean topLevelOnly;
    private Map<Nodable, Cell> generatedCells;

    private void trace(String s) {
    }

    private void traceln(String s) {
        this.trace(s);
        this.trace("\n");
    }

    public GenerateLayoutForGatesInSchematic(StdCellParams stdCell, boolean topLevelOnly) {
        this.stdCell = stdCell;
        this.topLevelOnly = topLevelOnly;
        this.generatedCells = new HashMap<Nodable, Cell>();
    }

    private static double getStrength(Nodable no, VarContext context) {
        Variable var = no.getVar(Tech.ATTR_X);
        if (var == null) {
            return -1.0;
        }
        Object val = context.evalVar(var, no);
        if (val == null) {
            return -2.0;
        }
        LayoutLib.error(!(val instanceof Number), "strength not number?");
        return ((Number)val).doubleValue();
    }

    private Cell generateCell(Nodable iconInst, HierarchyEnumerator.CellInfo info) {
        Cell c;
        VarContext context = info.getContext();
        String pNm = iconInst.getProto().getName();
        double x = GenerateLayoutForGatesInSchematic.getStrength(iconInst, context);
        if (x == -2.0) {
            System.out.println("no value for strength attribute for Cell: " + pNm + " instance: " + info.getUniqueNodableName(iconInst, "/"));
        }
        if ((c = GateLayoutGenerator.generateCell(this.stdCell.getOutputLibrary(), this.stdCell, pNm, x)) != null) {
            if (LEInst.getType(iconInst, context) == LEInst.Type.LEGATE) {
                c.newVar(LEInst.ATTR_LEGATE, (Object)c.libDescribe());
            }
            if (LEInst.getType(iconInst, context) == LEInst.Type.LEKEEPER) {
                c.newVar(LEInst.ATTR_LEKEEPER, (Object)c.libDescribe());
            }
            System.out.println("Use: " + pNm + " X=" + x + " for instance: " + info.getUniqueNodableName(iconInst, "/"));
        }
        return c;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        VarContext ctxt = info.getContext();
        this.traceln("Entering Cell instance: " + ctxt.getInstPath("/"));
        return true;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        VarContext ctxt = info.getContext();
        this.traceln("Leaving Cell instance: " + ctxt.getInstPath("/"));
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        if (no instanceof NodeInst) {
            return false;
        }
        this.trace("considering instance: " + info.getUniqueNodableName(no, "/") + " ... ");
        Cell cell = (Cell)no.getProto();
        Library lib = cell.getLibrary();
        String libNm = lib.getName();
        if (libNm.equals("redFour") || libNm.equals("purpleFour") || libNm.equals("power2_gates")) {
            this.traceln("generate");
            Cell c = this.generateCell(no, info);
            if (c != null) {
                this.generatedCells.put(no, c);
            }
            return false;
        }
        this.traceln("descend");
        return !this.topLevelOnly;
    }

    public Map<Nodable, Cell> getGeneratedCells() {
        return this.generatedCells;
    }
}

