/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class PrintingTab
extends PreferencePanel {
    private Cell initialCell;
    private double initialEPSScale;
    private String initialEPSSyncFile;
    private JLabel jLabel1;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JLabel printCellName;
    private JTextField printEPSScale;
    private JLabel printEPSScaleLabel;
    private JCheckBox printEncapsulated;
    private JTextField printHeight;
    private JTextField printLineWidth;
    private JTextField printMargin;
    private JCheckBox printPlotDateInCorner;
    private JRadioButton printPlotDisplayedWindow;
    private JRadioButton printPlotEntireCell;
    private JRadioButton printPlotHighlightedArea;
    private JComboBox printPostScriptStyle;
    private JTextField printResolution;
    private JComboBox printRotation;
    private JButton printSetEPSSync;
    private JTextField printSyncFileName;
    private JLabel printSynchLabel;
    private JRadioButton printUsePlotter;
    private JRadioButton printUsePrinter;
    private JTextField printWidth;
    private JPanel printing;
    private ButtonGroup printingPlotArea;
    private ButtonGroup printingPlotOrPrint;

    public PrintingTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getPanel() {
        return this.printing;
    }

    @Override
    public String getName() {
        return "Printing";
    }

    @Override
    public void init() {
        switch (IOTool.getPlotArea()) {
            case 0: {
                this.printPlotEntireCell.setSelected(true);
                break;
            }
            case 1: {
                this.printPlotHighlightedArea.setSelected(true);
                break;
            }
            case 2: {
                this.printPlotDisplayedWindow.setSelected(true);
            }
        }
        this.printResolution.setText(Integer.toString(IOTool.getPrintResolution()));
        this.printEncapsulated.setSelected(IOTool.isPrintEncapsulated());
        this.printPlotDateInCorner.setSelected(IOTool.isPlotDate());
        if (IOTool.isPrintForPlotter()) {
            this.printUsePlotter.setSelected(true);
        } else {
            this.printUsePrinter.setSelected(true);
        }
        this.printWidth.setText(TextUtils.formatDouble(IOTool.getPrintWidth()));
        this.printHeight.setText(TextUtils.formatDouble(IOTool.getPrintHeight()));
        this.printMargin.setText(TextUtils.formatDouble(IOTool.getPrintMargin()));
        this.printLineWidth.setText(TextUtils.formatDouble(IOTool.getPrintPSLineWidth()));
        this.printRotation.addItem("No Rotation");
        this.printRotation.addItem("Rotate plot 90 degrees");
        this.printRotation.addItem("Auto-rotate plot to fit");
        this.printRotation.setSelectedIndex(IOTool.getPrintRotation());
        this.printPostScriptStyle.addItem("Black&White");
        this.printPostScriptStyle.addItem("Color");
        this.printPostScriptStyle.addItem("Color Stippled");
        this.printPostScriptStyle.addItem("Color Merged");
        this.printPostScriptStyle.setSelectedIndex(IOTool.getPrintColorMethod());
        this.initialCell = WindowFrame.getCurrentCell();
        this.initialEPSScale = 1.0;
        this.initialEPSSyncFile = "";
        if (this.initialCell != null) {
            this.printCellName.setText("For: " + this.initialCell);
            this.initialEPSScale = IOTool.getPrintEPSScale(this.initialCell);
            this.initialEPSSyncFile = IOTool.getPrintEPSSynchronizeFile(this.initialCell);
            this.printSyncFileName.setText(this.initialEPSSyncFile);
            this.printSetEPSSync.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintingTab.this.printSetEPSSyncActionPerformed();
                }
            });
        } else {
            this.printCellName.setEnabled(false);
            this.printEPSScaleLabel.setEnabled(false);
            this.printEPSScale.setEditable(false);
            this.printSynchLabel.setEnabled(false);
            this.printSyncFileName.setEditable(false);
            this.printSetEPSSync.setEnabled(false);
        }
        this.printEPSScale.setText(TextUtils.formatDouble(this.initialEPSScale));
    }

    private void printSetEPSSyncActionPerformed() {
        String defaultFileName = this.initialCell.getName() + ".eps";
        String fileName = OpenFile.chooseOutputFile(FileType.POSTSCRIPT, "Choose EPS file", defaultFileName);
        if (fileName == null) {
            return;
        }
        this.printSyncFileName.setText(fileName);
    }

    @Override
    public void term() {
        double currDouble;
        boolean currBoolean;
        int currInt = 0;
        if (this.printPlotHighlightedArea.isSelected()) {
            currInt = 1;
        } else if (this.printPlotDisplayedWindow.isSelected()) {
            currInt = 2;
        }
        if (currInt != IOTool.getPlotArea()) {
            IOTool.setPlotArea(currInt);
        }
        if ((currInt = TextUtils.atoi(this.printResolution.getText())) != IOTool.getPrintResolution()) {
            IOTool.setPrintResolution(currInt);
        }
        if ((currBoolean = this.printPlotDateInCorner.isSelected()) != IOTool.isPlotDate()) {
            IOTool.setPlotDate(currBoolean);
        }
        if ((currBoolean = this.printEncapsulated.isSelected()) != IOTool.isPrintEncapsulated()) {
            IOTool.setPrintEncapsulated(currBoolean);
        }
        if ((currBoolean = this.printUsePlotter.isSelected()) != IOTool.isPrintForPlotter()) {
            IOTool.setPrintForPlotter(currBoolean);
        }
        if ((currDouble = TextUtils.atof(this.printWidth.getText())) != IOTool.getPrintWidth()) {
            IOTool.setPrintWidth(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.printHeight.getText())) != IOTool.getPrintHeight()) {
            IOTool.setPrintHeight(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.printMargin.getText())) != IOTool.getPrintMargin()) {
            IOTool.setPrintMargin(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.printLineWidth.getText())) != IOTool.getPrintPSLineWidth()) {
            IOTool.setPrintPSLineWidth(currDouble);
        }
        if ((currInt = this.printRotation.getSelectedIndex()) != IOTool.getPrintRotation()) {
            IOTool.setPrintRotation(currInt);
        }
        if ((currInt = this.printPostScriptStyle.getSelectedIndex()) != IOTool.getPrintColorMethod()) {
            IOTool.setPrintColorMethod(currInt);
        }
        if (this.initialCell != null) {
            String currentEPSSyncFile;
            currDouble = TextUtils.atof(this.printEPSScale.getText());
            if (currDouble != this.initialEPSScale && currDouble != 0.0) {
                IOTool.setPrintEPSScale(this.initialCell, currDouble);
            }
            if (!(currentEPSSyncFile = this.printSyncFileName.getText()).equals(this.initialEPSSyncFile)) {
                IOTool.setPrintEPSSynchronizeFile(this.initialCell, currentEPSSyncFile);
            }
        }
    }

    private void initComponents() {
        this.printingPlotArea = new ButtonGroup();
        this.printingPlotOrPrint = new ButtonGroup();
        this.printing = new JPanel();
        this.jPanel4 = new JPanel();
        this.printPlotEntireCell = new JRadioButton();
        this.printPlotHighlightedArea = new JRadioButton();
        this.printPlotDisplayedWindow = new JRadioButton();
        this.jLabel19 = new JLabel();
        this.printResolution = new JTextField();
        this.jPanel6 = new JPanel();
        this.printEncapsulated = new JCheckBox();
        this.printPostScriptStyle = new JComboBox();
        this.printUsePrinter = new JRadioButton();
        this.printUsePlotter = new JRadioButton();
        this.jLabel21 = new JLabel();
        this.printWidth = new JTextField();
        this.jLabel22 = new JLabel();
        this.printHeight = new JTextField();
        this.jLabel23 = new JLabel();
        this.printMargin = new JTextField();
        this.printRotation = new JComboBox();
        this.printCellName = new JLabel();
        this.printEPSScaleLabel = new JLabel();
        this.printEPSScale = new JTextField();
        this.jLabel20 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.printSyncFileName = new JTextField();
        this.printSynchLabel = new JLabel();
        this.printSetEPSSync = new JButton();
        this.jLabel1 = new JLabel();
        this.printLineWidth = new JTextField();
        this.jLabel2 = new JLabel();
        this.printPlotDateInCorner = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrintingTab.this.closeDialog(evt);
            }
        });
        this.printing.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("For all printing"));
        this.printingPlotArea.add(this.printPlotEntireCell);
        this.printPlotEntireCell.setText("Plot Entire Cell");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel4.add((Component)this.printPlotEntireCell, gridBagConstraints);
        this.printingPlotArea.add(this.printPlotHighlightedArea);
        this.printPlotHighlightedArea.setText("Plot only Highlighted Area");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel4.add((Component)this.printPlotHighlightedArea, gridBagConstraints);
        this.printingPlotArea.add(this.printPlotDisplayedWindow);
        this.printPlotDisplayedWindow.setText("Plot only Displayed Window");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel4.add((Component)this.printPlotDisplayedWindow, gridBagConstraints);
        this.jLabel19.setText("Print resolution (DPI):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel4.add((Component)this.jLabel19, gridBagConstraints);
        this.printResolution.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel4.add((Component)this.printResolution, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.printing.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("For PostScript"));
        this.printEncapsulated.setText("Encapsulated");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printEncapsulated, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printPostScriptStyle, gridBagConstraints);
        this.printingPlotOrPrint.add(this.printUsePrinter);
        this.printUsePrinter.setText("Printer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printUsePrinter, gridBagConstraints);
        this.printingPlotOrPrint.add(this.printUsePlotter);
        this.printUsePlotter.setText("Plotter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printUsePlotter, gridBagConstraints);
        this.jLabel21.setText("Width (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jLabel21, gridBagConstraints);
        this.printWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printWidth, gridBagConstraints);
        this.jLabel22.setText("Height (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jLabel22, gridBagConstraints);
        this.printHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printHeight, gridBagConstraints);
        this.jLabel23.setText("Margin (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jLabel23, gridBagConstraints);
        this.printMargin.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printMargin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printRotation, gridBagConstraints);
        this.printCellName.setText("For cell:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printCellName, gridBagConstraints);
        this.printEPSScaleLabel.setText("EPS Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel6.add((Component)this.printEPSScaleLabel, gridBagConstraints);
        this.printEPSScale.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printEPSScale, gridBagConstraints);
        this.jLabel20.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel6.add((Component)this.jSeparator1, gridBagConstraints);
        this.printSyncFileName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printSyncFileName, gridBagConstraints);
        this.printSynchLabel.setText("Synchronize to file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel6.add((Component)this.printSynchLabel, gridBagConstraints);
        this.printSetEPSSync.setText("Set");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        this.jPanel6.add((Component)this.printSetEPSSync, gridBagConstraints);
        this.jLabel1.setText("Line width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jLabel1, gridBagConstraints);
        this.printLineWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printLineWidth, gridBagConstraints);
        this.jLabel2.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel6.add((Component)this.jLabel2, gridBagConstraints);
        this.printPlotDateInCorner.setText("Plot Date In Corner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel6.add((Component)this.printPlotDateInCorner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.printing.add((Component)this.jPanel6, gridBagConstraints);
        this.getContentPane().add((Component)this.printing, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

