/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class LayerVisibility
extends PrefPackage {
    private static final String KEY_VISIBILITY = "VisibilityOf";
    private static final String KEY_LAYER_ORDER = "LayerOrderfor";
    private static LayerVisibility stdLayerVisibility;
    private TechPool techPool;
    private HashSet<PrimitiveNode> visibleNodes;
    private HashSet<ArcProto> visibleArcs;
    private boolean visibilityChanged;
    private TechData[] techData;

    public LayerVisibility(boolean factory) {
        this(factory, TechPool.getThreadTechPool());
    }

    LayerVisibility(boolean factory, TechPool techPool) {
        super(factory);
        this.techPool = techPool;
        this.loadCache(factory);
    }

    private void loadCache(boolean factory) {
        int maxTechIndex = -1;
        for (Technology tech : this.techPool.values()) {
            maxTechIndex = Math.max(maxTechIndex, tech.getId().techIndex);
        }
        this.techData = new TechData[maxTechIndex + 1];
        for (Technology tech : this.techPool.values()) {
            this.techData[tech.getId().techIndex] = new TechData(tech);
        }
        this.visibilityChanged = false;
        if (factory) {
            return;
        }
        Preferences techPrefs = LayerVisibility.getPrefRoot().node("technology/technologies");
        for (Technology tech : this.techPool.values()) {
            TechData td = this.getTechData(tech);
            String layerOrderKey = this.getKey(KEY_LAYER_ORDER, tech.getId());
            td.layerOrder = techPrefs.get(layerOrderKey, "");
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                assert (!layer.isPseudoLayer());
                String visibilityKey = this.getKey(KEY_VISIBILITY, layer.getId());
                ((TechData)td).visibleLayers[layer.getIndex()] = techPrefs.getBoolean(visibilityKey, true);
            }
        }
    }

    @Override
    public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
        super.putPrefs(prefRoot, removeDefaults);
        Preferences techPrefs = prefRoot.node("technology/technologies");
        for (Technology tech : this.techPool.values()) {
            TechData td = this.getTechData(tech);
            String layerOrder = td.layerOrder;
            String layerOrderKey = this.getKey(KEY_LAYER_ORDER, tech.getId());
            if (removeDefaults && layerOrder.length() == 0) {
                techPrefs.remove(layerOrderKey);
            } else {
                techPrefs.put(layerOrderKey, layerOrder);
            }
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                boolean visible = this.isVisible(layer);
                String visibilityKey = this.getKey(KEY_VISIBILITY, layer.getId());
                if (removeDefaults && visible) {
                    techPrefs.remove(visibilityKey);
                    continue;
                }
                techPrefs.putBoolean(visibilityKey, visible);
            }
        }
    }

    void setVisible(Layer layer, boolean visible) {
        Map<Layer, Boolean> visibilityChange = Collections.singletonMap(layer, visible);
        this.setVisible(visibilityChange);
    }

    void setVisible(Map<Layer, Boolean> visibilityChange) {
        boolean changed = false;
        for (Map.Entry<Layer, Boolean> e : visibilityChange.entrySet()) {
            Layer layer = e.getKey();
            TechData td = this.getTechData(layer.getTechnology());
            int layerIndex = layer.getIndex();
            boolean visible = e.getValue();
            if (visible == td.visibleLayers[layerIndex]) continue;
            changed = true;
            ((TechData)td).visibleLayers[layerIndex] = visible;
        }
        if (!changed) {
            return;
        }
        this.visibilityChanged = true;
        this.visibleNodes = null;
        this.visibleArcs = null;
    }

    void setHighlighted(Layer layer, boolean highlighted) {
        if (highlighted == this.isHighlighted(layer)) {
            return;
        }
        this.visibilityChanged = true;
        ((TechData)this.getTechData((Technology)layer.getTechnology())).highlightedLayers[layer.getIndex()] = highlighted;
    }

    public List<Layer> getSavedLayerOrder(Technology tech) {
        int end;
        TechData td = this.getTechData(tech);
        String order = td.layerOrder;
        if (order == null || order.length() == 0) {
            return null;
        }
        int pos = 0;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        while (pos < order.length() && (end = order.indexOf(44, pos)) >= 0) {
            Layer layer;
            String layerName = order.substring(pos, end);
            pos = end + 1;
            int colonPos = layerName.indexOf(58);
            Technology t = tech;
            if (colonPos >= 0) {
                String techName = layerName.substring(0, colonPos);
                t = this.techPool.findTechnology(techName);
                if (t == null) continue;
                layerName = layerName.substring(colonPos + 1);
            }
            if ((layer = t.findLayer(layerName)) == null) continue;
            layers.add(layer);
        }
        return layers;
    }

    public void setSavedLayerOrder(Technology tech, List<Layer> layers) {
        TechData td = this.getTechData(tech);
        if (layers.isEmpty()) {
            td.layerOrder = "";
        } else {
            StringBuffer sb = new StringBuffer();
            for (Layer lay : layers) {
                if (lay.getTechnology() != tech) {
                    sb.append(lay.getTechnology().getTechName() + ":");
                }
                sb.append(lay.getName() + ",");
            }
            td.layerOrder = sb.toString();
        }
        this.visibilityChanged = true;
    }

    public void setOpacity(Layer layer, double opacity) {
        TechData td = this.getTechData(layer.getTechnology());
        float fOpacity = (float)opacity;
        int layerIndex = layer.getIndex();
        if (fOpacity == td.layerDrawingOpacity[layerIndex]) {
            return;
        }
        this.visibilityChanged = true;
        ((TechData)td).layerDrawingOpacity[layerIndex] = fOpacity;
    }

    private void reset() {
        this.visibilityChanged = true;
        for (TechData td : this.techData) {
            if (td == null) continue;
            Arrays.fill(td.visibleLayers, true);
            Arrays.fill(td.highlightedLayers, false);
            td.layerOrder = "";
        }
        this.visibleNodes = null;
        this.visibleArcs = null;
    }

    private void resetOpacity() {
        for (TechData td : this.techData) {
            if (td == null) continue;
            td.setDefaultOpacity();
        }
    }

    void resetOpacity(Technology tech) {
        this.getTechData(tech).setDefaultOpacity();
    }

    boolean clearChanged() {
        boolean oldChanged = this.visibilityChanged;
        this.visibilityChanged = false;
        return oldChanged;
    }

    public boolean isVisible(Layer layer) {
        TechData td = this.getTechData(layer.getTechnology());
        return td.visibleLayers[layer.getIndex()];
    }

    public boolean isVisible(PrimitiveNode pn) {
        if (this.visibleNodes == null) {
            this.gatherVisiblePrims();
        }
        return this.visibleNodes.contains(pn);
    }

    public boolean isVisible(ArcProto ap) {
        if (this.visibleArcs == null) {
            this.gatherVisiblePrims();
        }
        return this.visibleArcs.contains(ap);
    }

    public boolean isHighlighted(Layer layer) {
        TechData td = this.getTechData(layer.getTechnology());
        return td.highlightedLayers[layer.getIndex()];
    }

    public float getOpacity(Layer layer) {
        return this.getTechData(layer.getTechnology()).layerDrawingOpacity[layer.getIndex()];
    }

    private void gatherVisiblePrims() {
        HashSet<PrimitiveNode> visibleNodes = new HashSet<PrimitiveNode>();
        HashSet<ArcProto> visibleArcs = new HashSet<ArcProto>();
        for (Technology tech : this.techPool.values()) {
            Layer layer;
            Iterator<Layer> lIt;
            boolean visible;
            Iterator<PrimitiveNode> nIt = tech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode pn = nIt.next();
                visible = false;
                lIt = pn.getLayerIterator();
                while (lIt.hasNext()) {
                    layer = lIt.next();
                    if (!this.isVisible(layer)) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                visibleNodes.add(pn);
            }
            Iterator<ArcProto> aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = aIt.next();
                visible = false;
                lIt = ap.getLayerIterator();
                while (lIt.hasNext()) {
                    layer = lIt.next();
                    if (!this.isVisible(layer)) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                visibleArcs.add(ap);
            }
        }
        this.visibleNodes = visibleNodes;
        this.visibleArcs = visibleArcs;
    }

    private float getDefaultOpacity(Layer layer) {
        Layer.Function fun = layer.getFunction();
        int extra = layer.getFunctionExtras();
        double opacity = 0.4;
        if (fun.isMetal()) {
            opacity = 0.75 - (double)fun.getLevel() * 0.05;
        } else if (fun.isContact()) {
            opacity = (extra & 0x4000) != 0 ? 0.7 : 1.0;
        } else if (fun == Layer.Function.OVERGLASS) {
            opacity = 0.2;
        } else if (fun == Layer.Function.POLY1 || fun == Layer.Function.POLY2 || fun == Layer.Function.POLY3 || fun == Layer.Function.GATE || fun == Layer.Function.DIFF || fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN || fun == Layer.Function.WELL || fun == Layer.Function.WELLP || fun == Layer.Function.WELLN || fun == Layer.Function.IMPLANT || fun == Layer.Function.IMPLANTN || fun == Layer.Function.IMPLANTP) {
            opacity = 1.0;
        } else if (layer == this.techPool.getGeneric().glyphLay) {
            opacity = 0.1;
        }
        return (float)opacity;
    }

    private TechData getTechData(Technology tech) {
        TechData td = this.techData[tech.getId().techIndex];
        assert (td.tech == tech);
        return td;
    }

    public static void updateLayerVisibility() {
        LayerVisibility.stdLayerVisibility.techPool = TechPool.getThreadTechPool();
        stdLayerVisibility.loadCache(false);
    }

    public static LayerVisibility getLayerVisibility() {
        assert (Job.isClientThread());
        return stdLayerVisibility;
    }

    public static void preserveVisibility() {
        assert (Job.isClientThread());
        if (stdLayerVisibility == null) {
            return;
        }
        stdLayerVisibility.putPrefs(LayerVisibility.getPrefRoot(), true);
    }

    public static LayerVisibility loadPreferences() {
        assert (Job.isClientThread());
        stdLayerVisibility = new LayerVisibility(false);
        return stdLayerVisibility;
    }

    public static void factoryReset() {
        assert (Job.isClientThread());
        if (stdLayerVisibility == null) {
            return;
        }
        stdLayerVisibility.reset();
    }

    public static void setDefaultOpacity() {
        assert (Job.isClientThread());
        if (stdLayerVisibility == null) {
            return;
        }
        stdLayerVisibility.resetOpacity();
    }

    private class TechData {
        private final Technology tech;
        private String layerOrder = "";
        private final boolean[] visibleLayers;
        private final boolean[] highlightedLayers;
        private final float[] layerDrawingOpacity;

        TechData(Technology tech) {
            this.tech = tech;
            assert (LayerVisibility.this.techPool.getTech(tech.getId()) == tech);
            int numLayers = tech.getNumLayers();
            this.visibleLayers = new boolean[numLayers];
            Arrays.fill(this.visibleLayers, true);
            this.highlightedLayers = new boolean[numLayers];
            this.layerDrawingOpacity = new float[numLayers];
            this.setDefaultOpacity();
        }

        private void setDefaultOpacity() {
            Iterator<Layer> it = this.tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                int layerIndex = layer.getIndex();
                float opacity = LayerVisibility.this.getDefaultOpacity(layer);
                if (opacity == this.layerDrawingOpacity[layerIndex]) continue;
                LayerVisibility.this.visibilityChanged = true;
                this.layerDrawingOpacity[layerIndex] = opacity;
            }
        }
    }
}

