/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.topology.Geometric;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.MutableDouble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XMLRules
implements Serializable {
    public HashMap<XMLRule, XMLRule>[] matrix;
    public HashMap<Layer, Set<Layer>> layersWithRules;
    private Technology tech;

    public XMLRules(Technology t) {
        this.tech = t;
        int numLayers = this.tech.getNumLayers();
        int uTSize = (numLayers * numLayers + numLayers) / 2 + numLayers + this.tech.getNumNodes();
        this.matrix = new HashMap[uTSize];
        this.layersWithRules = new HashMap();
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public int getRuleIndex(int index1, int index2) {
        int index = this.tech.getRuleIndex(index1, index2);
        return index;
    }

    public DRCTemplate getEdgeRule(Layer layer1, Layer layer2) {
        return null;
    }

    public boolean doesAllowMultipleWideRules(int index) {
        return true;
    }

    public int getNumberOfRules() {
        int numberOfRules = 0;
        for (HashMap<XMLRule, XMLRule> map2 : this.matrix) {
            if (map2 == null) continue;
            ++numberOfRules;
        }
        return numberOfRules;
    }

    public String[] getNodesWithRules() {
        String[] nodesWithRules = new String[this.tech.getNumNodes()];
        int j = 0;
        Iterator<PrimitiveNode> it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            nodesWithRules[j++] = np.getName();
        }
        return nodesWithRules;
    }

    public List<DRCTemplate> getSpacingRules(int index, DRCTemplate.DRCRuleType spacingCase, boolean wideRules) {
        List<DRCTemplate> list = new ArrayList<DRCTemplate>(2);
        switch (spacingCase) {
            case SPACING: {
                double maxLimit = 0.0;
                int multi = -1;
                if (wideRules) {
                    multi = 0;
                    maxLimit = Double.MAX_VALUE;
                }
                list = this.getRuleForRange(index, DRCTemplate.DRCRuleType.CONSPA, -1, multi, maxLimit, list);
                list = this.getRuleForRange(index, DRCTemplate.DRCRuleType.UCONSPA, -1, multi, maxLimit, list);
                break;
            }
            case UCONSPA2D: {
                list = this.getRuleForRange(index, DRCTemplate.DRCRuleType.UCONSPA2D, 1, -1.0, 0.0, list);
                break;
            }
        }
        return list;
    }

    public void setSpacingRules(int index, List<DRCTemplate> newRules, DRCTemplate.DRCRuleType spacingCase, boolean wideRules) {
        List<DRCTemplate> list = new ArrayList<DRCTemplate>(0);
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        for (DRCTemplate rule : newRules) {
            if (rule.getValue(0) <= 0.0 || rule.ruleName == null || rule.ruleName.equals("")) continue;
            switch (spacingCase) {
                case SPACING: {
                    double maxLimit = 0.0;
                    int multi = -1;
                    if (wideRules) {
                        multi = 0;
                        maxLimit = Double.MAX_VALUE;
                    }
                    list = this.getRuleForRange(index, rule.ruleType, -1, multi, maxLimit, list);
                    break;
                }
                case UCONSPA2D: {
                    list = this.getRuleForRange(index, rule.ruleType, 1, -1.0, 0.0, list);
                    break;
                }
            }
            for (DRCTemplate tmp : list) {
                map2.remove(tmp);
            }
        }
        for (DRCTemplate rule : newRules) {
            if (rule.getValue(0) <= 0.0 || rule.ruleName == null || rule.ruleName.equals("")) continue;
            this.addRule(index, rule);
        }
    }

    public XMLRule getRule(int index, DRCTemplate.DRCRuleType type) {
        return this.getRule(index, type, 0.0, 0.0, -1, null, null);
    }

    public XMLRule getRule(int index, DRCTemplate.DRCRuleType type, String nodeName) {
        ArrayList<String> nameList = new ArrayList<String>(1);
        nameList.add(nodeName);
        return this.getRule(index, type, 0.0, 0.0, -1, nameList, null);
    }

    public DRCTemplate getMinValue(Layer layer, DRCTemplate.DRCRuleType type) {
        int index = layer.getIndex();
        if (index < 0) {
            return null;
        }
        return this.getRule(index, type);
    }

    public void setMinValue(Layer layer, String name, double value, DRCTemplate.DRCRuleType type) {
        int index = layer.getIndex();
        if (value <= 0.0) {
            System.out.println("Error: zero value in XMLRules:setMinValue");
            return;
        }
        XMLRule oldRule = this.getRule(index, type);
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        if (map2 != null) {
            map2.remove(oldRule);
        }
        XMLRule r = new XMLRule(name, new double[]{value}, type, 0.0, 0.0, -1, DRCTemplate.DRCMode.ALL.mode());
        this.addXMLRule(index, r);
    }

    private List<DRCTemplate> getRuleForRange(int index, DRCTemplate.DRCRuleType type, int multiCut, double minW, double maxW, List<DRCTemplate> list) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        if (list == null) {
            list = new ArrayList<DRCTemplate>(2);
        }
        if (map2 == null) {
            return list;
        }
        for (XMLRule rule : map2.values()) {
            if (rule.ruleType != type || rule.multiCuts != -1 && rule.multiCuts != multiCut || !(rule.maxWidth <= maxW) || !(rule.maxWidth > minW)) continue;
            list.add(rule);
        }
        return list;
    }

    private XMLRule getRule(int index, DRCTemplate.DRCRuleType type, double wideS, double length, int multiCut, List<String> possibleNodeNames, List<String> layerNamesInOrder) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        if (map2 == null) {
            return null;
        }
        XMLRule maxR = null;
        boolean searchFor = wideS > 0.0;
        for (XMLRule rule : map2.values()) {
            if (rule.ruleType != type || rule.multiCuts != -1 && rule.multiCuts != multiCut || rule.nodeName != null && possibleNodeNames != null && !possibleNodeNames.contains(rule.nodeName) || layerNamesInOrder != null && (!rule.name1.equals(layerNamesInOrder.get(0)) || !rule.name2.equals(layerNamesInOrder.get(1)))) continue;
            if (!searchFor && (maxR == null || maxR.getValue(0) > rule.getValue(0) || maxR.getValue(1) > rule.getValue(1))) {
                maxR = rule;
                continue;
            }
            if (!(rule.maxWidth < wideS) || !(rule.minLength <= length) || maxR != null && (!(maxR.maxWidth < rule.maxWidth) || !(maxR.minLength <= rule.minLength))) continue;
            maxR = rule;
        }
        return maxR;
    }

    public void setWideLimits(double[] values) {
        System.out.println("Review XMLRules::setWideLimits");
        for (HashMap<XMLRule, XMLRule> map2 : this.matrix) {
            if (map2 == null) continue;
            for (XMLRule rule : map2.values()) {
                if (!(rule.maxWidth > 0.0) || rule.maxWidth == values[0]) continue;
                rule.maxWidth = values[0];
            }
        }
    }

    private void addXMLRule(int index, XMLRule rule) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        if (map2 == null) {
            this.matrix[index] = map2 = new HashMap();
        }
        map2.put(rule, rule);
    }

    public void deleteRule(int index, DRCTemplate rule) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        if (map2 == null) {
            return;
        }
        for (XMLRule r : map2.values()) {
            if (r.ruleType != rule.ruleType || r.maxWidth != rule.maxWidth || r.minLength != rule.minLength || r.multiCuts != rule.multiCuts || !r.ruleName.equals(rule.ruleName)) continue;
            map2.remove(r);
            return;
        }
    }

    public void addRule(int index, DRCTemplate rule, DRCTemplate.DRCRuleType spacingCase, boolean wideRules) {
        new Error("Not implemented");
    }

    public void addRule(int index, DRCTemplate rule) {
        XMLRule r;
        DRCTemplate.DRCRuleType internalType = rule.ruleType;
        ArrayList<Layer> list = null;
        if (rule.ruleType == DRCTemplate.DRCRuleType.EXTENSION || rule.ruleType == DRCTemplate.DRCRuleType.EXTENSIONGATE) {
            list = new ArrayList<Layer>(2);
            list.add(this.tech.findLayer(rule.name1));
            list.add(this.tech.findLayer(rule.name2));
        }
        switch (rule.ruleType) {
            case SPACING: {
                internalType = DRCTemplate.DRCRuleType.UCONSPA;
                r = new XMLRule(rule);
                r.ruleType = DRCTemplate.DRCRuleType.CONSPA;
                this.addXMLRule(index, r);
            }
        }
        r = new XMLRule(rule);
        r.ruleType = internalType;
        this.addXMLRule(index, r);
    }

    public void addRelationship(Layer lay1, Layer lay2) {
        assert (lay1 != null && lay2 != null);
        Set<Layer> l = this.layersWithRules.get(lay1);
        if (l == null) {
            l = new HashSet<Layer>();
            this.layersWithRules.put(lay1, l);
        }
        l.add(lay2);
    }

    private boolean getMinRule(int index, DRCTemplate.DRCRuleType type, double maxW, MutableDouble maxValue) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[index];
        boolean found = false;
        if (map2 == null) {
            return found;
        }
        maxValue.setValue(0.0);
        for (XMLRule rule : map2.values()) {
            if (rule.ruleType != type || rule.maxWidth > maxW) continue;
            for (int i = 0; i < rule.getNumValues(); ++i) {
                double val = rule.getValue(i);
                if (!(maxValue.doubleValue() < val)) continue;
                maxValue.setValue(val);
                found = true;
            }
        }
        return found;
    }

    public DRCTemplate getSpacingRule(Layer layer1, Geometric geo1, Layer layer2, Geometric geo2, boolean connected, int multiCut, double wideS, double length) {
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        DRCTemplate.DRCRuleType type = connected ? DRCTemplate.DRCRuleType.CONSPA : DRCTemplate.DRCRuleType.UCONSPA;
        ArrayList<String> list = new ArrayList<String>(2);
        if (geo1 != null) {
            list.add(DRCTemplate.getSpacingCombinedName(layer1, geo1));
        }
        if (geo2 != null) {
            list.add(DRCTemplate.getSpacingCombinedName(layer2, geo2));
        }
        XMLRule r = this.getRule(pIndex, type, wideS, length, multiCut, list, null);
        return r;
    }

    public List<DRCTemplate> getRules(Layer layer1, DRCTemplate.DRCRuleType type) {
        ArrayList<DRCTemplate> tempList = new ArrayList<DRCTemplate>();
        int layerIndex = layer1.getIndex();
        if (layerIndex < 0) {
            return tempList;
        }
        HashMap<XMLRule, XMLRule> map2 = this.matrix[layerIndex];
        if (map2 == null) {
            return tempList;
        }
        for (XMLRule rule : map2.values()) {
            if (rule.ruleType != type) continue;
            tempList.add(rule);
        }
        return tempList;
    }

    public DRCTemplate getExtensionRule(Layer layer1, Layer layer2, boolean isGateExtension) {
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(layer1.getName());
        list.add(layer2.getName());
        DRCTemplate.DRCRuleType rule = isGateExtension ? DRCTemplate.DRCRuleType.EXTENSIONGATE : DRCTemplate.DRCRuleType.EXTENSION;
        return this.getRule(pIndex, rule, 0.0, 0.0, -1, null, list);
    }

    public boolean isAnySpacingRule(Layer layer1, Layer layer2) {
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        HashMap<XMLRule, XMLRule> map2 = this.matrix[pIndex];
        if (map2 == null) {
            return false;
        }
        for (XMLRule rule : map2.values()) {
            if (!rule.isSpacingRule()) continue;
            return true;
        }
        return false;
    }

    public DRCTemplate isForbiddenNode(int nodeIndex, DRCTemplate.DRCRuleType type) {
        HashMap<XMLRule, XMLRule> map2 = this.matrix[nodeIndex];
        if (map2 == null) {
            return null;
        }
        for (XMLRule rule : map2.values()) {
            if (rule.ruleType != type) continue;
            return rule;
        }
        return null;
    }

    public boolean getWorstSpacingDistance(int lastMetal, MutableDouble worstDistance) {
        boolean worstDistanceFound = false;
        worstDistance.setValue(0.0);
        MutableDouble mutableDist = new MutableDouble(0.0);
        if (lastMetal != -1) {
            int numM = this.tech.getNumMetals();
            assert (numM >= lastMetal);
            numM = lastMetal;
            ArrayList<Layer> layers = new ArrayList<Layer>(numM);
            Iterator<Layer> itL = this.tech.getLayers();
            while (itL.hasNext()) {
                Layer l = itL.next();
                if (!l.getFunction().isMetal()) continue;
                layers.add(l);
            }
            for (int i = 0; i < numM; ++i) {
                Layer l1 = (Layer)layers.get(i);
                for (int j = i; j < numM; ++j) {
                    int index = this.getRuleIndex(l1.getIndex(), ((Layer)layers.get(j)).getIndex());
                    boolean found = this.getMinRule(index, DRCTemplate.DRCRuleType.UCONSPA, Double.MAX_VALUE, mutableDist);
                    double worstValue = mutableDist.doubleValue();
                    if (!found || !(worstValue > worstDistance.doubleValue())) continue;
                    worstDistance.setValue(worstValue);
                    worstDistanceFound = true;
                }
            }
        } else {
            for (int i = 0; i < this.matrix.length; ++i) {
                boolean found = this.getMinRule(i, DRCTemplate.DRCRuleType.UCONSPA, Double.MAX_VALUE, mutableDist);
                double worstValue = mutableDist.doubleValue();
                if (!found || !(worstValue > worstDistance.doubleValue())) continue;
                worstDistance.setValue(worstValue);
                worstDistanceFound = true;
            }
        }
        return worstDistanceFound;
    }

    public boolean getWorstSpacingDistance(Set<Layer> layers, MutableDouble worstDistance) {
        boolean worstDistanceFound = false;
        worstDistance.setValue(0.0);
        MutableDouble worstValue = new MutableDouble(0.0);
        for (Layer l : layers) {
            boolean found = this.getMaxSurround(l, 0.0, worstValue);
            if (!found || !(worstValue.doubleValue() > worstDistance.doubleValue())) continue;
            worstDistance.setValue(worstValue.doubleValue());
            worstDistanceFound = true;
        }
        return worstDistanceFound;
    }

    public boolean hasLayerRules(Layer layer) {
        return this.layersWithRules.get(layer) != null;
    }

    public boolean getMaxSurround(Layer layer, double maxSize, MutableDouble worstLayerRule) {
        worstLayerRule.setValue(-1.0);
        boolean worstValueFound = false;
        int layerIndex = layer.getIndex();
        int tot = this.tech.getNumLayers();
        MutableDouble mutableDist = new MutableDouble(-1.0);
        Set<Layer> set = this.layersWithRules.get(layer);
        if (set == null) {
            return worstValueFound;
        }
        for (Layer l : set) {
            int pIndex = this.getRuleIndex(layerIndex, l.getIndex());
            boolean found = this.getMinRule(pIndex, DRCTemplate.DRCRuleType.UCONSPA, Double.MAX_VALUE, mutableDist);
            double worstValue = mutableDist.doubleValue();
            if (!found || !(worstValue > worstLayerRule.doubleValue())) continue;
            worstLayerRule.setValue(worstValue);
            worstValueFound = true;
        }
        return worstValueFound;
    }

    public void applyDRCOverrides(String override, Technology tech) {
        int startKey;
        int endKey;
        int pos = 0;
        int len = override.length();
        while (pos < len && (endKey = override.indexOf(58, startKey = pos)) >= 0) {
            String key = override.substring(startKey, endKey);
            if (key.equals("c") || key.equals("cr") || key.equals("u") || key.equals("ur") || key.equals("cw") || key.equals("cwr") || key.equals("uw") || key.equals("uwr") || key.equals("cm") || key.equals("cmr") || key.equals("um") || key.equals("umr") || key.equals("e") || key.equals("er")) {
                XMLRule rule;
                Layer layer2;
                startKey = endKey + 1;
                Layer layer1 = Technology.getLayerFromOverride(override, startKey, '/', tech);
                if (layer1 == null || (startKey = override.indexOf(47, startKey)) < 0 || (layer2 = Technology.getLayerFromOverride(override, startKey + 1, '=', tech)) == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                int index = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
                if (key.equals("c")) {
                    rule = this.getRule(index, DRCTemplate.DRCRuleType.CONSPA);
                    if (rule != null) {
                        rule.setValue(0, TextUtils.atof(newValue));
                    }
                } else if (key.equals("cr")) {
                    rule = this.getRule(index, DRCTemplate.DRCRuleType.CONSPA);
                    if (rule != null) {
                        rule.ruleName = newValue;
                    }
                } else if (key.equals("u")) {
                    rule = this.getRule(index, DRCTemplate.DRCRuleType.UCONSPA);
                    if (rule != null) {
                        rule.setValue(0, TextUtils.atof(newValue));
                    }
                } else if (key.equals("ur")) {
                    rule = this.getRule(index, DRCTemplate.DRCRuleType.UCONSPA);
                    if (rule != null) {
                        rule.ruleName = newValue;
                    }
                } else if (key.equals("cw")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("cwr")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("uw")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("uwr")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("cm")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("cmr")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("um")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("umr")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("e")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                } else if (key.equals("er")) {
                    System.out.println("Not implemented in XMLRules:applyDRCOverrides");
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("m") || key.equals("mr")) {
                XMLRule rule;
                startKey = endKey + 1;
                Layer layer = Technology.getLayerFromOverride(override, startKey, '=', tech);
                if (layer == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                int index = layer.getIndex();
                if (key.equals("m")) {
                    XMLRule rule2 = this.getRule(index, DRCTemplate.DRCRuleType.MINWID);
                    if (rule2 != null) {
                        rule2.setValue(0, TextUtils.atof(newValue));
                    }
                } else if (key.equals("mr") && (rule = this.getRule(index, DRCTemplate.DRCRuleType.MINWID)) != null) {
                    rule.ruleName = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("n") || key.equals("nr")) {
                PrimitiveNode oNp;
                String nodeName;
                PrimitiveNode np;
                startKey = endKey + 1;
                int endPos = override.indexOf(61, startKey);
                if (endPos < 0 || (np = tech.findNodeProto(nodeName = override.substring(startKey, endPos))) == null) break;
                Iterator<PrimitiveNode> it = tech.getNodes();
                while (it.hasNext() && (oNp = it.next()) != np) {
                }
                if (key.equals("n")) {
                    int otherEndKey;
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(47, startKey)) < 0 || (otherEndKey = override.indexOf(59, startKey)) < 0) {
                        break;
                    }
                } else if (key.equals("nr")) {
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                    System.out.println("No implemented in TSMRules");
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("w")) {
                startKey = endKey + 1;
                if ((endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey, endKey);
                double value = TextUtils.atof(newValue);
                if (value > 0.0) {
                    this.setWideLimits(new double[]{value});
                }
                pos = endKey + 1;
                continue;
            }
            endKey = override.indexOf(59, startKey);
            pos = endKey + 1;
        }
    }

    public void loadDRCRules(Technology tech, Foundry foundry, DRCTemplate theRule, boolean pSubstrateProcess) {
        int numMetals = tech.getNumMetals();
        if (theRule.isRuleIgnoredInPSubstrateProcess(pSubstrateProcess)) {
            return;
        }
        int when = theRule.when;
        if (when != DRCTemplate.DRCMode.ALL.mode()) {
            boolean newValue = true;
            for (Foundry.Type t : Foundry.Type.getValues()) {
                if (t == Foundry.Type.NONE) continue;
                if ((when & t.getMode()) != 0 && foundry.getType() != t) {
                    newValue = false;
                }
                if (newValue) continue;
                break;
            }
            boolean oldValue = true;
            if ((when & Foundry.Type.ST.getMode()) != 0 && foundry.getType() == Foundry.Type.TSMC) {
                oldValue = false;
            } else if ((when & Foundry.Type.TSMC.getMode()) != 0 && foundry.getType() == Foundry.Type.ST) {
                oldValue = false;
            }
            if (oldValue != newValue) assert (false);
            if (!oldValue) {
                return;
            }
        }
        if ((when & (DRCTemplate.DRCMode.M7.mode() | DRCTemplate.DRCMode.M8.mode() | DRCTemplate.DRCMode.M5.mode() | DRCTemplate.DRCMode.M6.mode())) != 0) {
            DRCTemplate.DRCMode m = DRCTemplate.DRCMode.ALL;
            try {
                if (numMetals >= 2) {
                    m = DRCTemplate.DRCMode.valueOf("M" + numMetals);
                }
            }
            catch (Exception e) {
                System.out.println("Trying to upload metal layer that does not exist:" + numMetals);
            }
            if ((when & m.mode()) == 0) {
                return;
            }
        }
        Layer lay1 = null;
        int index1 = -1;
        if (theRule.name1 != null && (index1 = (lay1 = tech.findLayer(theRule.name1)) == null ? tech.getRuleNodeIndex(theRule.name1) : lay1.getIndex()) == -1) {
            System.out.println("Warning: no layer '" + theRule.name1 + "' in " + tech.getTechName());
            return;
        }
        Layer lay2 = null;
        int index2 = -1;
        if (theRule.name2 != null && (index2 = (lay2 = tech.findLayer(theRule.name2)) == null ? tech.getRuleNodeIndex(theRule.name2) : lay2.getIndex()) == -1) {
            System.out.println("Warning: no layer '" + theRule.name2 + "' in " + tech.getTechName());
            return;
        }
        int index = -1;
        if (index1 >= 0 && index2 >= 0) {
            index = this.getRuleIndex(index1, index2);
        } else if (index1 >= 0) {
            index = index1;
        } else if (index2 >= 0) assert (false);
        double distance = theRule.getValue(0);
        PrimitiveNode nty = null;
        ArcProto aty = null;
        if (theRule.nodeName != null) {
            if (theRule.ruleType == DRCTemplate.DRCRuleType.ASURROUND) {
                aty = tech.findArcProto(theRule.nodeName);
                if (aty == null) {
                    System.out.println("Warning: no arc '" + theRule.nodeName + "' in mocmos technology");
                    return;
                }
            } else if (theRule.ruleType != DRCTemplate.DRCRuleType.SPACING && (nty = tech.findNodeProto(theRule.nodeName)) == null) {
                System.out.println("Warning: no node '" + theRule.nodeName + "' in " + tech.getTechName());
                return;
            }
        }
        switch (theRule.ruleType) {
            case MINWID: 
            case MINWIDCOND: {
                this.addRule(index1, theRule);
                this.addRelationship(lay1, lay1);
                break;
            }
            case FORBIDDEN: {
                if (nty != null) {
                    this.addRule(tech.getPrimNodeIndexInTech(nty), theRule);
                    break;
                }
                this.addRule(index, theRule);
                break;
            }
            case MINAREA: 
            case MINENCLOSEDAREA: 
            case EXTENSION: 
            case EXTENSIONGATE: {
                if (index == -1) {
                    this.addRule(index1, theRule);
                    break;
                }
                this.addRule(index, theRule);
                break;
            }
            case SPACING: 
            case UCONSPA2D: 
            case SPACINGE: 
            case CONSPA: 
            case UCONSPA: {
                this.addRule(index, theRule);
                this.addRelationship(lay1, lay2);
                this.addRelationship(lay2, lay1);
                break;
            }
            case CUTSURX: {
                double[] specValues = nty.getSpecialValues();
                specValues[2] = distance;
                assert (false);
                break;
            }
            case CUTSURY: {
                double[] specValues = nty.getSpecialValues();
                specValues[3] = distance;
                assert (false);
                break;
            }
            case NODSIZ: {
                this.addRule(tech.getPrimNodeIndexInTech(nty), theRule);
                break;
            }
            case SURROUND: {
                this.addRule(index, theRule);
                break;
            }
            case ASURROUND: {
                break;
            }
            default: {
                System.out.println("Rule " + theRule.ruleName + " type " + (Object)((Object)theRule.ruleType) + " not implemented in " + tech.getTechName());
                assert (false);
                break;
            }
        }
    }

    public static class XMLRule
    extends DRCTemplate {
        public XMLRule(DRCTemplate rule) {
            super(rule);
        }

        public XMLRule(String name, double[] values, DRCTemplate.DRCRuleType type, double maxW, double minLen, int multiCuts, int when) {
            super(name, when, type, maxW, minLen, null, null, values, multiCuts);
        }

        public boolean isSpacingRule() {
            return this.ruleType == DRCTemplate.DRCRuleType.CONSPA || this.ruleType == DRCTemplate.DRCRuleType.UCONSPA;
        }

        public boolean equals(Object obj) {
            boolean basic;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof XMLRule)) {
                return obj.equals(this);
            }
            XMLRule a = (XMLRule)obj;
            boolean bl = basic = this.ruleName.equals(a.ruleName) && this.ruleType == a.ruleType;
            if (basic) {
                boolean bl2 = basic = this.nodeName == null || this.nodeName.equals(a.nodeName);
            }
            if (basic) {
                boolean bl3 = basic = this.name1 == null || this.name1.equals(a.name1);
            }
            if (basic) {
                basic = this.name2 == null || this.name2.equals(a.name2);
            }
            return basic;
        }

        public int hashCode() {
            return this.ruleType.hashCode();
        }
    }
}

