/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class SlotGet
extends Procedure2
implements HasSetter,
CanInline,
Inlineable {
    static Class[] noClasses = new Class[0];
    boolean isStatic;
    Procedure setter;
    public static final SlotGet field = new SlotGet("field", false, SlotSet.set$Mnfield$Ex);
    public static final SlotGet slotRef = new SlotGet("slot-ref", false, SlotSet.set$Mnfield$Ex);
    public static final SlotGet staticField = new SlotGet("static-field", true, SlotSet.set$Mnstatic$Mnfield$Ex);

    public SlotGet(String name, boolean isStatic) {
        super(name);
        this.isStatic = isStatic;
    }

    public SlotGet(String name, boolean isStatic, Procedure setter) {
        super(name);
        this.isStatic = isStatic;
        this.setter = setter;
    }

    public static Object field(Object obj, String fname) {
        return field.apply2(obj, fname);
    }

    public static Object staticField(Object obj, String fname) {
        return staticField.apply2(obj, fname);
    }

    public Object apply2(Object arg1, Object arg2) {
        String name;
        String fname;
        String getName = null;
        String isName = null;
        if (arg2 instanceof gnu.bytecode.Field) {
            fname = ((gnu.bytecode.Field)arg2).getName();
            name = Compilation.demangleName(fname, true);
        } else if (arg2 instanceof Method) {
            String mname = ((Method)arg2).getName();
            name = Compilation.demangleName(mname, false);
            if (mname.startsWith("get")) {
                getName = mname;
            } else if (mname.startsWith("is")) {
                isName = mname;
            }
            fname = null;
        } else if (arg2 instanceof SimpleSymbol || arg2 instanceof CharSequence) {
            name = arg2.toString();
            fname = Compilation.mangleNameIfNeeded(name);
        } else {
            throw new WrongType((Procedure)this, 2, arg2, "string");
        }
        if ("class".equals(fname)) {
            fname = "class";
        } else if ("length".equals(fname)) {
            fname = "length";
        }
        return SlotGet.getSlotValue(this.isStatic, arg1, name, fname, getName, isName, Language.getDefaultLanguage());
    }

    public static Object getSlotValue(boolean isStatic, Object obj, String name, String fname, String getName, String isName, Language language) {
        Class<?> clas;
        Class<?> clazz = clas = isStatic ? SlotGet.coerceToClass(obj) : obj.getClass();
        if (fname == "length" && clas.isArray()) {
            int length = Array.getLength(obj);
            return length;
        }
        if (fname == "class") {
            return clas;
        }
        boolean illegalAccess = false;
        if (fname != null) {
            Field field;
            try {
                field = clas.getField(fname);
            }
            catch (Exception ex) {
                field = null;
            }
            if (field != null) {
                if (isStatic && (field.getModifiers() & 8) == 0) {
                    throw new RuntimeException("cannot access non-static field '" + fname + '\'');
                }
                try {
                    return language.coerceToObject(field.getType(), field.get(obj));
                }
                catch (IllegalAccessException ex) {
                    illegalAccess = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        try {
            String mname = null;
            java.lang.reflect.Method getmethod = null;
            try {
                mname = getName != null ? getName : ClassExp.slotToMethodName("get", name);
                getmethod = clas.getMethod(mname, noClasses);
            }
            catch (Exception getEx) {
                mname = isName != null ? isName : ClassExp.slotToMethodName("is", name);
                getmethod = clas.getMethod(mname, noClasses);
            }
            if (isStatic && (getmethod.getModifiers() & 8) == 0) {
                throw new RuntimeException("cannot call non-static getter method '" + mname + '\'');
            }
            Object result = getmethod.invoke(obj, Values.noArgs);
            result = language.coerceToObject(getmethod.getReturnType(), result);
            return result;
        }
        catch (InvocationTargetException ex) {
            throw WrappedException.wrapIfNeeded(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            illegalAccess = true;
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (illegalAccess) {
            throw new RuntimeException("illegal access for field " + fname);
        }
        throw new RuntimeException("no such field " + fname + " in " + clas.getName());
    }

    static Class coerceToClass(Object obj) {
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof Type) {
            return ((Type)obj).getReflectClass();
        }
        throw new RuntimeException("argument is neither Class nor Type");
    }

    public void setN(Object[] args) {
        int nargs = args.length;
        if (nargs != 3) {
            throw new WrongArguments(this.getSetter(), nargs);
        }
        this.set2(args[0], args[1], args[2]);
    }

    public void set2(Object obj, Object name, Object value) {
        SlotSet.apply(this.isStatic, obj, (String)name, value);
    }

    public static Member lookupMember(ObjectType clas, String name, ClassType caller) {
        String getname;
        Method method;
        gnu.bytecode.Field field = clas.getField(Compilation.mangleNameIfNeeded(name), -1);
        if (field != null) {
            if (caller == null) {
                caller = Type.pointer_type;
            }
            if (caller.isAccessible(field, clas)) {
                return field;
            }
        }
        if ((method = clas.getMethod(getname = ClassExp.slotToMethodName("get", name), Type.typeArray0)) == null) {
            return field;
        }
        return method;
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        Type type;
        Object val1;
        exp.walkArgs(walker, argsInlined);
        Compilation comp = walker.getCompilation();
        Language language = comp.getLanguage();
        Expression[] args = exp.getArgs();
        Expression arg0 = args[0];
        Expression arg1 = args[1];
        String name = null;
        if (arg1 instanceof QuoteExp && ((val1 = ((QuoteExp)arg1).getValue()) instanceof String || val1 instanceof FString || val1 instanceof Symbol)) {
            name = val1.toString();
        }
        if (this.isStatic) {
            type = language.getTypeFor(arg0);
            int known = Invoke.checkKnownClass(type, comp);
            if (known < 0) {
                return exp;
            }
            if ("class".equals(name)) {
                if (known > 0) {
                    return QuoteExp.getInstance(type.getReflectClass());
                }
                Method method = Compilation.typeType.getDeclaredMethod("getReflectClass", 0);
                return new ApplyExp(method, new Expression[]{arg0});
            }
            if (type != null) {
                Expression[] nargs = new Expression[]{new QuoteExp(type), arg1};
                ApplyExp nexp = new ApplyExp(exp.getFunction(), nargs);
                nexp.setLine(exp);
                exp = nexp;
            }
        } else {
            type = arg0.getType();
        }
        if (type instanceof ClassType && name != null) {
            ClassType ctype = (ClassType)type;
            ClassType caller = comp.curClass != null ? comp.curClass : comp.mainClass;
            Member part = SlotGet.lookupMember(ctype, name, caller);
            if (part instanceof gnu.bytecode.Field) {
                boolean isStaticField;
                gnu.bytecode.Field field = (gnu.bytecode.Field)part;
                int modifiers = field.getModifiers();
                boolean bl = isStaticField = (modifiers & 8) != 0;
                if (this.isStatic && !isStaticField) {
                    return new ErrorExp("cannot access non-static field `" + name + "' using `" + this.getName() + '\'', comp);
                }
                if (caller != null && !caller.isAccessible(field, ctype)) {
                    return new ErrorExp("field " + field.getDeclaringClass().getName() + '.' + name + " is not accessible here", comp);
                }
            } else if (part instanceof Method) {
                Method method = (Method)part;
                ClassType dtype = method.getDeclaringClass();
                int modifiers = method.getModifiers();
                boolean isStaticMethod = method.getStaticFlag();
                if (this.isStatic && !isStaticMethod) {
                    return new ErrorExp("cannot call non-static getter method `" + name + "' using `" + this.getName() + '\'', comp);
                }
                if (caller != null && !caller.isAccessible(dtype, ctype, modifiers)) {
                    return new ErrorExp("method " + method + " is not accessible here", comp);
                }
            }
            if (part != null) {
                Expression[] nargs = new Expression[]{arg0, new QuoteExp(part)};
                ApplyExp nexp = new ApplyExp(exp.getFunction(), nargs);
                nexp.setLine(exp);
                return nexp;
            }
            if (type != Type.pointer_type) {
                comp.error('e', "no slot `" + name + "' in " + ctype.getName());
            }
        }
        if (name != null && !(type instanceof ArrayType)) {
            String fname = Compilation.mangleNameIfNeeded(name);
            fname = fname.intern();
            String getName = ClassExp.slotToMethodName("get", name);
            String isName = ClassExp.slotToMethodName("is", name);
            ApplyExp nexp = new ApplyExp(Invoke.invokeStatic, new Expression[]{QuoteExp.getInstance("gnu.kawa.reflect.SlotGet"), QuoteExp.getInstance("getSlotValue"), this.isStatic ? QuoteExp.trueExp : QuoteExp.falseExp, args[0], QuoteExp.getInstance(name), QuoteExp.getInstance(fname), QuoteExp.getInstance(getName), QuoteExp.getInstance(isName), QuoteExp.getInstance(language)});
            nexp.setLine(exp);
            return walker.walkApplyOnly(nexp);
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        Expression arg0 = args[0];
        Expression arg1 = args[1];
        Language language = comp.getLanguage();
        Type type = this.isStatic ? language.getTypeFor(arg0) : arg0.getType();
        CodeAttr code = comp.getCode();
        if (type instanceof ClassType && arg1 instanceof QuoteExp) {
            ClassType ctype = (ClassType)type;
            Object part = ((QuoteExp)arg1).getValue();
            if (part instanceof gnu.bytecode.Field) {
                gnu.bytecode.Field field = (gnu.bytecode.Field)part;
                int modifiers = field.getModifiers();
                boolean isStaticField = (modifiers & 8) != 0;
                args[0].compile(comp, isStaticField ? Target.Ignore : Target.pushValue(ctype));
                if (isStaticField) {
                    boolean inlined = false;
                    if (!inlined) {
                        code.emitGetStatic(field);
                    }
                } else {
                    code.emitGetField(field);
                }
                Type ftype = field.getType();
                Class fclass = ftype.getReflectClass();
                if (fclass != null) {
                    ftype = language.getTypeFor(fclass);
                }
                target.compileFromStack(comp, ftype);
                return;
            }
            if (part instanceof Method) {
                Method method = (Method)part;
                int modifiers = method.getModifiers();
                boolean isStaticMethod = method.getStaticFlag();
                args[0].compile(comp, isStaticMethod ? Target.Ignore : Target.pushValue(ctype));
                if (isStaticMethod) {
                    code.emitInvokeStatic(method);
                } else {
                    code.emitInvoke(method);
                }
                target.compileFromStack(comp, method.getReturnType());
                return;
            }
        }
        String name = ClassMethods.checkName(arg1);
        if (type instanceof ArrayType && "length".equals(name) && !this.isStatic) {
            args[0].compile(comp, Target.pushValue(type));
            code.emitArrayLength();
            target.compileFromStack(comp, LangPrimType.intType);
            return;
        }
        ApplyExp.compile(exp, comp, target);
    }

    public Type getReturnType(Expression[] args) {
        int nargs = args.length;
        if (nargs == 2) {
            Expression arg0 = args[0];
            Expression arg1 = args[1];
            if (arg1 instanceof QuoteExp) {
                Object part = ((QuoteExp)arg1).getValue();
                if (part instanceof gnu.bytecode.Field) {
                    return ((gnu.bytecode.Field)part).getType();
                }
                if (part instanceof Method) {
                    return ((Method)part).getReturnType();
                }
                if (!this.isStatic && arg0.getType() instanceof ArrayType && "length".equals(ClassMethods.checkName(arg1, true))) {
                    return LangPrimType.intType;
                }
            }
        }
        return Type.pointer_type;
    }

    public Procedure getSetter() {
        return this.setter == null ? super.getSetter() : this.setter;
    }

    public static ApplyExp makeGetField(Expression value, String fieldName) {
        Expression[] args = new Expression[]{value, new QuoteExp((Object)fieldName)};
        return new ApplyExp(field, args);
    }
}

