/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.CatchClause;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class TryExp
extends Expression {
    Expression try_clause;
    CatchClause catch_clauses;
    Expression finally_clause;

    public final CatchClause getCatchClauses() {
        return this.catch_clauses;
    }

    public final void setCatchClauses(CatchClause catchClause) {
        this.catch_clauses = catchClause;
    }

    public TryExp(Expression expression, Expression expression2) {
        this.try_clause = expression;
        this.finally_clause = expression2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(Environment environment) throws Throwable {
        if (this.catch_clauses != null) {
            throw new RuntimeException("internal error - TryExp.eval called");
        }
        try {
            Object object2 = this.try_clause.eval(environment);
            return object2;
        }
        finally {
            this.finally_clause.eval(environment);
        }
    }

    public void compile(Compilation compilation, Target target) {
        Type type;
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = this.finally_clause != null;
        Type type2 = type = target instanceof IgnoreTarget ? null : this.getType();
        Target target2 = type == null ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
        codeAttr.emitTryStart(bl, type);
        this.try_clause.compileWithPosition(compilation, target2);
        codeAttr.emitTryEnd();
        for (CatchClause catchClause = this.catch_clauses; catchClause != null; catchClause = catchClause.getNext()) {
            catchClause.compile(compilation, target2);
        }
        if (this.finally_clause != null) {
            codeAttr.emitFinallyStart();
            this.finally_clause.compileWithPosition(compilation, Target.Ignore);
            codeAttr.emitFinallyEnd();
        }
        codeAttr.emitTryCatchEnd();
        if (type != null) {
            target.compileFromStack(compilation, type);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkTryExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.try_clause = expWalker.walk(this.try_clause);
        for (CatchClause catchClause = this.catch_clauses; expWalker.exitValue == null && catchClause != null; catchClause = catchClause.getNext()) {
            expWalker.walk(catchClause);
        }
        if (expWalker.exitValue == null && this.finally_clause != null) {
            this.finally_clause = expWalker.walk(this.finally_clause);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Try", ")", 2);
        outPort.writeSpaceFill();
        this.try_clause.print(outPort);
        for (CatchClause catchClause = this.catch_clauses; catchClause != null; catchClause = catchClause.getNext()) {
            catchClause.print(outPort);
        }
        if (this.finally_clause != null) {
            outPort.writeSpaceLinear();
            outPort.print(" finally: ");
            this.finally_clause.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

