/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.lists.AbstractFormat;
import gnu.lists.Array;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.text.Char;
import java.io.PrintWriter;

public class DisplayFormat
extends AbstractFormat {
    public static final ThreadLocation outBase = new ThreadLocation("out-base");
    public static final ThreadLocation outRadix;
    boolean readable;
    char language;

    public DisplayFormat(boolean bl, char c) {
        this.readable = bl;
        this.language = c;
    }

    public static DisplayFormat getEmacsLispFormat(boolean bl) {
        return new DisplayFormat(bl, 'E');
    }

    public static DisplayFormat getCommonLispFormat(boolean bl) {
        return new DisplayFormat(bl, 'C');
    }

    public static DisplayFormat getSchemeFormat(boolean bl) {
        return new DisplayFormat(bl, 'S');
    }

    public boolean getReadableOutput() {
        return this.readable;
    }

    public void writeBoolean(boolean bl, Consumer consumer) {
        this.write(this.language == 'S' ? (bl ? "#t" : "#f") : (bl ? "t" : "nil"), consumer);
    }

    public void writeChar(int n, Consumer consumer) {
        if (!this.getReadableOutput()) {
            consumer.writeChar(n);
        } else if (this.language == 'E' && n > 32) {
            consumer.writeChar(63);
            consumer.writeChar(n);
        } else {
            this.write(Char.toScmReadableString(n), consumer);
        }
    }

    public void writeList(LList lList, OutPort outPort) {
        Object object2 = lList;
        outPort.startLogicalBlock("(", false, ")");
        while (object2 instanceof Pair) {
            if (object2 != lList) {
                outPort.writeSpaceFill();
            }
            Pair pair = (Pair)object2;
            this.writeObject(pair.car, (Consumer)outPort);
            object2 = pair.cdr;
        }
        if (object2 != LList.Empty) {
            outPort.writeSpaceFill();
            outPort.writeChars(". ");
            this.writeObject(LList.checkNonList(object2), (Consumer)outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public void writeObject(Object object2, Consumer consumer) {
        if (object2 instanceof Boolean) {
            this.writeBoolean((Boolean)object2, consumer);
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).charValue(), consumer);
        } else if (object2 instanceof Character) {
            this.writeChar(((Character)object2).charValue(), consumer);
        } else if (object2 instanceof Symbol) {
            this.writeObject((Object)object2.toString(), consumer);
        } else if (object2 instanceof CharSeq) {
            CharSeq charSeq = (CharSeq)object2;
            if (this.getReadableOutput() && consumer instanceof PrintWriter) {
                Strings.printQuoted(charSeq, (PrintWriter)((Object)consumer), 0);
            } else if (object2 instanceof FString) {
                FString fString = (FString)object2;
                consumer.write(fString.data, 0, fString.size());
            } else {
                charSeq.consume(0, charSeq.size(), consumer);
            }
        } else if (object2 instanceof LList && consumer instanceof OutPort) {
            this.writeList((LList)object2, (OutPort)consumer);
        } else if (object2 instanceof SimpleVector) {
            String string;
            String string2;
            SimpleVector simpleVector = (SimpleVector)object2;
            String string3 = simpleVector.getTag();
            if (this.language == 'E') {
                string2 = "[";
                string = "]";
            } else {
                string2 = string3 == null ? "#(" : "#" + string3 + "(";
                string = ")";
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).startLogicalBlock(string2, false, string);
            } else {
                this.write(string2, consumer);
            }
            int n = simpleVector.size() << 1;
            for (int i = 0; i < n; i += 2) {
                if (i > 0 && consumer instanceof OutPort) {
                    ((OutPort)consumer).writeSpaceFill();
                }
                if (!simpleVector.consumeNext(i, consumer)) break;
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).endLogicalBlock(string);
            } else {
                this.write(string, consumer);
            }
        } else if (object2 instanceof Array) {
            this.write((Array)object2, 0, 0, consumer);
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(consumer);
        } else if (object2 instanceof Printable && consumer instanceof PrintWriter) {
            ((Printable)object2).print((PrintWriter)((Object)consumer));
        } else if (object2 instanceof RatNum) {
            int n = 10;
            boolean bl = false;
            Object object3 = outBase.get(null);
            Object object4 = outRadix.get(null);
            if (object4 != null && (object4 == Boolean.TRUE || "yes".equals(object4.toString()))) {
                bl = true;
            }
            if (object3 instanceof Number) {
                n = ((IntNum)object3).intValue();
            } else if (object3 != null) {
                n = Integer.parseInt(object3.toString());
            }
            String string = ((RatNum)object2).toString(n);
            if (bl) {
                if (n == 16) {
                    this.write("#x", consumer);
                } else if (n == 8) {
                    this.write("#o", consumer);
                } else if (n == 2) {
                    this.write("#b", consumer);
                } else if (n != 10 || !(object2 instanceof IntNum)) {
                    this.write("#" + object3 + "r", consumer);
                }
            }
            this.write(string, consumer);
            if (bl && n == 10 && object2 instanceof IntNum) {
                this.write(".", consumer);
            }
        } else {
            String string;
            String string4 = string = object2 != null ? object2.toString() : null;
            if (string == null) {
                this.write("#!null", consumer);
            } else {
                this.write(string, consumer);
            }
        }
    }

    int write(Array array, int n, int n2, Consumer consumer) {
        String string;
        int n3 = array.rank();
        int n4 = 0;
        String string2 = n2 > 0 ? "(" : (string = n3 == 1 ? "#(" : "#" + n3 + "a(");
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).startLogicalBlock(string, false, ")");
        } else {
            this.write(string, consumer);
        }
        if (n3 > 0) {
            int n5 = array.getSize(n2);
            ++n2;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (i > 0 && consumer instanceof OutPort) {
                    ((OutPort)consumer).writeSpaceFill();
                }
                if (n2 == n3) {
                    this.writeObject(array.getRowMajor(n), consumer);
                    n6 = 1;
                } else {
                    n6 = this.write(array, n, n2, consumer);
                }
                n += n6;
                n4 += n6;
            }
        }
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).endLogicalBlock(")");
        } else {
            this.write(")", consumer);
        }
        return n4;
    }

    static {
        outBase.setGlobal(IntNum.ten());
        outRadix = new ThreadLocation("out-radix");
    }
}

