/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.Field;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.Sequence;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public abstract class LispLanguage
extends Language {
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    public ReadTable defaultReadTable = this.createReadTable();

    public abstract ReadTable createReadTable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Compilation parse(Lexer lexer, int n) throws IOException, SyntaxException {
        SourceMessages sourceMessages = lexer.getMessages();
        Translator translator = new Translator(this, sourceMessages);
        translator.immediate = (n & 1) != 0;
        ModuleExp moduleExp = new ModuleExp();
        if (Compilation.generateAppletDefault) {
            moduleExp.setFlag(16384);
        }
        String string = lexer.getName();
        moduleExp.setFile(string);
        Values values = new Values();
        translator.push(moduleExp);
        int n2 = translator.formStack.size();
        LispReader lispReader = (LispReader)lexer;
        Compilation compilation = Compilation.getCurrent();
        try {
            Compilation.setCurrent(translator);
            do {
                Object object2;
                if ((object2 = lispReader.readCommand()) == Sequence.eofValue) {
                    if ((n & 2) == 0) break;
                    Compilation compilation2 = null;
                    return compilation2;
                }
                translator.scanForm(object2, moduleExp);
            } while ((n & 2) == 0);
            if (lexer.peek() == 41) {
                lexer.fatal("An unexpected close paren was read.");
            }
            translator.finishModule(moduleExp, n2);
        }
        finally {
            Compilation.setCurrent(compilation);
        }
        return translator;
    }

    public Declaration declFromField(ModuleExp moduleExp, Object object2, Field field) {
        boolean bl;
        Declaration declaration = super.declFromField(moduleExp, object2, field);
        boolean bl2 = bl = (field.getModifiers() & 0x10) != 0;
        if (bl && object2 instanceof Syntax) {
            declaration.setSyntax();
        }
        return declaration;
    }

    protected void defSntxStFld(String string, String string2, String string3) {
        Object object2 = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        StaticFieldLocation staticFieldLocation = StaticFieldLocation.define(this.environ, this.environ.getSymbol(string), object2, string2, string3);
        staticFieldLocation.setSyntax();
    }

    protected void defSntxStFld(String string, String string2) {
        this.defSntxStFld(string, string2, Compilation.mangleNameIfNeeded(string));
    }

    public Expression makeBody(Expression[] expressionArray) {
        return new BeginExp(expressionArray);
    }

    public ApplyExp makeApply(Expression expression, Expression[] expressionArray) {
        return new ApplyExp(expression, expressionArray);
    }

    public boolean selfEvaluatingSymbol(Object object2) {
        return object2 instanceof Keyword;
    }

    public static Symbol langSymbolToSymbol(Object object2) {
        return ((LispLanguage)Language.getDefaultLanguage()).fromLangSymbol(object2);
    }

    protected Symbol fromLangSymbol(Object object2) {
        if (object2 instanceof String) {
            return this.getSymbol((String)object2);
        }
        return (Symbol)object2;
    }
}

