/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.RunnableClosure;

public class Future
extends Thread {
    public RunnableClosure closure;

    public Future(Procedure action, CallContext parentContext) {
        this.closure = new RunnableClosure(action, parentContext);
    }

    public Future(Procedure action, CallContext parentContext, Environment penvironment) {
        this.closure = new RunnableClosure(action, parentContext, penvironment);
        this.closure.environment.setName(this.getName());
    }

    public Future(Procedure action, Environment penvironment, InPort in, OutPort out, OutPort err) {
        this.closure = new RunnableClosure(action, penvironment, in, out, err);
    }

    public Future(Procedure action) {
        this.closure = new RunnableClosure(action);
    }

    public final CallContext getCallContext() {
        return this.closure.getCallContext();
    }

    public Environment getEnvironment() {
        return this.closure.environment;
    }

    public void run() {
        this.closure.run();
    }

    public Object waitForResult() throws Throwable {
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("thread join [force] was interrupted");
        }
        Throwable ex = this.closure.exception;
        if (ex != null) {
            throw ex;
        }
        return this.closure.result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("#<future ");
        buf.append(this.getName());
        buf.append(">");
        return buf.toString();
    }
}

