/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolValue2;
import gnu.bytecode.ExitableBlock;
import gnu.bytecode.Field;
import gnu.bytecode.IfState;
import gnu.bytecode.Label;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.SourceDebugExtAttr;
import gnu.bytecode.StackMapTableAttr;
import gnu.bytecode.SwitchState;
import gnu.bytecode.TryState;
import gnu.bytecode.Type;
import gnu.bytecode.UninitializedType;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;

public class CodeAttr
extends Attribute
implements AttrContainer {
    Attribute attributes;
    LineNumbersAttr lines;
    public LocalVarsAttr locals;
    public StackMapTableAttr stackMap;
    SourceDebugExtAttr sourceDbgExt;
    public static final int GENERATE_STACK_MAP_TABLE = 1;
    public static final int DONT_USE_JSR = 2;
    int flags;
    public Type[] stack_types;
    Type[] local_types;
    int SP;
    private int max_stack;
    private int max_locals;
    int PC;
    byte[] code;
    short[] exception_table;
    int exception_table_length;
    static final int FIXUP_NONE = 0;
    static final int FIXUP_DEFINE = 1;
    static final int FIXUP_SWITCH = 2;
    static final int FIXUP_CASE = 3;
    static final int FIXUP_GOTO = 4;
    static final int FIXUP_JSR = 5;
    static final int FIXUP_TRANSFER = 6;
    static final int FIXUP_TRANSFER2 = 7;
    static final int FIXUP_DELETE3 = 8;
    static final int FIXUP_MOVE = 9;
    static final int FIXUP_MOVE_TO_END = 10;
    static final int FIXUP_TRY = 11;
    static final int FIXUP_TRY_END = 12;
    static final int FIXUP_TRY_HANDLER = 13;
    static final int FIXUP_LINE_PC = 14;
    static final int FIXUP_LINE_NUMBER = 15;
    int[] fixup_offsets;
    Label[] fixup_labels;
    int fixup_count;
    public static boolean instructionLineMode = false;
    IfState if_stack;
    TryState try_stack;
    private boolean unreachable_here;
    ExitableBlock currentExitableBlock;
    int exitableBlockLevel;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    boolean useJsr() {
        return (this.flags & 2) == 0;
    }

    public final void fixupChain(Label label, Label label2) {
        this.fixupAdd(9, 0, label2);
        label.defineRaw(this);
    }

    public final void fixupAdd(int n, Label label) {
        this.fixupAdd(n, this.PC, label);
    }

    final void fixupAdd(int n, int n2, Label label) {
        int n3 = this.fixup_count;
        if (n3 == 0) {
            this.fixup_offsets = new int[30];
            this.fixup_labels = new Label[30];
        } else if (this.fixup_count == this.fixup_offsets.length) {
            int n4 = 2 * n3;
            Label[] labelArray = new Label[n4];
            System.arraycopy(this.fixup_labels, 0, labelArray, 0, n3);
            this.fixup_labels = labelArray;
            int[] nArray = new int[n4];
            System.arraycopy(this.fixup_offsets, 0, nArray, 0, n3);
            this.fixup_offsets = nArray;
        }
        this.fixup_offsets[n3] = n2 << 4 | n;
        this.fixup_labels[n3] = label;
        this.fixup_count = n3 + 1;
    }

    private final int fixupOffset(int n) {
        return this.fixup_offsets[n] >> 4;
    }

    private final int fixupKind(int n) {
        return this.fixup_offsets[n] & 0xF;
    }

    public final Method getMethod() {
        return (Method)this.getContainer();
    }

    public final int getPC() {
        return this.PC;
    }

    public final int getSP() {
        return this.SP;
    }

    public final ConstantPool getConstants() {
        return this.getMethod().classfile.constants;
    }

    public final boolean reachableHere() {
        return !this.unreachable_here;
    }

    public final void setReachable(boolean bl) {
        this.unreachable_here = !bl;
    }

    public final void setUnreachable() {
        this.unreachable_here = true;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] byArray) {
        this.code = byArray;
        this.PC = byArray.length;
    }

    public void setCodeLength(int n) {
        this.PC = n;
    }

    public int getCodeLength() {
        return this.PC;
    }

    public CodeAttr(Method method) {
        super("Code");
        this.addToFrontOf(method);
        method.code = this;
        if (method.getDeclaringClass().getClassfileMajorVersion() >= 50) {
            this.flags |= 3;
        }
    }

    public final void reserve(int n) {
        if (this.code == null) {
            this.code = new byte[100 + n];
        } else if (this.PC + n > this.code.length) {
            byte[] byArray = new byte[2 * this.code.length + n];
            System.arraycopy(this.code, 0, byArray, 0, this.PC);
            this.code = byArray;
        }
    }

    byte invert_opcode(byte by) {
        int n = by & 0xFF;
        if (n >= 153 && n <= 166 || n >= 198 && n <= 199) {
            return (byte)(n ^ 1);
        }
        throw new Error("unknown opcode to invert_opcode");
    }

    public final void put1(int n) {
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put2(int n) {
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put4(int n) {
        this.code[this.PC++] = (byte)(n >> 24);
        this.code[this.PC++] = (byte)(n >> 16);
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void putIndex2(CpoolEntry cpoolEntry) {
        this.put2(cpoolEntry.index);
    }

    public final void putLineNumber(String string, int n) {
        if (string != null) {
            this.getMethod().classfile.setSourceFile(string);
        }
        this.putLineNumber(n);
    }

    public final void putLineNumber(int n) {
        if (this.sourceDbgExt != null) {
            n = this.sourceDbgExt.fixLine(n);
        }
        this.fixupAdd(14, null);
        this.fixupAdd(15, n, null);
    }

    void noteParamTypes() {
        int n;
        Method method = this.getMethod();
        int n2 = 0;
        if ((method.access_flags & 8) == 0) {
            ObjectType objectType = method.classfile;
            if ("<init>".equals(method.getName()) && !"java.lang.Object".equals(objectType.getName())) {
                objectType = UninitializedType.uninitializedThis(objectType);
            }
            this.noteVarType(n2++, objectType);
        }
        for (Type type : method.arg_types) {
            this.noteVarType(n2++, type);
            n = type.getSizeInWords();
            while (--n > 0) {
                ++n2;
            }
        }
        if ((this.flags & 1) != 0) {
            this.stackMap = new StackMapTableAttr();
            int[] nArray = new int[20 + n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                int n4 = this.stackMap.encodeVerificationType(this.local_types[n], this);
                nArray[n3++] = n4;
                int n5 = n4 & 0xFF;
                if (n5 != 3 && n5 != 4) continue;
                ++n;
            }
            this.stackMap.encodedLocals = nArray;
            this.stackMap.countLocals = n3;
            this.stackMap.encodedStack = new int[10];
            this.stackMap.countStack = 0;
        }
    }

    public void noteVarType(int n, Type type) {
        Object object2;
        int n2 = type.getSizeInWords();
        if (this.local_types == null) {
            this.local_types = new Type[n + n2 + 20];
        } else if (n + n2 > this.local_types.length) {
            object2 = new Type[2 * (n + n2)];
            System.arraycopy(this.local_types, 0, object2, 0, this.local_types.length);
            this.local_types = object2;
        }
        this.local_types[n] = type;
        if (n > 0 && (object2 = this.local_types[n - 1]) != null && ((Type)object2).getSizeInWords() == 2) {
            this.local_types[n - 1] = null;
        }
        while (--n2 > 0) {
            this.local_types[++n] = null;
        }
    }

    public final void setTypes(Label label) {
        this.setTypes(label.localTypes, label.stackTypes);
    }

    public final void setTypes(Type[] typeArray, Type[] typeArray2) {
        int n;
        int n2 = typeArray2.length;
        int n3 = typeArray.length;
        if (this.local_types != null) {
            if (n3 > 0) {
                System.arraycopy(typeArray, 0, this.local_types, 0, n3);
            }
            for (n = n3; n < this.local_types.length; ++n) {
                this.local_types[n] = null;
            }
        }
        if (this.stack_types == null || n2 > this.stack_types.length) {
            this.stack_types = new Type[n2];
        } else {
            for (n = n2; n < this.stack_types.length; ++n) {
                this.stack_types[n] = null;
            }
        }
        System.arraycopy(typeArray2, 0, this.stack_types, 0, n2);
        this.SP = n2;
    }

    public final void pushType(Type type) {
        if (type.size == 0) {
            throw new Error("pushing void type onto stack");
        }
        if (this.stack_types == null || this.stack_types.length == 0) {
            this.stack_types = new Type[20];
        } else if (this.SP + 1 >= this.stack_types.length) {
            Type[] typeArray = new Type[2 * this.stack_types.length];
            System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
            this.stack_types = typeArray;
        }
        if (type.size == 8) {
            this.stack_types[this.SP++] = Type.voidType;
        }
        this.stack_types[this.SP++] = type;
        if (this.SP > this.max_stack) {
            this.max_stack = this.SP;
        }
    }

    public final Type popType() {
        if (this.SP <= 0) {
            throw new Error("popType called with empty stack " + this.getMethod());
        }
        Type type = this.stack_types[--this.SP];
        if (type.size == 8 && !this.popType().isVoid()) {
            throw new Error("missing void type on stack");
        }
        return type;
    }

    public final Type topType() {
        return this.stack_types[this.SP - 1];
    }

    public void emitPop(int n) {
        while (n > 0) {
            this.reserve(1);
            Type type = this.popType();
            if (type.size > 4) {
                this.put1(88);
            } else if (n > 1) {
                Type type2 = this.popType();
                if (type2.size > 4) {
                    this.put1(87);
                    this.reserve(1);
                }
                this.put1(88);
                --n;
            } else {
                this.put1(87);
            }
            --n;
        }
    }

    public Label getLabel() {
        Label label = new Label();
        label.defineRaw(this);
        return label;
    }

    public void emitSwap() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type.size > 4 || type2.size > 4) {
            this.pushType(type2);
            this.pushType(type);
            this.emitDupX();
            this.emitPop(1);
        } else {
            this.pushType(type);
            this.put1(95);
            this.pushType(type2);
        }
    }

    public void emitDup() {
        this.reserve(1);
        Type type = this.topType();
        this.put1(type.size <= 4 ? 89 : 92);
        this.pushType(type);
    }

    public void emitDupX() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type2.size <= 4) {
            this.put1(type.size <= 4 ? 90 : 93);
        } else {
            this.put1(type.size <= 4 ? 91 : 94);
        }
        this.pushType(type);
        this.pushType(type2);
        this.pushType(type);
    }

    public void emitDup(int n, int n2) {
        int n3;
        if (n == 0) {
            return;
        }
        this.reserve(1);
        Type type = this.popType();
        Type type2 = null;
        if (n == 1) {
            if (type.size > 4) {
                throw new Error("using dup for 2-word type");
            }
        } else {
            if (n != 2) {
                throw new Error("invalid size to emitDup");
            }
            if (type.size <= 4) {
                type2 = this.popType();
                if (type2.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        }
        Type type3 = null;
        Type type4 = null;
        if (n2 == 0) {
            n3 = n == 1 ? 89 : 92;
        } else if (n2 == 1) {
            n3 = n == 1 ? 90 : 93;
            type3 = this.popType();
            if (type3.size > 4) {
                throw new Error("dup will cause invalid types on stack");
            }
        } else if (n2 == 2) {
            n3 = n == 1 ? 91 : 94;
            type3 = this.popType();
            if (type3.size <= 4) {
                type4 = this.popType();
                if (type4.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        } else {
            throw new Error("emitDup:  invalid offset");
        }
        this.put1(n3);
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
        if (type4 != null) {
            this.pushType(type4);
        }
        if (type3 != null) {
            this.pushType(type3);
        }
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
    }

    public void emitDup(int n) {
        this.emitDup(n, 0);
    }

    public void emitDup(Type type) {
        this.emitDup(type.size > 4 ? 2 : 1, 0);
    }

    public void enterScope(Scope scope) {
        scope.setStartPC(this);
        this.locals.enterScope(scope);
    }

    public Scope pushScope() {
        Scope scope = new Scope();
        if (this.locals == null) {
            this.locals = new LocalVarsAttr(this.getMethod());
        }
        this.enterScope(scope);
        if (this.locals.parameter_scope == null) {
            this.locals.parameter_scope = scope;
        }
        return scope;
    }

    public Scope getCurrentScope() {
        return this.locals.current_scope;
    }

    public Scope popScope() {
        Scope scope = this.locals.current_scope;
        this.locals.current_scope = scope.parent;
        scope.freeLocals(this);
        scope.end = this.getLabel();
        return scope;
    }

    public Variable getArg(int n) {
        return this.locals.parameter_scope.getVariable(n);
    }

    public Variable lookup(String string) {
        Scope scope = this.locals.current_scope;
        while (scope != null) {
            Variable variable = scope.lookup(string);
            if (variable != null) {
                return variable;
            }
            scope = scope.parent;
        }
        return null;
    }

    public Variable addLocal(Type type) {
        return this.locals.current_scope.addVariable(this, type, null);
    }

    public Variable addLocal(Type type, String string) {
        return this.locals.current_scope.addVariable(this, type, string);
    }

    public void addParamLocals() {
        Method method = this.getMethod();
        if ((method.access_flags & 8) == 0) {
            this.addLocal(method.classfile).setParameter(true);
        }
        int n = method.arg_types.length;
        for (int i = 0; i < n; ++i) {
            this.addLocal(method.arg_types[i]).setParameter(true);
        }
    }

    public final void emitPushConstant(int n, Type type) {
        switch (type.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.emitPushInt(n);
                break;
            }
            case 'J': {
                this.emitPushLong(n);
                break;
            }
            case 'F': {
                this.emitPushFloat(n);
                break;
            }
            case 'D': {
                this.emitPushDouble(n);
                break;
            }
            default: {
                throw new Error("bad type to emitPushConstant");
            }
        }
    }

    public final void emitPushConstant(CpoolEntry cpoolEntry) {
        this.reserve(3);
        int n = cpoolEntry.index;
        if (cpoolEntry instanceof CpoolValue2) {
            this.put1(20);
            this.put2(n);
        } else if (n < 256) {
            this.put1(18);
            this.put1(n);
        } else {
            this.put1(19);
            this.put2(n);
        }
    }

    public final void emitPushInt(int n) {
        this.reserve(3);
        if (n >= -1 && n <= 5) {
            this.put1(n + 3);
        } else if (n >= -128 && n < 128) {
            this.put1(16);
            this.put1(n);
        } else if (n >= Short.MIN_VALUE && n < 32768) {
            this.put1(17);
            this.put2(n);
        } else {
            this.emitPushConstant(this.getConstants().addInt(n));
        }
        this.pushType(Type.intType);
    }

    public void emitPushLong(long l) {
        if (l == 0L || l == 1L) {
            this.reserve(1);
            this.put1(9 + (int)l);
        } else if ((long)((int)l) == l) {
            this.emitPushInt((int)l);
            this.reserve(1);
            this.popType();
            this.put1(133);
        } else {
            this.emitPushConstant(this.getConstants().addLong(l));
        }
        this.pushType(Type.longType);
    }

    public void emitPushFloat(float f) {
        int n = (int)f;
        if ((float)n == f && n >= -128 && n < 128) {
            if (n >= 0 && n <= 2) {
                this.reserve(1);
                this.put1(11 + n);
                if (n == 0 && Float.floatToIntBits(f) != 0) {
                    this.reserve(1);
                    this.put1(118);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(134);
            }
        } else {
            this.emitPushConstant(this.getConstants().addFloat(f));
        }
        this.pushType(Type.floatType);
    }

    public void emitPushDouble(double d) {
        int n = (int)d;
        if ((double)n == d && n >= -128 && n < 128) {
            if (n == 0 || n == 1) {
                this.reserve(1);
                this.put1(14 + n);
                if (n == 0 && Double.doubleToLongBits(d) != 0L) {
                    this.reserve(1);
                    this.put1(119);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(135);
            }
        } else {
            this.emitPushConstant(this.getConstants().addDouble(d));
        }
        this.pushType(Type.doubleType);
    }

    public static final String calculateSplit(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(20);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            char c = string.charAt(i);
            int n5 = c >= '\u0800' ? 3 : (n4 = c >= '\u0080' || c == '\u0000' ? 2 : 1);
            if (n3 + n4 > 65535) {
                stringBuffer.append((char)(i - n2));
                n2 = i;
                n3 = 0;
            }
            n3 += n4;
        }
        stringBuffer.append((char)(n - n2));
        return stringBuffer.toString();
    }

    public final void emitPushString(String string) {
        if (string == null) {
            this.emitPushNull();
        } else {
            int n = string.length();
            String string2 = CodeAttr.calculateSplit(string);
            int n2 = string2.length();
            if (n2 > 1) {
                if (n2 == 2) {
                    char c = string2.charAt(0);
                    this.emitPushString(string.substring(0, c));
                    this.emitPushString(string.substring(c));
                    Method method = Type.javalangStringType.getDeclaredMethod("concat", 1);
                    this.emitInvokeVirtual(method);
                } else {
                    ClassType classType = ClassType.make("java.lang.StringBuffer");
                    this.emitNew(classType);
                    this.emitDup(classType);
                    this.emitPushInt(n);
                    Type[] typeArray = new Type[]{Type.intType};
                    this.emitInvokeSpecial(classType.getDeclaredMethod("<init>", typeArray));
                    Type[] typeArray2 = new Type[]{Type.javalangStringType};
                    Method method = classType.getDeclaredMethod("append", typeArray2);
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        this.emitDup(classType);
                        int n4 = n3 + string2.charAt(i);
                        this.emitPushString(string.substring(n3, n4));
                        this.emitInvokeVirtual(method);
                        n3 = n4;
                    }
                    this.emitInvokeVirtual(Type.toString_method);
                }
                if (string == string.intern()) {
                    this.emitInvokeVirtual(Type.javalangStringType.getDeclaredMethod("intern", 0));
                }
                return;
            }
            this.emitPushConstant(this.getConstants().addString(string));
            this.pushType(Type.javalangStringType);
        }
    }

    public final void emitPushClass(ObjectType objectType) {
        this.emitPushConstant(this.getConstants().addClass(objectType));
        this.pushType(Type.javalangClassType);
    }

    public void emitPushNull() {
        this.reserve(1);
        this.put1(1);
        this.pushType(Type.nullType);
    }

    public void emitPushDefaultValue(Type type) {
        if ((type = type.getImplementationType()) instanceof PrimType) {
            this.emitPushConstant(0, type);
        } else {
            this.emitPushNull();
        }
    }

    public void emitStoreDefaultValue(Variable variable) {
        this.emitPushDefaultValue(variable.getType());
        this.emitStore(variable);
    }

    public final void emitPushThis() {
        this.emitLoad(this.locals.used[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void emitPushPrimArray(Object object2, ArrayType arrayType) {
        Type type = arrayType.getComponentType();
        int n = Array.getLength(object2);
        this.emitPushInt(n);
        this.emitNewArray(type);
        char c = type.getSignature().charAt(0);
        int n2 = 0;
        while (true) {
            block18: {
                if (n2 >= n) {
                    return;
                }
                long l = 0L;
                float f = 0.0f;
                double d = 0.0;
                switch (c) {
                    case 'J': {
                        l = ((long[])object2)[n2];
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'I': {
                        l = ((int[])object2)[n2];
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'S': {
                        l = ((short[])object2)[n2];
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'C': {
                        l = ((char[])object2)[n2];
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'B': {
                        l = ((byte[])object2)[n2];
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'Z': {
                        long l2 = l = ((boolean[])object2)[n2] ? 1L : 0L;
                        if (l != 0L) break;
                        break block18;
                    }
                    case 'F': {
                        f = ((float[])object2)[n2];
                        if ((double)f != 0.0) break;
                        break block18;
                    }
                    case 'D': {
                        d = ((double[])object2)[n2];
                        if (d == 0.0) break block18;
                    }
                }
                this.emitDup(arrayType);
                this.emitPushInt(n2);
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        this.emitPushInt((int)l);
                        break;
                    }
                    case 'J': {
                        this.emitPushLong(l);
                        break;
                    }
                    case 'F': {
                        this.emitPushFloat(f);
                        break;
                    }
                    case 'D': {
                        this.emitPushDouble(d);
                        break;
                    }
                }
                this.emitArrayStore(type);
            }
            ++n2;
        }
    }

    void emitNewArray(int n) {
        this.reserve(2);
        this.put1(188);
        this.put1(n);
    }

    public final void emitArrayLength() {
        if (!(this.popType() instanceof ArrayType)) {
            throw new Error("non-array type in emitArrayLength");
        }
        this.reserve(1);
        this.put1(190);
        this.pushType(Type.intType);
    }

    private int adjustTypedOp(char c) {
        switch (c) {
            case 'I': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            default: {
                return 4;
            }
            case 'B': 
            case 'Z': {
                return 5;
            }
            case 'C': {
                return 6;
            }
            case 'S': 
        }
        return 7;
    }

    private int adjustTypedOp(Type type) {
        return this.adjustTypedOp(type.getSignature().charAt(0));
    }

    private void emitTypedOp(int n, Type type) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(type));
    }

    private void emitTypedOp(int n, char c) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(c));
    }

    public void emitArrayStore(Type type) {
        this.popType();
        this.popType();
        this.popType();
        this.emitTypedOp(79, type);
    }

    public void emitArrayStore() {
        this.popType();
        this.popType();
        Type type = this.popType().getImplementationType();
        Type type2 = ((ArrayType)type).getComponentType();
        this.emitTypedOp(79, type2);
    }

    public void emitArrayLoad(Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(46, type);
        this.pushType(type);
    }

    public void emitArrayLoad() {
        this.popType();
        Type type = this.popType().getImplementationType();
        Type type2 = ((ArrayType)type).getComponentType();
        this.emitTypedOp(46, type2);
        this.pushType(type2);
    }

    public void emitNew(ClassType classType) {
        this.reserve(3);
        Label label = new Label(this);
        label.defineRaw(this);
        this.put1(187);
        this.putIndex2(this.getConstants().addClass(classType));
        this.pushType(new UninitializedType(classType, label));
    }

    public void emitNewArray(Type type, int n) {
        if (this.popType().promote() != Type.intType) {
            throw new Error("non-int dim. spec. in emitNewArray");
        }
        if (type instanceof PrimType) {
            int n2;
            switch (type.getSignature().charAt(0)) {
                case 'B': {
                    n2 = 8;
                    break;
                }
                case 'S': {
                    n2 = 9;
                    break;
                }
                case 'I': {
                    n2 = 10;
                    break;
                }
                case 'J': {
                    n2 = 11;
                    break;
                }
                case 'F': {
                    n2 = 6;
                    break;
                }
                case 'D': {
                    n2 = 7;
                    break;
                }
                case 'Z': {
                    n2 = 4;
                    break;
                }
                case 'C': {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new Error("bad PrimType in emitNewArray");
                }
            }
            this.emitNewArray(n2);
        } else if (type instanceof ObjectType) {
            this.reserve(3);
            this.put1(189);
            this.putIndex2(this.getConstants().addClass((ObjectType)type));
        } else if (type instanceof ArrayType) {
            this.reserve(4);
            this.put1(197);
            this.putIndex2(this.getConstants().addClass(new ArrayType(type)));
            if (n < 1 || n > 255) {
                throw new Error("dims out of range in emitNewArray");
            }
            this.put1(n);
            while (--n > 0) {
                if (this.popType().promote() == Type.intType) continue;
                throw new Error("non-int dim. spec. in emitNewArray");
            }
        } else {
            throw new Error("unimplemented type in emitNewArray");
        }
        this.pushType(new ArrayType(type));
    }

    public void emitNewArray(Type type) {
        this.emitNewArray(type, 1);
    }

    private void emitBinop(int n) {
        Type type = this.popType().promote();
        Type type2 = this.popType();
        Type type3 = type2.promote();
        if (type3 != type || !(type3 instanceof PrimType)) {
            throw new Error("non-matching or bad types in binary operation");
        }
        this.emitTypedOp(n, type3);
        this.pushType(type2);
    }

    private void emitBinop(int n, char c) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, c);
        this.pushType(Type.signatureToPrimitive(c));
    }

    public void emitBinop(int n, Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, type);
        this.pushType(type);
    }

    public final void emitAdd(char c) {
        this.emitBinop(96, c);
    }

    public final void emitAdd(PrimType primType) {
        this.emitBinop(96, primType);
    }

    public final void emitAdd() {
        this.emitBinop(96);
    }

    public final void emitSub(char c) {
        this.emitBinop(100, c);
    }

    public final void emitSub(PrimType primType) {
        this.emitBinop(100, primType);
    }

    public final void emitSub() {
        this.emitBinop(100);
    }

    public final void emitMul() {
        this.emitBinop(104);
    }

    public final void emitDiv() {
        this.emitBinop(108);
    }

    public final void emitRem() {
        this.emitBinop(112);
    }

    public final void emitAnd() {
        this.emitBinop(126);
    }

    public final void emitIOr() {
        this.emitBinop(128);
    }

    public final void emitXOr() {
        this.emitBinop(130);
    }

    public final void emitShl() {
        this.emitShift(120);
    }

    public final void emitShr() {
        this.emitShift(122);
    }

    public final void emitUshr() {
        this.emitShift(124);
    }

    private void emitShift(int n) {
        Type type = this.popType().promote();
        Type type2 = this.popType();
        Type type3 = type2.promote();
        if (type3 != Type.intType && type3 != Type.longType) {
            throw new Error("the value shifted must be an int or a long");
        }
        if (type != Type.intType) {
            throw new Error("the amount of shift must be an int");
        }
        this.emitTypedOp(n, type3);
        this.pushType(type2);
    }

    public final void emitNot(Type type) {
        this.emitPushConstant(1, type);
        this.emitAdd();
        this.emitPushConstant(1, type);
        this.emitAnd();
    }

    public void emitPrimop(int n, int n2, Type type) {
        this.reserve(1);
        while (--n2 >= 0) {
            this.popType();
        }
        this.put1(n);
        this.pushType(type);
    }

    void emitMaybeWide(int n, int n2) {
        if (n2 >= 256) {
            this.put1(196);
            this.put1(n);
            this.put2(n2);
        } else {
            this.put1(n);
            this.put1(n2);
        }
    }

    public final void emitLoad(Variable variable) {
        if (variable.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to load from unassigned variable " + variable + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(4);
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(26 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(21 + n2, n);
        }
        this.pushType(variable.getType());
    }

    public void emitStore(Variable variable) {
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to store in unassigned " + variable + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.noteVarType(n, type);
        this.reserve(4);
        this.popType();
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(59 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(54 + n2, n);
        }
    }

    public void emitInc(Variable variable, short s) {
        boolean bl;
        if (variable.dead()) {
            throw new Error("attempting to increment dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to increment unassigned variable" + variable.getName() + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        this.reserve(6);
        if (variable.getType().getImplementationType().promote() != Type.intType) {
            throw new Error("attempting to increment non-int variable");
        }
        boolean bl2 = bl = n > 255 || s > 255 || s < -256;
        if (bl) {
            this.put1(196);
            this.put1(132);
            this.put2(n);
            this.put2(s);
        } else {
            this.put1(132);
            this.put1(n);
            this.put1(s);
        }
    }

    private final void emitFieldop(Field field, int n) {
        this.reserve(3);
        this.put1(n);
        this.putIndex2(this.getConstants().addFieldRef(field));
    }

    public final void emitGetStatic(Field field) {
        this.pushType(field.type);
        this.emitFieldop(field, 178);
    }

    public final void emitGetField(Field field) {
        this.popType();
        this.pushType(field.type);
        this.emitFieldop(field, 180);
    }

    public final void emitPutStatic(Field field) {
        this.popType();
        this.emitFieldop(field, 179);
    }

    public final void emitPutField(Field field) {
        this.popType();
        this.popType();
        this.emitFieldop(field, 181);
    }

    private int words(Type[] typeArray) {
        int n = 0;
        int n2 = typeArray.length;
        while (--n2 >= 0) {
            if (typeArray[n2].size > 4) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    public void emitInvokeMethod(Method method, int n) {
        Type type;
        this.reserve(n == 185 ? 5 : 3);
        int n2 = method.arg_types.length;
        boolean bl = n == 184;
        boolean bl2 = n == 183 && "<init>".equals(method.getName());
        if (bl != ((method.access_flags & 8) != 0)) {
            throw new Error("emitInvokeXxx static flag mis-match method.flags=" + method.access_flags);
        }
        if (!bl && !bl2) {
            ++n2;
        }
        this.put1(n);
        this.putIndex2(this.getConstants().addMethodRef(method));
        if (n == 185) {
            this.put1(this.words(method.arg_types) + 1);
            this.put1(0);
        }
        while (--n2 >= 0) {
            type = this.popType();
            if (!(type instanceof UninitializedType)) continue;
            throw new Error("passing " + type + " as parameter");
        }
        if (bl2) {
            int n3;
            type = this.popType();
            if (!(type instanceof UninitializedType)) {
                throw new Error("calling <init> on already-initialized object");
            }
            ClassType classType = ((UninitializedType)type).ctype;
            for (int i = 0; i < this.SP; ++i) {
                if (this.stack_types[i] != type) continue;
                this.stack_types[i] = classType;
            }
            Variable[] variableArray = this.locals.used;
            int n4 = n3 = variableArray == null ? 0 : variableArray.length;
            while (--n3 >= 0) {
                Variable variable = variableArray[n3];
                if (variable == null || variable.type != type) continue;
                variable.type = classType;
            }
        }
        if (method.return_type.size != 0) {
            this.pushType(method.return_type);
        }
    }

    public void emitInvoke(Method method) {
        int n = (method.access_flags & 8) != 0 ? 184 : (method.classfile.isInterface() ? 185 : ("<init>".equals(method.getName()) ? 183 : 182));
        this.emitInvokeMethod(method, n);
    }

    public void emitInvokeVirtual(Method method) {
        this.emitInvokeMethod(method, 182);
    }

    public void emitInvokeSpecial(Method method) {
        this.emitInvokeMethod(method, 183);
    }

    public void emitInvokeStatic(Method method) {
        this.emitInvokeMethod(method, 184);
    }

    public void emitInvokeInterface(Method method) {
        this.emitInvokeMethod(method, 185);
    }

    final void emitTransfer(Label label, int n) {
        label.setTypes(this);
        this.fixupAdd(6, label);
        this.put1(n);
        this.PC += 2;
    }

    public final void emitGoto(Label label) {
        label.setTypes(this);
        this.fixupAdd(4, label);
        this.reserve(3);
        this.put1(167);
        this.PC += 2;
        this.setUnreachable();
    }

    public final void emitJsr(Label label) {
        this.fixupAdd(5, label);
        this.reserve(3);
        this.put1(168);
        this.PC += 2;
    }

    public ExitableBlock startExitableBlock(Type type, boolean bl) {
        ExitableBlock exitableBlock = new ExitableBlock(type, this, bl);
        exitableBlock.outer = this.currentExitableBlock;
        this.currentExitableBlock = exitableBlock;
        return exitableBlock;
    }

    public void endExitableBlock() {
        ExitableBlock exitableBlock = this.currentExitableBlock;
        exitableBlock.finish();
        this.currentExitableBlock = exitableBlock.outer;
    }

    public final void emitGotoIfCompare1(Label label, int n) {
        this.popType();
        this.reserve(3);
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfIntEqZero(Label label) {
        this.emitGotoIfCompare1(label, 153);
    }

    public final void emitGotoIfIntNeZero(Label label) {
        this.emitGotoIfCompare1(label, 154);
    }

    public final void emitGotoIfIntLtZero(Label label) {
        this.emitGotoIfCompare1(label, 155);
    }

    public final void emitGotoIfIntGeZero(Label label) {
        this.emitGotoIfCompare1(label, 156);
    }

    public final void emitGotoIfIntGtZero(Label label) {
        this.emitGotoIfCompare1(label, 157);
    }

    public final void emitGotoIfIntLeZero(Label label) {
        this.emitGotoIfCompare1(label, 158);
    }

    public final void emitGotoIfCompare2(Label label, int n) {
        boolean bl;
        if (n < 153 || n > 158) {
            throw new Error("emitGotoIfCompare2: logop must be one of ifeq...ifle");
        }
        Type type = this.popType().promote();
        Type type2 = this.popType().promote();
        this.reserve(4);
        char c = type2.getSignature().charAt(0);
        char c2 = type.getSignature().charAt(0);
        boolean bl2 = bl = n == 155 || n == 158;
        if (c == 'I' && c2 == 'I') {
            n += 6;
        } else if (c == 'J' && c2 == 'J') {
            this.put1(148);
        } else if (c == 'F' && c2 == 'F') {
            this.put1(bl ? 149 : 150);
        } else if (c == 'D' && c2 == 'D') {
            this.put1(bl ? 151 : 152);
        } else if (!(c != 'L' && c != '[' || c2 != 'L' && c2 != '[' || n > 154)) {
            n += 12;
        } else {
            throw new Error("invalid types to emitGotoIfCompare2");
        }
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfEq(Label label, boolean bl) {
        this.emitGotoIfCompare2(label, bl ? 154 : 153);
    }

    public final void emitGotoIfEq(Label label) {
        this.emitGotoIfCompare2(label, 153);
    }

    public final void emitGotoIfNE(Label label) {
        this.emitGotoIfCompare2(label, 154);
    }

    public final void emitGotoIfLt(Label label) {
        this.emitGotoIfCompare2(label, 155);
    }

    public final void emitGotoIfGe(Label label) {
        this.emitGotoIfCompare2(label, 156);
    }

    public final void emitGotoIfGt(Label label) {
        this.emitGotoIfCompare2(label, 157);
    }

    public final void emitGotoIfLe(Label label) {
        this.emitGotoIfCompare2(label, 158);
    }

    public final void emitIfCompare1(int n) {
        IfState ifState = new IfState(this);
        if (this.popType().promote() != Type.intType) {
            throw new Error("non-int type to emitIfCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntNotZero() {
        this.emitIfCompare1(153);
    }

    public final void emitIfIntEqZero() {
        this.emitIfCompare1(154);
    }

    public final void emitIfIntLEqZero() {
        this.emitIfCompare1(157);
    }

    public final void emitIfRefCompare1(int n) {
        IfState ifState = new IfState(this);
        if (!(this.popType() instanceof ObjectType)) {
            throw new Error("non-ref type to emitIfRefCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfNotNull() {
        this.emitIfRefCompare1(198);
    }

    public final void emitIfNull() {
        this.emitIfRefCompare1(199);
    }

    public final void emitIfIntCompare(int n) {
        IfState ifState = new IfState(this);
        this.popType();
        this.popType();
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntLt() {
        this.emitIfIntCompare(162);
    }

    public final void emitIfNEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfEq(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfNE(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public void emitRet(Variable variable) {
        int n = variable.offset;
        if (n < 256) {
            this.reserve(2);
            this.put1(169);
            this.put1(n);
        } else {
            this.reserve(4);
            this.put1(196);
            this.put1(169);
            this.put2(n);
        }
    }

    public final void emitThen() {
        this.if_stack.start_stack_size = this.SP;
    }

    public final void emitIfThen() {
        new IfState(this, null);
    }

    public final void emitElse() {
        Label label = this.if_stack.end_label;
        if (this.reachableHere()) {
            int n;
            Label label2;
            this.if_stack.end_label = label2 = new Label(this);
            this.if_stack.stack_growth = n = this.SP - this.if_stack.start_stack_size;
            if (n > 0) {
                this.if_stack.then_stacked_types = new Type[n];
                System.arraycopy(this.stack_types, this.if_stack.start_stack_size, this.if_stack.then_stacked_types, 0, n);
            } else {
                this.if_stack.then_stacked_types = new Type[0];
            }
            this.emitGoto(label2);
        } else {
            this.if_stack.end_label = null;
        }
        while (this.SP > this.if_stack.start_stack_size) {
            this.popType();
        }
        this.SP = this.if_stack.start_stack_size;
        if (label != null) {
            label.define(this);
        }
        this.if_stack.doing_else = true;
    }

    public final void emitFi() {
        boolean bl = false;
        if (!this.if_stack.doing_else) {
            if (this.reachableHere() && this.SP != this.if_stack.start_stack_size) {
                throw new Error("at PC " + this.PC + " then clause grows stack with no else clause");
            }
        } else if (this.if_stack.then_stacked_types != null) {
            int n = this.if_stack.start_stack_size + this.if_stack.stack_growth;
            if (!this.reachableHere()) {
                if (this.if_stack.stack_growth > 0) {
                    System.arraycopy(this.if_stack.then_stacked_types, 0, this.stack_types, this.if_stack.start_stack_size, this.if_stack.stack_growth);
                }
                this.SP = n;
            } else if (this.SP != n) {
                throw new Error("at PC " + this.PC + ": SP at end of 'then' was " + n + " while SP at end of 'else' was " + this.SP);
            }
        } else if (this.unreachable_here) {
            bl = true;
        }
        if (this.if_stack.end_label != null) {
            this.if_stack.end_label.define(this);
        }
        if (bl) {
            this.setUnreachable();
        }
        this.if_stack = this.if_stack.previous;
    }

    public final void emitConvert(Type type, Type type2) {
        String string = type2.getSignature();
        String string2 = type.getSignature();
        int n = -1;
        if (string.length() == 1 || string2.length() == 1) {
            int n2 = string.charAt(0);
            int n3 = string2.charAt(0);
            if (n3 == n2) {
                return;
            }
            if (type.size < 4) {
                n3 = 73;
            }
            if (type2.size < 4) {
                this.emitConvert(type, Type.intType);
                n3 = 73;
            }
            if (n3 == n2) {
                return;
            }
            block0 : switch (n3) {
                case 73: {
                    switch (n2) {
                        case 66: {
                            n = 145;
                            break;
                        }
                        case 67: {
                            n = 146;
                            break;
                        }
                        case 83: {
                            n = 147;
                            break;
                        }
                        case 74: {
                            n = 133;
                            break;
                        }
                        case 70: {
                            n = 134;
                            break;
                        }
                        case 68: {
                            n = 135;
                        }
                    }
                    break;
                }
                case 74: {
                    switch (n2) {
                        case 73: {
                            n = 136;
                            break;
                        }
                        case 70: {
                            n = 137;
                            break;
                        }
                        case 68: {
                            n = 138;
                        }
                    }
                    break;
                }
                case 70: {
                    switch (n2) {
                        case 73: {
                            n = 139;
                            break;
                        }
                        case 74: {
                            n = 140;
                            break;
                        }
                        case 68: {
                            n = 141;
                        }
                    }
                    break;
                }
                case 68: {
                    switch (n2) {
                        case 73: {
                            n = 142;
                            break block0;
                        }
                        case 74: {
                            n = 143;
                            break block0;
                        }
                        case 70: {
                            n = 144;
                        }
                    }
                }
            }
        }
        if (n < 0) {
            throw new Error("unsupported CodeAttr.emitConvert");
        }
        this.reserve(1);
        this.popType();
        this.put1(n);
        this.pushType(type2);
    }

    private void emitCheckcast(Type type, int n) {
        this.reserve(3);
        this.popType();
        this.put1(n);
        if (!(type instanceof ObjectType)) {
            throw new Error("unimplemented type " + type + " in emitCheckcast/emitInstanceof");
        }
        this.putIndex2(this.getConstants().addClass((ObjectType)type));
    }

    public static boolean castNeeded(Type type, Type type2) {
        if (type instanceof UninitializedType) {
            type = ((UninitializedType)type).getImplementationType();
        }
        while (true) {
            if (type2 instanceof ClassType && type instanceof ClassType && ((ClassType)type).isSubclass((ClassType)type2)) {
                return false;
            }
            if (!(type2 instanceof ArrayType) || !(type instanceof ArrayType)) break;
            type2 = ((ArrayType)type2).getComponentType();
            type = ((ArrayType)type).getComponentType();
        }
        return true;
    }

    public void emitCheckcast(Type type) {
        if (CodeAttr.castNeeded(this.topType(), type)) {
            this.emitCheckcast(type, 192);
            this.pushType(type);
        }
    }

    public void emitInstanceof(Type type) {
        this.emitCheckcast(type, 193);
        this.pushType(Type.booleanType);
    }

    public final void emitThrow() {
        this.popType();
        this.reserve(1);
        this.put1(191);
        this.setUnreachable();
    }

    public final void emitMonitorEnter() {
        this.popType();
        this.reserve(1);
        this.put1(194);
    }

    public final void emitMonitorExit() {
        this.popType();
        this.reserve(1);
        this.put1(195);
    }

    public final void emitReturn() {
        if (this.try_stack != null) {
            new Error();
        }
        this.emitRawReturn();
    }

    final void emitRawReturn() {
        if (this.getMethod().getReturnType().size == 0) {
            this.reserve(1);
            this.put1(177);
        } else {
            this.emitTypedOp(172, this.popType().promote());
        }
        this.setUnreachable();
    }

    public void addHandler(int n, int n2, int n3, int n4) {
        int n5 = 4 * this.exception_table_length;
        if (this.exception_table == null) {
            this.exception_table = new short[20];
        } else if (this.exception_table.length <= n5) {
            short[] sArray = new short[2 * this.exception_table.length];
            System.arraycopy(this.exception_table, 0, sArray, 0, n5);
            this.exception_table = sArray;
        }
        this.exception_table[n5++] = (short)n;
        this.exception_table[n5++] = (short)n2;
        this.exception_table[n5++] = (short)n3;
        this.exception_table[n5++] = (short)n4;
        ++this.exception_table_length;
    }

    public void addHandler(Label label, Label label2, ClassType classType) {
        ConstantPool constantPool = this.getConstants();
        int n = classType == null ? 0 : constantPool.addClass((ObjectType)classType).index;
        this.fixupAdd(11, label);
        this.fixupAdd(12, n, label2);
        Label label3 = new Label();
        label3.localTypes = label.localTypes;
        label3.stackTypes = new Type[1];
        ClassType classType2 = classType == null ? Type.javalangThrowableType : classType;
        label3.stackTypes[0] = classType2;
        this.setTypes(label3);
        this.fixupAdd(13, 0, label3);
    }

    public void emitWithCleanupStart() {
        int n = this.SP;
        this.SP = 0;
        this.emitTryStart(false, null);
        this.SP = n;
    }

    public void emitWithCleanupCatch(Variable variable) {
        Type[] typeArray;
        this.emitTryEnd();
        if (this.SP > 0) {
            typeArray = new Type[this.SP];
            System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
            this.SP = 0;
        } else {
            typeArray = null;
        }
        this.try_stack.savedTypes = typeArray;
        this.try_stack.saved_result = variable;
        int n = this.SP;
        this.emitCatchStart(variable);
    }

    public void emitWithCleanupDone() {
        Variable variable = this.try_stack.saved_result;
        this.try_stack.saved_result = null;
        if (variable != null) {
            this.emitLoad(variable);
        }
        this.emitThrow();
        this.emitCatchEnd();
        Type[] typeArray = this.try_stack.savedTypes;
        this.emitTryCatchEnd();
        if (typeArray != null) {
            this.SP = typeArray.length;
            if (this.SP >= this.stack_types.length) {
                this.stack_types = typeArray;
            } else {
                System.arraycopy(typeArray, 0, this.stack_types, 0, this.SP);
            }
        } else {
            this.SP = 0;
        }
    }

    public void emitTryStart(boolean bl, Type type) {
        Object object2;
        int n;
        if (type != null && type.isVoid()) {
            type = null;
        }
        Variable[] variableArray = null;
        if (type != null || this.SP > 0) {
            this.pushScope();
        }
        if (this.SP > 0) {
            variableArray = new Variable[this.SP];
            int n2 = 0;
            while (this.SP > 0) {
                Variable variable = this.addLocal(this.topType());
                this.emitStore(variable);
                variableArray[n2++] = variable;
            }
        }
        TryState tryState = new TryState(this);
        tryState.savedStack = variableArray;
        int n3 = n = this.local_types == null ? 0 : this.local_types.length;
        while (n > 0 && (object2 = this.local_types[n - 1]) == null) {
            --n;
        }
        if (n == 0) {
            object2 = Type.typeArray0;
        } else {
            object2 = new Type[n];
            System.arraycopy(this.local_types, 0, object2, 0, n);
        }
        tryState.start_try.localTypes = object2;
        if (type != null) {
            tryState.saved_result = this.addLocal(type);
        }
        if (bl) {
            tryState.finally_subr = new Label();
        }
    }

    public void emitTryEnd() {
        this.emitTryEnd(false);
    }

    private void emitTryEnd(boolean bl) {
        if (this.try_stack.tryClauseDone) {
            return;
        }
        this.try_stack.tryClauseDone = true;
        if (this.try_stack.finally_subr != null) {
            this.try_stack.exception = this.addLocal(Type.javalangThrowableType);
        }
        this.gotoFinallyOrEnd(bl);
        this.try_stack.end_try = this.getLabel();
    }

    public void emitCatchStart(Variable variable) {
        ClassType classType;
        this.emitTryEnd(false);
        this.setTypes(this.try_stack.start_try.localTypes, Type.typeArray0);
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.try_stack.try_type = classType = variable == null ? null : (ClassType)variable.getType();
        this.addHandler(this.try_stack.start_try, this.try_stack.end_try, classType);
        if (variable != null) {
            this.emitStore(variable);
        }
    }

    public void emitCatchEnd() {
        this.gotoFinallyOrEnd(false);
        this.try_stack.try_type = null;
    }

    private void gotoFinallyOrEnd(boolean bl) {
        if (this.reachableHere()) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            if (this.try_stack.end_label == null) {
                this.try_stack.end_label = new Label();
            }
            if (this.try_stack.finally_subr == null || this.useJsr()) {
                if (this.try_stack.finally_subr != null) {
                    this.emitJsr(this.try_stack.finally_subr);
                }
                this.emitGoto(this.try_stack.end_label);
            } else {
                if (this.try_stack.exitCases != null) {
                    this.emitPushInt(0);
                }
                this.emitPushNull();
                if (!bl) {
                    this.emitGoto(this.try_stack.finally_subr);
                }
            }
        }
    }

    public void emitFinallyStart() {
        Object object2;
        this.emitTryEnd(true);
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.try_stack.end_try = this.getLabel();
        this.pushScope();
        if (this.useJsr()) {
            this.SP = 0;
            this.emitCatchStart(null);
            this.emitStore(this.try_stack.exception);
            this.emitJsr(this.try_stack.finally_subr);
            this.emitLoad(this.try_stack.exception);
            this.emitThrow();
        } else {
            this.setUnreachable();
            object2 = new Label(this);
            int n = this.beginFragment((Label)object2);
            this.addHandler(this.try_stack.start_try, this.try_stack.end_try, Type.javalangThrowableType);
            if (this.try_stack.saved_result != null) {
                this.emitStoreDefaultValue(this.try_stack.saved_result);
            }
            if (this.try_stack.exitCases != null) {
                this.emitPushInt(-1);
                this.emitSwap();
            }
            this.emitGoto(this.try_stack.finally_subr);
            this.endFragment(n);
        }
        this.try_stack.finally_subr.define(this);
        if (this.useJsr()) {
            object2 = Type.objectType;
            this.try_stack.finally_ret_addr = this.addLocal((Type)object2);
            this.pushType((Type)object2);
            this.emitStore(this.try_stack.finally_ret_addr);
        }
    }

    public void emitFinallyEnd() {
        if (this.useJsr()) {
            this.emitRet(this.try_stack.finally_ret_addr);
        } else if (this.try_stack.end_label == null && this.try_stack.exitCases == null) {
            this.emitThrow();
        } else {
            this.emitStore(this.try_stack.exception);
            this.emitLoad(this.try_stack.exception);
            this.emitIfNotNull();
            this.emitLoad(this.try_stack.exception);
            this.emitThrow();
            this.emitElse();
            ExitableBlock exitableBlock = this.try_stack.exitCases;
            if (exitableBlock != null) {
                SwitchState switchState = this.startSwitch();
                while (exitableBlock != null) {
                    ExitableBlock exitableBlock2 = exitableBlock.nextCase;
                    exitableBlock.nextCase = null;
                    exitableBlock.currentTryState = null;
                    TryState tryState = TryState.outerHandler(this.try_stack.previous, exitableBlock.initialTryState);
                    if (tryState == exitableBlock.initialTryState) {
                        switchState.addCaseGoto(exitableBlock.switchCase, this, exitableBlock.endLabel);
                    } else {
                        switchState.addCase(exitableBlock.switchCase, this);
                        exitableBlock.exit(tryState);
                    }
                    exitableBlock = exitableBlock2;
                }
                this.try_stack.exitCases = null;
                switchState.addDefault(this);
                switchState.finish(this);
            }
            this.emitFi();
            this.setUnreachable();
        }
        this.popScope();
        this.try_stack.finally_subr = null;
    }

    public void emitTryCatchEnd() {
        if (this.try_stack.finally_subr != null) {
            this.emitFinallyEnd();
        }
        Variable[] variableArray = this.try_stack.savedStack;
        if (this.try_stack.end_label == null) {
            this.setUnreachable();
        } else {
            this.setTypes(this.try_stack.start_try.localTypes, Type.typeArray0);
            this.try_stack.end_label.define(this);
            if (variableArray != null) {
                int n = variableArray.length;
                while (--n >= 0) {
                    Variable variable = variableArray[n];
                    if (variable == null) continue;
                    this.emitLoad(variable);
                }
            }
            if (this.try_stack.saved_result != null) {
                this.emitLoad(this.try_stack.saved_result);
            }
        }
        if (this.try_stack.saved_result != null || variableArray != null) {
            this.popScope();
        }
        this.try_stack = this.try_stack.previous;
    }

    public final TryState getCurrentTry() {
        return this.try_stack;
    }

    public final boolean isInTry() {
        return this.try_stack != null;
    }

    public SwitchState startSwitch() {
        SwitchState switchState = new SwitchState(this);
        switchState.switchValuePushed(this);
        return switchState;
    }

    public void emitTailCall(boolean bl, Scope scope) {
        if (bl) {
            Method method = this.getMethod();
            int n = (method.access_flags & 8) != 0 ? 0 : 1;
            int n2 = method.arg_types.length;
            while (--n2 >= 0) {
                n += method.arg_types[n2].size > 4 ? 2 : 1;
            }
            n2 = method.arg_types.length;
            while (--n2 >= 0) {
                this.emitStore(this.locals.used[n -= method.arg_types[n2].size > 4 ? 2 : 1]);
            }
        }
        this.emitGoto(scope.start);
    }

    public void processFixups() {
        short s;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.fixup_count <= 0) {
            return;
        }
        int n5 = 0;
        int n6 = this.fixup_count;
        this.fixupAdd(9, 0, null);
        int n7 = 0;
        block33: while (true) {
            n4 = this.fixup_offsets[n7];
            n3 = n4 & 0xF;
            n4 >>= 4;
            Label label = this.fixup_labels[n7];
            switch (n3) {
                case 11: {
                    n7 += 2;
                    break;
                }
                case 14: {
                    ++n7;
                }
                case 0: 
                case 3: 
                case 8: {
                    break;
                }
                case 1: {
                    label.position += n5;
                    break;
                }
                case 2: {
                    n5 += 3;
                    break;
                }
                case 4: {
                    if (label.first_fixup == n7 + 1 && this.fixupOffset(n7 + 1) == n4 + 3) {
                        this.fixup_offsets[n7] = n4 << 4 | 8;
                        this.fixup_labels[n7] = null;
                        n5 -= 3;
                        break;
                    }
                }
                case 5: {
                    if (this.PC < 32768) break;
                    n5 += 2;
                    break;
                }
                case 6: {
                    if (this.PC < 32768) break;
                    n5 += 5;
                    break;
                }
                case 10: {
                    this.fixup_labels[n6] = this.fixup_labels[n7 + 1];
                    n6 = n4;
                }
                case 9: {
                    n2 = n7 + 1 >= this.fixup_count ? this.PC : this.fixupOffset(this.fixup_labels[n7 + 1].first_fixup);
                    this.fixup_offsets[n7] = n2 << 4 | 9;
                    if (label == null) break block33;
                    n7 = label.first_fixup;
                    n = this.fixupOffset(n7);
                    n5 = n2 + n5 - n;
                    continue block33;
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            ++n7;
        }
        n7 = this.PC;
        n5 = 0;
        n4 = 0;
        block34: while (n4 < this.fixup_count) {
            n3 = this.fixup_offsets[n4];
            int n8 = n3 & 0xF;
            Label label = this.fixup_labels[n4];
            if (label != null && label.position < 0) {
                throw new Error("undefined label " + label);
            }
            while (label != null && n8 >= 4 && n8 <= 7 && label.first_fixup + 1 < this.fixup_count && this.fixup_offsets[label.first_fixup + 1] == (this.fixup_offsets[label.first_fixup] & 0xF | 4)) {
                this.fixup_labels[n4] = label = this.fixup_labels[label.first_fixup + 1];
            }
            n3 >>= 4;
            switch (n8) {
                case 11: {
                    this.fixup_labels[n4 += 2].position = n3 + n5;
                    break;
                }
                case 14: {
                    ++n4;
                }
                case 0: 
                case 3: {
                    break;
                }
                case 8: {
                    n5 -= 3;
                    n7 -= 3;
                    break;
                }
                case 1: {
                    label.position = n3 + n5;
                    break;
                }
                case 2: {
                    n = 3 - (n3 + n5) & 3;
                    n5 += n;
                    n7 += n;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    s = label.position - (n3 + n5);
                    if ((short)s == s) {
                        this.fixup_offsets[n4] = n3 << 4 | 7;
                        break;
                    }
                    n5 += n8 == 6 ? 5 : 2;
                    n7 += n8 == 6 ? 5 : 2;
                    break;
                }
                case 9: {
                    if (label == null) break block34;
                    n4 = label.first_fixup;
                    int n9 = this.fixupOffset(n4);
                    n5 = n3 + n5 - n9;
                    continue block34;
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            ++n4;
        }
        byte[] byArray = new byte[n7];
        n3 = -1;
        int n10 = 0;
        n2 = 0;
        n = this.fixupOffset(0);
        s = -1;
        Label label = null;
        int n11 = 0;
        block36: while (true) {
            if (n11 < n) {
                byArray[n10++] = this.code[n11++];
                continue;
            }
            int n12 = this.fixup_offsets[n2] & 0xF;
            Label label2 = this.fixup_labels[n2];
            if (label != null && label.position < n10) {
                this.stackMap.emitStackMapEntry(label, this);
                label = null;
            }
            if (label != null && label.position > n10) {
                throw new Error("labels out of order");
            }
            switch (n12) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.stackMap == null || label2 == null || label2.stackTypes == null || label2.position == 0) break;
                    label = this.mergeLabels(label, label2);
                    break;
                }
                case 8: {
                    n11 += 3;
                    break;
                }
                case 7: {
                    n5 = label2.position - n10;
                    byArray[n10++] = this.code[n11];
                    byArray[n10++] = (byte)(n5 >> 8);
                    byArray[n10++] = (byte)(n5 & 0xFF);
                    n11 += 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n5 = label2.position - n10;
                    int n13 = this.code[n11];
                    if (n12 == 6) {
                        n13 = this.invert_opcode((byte)n13);
                        byArray[n10++] = n13;
                        byArray[n10++] = 0;
                        byArray[n10++] = 8;
                        n13 = -56;
                    } else {
                        n13 = (byte)(n13 + 33);
                    }
                    byArray[n10++] = n13;
                    byArray[n10++] = (byte)(n5 >> 24);
                    byArray[n10++] = (byte)(n5 >> 16);
                    byArray[n10++] = (byte)(n5 >> 8);
                    byArray[n10++] = (byte)(n5 & 0xFF);
                    n11 += 3;
                    break;
                }
                case 2: {
                    int n14;
                    int n15 = 3 - n10 & 3;
                    int n16 = n10;
                    byArray[n10++] = this.code[n11++];
                    while (--n15 >= 0) {
                        byArray[n10++] = 0;
                    }
                    while (n2 < this.fixup_count && this.fixupKind(n2 + 1) == 3) {
                        n14 = this.fixupOffset(++n2);
                        while (n11 < n14) {
                            byArray[n10++] = this.code[n11++];
                        }
                        n5 = this.fixup_labels[n2].position - n16;
                        byArray[n10++] = (byte)(n5 >> 24);
                        byArray[n10++] = (byte)(n5 >> 16);
                        byArray[n10++] = (byte)(n5 >> 8);
                        byArray[n10++] = (byte)(n5 & 0xFF);
                        n11 += 4;
                    }
                    break;
                }
                case 11: {
                    label2 = this.fixup_labels[n2 + 2];
                    int n14 = this.fixupOffset(n2 + 1);
                    if (this.stackMap != null) {
                        label = this.mergeLabels(label, label2);
                    }
                    this.addHandler(this.fixup_labels[n2].position, this.fixup_labels[n2 + 1].position, n10, n14);
                    n2 += 2;
                    break;
                }
                case 14: {
                    int n17;
                    if (this.lines == null) {
                        this.lines = new LineNumbersAttr(this);
                    }
                    if ((n17 = this.fixupOffset(++n2)) != n3) {
                        this.lines.put(n17, n10);
                    }
                    n3 = n17;
                    break;
                }
                case 9: {
                    if (label2 == null) break block36;
                    n2 = label2.first_fixup;
                    n = n11 = this.fixupOffset(n2);
                    if (label2.position == n10) continue block36;
                    throw new Error("bad pc");
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            n = this.fixupOffset(++n2);
        }
        if (n7 != n10) {
            throw new Error("PC confusion new_pc:" + n10 + " new_size:" + n7);
        }
        this.PC = n7;
        this.code = byArray;
        this.fixup_count = 0;
        this.fixup_labels = null;
        this.fixup_offsets = null;
    }

    private Label mergeLabels(Label label, Label label2) {
        if (label != null) {
            Type[] typeArray = label.localTypes;
            Type[] typeArray2 = label.stackTypes;
            label2.setTypes(typeArray, typeArray.length, typeArray2, typeArray2.length);
        }
        return label2;
    }

    public void assignConstants(ClassType classType) {
        if (this.locals != null && this.locals.container == null && !this.locals.isEmpty()) {
            this.locals.addToFrontOf(this);
        }
        this.processFixups();
        if (this.stackMap != null && this.stackMap.numEntries > 0) {
            this.stackMap.addToFrontOf(this);
        }
        if (instructionLineMode) {
            if (this.lines == null) {
                this.lines = new LineNumbersAttr(this);
            }
            this.lines.linenumber_count = 0;
            int n = this.getCodeLength();
            for (int i = 0; i < n; ++i) {
                this.lines.put(i, i);
            }
        }
        super.assignConstants(classType);
        Attribute.assignConstants(this, classType);
    }

    public final int getLength() {
        return 12 + this.getCodeLength() + 8 * this.exception_table_length + Attribute.getLengthAll(this);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.PC);
        dataOutputStream.write(this.code, 0, this.PC);
        dataOutputStream.writeShort(this.exception_table_length);
        int n = this.exception_table_length;
        int n2 = 0;
        while (--n >= 0) {
            dataOutputStream.writeShort(this.exception_table[n2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 1]);
            dataOutputStream.writeShort(this.exception_table[n2 + 2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 3]);
            n2 += 4;
        }
        Attribute.writeAll(this, dataOutputStream);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", max_stack:");
        classTypeWriter.print(this.max_stack);
        classTypeWriter.print(", max_locals:");
        classTypeWriter.print(this.max_locals);
        classTypeWriter.print(", code_length:");
        int n = this.getCodeLength();
        classTypeWriter.println(n);
        this.disAssemble(classTypeWriter, 0, n);
        if (this.exception_table_length > 0) {
            classTypeWriter.print("Exceptions (count: ");
            classTypeWriter.print(this.exception_table_length);
            classTypeWriter.println("):");
            int n2 = this.exception_table_length;
            int n3 = 0;
            while (--n2 >= 0) {
                classTypeWriter.print("  start: ");
                classTypeWriter.print(this.exception_table[n3] & 0xFFFF);
                classTypeWriter.print(", end: ");
                classTypeWriter.print(this.exception_table[n3 + 1] & 0xFFFF);
                classTypeWriter.print(", handler: ");
                classTypeWriter.print(this.exception_table[n3 + 2] & 0xFFFF);
                classTypeWriter.print(", type: ");
                int n4 = this.exception_table[n3 + 3] & 0xFFFF;
                if (n4 == 0) {
                    classTypeWriter.print("0 /* finally */");
                } else {
                    classTypeWriter.printOptionalIndex(n4);
                    classTypeWriter.printConstantTersely(n4, 7);
                }
                classTypeWriter.println();
                n3 += 4;
            }
        }
        classTypeWriter.printAttributes(this);
    }

    public void disAssemble(ClassTypeWriter classTypeWriter, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            int n4;
            int n5 = n3++;
            int n6 = this.code[n5] & 0xFF;
            String string = Integer.toString(n5);
            int n7 = 0;
            int n8 = string.length();
            while (++n8 <= 3) {
                classTypeWriter.print(' ');
            }
            classTypeWriter.print(string);
            classTypeWriter.print(": ");
            if (n6 < 120) {
                if (n6 < 87) {
                    if (n6 < 3) {
                        this.print("nop;aconst_null;iconst_m1;", n6, classTypeWriter);
                    } else if (n6 < 9) {
                        classTypeWriter.print("iconst_");
                        classTypeWriter.print(n6 - 3);
                    } else if (n6 < 16) {
                        char c;
                        if (n6 < 11) {
                            c = 'l';
                            n6 -= 9;
                        } else if (n6 < 14) {
                            c = 'f';
                            n6 -= 11;
                        } else {
                            c = 'd';
                            n6 -= 14;
                        }
                        classTypeWriter.print(c);
                        classTypeWriter.print("const_");
                        classTypeWriter.print(n6);
                    } else if (n6 < 21) {
                        if (n6 < 18) {
                            short s;
                            this.print("bipush ;sipush ;", n6 - 16, classTypeWriter);
                            if (n6 == 16) {
                                s = this.code[n3++];
                            } else {
                                s = (short)this.readUnsignedShort(n3);
                                n3 += 2;
                            }
                            classTypeWriter.print(s);
                        } else {
                            n7 = n6 == 18 ? 1 : 2;
                            this.print("ldc;ldc_w;ldc2_w;", n6 - 18, classTypeWriter);
                        }
                    } else {
                        String string2;
                        if (n6 < 54) {
                            string2 = "load";
                        } else {
                            string2 = "store";
                            n6 -= 33;
                        }
                        if (n6 < 26) {
                            n4 = -1;
                            n6 -= 21;
                        } else if (n6 < 46) {
                            n4 = (n6 -= 26) % 4;
                            n6 >>= 2;
                        } else {
                            n4 = -2;
                            n6 -= 46;
                        }
                        classTypeWriter.print("ilfdabcs".charAt(n6));
                        if (n4 == -2) {
                            classTypeWriter.write(97);
                        }
                        classTypeWriter.print(string2);
                        if (n4 >= 0) {
                            classTypeWriter.write(95);
                            classTypeWriter.print(n4);
                        } else if (n4 == -1) {
                            if (bl) {
                                n4 = this.readUnsignedShort(n3);
                                n3 += 2;
                            } else {
                                n4 = this.code[n3] & 0xFF;
                                ++n3;
                            }
                            bl = false;
                            classTypeWriter.print(' ');
                            classTypeWriter.print(n4);
                        }
                    }
                } else if (n6 < 96) {
                    this.print("pop;pop2;dup;dup_x1;dup_x2;dup2;dup2_x1;dup2_x2;swap;", n6 - 87, classTypeWriter);
                } else {
                    classTypeWriter.print("ilfda".charAt((n6 - 96) % 4));
                    this.print("add;sub;mul;div;rem;neg;", n6 - 96 >> 2, classTypeWriter);
                }
            } else if (n6 < 170) {
                if (n6 < 132) {
                    classTypeWriter.print((n6 & 1) == 0 ? (char)'i' : 'l');
                    this.print("shl;shr;ushr;and;or;xor;", n6 - 120 >> 1, classTypeWriter);
                } else if (n6 == 132) {
                    int n9;
                    classTypeWriter.print("iinc");
                    if (!bl) {
                        n9 = 0xFF & this.code[n3++];
                        n4 = this.code[n3++];
                    } else {
                        n9 = this.readUnsignedShort(n3);
                        n4 = this.readUnsignedShort(n3 += 2);
                        n3 += 2;
                        bl = false;
                    }
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n9);
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n4);
                } else if (n6 < 148) {
                    classTypeWriter.print("ilfdi".charAt((n6 - 133) / 3));
                    classTypeWriter.print('2');
                    classTypeWriter.print("lfdifdildilfbcs".charAt(n6 - 133));
                } else if (n6 < 153) {
                    this.print("lcmp;fcmpl;fcmpg;dcmpl;dcmpg;", n6 - 148, classTypeWriter);
                } else if (n6 < 169) {
                    if (n6 < 159) {
                        classTypeWriter.print("if");
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 153, classTypeWriter);
                    } else if (n6 < 167) {
                        if (n6 < 165) {
                            classTypeWriter.print("if_icmp");
                        } else {
                            classTypeWriter.print("if_acmp");
                            n6 -= 6;
                        }
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 159, classTypeWriter);
                    } else {
                        this.print("goto;jsr;", n6 - 167, classTypeWriter);
                    }
                    short s = (short)this.readUnsignedShort(n3);
                    n3 += 2;
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n5 + s);
                } else {
                    int n10;
                    classTypeWriter.print("ret ");
                    if (bl) {
                        n10 = this.readUnsignedShort(n3);
                        n10 += 2;
                    } else {
                        n10 = this.code[n3] & 0xFF;
                        ++n3;
                    }
                    bl = false;
                    classTypeWriter.print(n10);
                }
            } else if (n6 < 172) {
                int n11;
                if (this.fixup_count <= 0) {
                    n3 = n3 + 3 & 0xFFFFFFFC;
                }
                int n12 = this.readInt(n3);
                n3 += 4;
                if (n6 == 170) {
                    classTypeWriter.print("tableswitch");
                    n4 = this.readInt(n3);
                    n11 = this.readInt(n3 += 4);
                    n3 += 4;
                    classTypeWriter.print(" low: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" high: ");
                    classTypeWriter.print(n11);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n12);
                    while (n4 <= n11) {
                        n12 = this.readInt(n3);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n4);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n12);
                        ++n4;
                    }
                } else {
                    classTypeWriter.print("lookupswitch");
                    n4 = this.readInt(n3);
                    n3 += 4;
                    classTypeWriter.print(" npairs: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n12);
                    while (--n4 >= 0) {
                        n11 = this.readInt(n3);
                        n12 = this.readInt(n3 += 4);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n11);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n12);
                    }
                }
            } else if (n6 < 178) {
                if (n6 < 177) {
                    classTypeWriter.print("ilfda".charAt(n6 - 172));
                }
                classTypeWriter.print("return");
            } else if (n6 < 182) {
                this.print("getstatic;putstatic;getfield;putfield;", n6 - 178, classTypeWriter);
                n7 = 2;
            } else if (n6 < 185) {
                classTypeWriter.print("invoke");
                this.print("virtual;special;static;", n6 - 182, classTypeWriter);
                n7 = 2;
            } else if (n6 == 185) {
                classTypeWriter.print("invokeinterface (");
                int n13 = this.readUnsignedShort(n3);
                n4 = 0xFF & this.code[n3 += 2];
                n3 += 2;
                classTypeWriter.print(n4 + " args)");
                classTypeWriter.printConstantOperand(n13);
            } else if (n6 < 196) {
                this.print("186;new;newarray;anewarray;arraylength;athrow;checkcast;instanceof;monitorenter;monitorexit;", n6 - 186, classTypeWriter);
                if (n6 == 187 || n6 == 189 || n6 == 192 || n6 == 193) {
                    n7 = 2;
                } else if (n6 == 188) {
                    byte by = this.code[n3++];
                    classTypeWriter.print(' ');
                    if (by >= 4 && by <= 11) {
                        this.print("boolean;char;float;double;byte;short;int;long;", by - 4, classTypeWriter);
                    } else {
                        classTypeWriter.print(by);
                    }
                }
            } else if (n6 == 196) {
                classTypeWriter.print("wide");
                bl = true;
            } else if (n6 == 197) {
                classTypeWriter.print("multianewarray");
                int n14 = this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.printConstantOperand(n14);
                n4 = 0xFF & this.code[n3++];
                classTypeWriter.print(' ');
                classTypeWriter.print(n4);
            } else if (n6 < 200) {
                this.print("ifnull;ifnonnull;", n6 - 198, classTypeWriter);
                short s = (short)this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + s);
            } else if (n6 < 202) {
                this.print("goto_w;jsr_w;", n6 - 200, classTypeWriter);
                int n15 = this.readInt(n3);
                n3 += 4;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + n15);
            } else {
                classTypeWriter.print(n6);
            }
            if (n7 > 0) {
                int n16;
                if (n7 == 1) {
                    n16 = 0xFF & this.code[n3++];
                } else {
                    n16 = this.readUnsignedShort(n3);
                    n3 += 2;
                }
                classTypeWriter.printConstantOperand(n16);
            }
            classTypeWriter.println();
        }
    }

    private int readUnsignedShort(int n) {
        return (0xFF & this.code[n]) << 8 | 0xFF & this.code[n + 1];
    }

    private int readInt(int n) {
        return this.readUnsignedShort(n) << 16 | this.readUnsignedShort(n + 2);
    }

    private void print(String string, int n, PrintWriter printWriter) {
        int n2 = 0;
        int n3 = -1;
        while (n >= 0) {
            n2 = ++n3;
            n3 = string.indexOf(59, n2);
            --n;
        }
        printWriter.write(string, n2, n3 - n2);
    }

    public int beginFragment(Label label) {
        return this.beginFragment(new Label(), label);
    }

    public int beginFragment(Label label, Label label2) {
        int n = this.fixup_count;
        this.fixupAdd(10, label2);
        label.define(this);
        return n;
    }

    public void endFragment(int n) {
        this.fixup_offsets[n] = this.fixup_count << 4 | 0xA;
        Label label = this.fixup_labels[n];
        this.fixupAdd(9, 0, null);
        label.define(this);
    }
}

