/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.KeyPair;
import gnu.mapping.Symbol;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression expression, Compilation compilation) {
        FindCapturedVars findCapturedVars = new FindCapturedVars();
        findCapturedVars.setContext(compilation);
        expression.walk(findCapturedVars);
    }

    @Override
    protected Expression walkApplyExp(ApplyExp applyExp) {
        boolean bl = false;
        if (applyExp.func instanceof ReferenceExp && Compilation.defaultCallConvention <= 1) {
            LambdaExp lambdaExp;
            Expression expression;
            Declaration declaration = Declaration.followAliases(((ReferenceExp)applyExp.func).binding);
            if (declaration != null && declaration.context instanceof ModuleExp && !declaration.isPublic() && !declaration.getFlag(4096) && (expression = declaration.getValue()) instanceof LambdaExp && !(lambdaExp = (LambdaExp)expression).getNeedsClosureEnv()) {
                bl = true;
            }
        } else if (applyExp.func instanceof QuoteExp && applyExp.getArgCount() > 0) {
            Object object2 = ((QuoteExp)applyExp.func).getValue();
            Expression expression = applyExp.getArg(0);
            if (object2 instanceof PrimProcedure && expression instanceof ReferenceExp) {
                Expression expression2;
                PrimProcedure primProcedure = (PrimProcedure)object2;
                Declaration declaration = Declaration.followAliases(((ReferenceExp)expression).binding);
                if (declaration != null && declaration.context instanceof ModuleExp && !declaration.getFlag(4096) && (expression2 = declaration.getValue()) instanceof ClassExp) {
                    Expression[] expressionArray = applyExp.getArgs();
                    LambdaExp lambdaExp = (LambdaExp)expression2;
                    if (!lambdaExp.getNeedsClosureEnv()) {
                        applyExp.nextCall = declaration.firstCall;
                        declaration.firstCall = applyExp;
                        for (int i = 1; i < expressionArray.length; ++i) {
                            expressionArray[i].walk(this);
                        }
                        return applyExp;
                    }
                }
            }
        }
        if (!bl) {
            applyExp.func = applyExp.func.walk(this);
        }
        if (this.exitValue == null) {
            applyExp.args = this.walkExps(applyExp.args);
        }
        return applyExp;
    }

    @Override
    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(lambdaExp);
        for (Declaration declaration = lambdaExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.isSimple()) continue;
            lambdaExp.setFlag(true, 512);
            break;
        }
    }

    @Override
    protected Expression walkClassExp(ClassExp classExp) {
        Expression expression = super.walkClassExp(classExp);
        if (!classExp.explicitInit && !classExp.instanceType.isInterface()) {
            Compilation.getConstructor(classExp.instanceType, classExp);
        } else if (classExp.getNeedsClosureEnv()) {
            LambdaExp lambdaExp = classExp.firstChild;
            while (lambdaExp != null) {
                if ("*init*".equals(lambdaExp.getName())) {
                    lambdaExp.setNeedsStaticLink(true);
                }
                lambdaExp = lambdaExp.nextSibling;
            }
        }
        if (classExp.isSimple() && classExp.getNeedsClosureEnv() && classExp.nameDecl != null) {
            this.comp.error('w', "simple class requiring lexical link - use define-class instead");
            if (classExp.nameDecl.getType() == Compilation.typeClass) {
                classExp.nameDecl.setType(Compilation.typeClassType);
            }
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkModuleExp(ModuleExp moduleExp) {
        ModuleExp moduleExp2 = this.currentModule;
        Hashtable hashtable2 = this.unknownDecls;
        this.currentModule = moduleExp;
        this.unknownDecls = null;
        try {
            Expression expression = this.walkLambdaExp(moduleExp);
            return expression;
        }
        finally {
            this.currentModule = moduleExp2;
            this.unknownDecls = hashtable2;
        }
    }

    @Override
    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        for (Declaration declaration = fluidLetExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.base != null) continue;
            Declaration declaration2 = this.allocUnboundDecl(declaration.getSymbol(), false);
            this.capture(declaration2);
            declaration.base = declaration2;
        }
        return super.walkLetExp(fluidLetExp);
    }

    @Override
    protected Expression walkLetExp(LetExp letExp) {
        if (letExp.body instanceof BeginExp) {
            Expression[] expressionArray = letExp.inits;
            int n = expressionArray.length;
            Expression[] expressionArray2 = ((BeginExp)letExp.body).exps;
            int n2 = 0;
            Declaration declaration = letExp.firstDecl();
            for (int i = 0; i < expressionArray2.length && n2 < n; ++i) {
                Expression expression = expressionArray2[i];
                if (!(expression instanceof SetExp)) continue;
                SetExp setExp = (SetExp)expression;
                if (setExp.binding != declaration || expressionArray[n2] != QuoteExp.nullExp || !setExp.isDefining()) continue;
                Expression expression2 = setExp.new_value;
                if ((expression2 instanceof QuoteExp || expression2 instanceof LambdaExp) && declaration.getValue() == expression2) {
                    expressionArray[n2] = expression2;
                    expressionArray2[i] = QuoteExp.voidExp;
                }
                ++n2;
                declaration = declaration.nextDecl();
            }
        }
        return super.walkLetExp(letExp);
    }

    static Expression checkInlineable(LambdaExp lambdaExp, Set<LambdaExp> set) {
        if (lambdaExp.returnContinuation == LambdaExp.unknownContinuation) {
            return lambdaExp.returnContinuation;
        }
        if (set.contains(lambdaExp)) {
            return lambdaExp.returnContinuation;
        }
        if (lambdaExp.getCanRead() || lambdaExp.isClassMethod() || lambdaExp.min_args != lambdaExp.max_args) {
            lambdaExp.returnContinuation = LambdaExp.unknownContinuation;
            return LambdaExp.unknownContinuation;
        }
        set.add(lambdaExp);
        Expression expression = lambdaExp.returnContinuation;
        if (lambdaExp.tailCallers != null) {
            LambdaExp lambdaExp2 = lambdaExp.outerLambda();
            for (LambdaExp lambdaExp3 : lambdaExp.tailCallers) {
                Expression expression2 = FindCapturedVars.checkInlineable(lambdaExp3, set);
                if (expression2 == LambdaExp.unknownContinuation) {
                    if (expression == null || expression == lambdaExp3.body) {
                        expression = lambdaExp3.body;
                        lambdaExp.inlineHome = lambdaExp3;
                        continue;
                    }
                    lambdaExp.returnContinuation = LambdaExp.unknownContinuation;
                    return expression2;
                }
                if (expression == null) {
                    expression = expression2;
                    if (lambdaExp.inlineHome != null) continue;
                    lambdaExp.inlineHome = lambdaExp.nestedIn(lambdaExp3) ? lambdaExp3 : lambdaExp3.inlineHome;
                    continue;
                }
                if ((expression2 == null || expression == expression2) && !lambdaExp.getFlag(32)) continue;
                lambdaExp.returnContinuation = LambdaExp.unknownContinuation;
                return LambdaExp.unknownContinuation;
            }
        }
        return expression;
    }

    @Override
    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        LinkedHashSet<LambdaExp> linkedHashSet = new LinkedHashSet<LambdaExp>();
        Expression expression = FindCapturedVars.checkInlineable(lambdaExp, linkedHashSet);
        if (expression != LambdaExp.unknownContinuation) {
            lambdaExp.setInlineOnly(true);
        }
        return super.walkLambdaExp(lambdaExp);
    }

    public void capture(Declaration declaration) {
        LambdaExp lambdaExp;
        Expression expression;
        Expression expression2;
        LambdaExp lambdaExp2;
        if (!declaration.getCanRead() && !declaration.getCanCall()) {
            return;
        }
        if (declaration.field != null && declaration.field.getStaticFlag()) {
            return;
        }
        if (this.comp.immediate && declaration.hasConstantValue()) {
            return;
        }
        LambdaExp lambdaExp3 = declaration.getContext().currentLambda();
        Expression expression3 = null;
        LambdaExp lambdaExp4 = null;
        for (lambdaExp2 = this.getCurrentLambda(); lambdaExp2 != lambdaExp3 && lambdaExp2.getInlineOnly(); lambdaExp2 = lambdaExp2.getCaller()) {
            expression2 = lambdaExp2.outerLambda();
            if (expression2 != expression3) {
                lambdaExp4 = ((LambdaExp)expression2).firstChild;
                expression3 = expression2;
            }
            if (lambdaExp4 == null || lambdaExp2.inlineHome == null) {
                lambdaExp2.setCanCall(false);
                return;
            }
            lambdaExp4 = lambdaExp4.nextSibling;
        }
        if (this.comp.usingCPStyle() ? lambdaExp2 instanceof ModuleExp : lambdaExp2 == lambdaExp3) {
            return;
        }
        expression2 = declaration.getValue();
        if (expression2 == null || !(expression2 instanceof LambdaExp)) {
            expression = null;
        } else {
            expression = expression2;
            if (((LambdaExp)expression).getInlineOnly()) {
                return;
            }
            if (((LambdaExp)expression).isHandlingTailCalls()) {
                expression = null;
            } else if (expression == lambdaExp2 && !declaration.getCanRead()) {
                return;
            }
        }
        if (declaration.getFlag(65536)) {
            for (lambdaExp = lambdaExp2; lambdaExp != lambdaExp3; lambdaExp = lambdaExp.outerLambda()) {
                if (lambdaExp.nameDecl == null || !lambdaExp.nameDecl.getFlag(2048)) continue;
                declaration.setFlag(2048);
                break;
            }
        }
        if (declaration.base != null) {
            declaration.base.setCanRead(true);
            this.capture(declaration.base);
        } else if (declaration.getCanRead() || expression == null) {
            if (!declaration.isStatic()) {
                LambdaExp lambdaExp5;
                lambdaExp = lambdaExp2;
                lambdaExp.setImportsLexVars();
                LambdaExp lambdaExp6 = lambdaExp5 = lambdaExp.outerLambda();
                while (lambdaExp6 != lambdaExp3 && lambdaExp6 != null) {
                    lambdaExp = lambdaExp6;
                    if (!declaration.getCanRead() && expression == lambdaExp6) break;
                    Declaration declaration2 = lambdaExp.nameDecl;
                    if (declaration2 != null && declaration2.getFlag(2048)) {
                        this.comp.error('e', "static " + lambdaExp.getName() + " references non-static " + declaration.getName());
                    }
                    lambdaExp.setNeedsStaticLink();
                    lambdaExp6 = lambdaExp.outerLambda();
                }
            }
            lambdaExp3.capture(declaration);
        }
    }

    Declaration allocUnboundDecl(Object object2, boolean bl) {
        Declaration declaration;
        Object object3 = object2;
        if (bl && object2 instanceof Symbol) {
            if (!this.getCompilation().getLanguage().hasSeparateFunctionNamespace()) {
                bl = false;
            } else {
                object3 = new KeyPair((Symbol)object2, EnvironmentKey.FUNCTION);
            }
        }
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            declaration = null;
        } else {
            declaration = (Declaration)this.unknownDecls.get(object3);
        }
        if (declaration == null) {
            declaration = this.currentModule.addDeclaration(object2);
            declaration.setSimple(false);
            declaration.setPrivate(true);
            if (bl) {
                declaration.setProcedureDecl(true);
            }
            if (this.currentModule.isStatic()) {
                declaration.setFlag(2048);
            }
            declaration.setCanRead(true);
            declaration.setCanWrite(true);
            declaration.setFlag(65536);
            declaration.setIndirectBinding(true);
            this.unknownDecls.put(object3, declaration);
        }
        return declaration;
    }

    @Override
    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Object object2;
        Declaration declaration = referenceExp.getBinding();
        if (declaration == null) {
            declaration = this.allocUnboundDecl(referenceExp.getSymbol(), referenceExp.isProcedureName());
            referenceExp.setBinding(declaration);
        }
        if (declaration.getFlag(65536) && this.comp.getBooleanOption("warn-undefined-variable", false) && (object2 = this.comp.resolve(referenceExp.getSymbol(), referenceExp.isProcedureName())) == null) {
            this.comp.error('w', "no declaration seen for " + referenceExp.getName(), referenceExp);
        }
        this.capture(referenceExp.contextDecl(), declaration);
        return referenceExp;
    }

    void capture(Declaration declaration, Declaration declaration2) {
        if (declaration2.isAlias() && declaration2.value instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)declaration2.value;
            Declaration declaration3 = referenceExp.binding;
            if (!(declaration3 == null || declaration != null && declaration3.needsContext())) {
                this.capture(referenceExp.contextDecl(), declaration3);
                return;
            }
        }
        if (declaration != null && declaration2.needsContext()) {
            this.capture(declaration);
        } else {
            this.capture(declaration2);
        }
    }

    @Override
    protected Expression walkThisExp(ThisExp thisExp) {
        if (thisExp.isForContext()) {
            this.getCurrentLambda().setImportsLexVars();
            return thisExp;
        }
        return this.walkReferenceExp(thisExp);
    }

    @Override
    protected Expression walkSetExp(SetExp setExp) {
        Declaration declaration = setExp.binding;
        if (declaration == null) {
            setExp.binding = declaration = this.allocUnboundDecl(setExp.getSymbol(), setExp.isFuncDef());
        }
        if (!declaration.ignorable()) {
            if (!setExp.isDefining()) {
                declaration = Declaration.followAliases(declaration);
            }
            this.capture(setExp.contextDecl(), declaration);
        }
        return super.walkSetExp(setExp);
    }
}

