/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.RealNum;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ExponentialFormat
extends Format {
    public int fracDigits = -1;
    public int intDigits;
    public int expDigits;
    public char overflowChar;
    public char padChar;
    public char exponentChar = (char)69;
    public boolean exponentShowSign;
    public boolean showPlus;
    public int width;
    public boolean general;
    static final double LOG10 = Math.log(10.0);

    static boolean addOne(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n2;
        while (true) {
            char c;
            if (n3 == n) {
                stringBuffer.insert(n3, '1');
                return true;
            }
            if ((c = stringBuffer.charAt(--n3)) != '9') {
                stringBuffer.setCharAt(n3, (char)(c + '\u0001'));
                return false;
            }
            stringBuffer.setCharAt(n3, '0');
        }
    }

    public StringBuffer format(float f, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(f, this.fracDigits < 0 ? Float.toString(f) : null, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(d, this.fracDigits < 0 ? Double.toString(d) : null, stringBuffer, fieldPosition);
    }

    StringBuffer format(double d, String string, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        block47: {
            int n;
            int n2;
            block46: {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                boolean bl2;
                boolean bl3;
                int n14 = this.intDigits;
                int n15 = this.fracDigits;
                boolean bl4 = bl3 = d < 0.0;
                if (bl3) {
                    d = -d;
                }
                n2 = stringBuffer.length();
                int n16 = 1;
                if (bl3) {
                    if (n15 >= 0) {
                        stringBuffer.append('-');
                    }
                } else if (this.showPlus) {
                    stringBuffer.append('+');
                } else {
                    n16 = 0;
                }
                int n17 = stringBuffer.length();
                boolean bl5 = bl2 = Double.isNaN(d) || Double.isInfinite(d);
                if (n15 < 0 || bl2) {
                    if (string == null) {
                        string = Double.toString(d);
                    }
                    if ((n13 = string.indexOf(69)) >= 0) {
                        stringBuffer.append(string);
                        n12 = string.charAt((n13 += n17) + 1) == '-' ? 1 : 0;
                        n11 = 0;
                        for (n10 = n13 + (n12 != 0 ? 2 : 1); n10 < stringBuffer.length(); ++n10) {
                            n11 = 10 * n11 + (stringBuffer.charAt(n10) - 48);
                        }
                        if (n12 != 0) {
                            n11 = -n11;
                        }
                        stringBuffer.setLength(n13);
                    } else {
                        n11 = RealNum.toStringScientific(string, stringBuffer);
                    }
                    if (bl3) {
                        ++n17;
                    }
                    n12 = n17 + 1;
                    stringBuffer.deleteCharAt(n12);
                    n9 = stringBuffer.length() - n17;
                    if (n9 > 1 && stringBuffer.charAt(n17 + n9 - 1) == '0') {
                        stringBuffer.setLength(n17 + --n9);
                    }
                    n8 = n9 - n11 - 1;
                } else {
                    n9 = n15 + (n14 > 0 ? 1 : n14);
                    n13 = (int)(Math.log(d) / LOG10 + 1000.0);
                    n13 = n13 == Integer.MIN_VALUE ? 0 : (n13 -= 1000);
                    n8 = n9 - n13 - 1;
                    RealNum.toScaledInt(d, n8).format(10, stringBuffer);
                    n11 = n9 - 1 - n8;
                }
                int n18 = n13 = (n11 -= n14 - 1) < 0 ? -n11 : n11;
                int n19 = n13 >= 1000 ? 4 : (n13 >= 100 ? 3 : (n12 = n13 >= 10 ? 2 : 1));
                if (this.expDigits > n12) {
                    n12 = this.expDigits;
                }
                n10 = 1;
                int n20 = !this.general ? 0 : (this.expDigits > 0 ? this.expDigits + 2 : 4);
                boolean bl6 = bl = n15 < 0;
                if (this.general || bl) {
                    n7 = n9 - n8;
                    if (bl) {
                        int n21 = n15 = n7 < 7 ? n7 : 7;
                        if (n9 > n15) {
                            n15 = n9;
                        }
                    }
                    n6 = n15 - n7;
                    if (this.general && n7 >= 0 && n6 >= 0) {
                        n9 = n15;
                        n14 = n7;
                        n10 = 0;
                    } else if (bl) {
                        if (this.width <= 0) {
                            n9 = n15;
                        } else {
                            n9 = n5 = this.width - n16 - n12 - 3;
                            if (n14 < 0) {
                                n9 -= n14;
                            }
                            if (n9 > n15) {
                                n9 = n15;
                            }
                        }
                        if (n9 <= 0) {
                            n9 = 1;
                        }
                    }
                }
                n7 = n17 + n9;
                while (stringBuffer.length() < n7) {
                    stringBuffer.append('0');
                }
                n6 = n7 == stringBuffer.length() ? 48 : (int)stringBuffer.charAt(n7);
                int n22 = n5 = n6 >= 53 ? 1 : 0;
                if (n5 != 0 && ExponentialFormat.addOne(stringBuffer, n17, n7)) {
                    ++n8;
                }
                n8 -= stringBuffer.length() - n7;
                stringBuffer.setLength(n7);
                int n23 = n17;
                if (n14 < 0) {
                    n4 = n14;
                    while (++n4 <= 0) {
                        stringBuffer.insert(n17, '0');
                    }
                } else {
                    while (n17 + n14 > n7) {
                        stringBuffer.append('0');
                        ++n7;
                    }
                    n23 += n14;
                }
                if (bl2) {
                    n10 = 0;
                } else {
                    stringBuffer.insert(n23, '.');
                }
                if (n10 != 0) {
                    stringBuffer.append(this.exponentChar);
                    if (this.exponentShowSign || n11 < 0) {
                        stringBuffer.append(n11 >= 0 ? (char)'+' : '-');
                    }
                    n = stringBuffer.length();
                    stringBuffer.append(n13);
                    n4 = stringBuffer.length();
                    n3 = this.expDigits - (n4 - n);
                    if (n3 > 0) {
                        n4 += n3;
                        while (--n3 >= 0) {
                            stringBuffer.insert(n, '0');
                        }
                    }
                } else {
                    n12 = 0;
                }
                n4 = stringBuffer.length();
                n3 = n4 - n2;
                n = this.width - n3;
                if (!(!bl || n23 + 1 != stringBuffer.length() && stringBuffer.charAt(n23 + 1) != this.exponentChar || this.width > 0 && n <= 0)) {
                    --n;
                    stringBuffer.insert(n23 + 1, '0');
                }
                if (n < 0 && this.width > 0 || n10 != 0 && n12 > this.expDigits && this.expDigits > 0 && this.overflowChar != '\u0000') break block46;
                if (n14 <= 0 && (n > 0 || this.width <= 0)) {
                    stringBuffer.insert(n17, '0');
                    --n;
                }
                if (n10 == 0 && this.width > 0) {
                    while (--n20 >= 0) {
                        stringBuffer.append(' ');
                        --n;
                    }
                }
                while (--n >= 0) {
                    stringBuffer.insert(n2, this.padChar);
                }
                break block47;
            }
            if (this.overflowChar == '\u0000') break block47;
            stringBuffer.setLength(n2);
            n = this.width;
            while (--n >= 0) {
                stringBuffer.append(this.overflowChar);
            }
        }
        return stringBuffer;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(Object object2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(((RealNum)object2).doubleValue(), stringBuffer, fieldPosition);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("ExponentialFormat.parse - not implemented");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("ExponentialFormat.parseObject - not implemented");
    }
}

