/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.CollationKey;
import java.text.Collator;

public class NamedCollator
extends Collator
implements Externalizable {
    Collator collator;
    String name;
    public static final String UNICODE_CODEPOINT_COLLATION = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    public static final NamedCollator codepointCollation = new NamedCollator();

    public static NamedCollator make(String string) {
        NamedCollator namedCollator = new NamedCollator();
        namedCollator.name = string;
        namedCollator.resolve();
        return namedCollator;
    }

    public String getName() {
        return this.name;
    }

    public static NamedCollator find(String string) {
        return NamedCollator.make(string);
    }

    public void resolve() {
        if (this.name != null && !this.name.equals(UNICODE_CODEPOINT_COLLATION)) {
            throw new RuntimeException("unknown collation: " + this.name);
        }
    }

    public static int codepointCompare(String string, String string2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = string2.length();
        do {
            if (n3 == n5) {
                return n4 == n6 ? 0 : -1;
            }
            if (n4 == n6) {
                return 1;
            }
            if ((n2 = string.charAt(n3++)) >= 55296 && n2 < 56320 && n3 < n5) {
                n2 = (n2 - 55296) * 1024 + (string.charAt(n3++) - 56320) + 65536;
            }
            if ((n = string2.charAt(n4++)) < 55296 || n >= 56320 || n4 >= n6) continue;
            n = (n - 55296) * 1024 + (string2.charAt(n4++) - 56320) + 65536;
        } while (n2 == n);
        return n2 < n ? -1 : 1;
    }

    public int compare(String string, String string2) {
        if (this.collator != null) {
            return this.collator.compare(string, string2);
        }
        return NamedCollator.codepointCompare(string, string2);
    }

    public CollationKey getCollationKey(String string) {
        return this.collator.getCollationKey(string);
    }

    public int hashCode() {
        if (this.collator != null) {
            return this.collator.hashCode();
        }
        return 0;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.name);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = objectInput.readUTF();
        this.resolve();
    }

    static {
        NamedCollator.codepointCollation.name = UNICODE_CODEPOINT_COLLATION;
    }
}

