/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.bytecode.Type;
import gnu.expr.Expression;
import gnu.mapping.ArgList;
import gnu.mapping.CallContext;
import gnu.mapping.HasSetter;
import gnu.mapping.LazyPropertyKey;
import gnu.mapping.Namespace;
import gnu.mapping.PropertySet;
import gnu.mapping.Setter;
import gnu.mapping.Setter0;
import gnu.mapping.Setter1;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Procedure
extends PropertySet {
    protected MethodHandle applyToObjectMethod;
    protected MethodHandle applyToConsumerMethod;
    private static final String sourceLocationKey = "source-location";
    private static final Symbol setterKey = Namespace.EmptyNamespace.getSymbol("setter");
    public static final Symbol validateApplyKey = Namespace.EmptyNamespace.getSymbol("validate-apply");
    public static final Symbol validateXApplyKey = Namespace.EmptyNamespace.getSymbol("validate-xapply");
    public static final Symbol compilerXKey = Namespace.EmptyNamespace.getSymbol("compile-apply");
    public static final LazyPropertyKey<?> compilerKey = new LazyPropertyKey("compiler");
    public static final MethodType applyMethodType = MethodType.methodType(Object.class, Procedure.class, CallContext.class);
    public static final MethodHandle applyToObjectDefault = Procedure.lookupApplyHandle(Procedure.class, "applyToObjectDefault");
    public static final MethodHandle applyToConsumerDefault = Procedure.lookupApplyHandle(Procedure.class, "applyToConsumerDefault");

    public void setSourceLocation(String file2, int line) {
        this.setProperty(sourceLocationKey, file2 + ":" + line);
    }

    public String getSourceLocation() {
        Object value = this.getProperty(sourceLocationKey, null);
        return value == null ? null : value.toString();
    }

    public final MethodHandle getApplyToConsumerMethod() {
        return this.applyToConsumerMethod;
    }

    public final MethodHandle getApplyToObjectMethod() {
        return this.applyToObjectMethod;
    }

    public static Object applyToConsumerDefault(Procedure proc, CallContext ctx) throws Throwable {
        ctx.proc = proc;
        Object r = proc.applyToObjectMethod.invokeExact(proc, ctx);
        if (r != ctx) {
            Values.writeValues(r, ctx.consumer);
            r = null;
        }
        return r;
    }

    public static Object applyToObjectDefault(Procedure proc, CallContext ctx) throws Throwable {
        int start = ctx.startFromContext();
        try {
            if (proc.applyToConsumerMethod.invokeExact(proc, ctx) != ctx) {
                return ctx.getFromContext(start);
            }
            ctx.cleanupFromContext(start);
            return ctx;
        }
        catch (Throwable ex) {
            ctx.cleanupFromContext(start);
            throw ex;
        }
    }

    public Procedure() {
    }

    public Procedure(String n) {
        this.setName(n);
    }

    public Procedure(boolean resultGoesToConsumer, MethodHandle applyMethod) {
        if (resultGoesToConsumer) {
            this.applyToConsumerMethod = applyMethod;
            this.applyToObjectMethod = applyToObjectDefault;
        } else {
            this.applyToObjectMethod = applyMethod;
            this.applyToConsumerMethod = applyToConsumerDefault;
        }
    }

    public Procedure(boolean resultGoesToConsumer, MethodHandle applyMethod, String n) {
        this(resultGoesToConsumer, applyMethod);
        this.setName(n);
    }

    public void checkBadCode(CallContext ctx) {
        boolean code = false;
    }

    public Object applyL(ArgList args) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this);
        ctx.addAll(args);
        return ctx.runUntilValue();
    }

    public Object applyN(Object[] args) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApplyAll(this, args);
        return ctx.runUntilValue();
    }

    public Object apply0() throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this);
        return ctx.runUntilValue();
    }

    public Object apply1(Object arg1) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this, arg1);
        return ctx.runUntilValue();
    }

    public Object apply2(Object arg1, Object arg2) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this, arg1, arg2);
        return ctx.runUntilValue();
    }

    public Object apply3(Object arg1, Object arg2, Object arg3) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this, arg1, arg2, arg3);
        return ctx.runUntilValue();
    }

    public Object apply4(Object arg1, Object arg2, Object arg3, Object arg4) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        ctx.setupApply(this, arg1, arg2, arg3, arg4);
        return ctx.runUntilValue();
    }

    public final int minArgs() {
        return Procedure.minArgs(this.numArgs());
    }

    public final int maxArgs() {
        return Procedure.maxArgs(this.numArgs());
    }

    public int numArgs() {
        return -4096;
    }

    public static int minArgs(int num) {
        return num & 0xFFF;
    }

    public static int maxArgs(int num) {
        return num >> 12;
    }

    public static void checkArgCount(Procedure proc, int argCount) {
        int num = proc.numArgs();
        if (argCount < Procedure.minArgs(num) || num >= 0 && argCount > Procedure.maxArgs(num)) {
            throw new WrongArguments(proc, argCount);
        }
    }

    public Procedure getSetter() {
        if (!(this instanceof HasSetter)) {
            Object setter = this.getProperty(setterKey, null);
            if (setter instanceof Procedure) {
                return (Procedure)setter;
            }
            throw new RuntimeException("procedure '" + this.getName() + "' has no setter");
        }
        int num_args = this.numArgs();
        if (num_args == 0) {
            return new Setter0(this);
        }
        if (num_args == 4097) {
            return new Setter1(this);
        }
        return new Setter(this);
    }

    public void setSetter(Procedure setter) {
        if (this instanceof HasSetter) {
            throw new RuntimeException("procedure '" + this.getName() + "' has builtin setter - cannot be modified");
        }
        this.setProperty(setterKey, setter);
    }

    public void set0(Object result) throws Throwable {
        this.getSetter().apply1(result);
    }

    public void set1(Object arg1, Object value) throws Throwable {
        this.getSetter().apply2(arg1, value);
    }

    public void setN(Object[] args) throws Throwable {
        this.getSetter().applyN(args);
    }

    public boolean isSideEffectFree() {
        return false;
    }

    public Type getReturnType(Expression[] args) {
        return Type.objectType;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("#<procedure ");
        String n = this.getName();
        if (n == null) {
            n = this.getSourceLocation();
        }
        if (n == null) {
            n = this.getClass().getName();
        }
        sbuf.append(n);
        sbuf.append('>');
        return sbuf.toString();
    }

    public static MethodHandle lookupApplyHandle(Class clas, String mname) {
        try {
            return MethodHandles.lookup().findStatic(clas, mname, applyMethodType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

