/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.javafx;

import java.lang.reflect.Method;
import javafx.application.Application;
import org.domterm.Backend;
import org.domterm.ClassBackend;
import org.domterm.ProcessBackend;
import org.domterm.javafx.WebTerminalApp;
import org.domterm.pty.PTY;
import org.domterm.pty.PtyBackend;
import org.domterm.util.WTDebug;

public class Main {
    static Backend mainClient;

    public static void usage() {
        System.err.println("--class classname arg ...");
        System.err.println("--process [command arg ...]");
        System.err.println("--pty [command arg ...]");
    }

    public static void usage(String string) {
        System.err.print("error in org.domterm.javafx.Main: ");
        System.err.println(string);
        Main.usage();
        System.exit(-1);
    }

    protected Backend makeClient() throws Exception {
        return mainClient;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 32;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            if (stringArray2.equals("--class")) {
                if (n + 1 == stringArray.length) {
                    Main.usage("missing class name");
                }
                Method method = null;
                try {
                    method = ClassBackend.getMainMethod(stringArray[n + 1]);
                }
                catch (Throwable throwable) {
                    Main.usage("caught " + throwable);
                }
                System.err.println("found method " + method);
                String[] stringArray3 = new String[stringArray.length - n - 2];
                System.arraycopy(stringArray, n + 2, stringArray3, 0, stringArray3.length);
                mainClient = new ClassBackend(method, stringArray3);
                break;
            }
            if (stringArray2.equals("--pty")) {
                n2 = 84;
                continue;
            }
            if (stringArray2.equals("--shell") || stringArray2.equals("--process") || stringArray.equals("--pipe")) {
                n2 = 83;
                continue;
            }
            if (stringArray2.length() != 0 && stringArray2.charAt(0) != '-') break;
            Main.usage("unknown argument '" + (String)stringArray2 + "'");
        }
        if (mainClient == null) {
            stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
            if (n2 == 84 || n2 == 32) {
                try {
                    PTY.checkLoaded();
                    n2 = 84;
                }
                catch (Throwable throwable) {
                    if (n2 == 32) {
                        n2 = 83;
                        System.err.println("(no pty in java.library.path - using --process)");
                    }
                    Main.usage("caught " + throwable);
                }
            }
            try {
                mainClient = n2 == 83 ? new ProcessBackend(stringArray2) : new PtyBackend(stringArray2, null);
            }
            catch (Throwable throwable) {
                Main.usage("caught " + throwable);
            }
        }
        WTDebug.init();
        try {
            WebTerminalApp.exitOnStop = true;
            WebTerminalApp.mainClient = mainClient;
        }
        catch (Throwable throwable) {
            Main.usage("JavaFX or WebEngine classes not found");
        }
        Application.launch(WebTerminalApp.class, (String[])stringArray);
    }
}

