import{UIString as t,Color as e,ObjectWrapper as i,Settings as s}from"../common/common.js";import{Platform as r}from"../host/host.js";import{NumberUtilities as o}from"../platform/platform.js";import{SDKModel as n,PerformanceMetricsModel as a}from"../sdk/sdk.js";import{ThemeSupport as l}from"../theme_support/theme_support.js";import{Widget as h,ARIAUtils as c,Icon as m}from"../ui/ui.js";class d extends h.HBox{constructor(){super(!0),this.registerRequiredCSS("performance_monitor/performanceMonitor.css",{enableLegacyPatching:!0}),this.contentElement.classList.add("perfmon-pane"),this._metricsBuffer=[],this._pixelsPerMs=.01,this._pollIntervalMs=500,this._scaleHeight=16,this._graphHeight=90,this._gridColor=l.instance().patchColorText("rgba(0, 0, 0, 0.08)",l.ColorUsage.Foreground),this._controlPane=new g(this.contentElement);const e=this.contentElement.createChild("div","perfmon-chart-container");this._canvas=e.createChild("canvas"),this._canvas.tabIndex=-1,c.setAccessibleName(this._canvas,t.UIString("Graphs displaying a real-time view of performance metrics")),this.contentElement.createChild("div","perfmon-chart-suspend-overlay fill").createChild("div").textContent=t.UIString("Paused"),this._controlPane.addEventListener(f.MetricChanged,this._recalcChartHeight,this),n.TargetManager.instance().observeModels(a.PerformanceMetricsModel,this)}wasShown(){this._model&&(n.TargetManager.instance().addEventListener(n.Events.SuspendStateChanged,this._suspendStateChanged,this),this._model.enable(),this._suspendStateChanged())}willHide(){this._model&&(n.TargetManager.instance().removeEventListener(n.Events.SuspendStateChanged,this._suspendStateChanged,this),this._stopPolling(),this._model.disable())}modelAdded(t){this._model||(this._model=t,this.isShowing()&&this.wasShown())}modelRemoved(t){this._model===t&&(this.isShowing()&&this.willHide(),this._model=null)}_suspendStateChanged(){const t=n.TargetManager.instance().allTargetsSuspended();t?this._stopPolling():this._startPolling(),this.contentElement.classList.toggle("suspended",t)}_startPolling(){this._startTimestamp=0,this._pollTimer=setInterval(()=>this._poll(),this._pollIntervalMs),this.onResize(),function t(){this._draw(),this._animationId=this.contentElement.window().requestAnimationFrame(t.bind(this))}.call(this)}_stopPolling(){clearInterval(this._pollTimer),this.contentElement.window().cancelAnimationFrame(this._animationId),this._metricsBuffer=[]}async _poll(){const t=await this._model.requestMetrics(),e=t.timestamp,i=t.metrics;this._metricsBuffer.push({timestamp:e,metrics:i});const s=this._width/this._pixelsPerMs,r=Math.ceil(s/this._pollIntervalMs*2);this._metricsBuffer.length>2*r&&this._metricsBuffer.splice(0,this._metricsBuffer.length-r),this._controlPane.updateMetrics(i)}_draw(){const t=this._canvas.getContext("2d");t.save(),t.scale(window.devicePixelRatio,window.devicePixelRatio),t.clearRect(0,0,this._width,this._height),t.save(),t.translate(0,this._scaleHeight);for(const e of this._controlPane.charts())this._controlPane.isActive(e.metrics[0].name)&&(this._drawChart(t,e,this._graphHeight),t.translate(0,this._graphHeight));t.restore(),this._drawHorizontalGrid(t),t.restore()}_drawHorizontalGrid(t){const e=l.instance().patchColorText("rgba(0, 0, 0, 0.02)",l.ColorUsage.Foreground);t.font="10px "+r.fontFamily(),t.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground);const i=Date.now()/1e3;for(let s=Math.ceil(i);;--s){const r=this._width-(1e3*(i-s)-this._pollIntervalMs)*this._pixelsPerMs;if(r<-50)break;t.beginPath(),t.moveTo(r,0),t.lineTo(r,this._height),s>=0&&s%10==0&&t.fillText(new Date(1e3*s).toLocaleTimeString(),r+4,12),t.strokeStyle=s%10?e:this._gridColor,t.stroke()}}_drawChart(t,i,s){t.save(),t.rect(0,0,this._width,s),t.clip();const o=1.05*this._calcMax(i),n=i.stacked?new Map:null,a=[];for(let t=i.metrics.length-1;t>=0;--t){const e=i.metrics[t];a.push({path:this._buildMetricPath(i,e,s-8,o,t?n:null),color:e.color})}const h=e.Color.parse(l.instance().patchColorText("white",l.ColorUsage.Background));for(const i of a.reverse()){const s=i.color;t.save(),t.fillStyle=h.blendWith(e.Color.parse(s).setAlpha(.2)).asString(null),t.fill(i.path),t.strokeStyle=s,t.lineWidth=.5,t.stroke(i.path),t.restore()}t.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground),t.font="10px  "+r.fontFamily(),t.fillText(i.title,8,10),this._drawVerticalGrid(t,s-8,o,i),t.restore()}_calcMax(t){if(t.max)return t.max;const e=this._width,i=performance.now()-this._pollIntervalMs-e/this._pixelsPerMs;let s=-1/0;for(const e of t.metrics)for(let t=this._metricsBuffer.length-1;t>=0;--t){const r=this._metricsBuffer[t],o=r.metrics.get(e.name);if(s=Math.max(s,o),r.timestamp<i)break}if(!this._metricsBuffer.length)return 10;const r=Math.pow(10,Math.floor(Math.log10(s)));s=Math.ceil(s/r/2)*r*2;return t.currentMax=.2*s+.8*(t.currentMax||s),t.currentMax}_drawVerticalGrid(t,e,i,s){let r=Math.pow(10,Math.floor(Math.log10(i)));const o=Math.floor(i/r);1!==o&&o%2==1&&(r*=2);let n=Math.floor(i/r)*r;const a=i,h=e-18;t.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground),t.strokeStyle=this._gridColor,t.beginPath();for(let e=0;e<2;++e){const e=c(n),i=p._formatNumber(n,s);t.moveTo(0,e),t.lineTo(4,e),t.moveTo(t.measureText(i).width+12,e),t.lineTo(this._width,e),t.fillText(i,8,c(n)+3),n/=2}function c(t){return Math.round(e-h*t/a)+.5}t.stroke(),t.beginPath(),t.moveTo(0,e+.5),t.lineTo(this._width,e+.5),t.strokeStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.2)",l.ColorUsage.Foreground),t.stroke()}_buildMetricPath(t,e,i,s,r){const n=new Path2D,a=i-18;if(a<1)return n;const l=s,h=e.name,c=this._pixelsPerMs,m=performance.now()-this._pollIntervalMs-this._width/c,d=t.smooth;let _=0,g=0,f=0;this._metricsBuffer.length&&(_=(this._metricsBuffer[0].timestamp-m)*c,n.moveTo(_,p(0)),n.lineTo(this._width+5,p(0)),g=p(this._metricsBuffer.peekLast().metrics.get(h)),f=this._width+5,n.lineTo(f,g));for(let t=this._metricsBuffer.length-1;t>=0;--t){const e=this._metricsBuffer[t],i=e.timestamp;let s=e.metrics.get(h);r&&(s+=r.get(i)||0,s=o.clamp(s,0,1),r.set(i,s));const a=p(s);if(_=(i-m)*c,d){const t=(f+_)/2;n.bezierCurveTo(t,g,t,a,_,a)}else n.lineTo(_,g),n.lineTo(_,a);if(f=_,g=a,i<m)break}return n;function p(t){return Math.round(i-a*t/l)+.5}}onResize(){super.onResize(),this._width=this._canvas.offsetWidth,this._canvas.width=Math.round(this._width*window.devicePixelRatio),this._recalcChartHeight()}_recalcChartHeight(){let t=this._scaleHeight;for(const e of this._controlPane.charts())this._controlPane.isActive(e.metrics[0].name)&&(t+=this._graphHeight);this._height=Math.ceil(t*window.devicePixelRatio),this._canvas.height=this._height,this._canvas.style.height=this._height/window.devicePixelRatio+"px"}}const _={Percent:Symbol("Percent"),Bytes:Symbol("Bytes")};class g extends i.ObjectWrapper{constructor(e){super(),this.element=e.createChild("div","perfmon-control-pane"),this._enabledChartsSetting=s.Settings.instance().createSetting("perfmonActiveIndicators2",["TaskDuration","JSHeapTotalSize","Nodes"]),this._enabledCharts=new Set(this._enabledChartsSetting.get());const i=_;this._chartsInfo=[{title:t.UIString("CPU usage"),metrics:[{name:"TaskDuration",color:"#999"},{name:"ScriptDuration",color:"orange"},{name:"LayoutDuration",color:"blueviolet"},{name:"RecalcStyleDuration",color:"violet"}],format:i.Percent,smooth:!0,stacked:!0,color:"red",max:1},{title:t.UIString("JS heap size"),metrics:[{name:"JSHeapTotalSize",color:"#99f"},{name:"JSHeapUsedSize",color:"blue"}],format:i.Bytes,color:"blue"},{title:t.UIString("DOM Nodes"),metrics:[{name:"Nodes",color:"green"}]},{title:t.UIString("JS event listeners"),metrics:[{name:"JSEventListeners",color:"yellowgreen"}]},{title:t.UIString("Documents"),metrics:[{name:"Documents",color:"darkblue"}]},{title:t.UIString("Document Frames"),metrics:[{name:"Frames",color:"darkcyan"}]},{title:t.UIString("Layouts / sec"),metrics:[{name:"LayoutCount",color:"hotpink"}]},{title:t.UIString("Style recalcs / sec"),metrics:[{name:"RecalcStyleCount",color:"deeppink"}]}];for(const t of this._chartsInfo){t.color&&(t.color=l.instance().patchColorText(t.color,l.ColorUsage.Foreground));for(const e of t.metrics)e.color=l.instance().patchColorText(e.color,l.ColorUsage.Foreground)}this._indicators=new Map;for(const t of this._chartsInfo){const e=t.metrics[0].name,i=this._enabledCharts.has(e),s=new p(this.element,t,i,this._onToggle.bind(this,e));this._indicators.set(e,s)}}_onToggle(t,e){e?this._enabledCharts.add(t):this._enabledCharts.delete(t),this._enabledChartsSetting.set(Array.from(this._enabledCharts)),this.dispatchEventToListeners(f.MetricChanged)}charts(){return this._chartsInfo}isActive(t){return this._enabledCharts.has(t)}updateMetrics(t){for(const e of this._indicators.keys())t.has(e)&&this._indicators.get(e).setValue(t.get(e))}}const f={MetricChanged:Symbol("MetricChanged")};class p{constructor(t,e,i,s){const r=e.color||e.metrics[0].color;this._info=e,this._active=i,this._onToggle=s,this.element=t.createChild("div","perfmon-indicator"),this._swatchElement=m.Icon.create("smallicon-checkmark-square","perfmon-indicator-swatch"),this._swatchElement.style.backgroundColor=r,this.element.appendChild(this._swatchElement),this.element.createChild("div","perfmon-indicator-title").textContent=e.title,this._valueElement=this.element.createChild("div","perfmon-indicator-value"),this._valueElement.style.color=r,this.element.addEventListener("click",()=>this._toggleIndicator()),this.element.addEventListener("keypress",t=>this._handleKeypress(t)),this.element.classList.toggle("active",i),c.markAsCheckbox(this.element),c.setChecked(this.element,this._active),this.element.tabIndex=0}static _formatNumber(t,e){switch(p._numberFormatter||(p._numberFormatter=new Intl.NumberFormat("en-US",{maximumFractionDigits:1}),p._percentFormatter=new Intl.NumberFormat("en-US",{maximumFractionDigits:1,style:"percent"})),e.format){case _.Percent:return p._percentFormatter.format(t);case _.Bytes:return o.bytesToString(t);default:return p._numberFormatter.format(t)}}setValue(t){this._valueElement.textContent=p._formatNumber(t,this._info)}_toggleIndicator(){this._active=!this._active,this.element.classList.toggle("active",this._active),c.setChecked(this.element,this._active),this._onToggle(this._active)}_handleKeypress(t){const e=t;" "!==e.key&&"Enter"!==e.key||this._toggleIndicator()}}const u=new Intl.NumberFormat("en-US",{maximumFractionDigits:1});var v=Object.freeze({__proto__:null,PerformanceMonitorImpl:d,Format:_,ControlPane:g,Events:f,MetricIndicator:p,format:u,MetricInfo:void 0,ChartInfo:void 0});export{v as PerformanceMonitor};
