/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorProtocolTypes.h"
#include <wtf/Assertions.h>

namespace Inspector {



namespace Protocol {

// Versions.
namespace Audit {
static constexpr unsigned VERSION = 3;
} // Audit

namespace Recording {
static constexpr unsigned VERSION = 1;
} // Recording
// End of versions.


// Forward declarations.
namespace Animation {
class Animation;
class Effect;
class Keyframe;
class TrackingUpdate;
enum class AnimationState;
enum class PlaybackDirection;
enum class FillMode;
} // Animation

namespace ApplicationCache {
class ApplicationCacheResource;
class ApplicationCache;
class FrameWithManifest;
} // ApplicationCache

namespace Browser {
class Extension;
} // Browser

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace CPUProfiler {
class ThreadInfo;
class Event;
} // CPUProfiler
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace CSS {
class CSSStyleId;
class CSSRuleId;
class PseudoIdMatches;
class InheritedStyleEntry;
class RuleMatch;
class CSSSelector;
class SelectorList;
class CSSStyleAttribute;
class CSSStyleSheetHeader;
class CSSStyleSheetBody;
class CSSRule;
class SourceRange;
class ShorthandEntry;
class CSSPropertyInfo;
class CSSComputedStyleProperty;
class CSSStyle;
class CSSProperty;
class Grouping;
enum class StyleSheetOrigin;
enum class PseudoId;
enum class CSSPropertyStatus;
} // CSS

namespace Canvas {
class ContextAttributes;
class Canvas;
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
class ShaderProgram;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
enum class ContextType;
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
enum class ProgramType;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
enum class ShaderType;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
} // Canvas

namespace Console {
class Channel;
class ConsoleMessage;
class CallFrame;
class StackTrace;
enum class ChannelSource;
enum class ChannelLevel;
} // Console

namespace DOM {
class Node;
class DataBinding;
class Rect;
class EventListener;
class AccessibilityProperties;
class RGBAColor;
class HighlightConfig;
class FilePayload;
enum class PseudoType;
enum class ShadowRootType;
enum class CustomElementState;
enum class LiveRegionRelevant;
} // DOM

namespace DOMDebugger {
enum class DOMBreakpointType;
enum class EventBreakpointType;
} // DOMDebugger

namespace DOMStorage {
class StorageId;
} // DOMStorage

namespace Database {
class Database;
class Error;
} // Database

namespace Debugger {
class Location;
class BreakpointAction;
class BreakpointOptions;
class FunctionDetails;
class CallFrame;
class Scope;
class ProbeSample;
class AssertPauseReason;
class BreakpointPauseReason;
class CSPViolationPauseReason;
} // Debugger

namespace GenericTypes {
class SearchMatch;
} // GenericTypes

namespace Heap {
class GarbageCollection;
} // Heap

#if defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE
namespace IndexedDB {
class DatabaseWithObjectStores;
class ObjectStore;
class ObjectStoreIndex;
class Key;
class KeyRange;
class DataEntry;
class KeyPath;
} // IndexedDB
#endif // defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE

namespace LayerTree {
class IntRect;
class Layer;
class CompositingReasons;
} // LayerTree

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace Memory {
class Event;
class CategoryData;
} // Memory
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace Network {
class Headers;
class ResourceTiming;
class Request;
class Response;
class Metrics;
class WebSocketRequest;
class WebSocketResponse;
class WebSocketFrame;
class CachedResource;
class Initiator;
enum class NetworkStage;
enum class ResourceErrorType;
} // Network

namespace Page {
class Frame;
class FrameResource;
class FrameResourceTree;
class SearchResult;
class Cookie;
class AXNode;
enum class Setting;
enum class ResourceType;
enum class CoordinateSystem;
enum class CookieSameSitePolicy;
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
enum class Appearance;
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
} // Page

namespace Playwright {
class Cookie;
class SetCookieParam;
class Geolocation;
enum class CookieSameSitePolicy;
} // Playwright

namespace Recording {
class InitialState;
class Frame;
class Recording;
enum class Type;
enum class Initiator;
} // Recording

namespace Runtime {
class RemoteObject;
class ObjectPreview;
class PropertyPreview;
class EntryPreview;
class CollectionEntry;
class PropertyDescriptor;
class InternalPropertyDescriptor;
class CallArgument;
class ExecutionContextDescription;
class ErrorRange;
class StructureDescription;
class TypeSet;
class TypeDescription;
class TypeLocation;
class BasicBlock;
enum class ExecutionContextType;
enum class SyntaxErrorType;
} // Runtime

namespace ScriptProfiler {
class Event;
class ExpressionLocation;
class StackFrame;
class StackTrace;
class Samples;
enum class EventType;
} // ScriptProfiler

namespace Security {
class Connection;
class Certificate;
class Security;
} // Security

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
namespace ServiceWorker {
class Configuration;
} // ServiceWorker
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

namespace Target {
class TargetInfo;
} // Target

namespace Timeline {
class TimelineEvent;
enum class EventType;
enum class Instrument;
} // Timeline
// End of forward declarations.


// Typedefs.
namespace Animation {
/* Unique Web Animation identifier. */
using AnimationId = String;
} // Animation

namespace Browser {
/* Unique extension identifier. */
using ExtensionId = String;
} // Browser

namespace CSS {
using StyleSheetId = String;
} // CSS

namespace Canvas {
/* Unique canvas identifier. */
using CanvasId = String;
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
/* Unique shader program identifier. */
using ProgramId = String;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
} // Canvas

namespace DOM {
/* Unique DOM node identifier. */
using NodeId = int;
/* Unique event listener identifier. */
using EventListenerId = int;
/* An array of quad vertices, x immediately followed by y for each point, points clock-wise. */
using Quad = JSON::ArrayOf<double>;
} // DOM

namespace DOMStorage {
/* DOM Storage item. */
using Item = JSON::ArrayOf<String>;
} // DOMStorage

namespace Database {
/* Unique identifier of Database object. */
using DatabaseId = String;
} // Database

namespace Debugger {
/* Breakpoint identifier. */
using BreakpointId = String;
/* Breakpoint action identifier. */
using BreakpointActionIdentifier = int;
/* Unique script identifier. */
using ScriptId = String;
/* Call frame identifier. */
using CallFrameId = String;
} // Debugger

namespace Heap {
/* JavaScriptCore HeapSnapshot JSON data. */
using HeapSnapshotData = String;
} // Heap

namespace Input {
/* UTC time in seconds, counted from January 1, 1970. */
using TimeSinceEpoch = double;
} // Input

namespace LayerTree {
/* Unique RenderLayer identifier. */
using LayerId = String;
/* Unique PseudoElement identifier. */
using PseudoElementId = String;
} // LayerTree

namespace Network {
/* Unique loader identifier. */
using LoaderId = String;
/* Unique frame identifier. */
using FrameId = String;
/* Unique request identifier. */
using RequestId = String;
/* Elapsed seconds since frontend connected. */
using Timestamp = double;
/* Number of seconds since epoch. */
using Walltime = double;
} // Network

namespace Playwright {
/* Id of Browser context. */
using ContextID = String;
/* Id of WebPageProxy. */
using PageProxyID = String;
} // Playwright

namespace Runtime {
/* Unique object identifier. */
using RemoteObjectId = String;
/* Id of an execution context. */
using ExecutionContextId = int;
} // Runtime

namespace Screencast {
/* Unique identifier of the screencast. */
using ScreencastId = String;
} // Screencast
// End of typedefs.

namespace InspectorHelpers {

JS_EXPORT_PRIVATE String getEnumConstantValue(int code);

template<typename T> String getEnumConstantValue(T enumValue)
{
    return getEnumConstantValue(static_cast<int>(enumValue));
}

} // namespace InspectorHelpers

namespace Animation {

enum class AnimationState {
    Ready = 0,
    Delayed = 1,
    Active = 2,
    Canceled = 3,
    Done = 4,
}; // enum class AnimationState

enum class PlaybackDirection {
    Normal = 5,
    Reverse = 6,
    Alternate = 7,
    AlternateReverse = 8,
}; // enum class PlaybackDirection

enum class FillMode {
    None = 9,
    Forwards = 10,
    Backwards = 11,
    Both = 12,
    Auto = 13,
}; // enum class FillMode

class Animation : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AnimationIdSet = 1 << 0,
        AllFieldsSet = (AnimationIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Animation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Animation;
    public:

        Builder<STATE | AnimationIdSet>& setAnimationId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & AnimationIdSet), property_animationId_already_set);
            m_result->setString("animationId"_s, value);
            return castState<AnimationIdSet>();
        }

        Ref<Animation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Animation) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Animation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Animation> result = Animation::create()
     *     .setAnimationId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }

    void setCssAnimationName(const String& value)
    {
        JSON::ObjectBase::setString("cssAnimationName"_s, value);
    }

    void setCssTransitionProperty(const String& value)
    {
        JSON::ObjectBase::setString("cssTransitionProperty"_s, value);
    }

    void setEffect(RefPtr<Inspector::Protocol::Animation::Effect> value)
    {
        JSON::ObjectBase::setObject("effect"_s, WTFMove(value));
    }

    void setBacktrace(RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::CallFrame>> value)
    {
        JSON::ObjectBase::setArray("backtrace"_s, WTFMove(value));
    }
};

class Effect : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Effect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Effect;
    public:

        Ref<Effect> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Effect) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Effect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Effect> result = Effect::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStartDelay(double value)
    {
        JSON::ObjectBase::setDouble("startDelay"_s, value);
    }

    void setEndDelay(double value)
    {
        JSON::ObjectBase::setDouble("endDelay"_s, value);
    }

    void setIterationCount(double value)
    {
        JSON::ObjectBase::setDouble("iterationCount"_s, value);
    }

    void setIterationStart(double value)
    {
        JSON::ObjectBase::setDouble("iterationStart"_s, value);
    }

    void setIterationDuration(double value)
    {
        JSON::ObjectBase::setDouble("iterationDuration"_s, value);
    }

    void setTimingFunction(const String& value)
    {
        JSON::ObjectBase::setString("timingFunction"_s, value);
    }

    void setPlaybackDirection(Inspector::Protocol::Animation::PlaybackDirection value)
    {
        JSON::ObjectBase::setString("playbackDirection"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setFillMode(Inspector::Protocol::Animation::FillMode value)
    {
        JSON::ObjectBase::setString("fillMode"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setKeyframes(RefPtr<JSON::ArrayOf<Inspector::Protocol::Animation::Keyframe>> value)
    {
        JSON::ObjectBase::setArray("keyframes"_s, WTFMove(value));
    }
};

class Keyframe : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OffsetSet = 1 << 0,
        AllFieldsSet = (OffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Keyframe*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Keyframe;
    public:

        Builder<STATE | OffsetSet>& setOffset(double value)
        {
            COMPILE_ASSERT(!(STATE & OffsetSet), property_offset_already_set);
            m_result->setDouble("offset"_s, value);
            return castState<OffsetSet>();
        }

        Ref<Keyframe> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Keyframe) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Keyframe>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Keyframe> result = Keyframe::create()
     *     .setOffset(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setEasing(const String& value)
    {
        JSON::ObjectBase::setString("easing"_s, value);
    }

    void setStyle(const String& value)
    {
        JSON::ObjectBase::setString("style"_s, value);
    }
};

class TrackingUpdate : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TrackingAnimationIdSet = 1 << 0,
        AnimationStateSet = 1 << 1,
        AllFieldsSet = (TrackingAnimationIdSet | AnimationStateSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TrackingUpdate*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TrackingUpdate;
    public:

        Builder<STATE | TrackingAnimationIdSet>& setTrackingAnimationId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TrackingAnimationIdSet), property_trackingAnimationId_already_set);
            m_result->setString("trackingAnimationId"_s, value);
            return castState<TrackingAnimationIdSet>();
        }

        Builder<STATE | AnimationStateSet>& setAnimationState(Inspector::Protocol::Animation::AnimationState value)
        {
            COMPILE_ASSERT(!(STATE & AnimationStateSet), property_animationState_already_set);
            m_result->setString("animationState"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<AnimationStateSet>();
        }

        Ref<TrackingUpdate> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TrackingUpdate) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TrackingUpdate>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TrackingUpdate> result = TrackingUpdate::create()
     *     .setTrackingAnimationId(...)
     *     .setAnimationState(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int value)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, value);
    }

    void setAnimationName(const String& value)
    {
        JSON::ObjectBase::setString("animationName"_s, value);
    }

    void setTransitionProperty(const String& value)
    {
        JSON::ObjectBase::setString("transitionProperty"_s, value);
    }
};

} // Animation

namespace ApplicationCache {

/* Detailed application cache resource information. */
class ApplicationCacheResource : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        SizeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | SizeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCacheResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ApplicationCacheResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setInteger("size"_s, value);
            return castState<SizeSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, value);
            return castState<TypeSet>();
        }

        Ref<ApplicationCacheResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCacheResource) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ApplicationCacheResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCacheResource> result = ApplicationCacheResource::create()
     *     .setUrl(...)
     *     .setSize(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Detailed application cache information. */
class ApplicationCache : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ManifestURLSet = 1 << 0,
        SizeSet = 1 << 1,
        CreationTimeSet = 1 << 2,
        UpdateTimeSet = 1 << 3,
        ResourcesSet = 1 << 4,
        AllFieldsSet = (ManifestURLSet | SizeSet | CreationTimeSet | UpdateTimeSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCache*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ApplicationCache;
    public:

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL"_s, value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setDouble("size"_s, value);
            return castState<SizeSet>();
        }

        Builder<STATE | CreationTimeSet>& setCreationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & CreationTimeSet), property_creationTime_already_set);
            m_result->setDouble("creationTime"_s, value);
            return castState<CreationTimeSet>();
        }

        Builder<STATE | UpdateTimeSet>& setUpdateTime(double value)
        {
            COMPILE_ASSERT(!(STATE & UpdateTimeSet), property_updateTime_already_set);
            m_result->setDouble("updateTime"_s, value);
            return castState<UpdateTimeSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(RefPtr<JSON::ArrayOf<Inspector::Protocol::ApplicationCache::ApplicationCacheResource>> value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setArray("resources"_s, value);
            return castState<ResourcesSet>();
        }

        Ref<ApplicationCache> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCache) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ApplicationCache>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCache> result = ApplicationCache::create()
     *     .setManifestURL(...)
     *     .setSize(...)
     *     .setCreationTime(...)
     *     .setUpdateTime(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Frame identifier - manifest URL pair. */
class FrameWithManifest : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameIdSet = 1 << 0,
        ManifestURLSet = 1 << 1,
        StatusSet = 1 << 2,
        AllFieldsSet = (FrameIdSet | ManifestURLSet | StatusSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameWithManifest*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameWithManifest;
    public:

        Builder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId"_s, value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL"_s, value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setInteger("status"_s, value);
            return castState<StatusSet>();
        }

        Ref<FrameWithManifest> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameWithManifest) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameWithManifest>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameWithManifest> result = FrameWithManifest::create()
     *     .setFrameId(...)
     *     .setManifestURL(...)
     *     .setStatus(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ApplicationCache

namespace Browser {

/* Information about an extension. */
class Extension : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ExtensionIdSet = 1 << 0,
        NameSet = 1 << 1,
        AllFieldsSet = (ExtensionIdSet | NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Extension*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Extension;
    public:

        Builder<STATE | ExtensionIdSet>& setExtensionId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ExtensionIdSet), property_extensionId_already_set);
            m_result->setString("extensionId"_s, value);
            return castState<ExtensionIdSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Ref<Extension> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Extension) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Extension>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Extension> result = Extension::create()
     *     .setExtensionId(...)
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Browser

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace CPUProfiler {

/* CPU usage for an individual thread. */
class ThreadInfo : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating ThreadInfo.
    enum class Type {
        Main = 14,
        WebKit = 15,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        UsageSet = 1 << 1,
        AllFieldsSet = (NameSet | UsageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ThreadInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ThreadInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | UsageSet>& setUsage(double value)
        {
            COMPILE_ASSERT(!(STATE & UsageSet), property_usage_already_set);
            m_result->setDouble("usage"_s, value);
            return castState<UsageSet>();
        }

        Ref<ThreadInfo> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ThreadInfo) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ThreadInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ThreadInfo> result = ThreadInfo::create()
     *     .setName(...)
     *     .setUsage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(Type value)
    {
        JSON::ObjectBase::setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setTargetId(const String& value)
    {
        JSON::ObjectBase::setString("targetId"_s, value);
    }
};

class Event : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        UsageSet = 1 << 1,
        AllFieldsSet = (TimestampSet | UsageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Event;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble("timestamp"_s, value);
            return castState<TimestampSet>();
        }

        Builder<STATE | UsageSet>& setUsage(double value)
        {
            COMPILE_ASSERT(!(STATE & UsageSet), property_usage_already_set);
            m_result->setDouble("usage"_s, value);
            return castState<UsageSet>();
        }

        Ref<Event> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Event) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setTimestamp(...)
     *     .setUsage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setThreads(RefPtr<JSON::ArrayOf<Inspector::Protocol::CPUProfiler::ThreadInfo>> value)
    {
        JSON::ObjectBase::setArray("threads"_s, WTFMove(value));
    }
};

} // CPUProfiler
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace CSS {

/* This object identifies a CSS style in a unique way. */
class CSSStyleId : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId"_s, value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setInteger("ordinal"_s, value);
            return castState<OrdinalSet>();
        }

        Ref<CSSStyleId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleId) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleId> result = CSSStyleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Stylesheet type: "user" for user stylesheets, "user-agent" for user-agent stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via inspector" rules), "regular" for regular stylesheets. */
enum class StyleSheetOrigin {
    User = 16,
    UserAgent = 17,
    Author = 18,
    Inspector = 19,
}; // enum class StyleSheetOrigin

/* This object identifies a CSS rule in a unique way. */
class CSSRuleId : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRuleId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSRuleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId"_s, value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setInteger("ordinal"_s, value);
            return castState<OrdinalSet>();
        }

        Ref<CSSRuleId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRuleId) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSRuleId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRuleId> result = CSSRuleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Pseudo-style identifier (see <code>enum PseudoId</code> in <code>RenderStyleConstants.h</code>). */
enum class PseudoId {
    FirstLine = 20,
    FirstLetter = 21,
    Highlight = 22,
    Marker = 23,
    Before = 24,
    After = 25,
    Selection = 26,
    Scrollbar = 27,
    ScrollbarThumb = 28,
    ScrollbarButton = 29,
    ScrollbarTrack = 30,
    ScrollbarTrackPiece = 31,
    ScrollbarCorner = 32,
    Resizer = 33,
}; // enum class PseudoId

/* CSS rule collection for a single pseudo style. */
class PseudoIdMatches : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PseudoIdSet = 1 << 0,
        MatchesSet = 1 << 1,
        AllFieldsSet = (PseudoIdSet | MatchesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PseudoIdMatches*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PseudoIdMatches;
    public:

        Builder<STATE | PseudoIdSet>& setPseudoId(Inspector::Protocol::CSS::PseudoId value)
        {
            COMPILE_ASSERT(!(STATE & PseudoIdSet), property_pseudoId_already_set);
            m_result->setString("pseudoId"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<PseudoIdSet>();
        }

        Builder<STATE | MatchesSet>& setMatches(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::RuleMatch>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchesSet), property_matches_already_set);
            m_result->setArray("matches"_s, value);
            return castState<MatchesSet>();
        }

        Ref<PseudoIdMatches> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PseudoIdMatches) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PseudoIdMatches>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PseudoIdMatches> result = PseudoIdMatches::create()
     *     .setPseudoId(...)
     *     .setMatches(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS rule collection for a single pseudo style. */
class InheritedStyleEntry : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MatchedCSSRulesSet = 1 << 0,
        AllFieldsSet = (MatchedCSSRulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InheritedStyleEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class InheritedStyleEntry;
    public:

        Builder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::RuleMatch>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchedCSSRulesSet), property_matchedCSSRules_already_set);
            m_result->setArray("matchedCSSRules"_s, value);
            return castState<MatchedCSSRulesSet>();
        }

        Ref<InheritedStyleEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InheritedStyleEntry) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InheritedStyleEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InheritedStyleEntry> result = InheritedStyleEntry::create()
     *     .setMatchedCSSRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setInlineStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
    {
        JSON::ObjectBase::setObject("inlineStyle"_s, WTFMove(value));
    }
};

/* Match data for a CSS rule. */
class RuleMatch : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RuleSet = 1 << 0,
        MatchingSelectorsSet = 1 << 1,
        AllFieldsSet = (RuleSet | MatchingSelectorsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RuleMatch*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RuleMatch;
    public:

        Builder<STATE | RuleSet>& setRule(RefPtr<Inspector::Protocol::CSS::CSSRule> value)
        {
            COMPILE_ASSERT(!(STATE & RuleSet), property_rule_already_set);
            m_result->setObject("rule"_s, value);
            return castState<RuleSet>();
        }

        Builder<STATE | MatchingSelectorsSet>& setMatchingSelectors(RefPtr<JSON::ArrayOf<int>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchingSelectorsSet), property_matchingSelectors_already_set);
            m_result->setArray("matchingSelectors"_s, value);
            return castState<MatchingSelectorsSet>();
        }

        Ref<RuleMatch> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RuleMatch) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RuleMatch>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RuleMatch> result = RuleMatch::create()
     *     .setRule(...)
     *     .setMatchingSelectors(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS selector. */
class CSSSelector : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        AllFieldsSet = (TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSSelector*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSSelector;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text"_s, value);
            return castState<TextSet>();
        }

        Ref<CSSSelector> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSSelector) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSSelector>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSSelector> result = CSSSelector::create()
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSpecificity(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("specificity"_s, WTFMove(value));
    }

    void setDynamic(bool value)
    {
        JSON::ObjectBase::setBoolean("dynamic"_s, value);
    }
};

/* Selector list data. */
class SelectorList : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorsSet = 1 << 0,
        TextSet = 1 << 1,
        AllFieldsSet = (SelectorsSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SelectorList*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SelectorList;
    public:

        Builder<STATE | SelectorsSet>& setSelectors(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSSelector>> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorsSet), property_selectors_already_set);
            m_result->setArray("selectors"_s, value);
            return castState<SelectorsSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text"_s, value);
            return castState<TextSet>();
        }

        Ref<SelectorList> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorList) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SelectorList>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SelectorList> result = SelectorList::create()
     *     .setSelectors(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(value));
    }
};

/* CSS style information for a DOM style attribute. */
class CSSStyleAttribute : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        StyleSet = 1 << 1,
        AllFieldsSet = (NameSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleAttribute*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleAttribute;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | StyleSet>& setStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setObject("style"_s, value);
            return castState<StyleSet>();
        }

        Ref<CSSStyleAttribute> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleAttribute) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleAttribute>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleAttribute> result = CSSStyleAttribute::create()
     *     .setName(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS stylesheet meta-information. */
class CSSStyleSheetHeader : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        FrameIdSet = 1 << 1,
        SourceURLSet = 1 << 2,
        OriginSet = 1 << 3,
        TitleSet = 1 << 4,
        DisabledSet = 1 << 5,
        IsInlineSet = 1 << 6,
        StartLineSet = 1 << 7,
        StartColumnSet = 1 << 8,
        AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet | IsInlineSet | StartLineSet | StartColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetHeader*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleSheetHeader;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId"_s, value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId"_s, value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | SourceURLSet>& setSourceURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceURLSet), property_sourceURL_already_set);
            m_result->setString("sourceURL"_s, value);
            return castState<SourceURLSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Inspector::Protocol::CSS::StyleSheetOrigin value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title"_s, value);
            return castState<TitleSet>();
        }

        Builder<STATE | DisabledSet>& setDisabled(bool value)
        {
            COMPILE_ASSERT(!(STATE & DisabledSet), property_disabled_already_set);
            m_result->setBoolean("disabled"_s, value);
            return castState<DisabledSet>();
        }

        Builder<STATE | IsInlineSet>& setIsInline(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsInlineSet), property_isInline_already_set);
            m_result->setBoolean("isInline"_s, value);
            return castState<IsInlineSet>();
        }

        Builder<STATE | StartLineSet>& setStartLine(double value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setDouble("startLine"_s, value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(double value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setDouble("startColumn"_s, value);
            return castState<StartColumnSet>();
        }

        Ref<CSSStyleSheetHeader> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetHeader) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleSheetHeader>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetHeader> result = CSSStyleSheetHeader::create()
     *     .setStyleSheetId(...)
     *     .setFrameId(...)
     *     .setSourceURL(...)
     *     .setOrigin(...)
     *     .setTitle(...)
     *     .setDisabled(...)
     *     .setIsInline(...)
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS stylesheet contents. */
class CSSStyleSheetBody : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        RulesSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | RulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetBody*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleSheetBody;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId"_s, value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | RulesSet>& setRules(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSRule>> value)
        {
            COMPILE_ASSERT(!(STATE & RulesSet), property_rules_already_set);
            m_result->setArray("rules"_s, value);
            return castState<RulesSet>();
        }

        Ref<CSSStyleSheetBody> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetBody) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleSheetBody>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetBody> result = CSSStyleSheetBody::create()
     *     .setStyleSheetId(...)
     *     .setRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setText(const String& value)
    {
        JSON::ObjectBase::setString("text"_s, value);
    }
};

/* CSS rule representation. */
class CSSRule : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorListSet = 1 << 0,
        SourceLineSet = 1 << 1,
        OriginSet = 1 << 2,
        StyleSet = 1 << 3,
        AllFieldsSet = (SelectorListSet | SourceLineSet | OriginSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRule*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSRule;
    public:

        Builder<STATE | SelectorListSet>& setSelectorList(RefPtr<Inspector::Protocol::CSS::SelectorList> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorListSet), property_selectorList_already_set);
            m_result->setObject("selectorList"_s, value);
            return castState<SelectorListSet>();
        }

        Builder<STATE | SourceLineSet>& setSourceLine(int value)
        {
            COMPILE_ASSERT(!(STATE & SourceLineSet), property_sourceLine_already_set);
            m_result->setInteger("sourceLine"_s, value);
            return castState<SourceLineSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Inspector::Protocol::CSS::StyleSheetOrigin value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | StyleSet>& setStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setObject("style"_s, value);
            return castState<StyleSet>();
        }

        Ref<CSSRule> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRule) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSRule>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRule> result = CSSRule::create()
     *     .setSelectorList(...)
     *     .setSourceLine(...)
     *     .setOrigin(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRuleId(RefPtr<Inspector::Protocol::CSS::CSSRuleId> value)
    {
        JSON::ObjectBase::setObject("ruleId"_s, WTFMove(value));
    }

    void setSourceURL(const String& value)
    {
        JSON::ObjectBase::setString("sourceURL"_s, value);
    }

    void setGroupings(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::Grouping>> value)
    {
        JSON::ObjectBase::setArray("groupings"_s, WTFMove(value));
    }
};

/* Text range within a resource. */
class SourceRange : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartLineSet = 1 << 0,
        StartColumnSet = 1 << 1,
        EndLineSet = 1 << 2,
        EndColumnSet = 1 << 3,
        AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SourceRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SourceRange;
    public:

        Builder<STATE | StartLineSet>& setStartLine(int value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setInteger("startLine"_s, value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setInteger("startColumn"_s, value);
            return castState<StartColumnSet>();
        }

        Builder<STATE | EndLineSet>& setEndLine(int value)
        {
            COMPILE_ASSERT(!(STATE & EndLineSet), property_endLine_already_set);
            m_result->setInteger("endLine"_s, value);
            return castState<EndLineSet>();
        }

        Builder<STATE | EndColumnSet>& setEndColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & EndColumnSet), property_endColumn_already_set);
            m_result->setInteger("endColumn"_s, value);
            return castState<EndColumnSet>();
        }

        Ref<SourceRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SourceRange) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SourceRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SourceRange> result = SourceRange::create()
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .setEndLine(...)
     *     .setEndColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class ShorthandEntry : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShorthandEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ShorthandEntry;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<ShorthandEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShorthandEntry) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ShorthandEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShorthandEntry> result = ShorthandEntry::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class CSSPropertyInfo : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSPropertyInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSPropertyInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Ref<CSSPropertyInfo> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSPropertyInfo) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSPropertyInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSPropertyInfo> result = CSSPropertyInfo::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAliases(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("aliases"_s, WTFMove(value));
    }

    void setLonghands(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("longhands"_s, WTFMove(value));
    }

    void setValues(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("values"_s, WTFMove(value));
    }

    void setInherited(bool value)
    {
        JSON::ObjectBase::setBoolean("inherited"_s, value);
    }
};

class CSSComputedStyleProperty : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSComputedStyleProperty*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSComputedStyleProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<CSSComputedStyleProperty> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSComputedStyleProperty) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSComputedStyleProperty>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSComputedStyleProperty> result = CSSComputedStyleProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS style representation. */
class CSSStyle : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CssPropertiesSet = 1 << 0,
        ShorthandEntriesSet = 1 << 1,
        AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyle*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyle;
    public:

        Builder<STATE | CssPropertiesSet>& setCssProperties(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSProperty>> value)
        {
            COMPILE_ASSERT(!(STATE & CssPropertiesSet), property_cssProperties_already_set);
            m_result->setArray("cssProperties"_s, value);
            return castState<CssPropertiesSet>();
        }

        Builder<STATE | ShorthandEntriesSet>& setShorthandEntries(RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::ShorthandEntry>> value)
        {
            COMPILE_ASSERT(!(STATE & ShorthandEntriesSet), property_shorthandEntries_already_set);
            m_result->setArray("shorthandEntries"_s, value);
            return castState<ShorthandEntriesSet>();
        }

        Ref<CSSStyle> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyle) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyle>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyle> result = CSSStyle::create()
     *     .setCssProperties(...)
     *     .setShorthandEntries(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStyleId(RefPtr<Inspector::Protocol::CSS::CSSStyleId> value)
    {
        JSON::ObjectBase::setObject("styleId"_s, WTFMove(value));
    }

    void setCssText(const String& value)
    {
        JSON::ObjectBase::setString("cssText"_s, value);
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(value));
    }

    void setWidth(const String& value)
    {
        JSON::ObjectBase::setString("width"_s, value);
    }

    void setHeight(const String& value)
    {
        JSON::ObjectBase::setString("height"_s, value);
    }
};

/* The property status: "active" if the property is effective in the style, "inactive" if the property is overridden by a same-named property in this style later on, "disabled" if the property is disabled by the user, "style" (implied if absent) if the property is reported by the browser rather than by the CSS source parser. */
enum class CSSPropertyStatus {
    Active = 2,
    Inactive = 34,
    Disabled = 35,
    Style = 36,
}; // enum class CSSPropertyStatus

/* CSS style effective visual dimensions and source offsets. */
class CSSProperty : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSProperty*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<CSSProperty> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSProperty) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSProperty>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSProperty> result = CSSProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPriority(const String& value)
    {
        JSON::ObjectBase::setString("priority"_s, value);
    }

    void setImplicit(bool value)
    {
        JSON::ObjectBase::setBoolean("implicit"_s, value);
    }

    void setText(const String& value)
    {
        JSON::ObjectBase::setString("text"_s, value);
    }

    void setParsedOk(bool value)
    {
        JSON::ObjectBase::setBoolean("parsedOk"_s, value);
    }

    void setStatus(Inspector::Protocol::CSS::CSSPropertyStatus value)
    {
        JSON::ObjectBase::setString("status"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* Name;
    JS_EXPORT_PRIVATE static const char* Value;
    JS_EXPORT_PRIVATE static const char* Priority;
    JS_EXPORT_PRIVATE static const char* Implicit;
    JS_EXPORT_PRIVATE static const char* Text;
    JS_EXPORT_PRIVATE static const char* ParsedOk;
    JS_EXPORT_PRIVATE static const char* Status;
    JS_EXPORT_PRIVATE static const char* Range;
};

/* CSS @media (as well as other users of media queries, like @import, <style>, <link>, etc.) and @supports descriptor. */
class Grouping : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Grouping.
    enum class Type {
        MediaRule = 37,
        MediaImportRule = 38,
        MediaLinkNode = 39,
        MediaStyleNode = 40,
        SupportsRule = 41,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (TextSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Grouping*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Grouping;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text"_s, value);
            return castState<TextSet>();
        }

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<Grouping> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Grouping) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Grouping>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Grouping> result = Grouping::create()
     *     .setText(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSourceURL(const String& value)
    {
        JSON::ObjectBase::setString("sourceURL"_s, value);
    }
};

} // CSS

namespace Canvas {

/* The type of rendering context backing the canvas element. */
enum class ContextType {
    Canvas2D = 42,
    BitmapRenderer = 43,
    WebGL = 44,
    WebGL2 = 45,
    WebGPU = 46,
}; // enum class ContextType

#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
enum class ProgramType {
    Compute = 47,
    Render = 48,
}; // enum class ProgramType
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)

#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
enum class ShaderType {
    Compute = 47,
    Fragment = 49,
    Vertex = 50,
}; // enum class ShaderType
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)

/* Drawing surface attributes. */
class ContextAttributes : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ContextAttributes*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ContextAttributes;
    public:

        Ref<ContextAttributes> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ContextAttributes) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ContextAttributes>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ContextAttributes> result = ContextAttributes::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAlpha(bool value)
    {
        JSON::ObjectBase::setBoolean("alpha"_s, value);
    }

    void setDepth(bool value)
    {
        JSON::ObjectBase::setBoolean("depth"_s, value);
    }

    void setStencil(bool value)
    {
        JSON::ObjectBase::setBoolean("stencil"_s, value);
    }

    void setAntialias(bool value)
    {
        JSON::ObjectBase::setBoolean("antialias"_s, value);
    }

    void setPremultipliedAlpha(bool value)
    {
        JSON::ObjectBase::setBoolean("premultipliedAlpha"_s, value);
    }

    void setPreserveDrawingBuffer(bool value)
    {
        JSON::ObjectBase::setBoolean("preserveDrawingBuffer"_s, value);
    }

    void setFailIfMajorPerformanceCaveat(bool value)
    {
        JSON::ObjectBase::setBoolean("failIfMajorPerformanceCaveat"_s, value);
    }

    void setPowerPreference(const String& value)
    {
        JSON::ObjectBase::setString("powerPreference"_s, value);
    }
};

/* Information about a canvas for which a rendering context has been created. */
class Canvas : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CanvasIdSet = 1 << 0,
        ContextTypeSet = 1 << 1,
        AllFieldsSet = (CanvasIdSet | ContextTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Canvas*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Canvas;
    public:

        Builder<STATE | CanvasIdSet>& setCanvasId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & CanvasIdSet), property_canvasId_already_set);
            m_result->setString("canvasId"_s, value);
            return castState<CanvasIdSet>();
        }

        Builder<STATE | ContextTypeSet>& setContextType(Inspector::Protocol::Canvas::ContextType value)
        {
            COMPILE_ASSERT(!(STATE & ContextTypeSet), property_contextType_already_set);
            m_result->setString("contextType"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<ContextTypeSet>();
        }

        Ref<Canvas> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Canvas) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Canvas>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Canvas> result = Canvas::create()
     *     .setCanvasId(...)
     *     .setContextType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int value)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, value);
    }

    void setCssCanvasName(const String& value)
    {
        JSON::ObjectBase::setString("cssCanvasName"_s, value);
    }

    void setContextAttributes(RefPtr<Inspector::Protocol::Canvas::ContextAttributes> value)
    {
        JSON::ObjectBase::setObject("contextAttributes"_s, WTFMove(value));
    }

    void setMemoryCost(double value)
    {
        JSON::ObjectBase::setDouble("memoryCost"_s, value);
    }

    void setBacktrace(RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::CallFrame>> value)
    {
        JSON::ObjectBase::setArray("backtrace"_s, WTFMove(value));
    }
};

#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
/* Information about a WebGL/WebGL2 shader program or WebGPU shader pipeline. */
class ShaderProgram : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProgramIdSet = 1 << 0,
        ProgramTypeSet = 1 << 1,
        CanvasIdSet = 1 << 2,
        AllFieldsSet = (ProgramIdSet | ProgramTypeSet | CanvasIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShaderProgram*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ShaderProgram;
    public:

        Builder<STATE | ProgramIdSet>& setProgramId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ProgramIdSet), property_programId_already_set);
            m_result->setString("programId"_s, value);
            return castState<ProgramIdSet>();
        }

        Builder<STATE | ProgramTypeSet>& setProgramType(Inspector::Protocol::Canvas::ProgramType value)
        {
            COMPILE_ASSERT(!(STATE & ProgramTypeSet), property_programType_already_set);
            m_result->setString("programType"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<ProgramTypeSet>();
        }

        Builder<STATE | CanvasIdSet>& setCanvasId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & CanvasIdSet), property_canvasId_already_set);
            m_result->setString("canvasId"_s, value);
            return castState<CanvasIdSet>();
        }

        Ref<ShaderProgram> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShaderProgram) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ShaderProgram>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShaderProgram> result = ShaderProgram::create()
     *     .setProgramId(...)
     *     .setProgramType(...)
     *     .setCanvasId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSharesVertexFragmentShader(bool value)
    {
        JSON::ObjectBase::setBoolean("sharesVertexFragmentShader"_s, value);
    }
};
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)

} // Canvas

namespace Console {

/* Channels for different types of log messages. */
enum class ChannelSource {
    XML = 51,
    JavaScript = 52,
    Network = 53,
    ConsoleAPI = 54,
    Storage = 55,
    Appcache = 56,
    Rendering = 57,
    CSS = 58,
    Security = 59,
    ContentBlocker = 60,
    Media = 61,
    MediaSource = 62,
    WebRTC = 63,
    ITPDebug = 64,
    AdClickAttribution = 65,
    Other = 66,
}; // enum class ChannelSource

/* Level of logging. */
enum class ChannelLevel {
    Off = 67,
    Basic = 68,
    Verbose = 69,
}; // enum class ChannelLevel

/* Logging channel. */
class Channel : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        AllFieldsSet = (SourceSet | LevelSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Channel*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Channel;
    public:

        Builder<STATE | SourceSet>& setSource(Inspector::Protocol::Console::ChannelSource value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Inspector::Protocol::Console::ChannelLevel value)
        {
            COMPILE_ASSERT(!(STATE & LevelSet), property_level_already_set);
            m_result->setString("level"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<LevelSet>();
        }

        Ref<Channel> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Channel) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Channel>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Channel> result = Channel::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Console message. */
class ConsoleMessage : public JSON::ObjectBase {
public:
    // Named after property name 'level' while generating ConsoleMessage.
    enum class Level {
        Log = 70,
        Info = 71,
        Warning = 72,
        Error = 73,
        Debug = 74,
    }; // enum class Level
    // Named after property name 'type' while generating ConsoleMessage.
    enum class Type {
        Log = 70,
        Dir = 75,
        DirXML = 76,
        Table = 77,
        Trace = 78,
        Clear = 79,
        StartGroup = 80,
        StartGroupCollapsed = 81,
        EndGroup = 82,
        Assert = 83,
        Timing = 84,
        Profile = 85,
        ProfileEnd = 86,
        Image = 87,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        TextSet = 1 << 2,
        AllFieldsSet = (SourceSet | LevelSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ConsoleMessage*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ConsoleMessage;
    public:

        Builder<STATE | SourceSet>& setSource(Inspector::Protocol::Console::ChannelSource value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Level value)
        {
            COMPILE_ASSERT(!(STATE & LevelSet), property_level_already_set);
            m_result->setString("level"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<LevelSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text"_s, value);
            return castState<TextSet>();
        }

        Ref<ConsoleMessage> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ConsoleMessage) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ConsoleMessage>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ConsoleMessage> result = ConsoleMessage::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(Type value)
    {
        JSON::ObjectBase::setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setUrl(const String& value)
    {
        JSON::ObjectBase::setString("url"_s, value);
    }

    void setLine(int value)
    {
        JSON::ObjectBase::setInteger("line"_s, value);
    }

    void setColumn(int value)
    {
        JSON::ObjectBase::setInteger("column"_s, value);
    }

    void setRepeatCount(int value)
    {
        JSON::ObjectBase::setInteger("repeatCount"_s, value);
    }

    void setParameters(RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::RemoteObject>> value)
    {
        JSON::ObjectBase::setArray("parameters"_s, WTFMove(value));
    }

    void setStackTrace(RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::CallFrame>> value)
    {
        JSON::ObjectBase::setArray("stackTrace"_s, WTFMove(value));
    }

    void setNetworkRequestId(const String& value)
    {
        JSON::ObjectBase::setString("networkRequestId"_s, value);
    }
};

/* Stack entry for console errors and assertions. */
class CallFrame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        UrlSet = 1 << 1,
        ScriptIdSet = 1 << 2,
        LineNumberSet = 1 << 3,
        ColumnNumberSet = 1 << 4,
        AllFieldsSet = (FunctionNameSet | UrlSet | ScriptIdSet | LineNumberSet | ColumnNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallFrame;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName"_s, value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | ScriptIdSet>& setScriptId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId"_s, value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setInteger("lineNumber"_s, value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
            m_result->setInteger("columnNumber"_s, value);
            return castState<ColumnNumberSet>();
        }

        Ref<CallFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setFunctionName(...)
     *     .setUrl(...)
     *     .setScriptId(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Call frames for async function calls, console assertions, and error messages. */
class StackTrace : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFramesSet = 1 << 0,
        AllFieldsSet = (CallFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackTrace*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StackTrace;
    public:

        Builder<STATE | CallFramesSet>& setCallFrames(RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::CallFrame>> value)
        {
            COMPILE_ASSERT(!(STATE & CallFramesSet), property_callFrames_already_set);
            m_result->setArray("callFrames"_s, value);
            return castState<CallFramesSet>();
        }

        Ref<StackTrace> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackTrace) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackTrace>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackTrace> result = StackTrace::create()
     *     .setCallFrames(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setTopCallFrameIsBoundary(bool value)
    {
        JSON::ObjectBase::setBoolean("topCallFrameIsBoundary"_s, value);
    }

    void setTruncated(bool value)
    {
        JSON::ObjectBase::setBoolean("truncated"_s, value);
    }

    void setParentStackTrace(RefPtr<Inspector::Protocol::Console::StackTrace> value)
    {
        JSON::ObjectBase::setObject("parentStackTrace"_s, WTFMove(value));
    }
};

} // Console

namespace DOM {

/* Pseudo element type. */
enum class PseudoType {
    Before = 24,
    After = 25,
}; // enum class PseudoType

/* Shadow root type. */
enum class ShadowRootType {
    UserAgent = 17,
    Open = 88,
    Closed = 89,
}; // enum class ShadowRootType

/* Custom element state. */
enum class CustomElementState {
    Builtin = 90,
    Custom = 91,
    Waiting = 92,
    Failed = 93,
}; // enum class CustomElementState

/* Token values of @aria-relevant attribute. */
enum class LiveRegionRelevant {
    Additions = 94,
    Removals = 95,
    Text = 96,
}; // enum class LiveRegionRelevant

/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class Node : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        NodeTypeSet = 1 << 1,
        NodeNameSet = 1 << 2,
        LocalNameSet = 1 << 3,
        NodeValueSet = 1 << 4,
        AllFieldsSet = (NodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Node*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Node;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger("nodeId"_s, value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeTypeSet), property_nodeType_already_set);
            m_result->setInteger("nodeType"_s, value);
            return castState<NodeTypeSet>();
        }

        Builder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeNameSet), property_nodeName_already_set);
            m_result->setString("nodeName"_s, value);
            return castState<NodeNameSet>();
        }

        Builder<STATE | LocalNameSet>& setLocalName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LocalNameSet), property_localName_already_set);
            m_result->setString("localName"_s, value);
            return castState<LocalNameSet>();
        }

        Builder<STATE | NodeValueSet>& setNodeValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeValueSet), property_nodeValue_already_set);
            m_result->setString("nodeValue"_s, value);
            return castState<NodeValueSet>();
        }

        Ref<Node> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Node) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Node>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Node> result = Node::create()
     *     .setNodeId(...)
     *     .setNodeType(...)
     *     .setNodeName(...)
     *     .setLocalName(...)
     *     .setNodeValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFrameId(const String& value)
    {
        JSON::ObjectBase::setString("frameId"_s, value);
    }

    void setChildNodeCount(int value)
    {
        JSON::ObjectBase::setInteger("childNodeCount"_s, value);
    }

    void setChildren(RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::Node>> value)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(value));
    }

    void setAttributes(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("attributes"_s, WTFMove(value));
    }

    void setDocumentURL(const String& value)
    {
        JSON::ObjectBase::setString("documentURL"_s, value);
    }

    void setBaseURL(const String& value)
    {
        JSON::ObjectBase::setString("baseURL"_s, value);
    }

    void setPublicId(const String& value)
    {
        JSON::ObjectBase::setString("publicId"_s, value);
    }

    void setSystemId(const String& value)
    {
        JSON::ObjectBase::setString("systemId"_s, value);
    }

    void setXmlVersion(const String& value)
    {
        JSON::ObjectBase::setString("xmlVersion"_s, value);
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }

    void setValue(const String& value)
    {
        JSON::ObjectBase::setString("value"_s, value);
    }

    void setPseudoType(Inspector::Protocol::DOM::PseudoType value)
    {
        JSON::ObjectBase::setString("pseudoType"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setShadowRootType(Inspector::Protocol::DOM::ShadowRootType value)
    {
        JSON::ObjectBase::setString("shadowRootType"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setCustomElementState(Inspector::Protocol::DOM::CustomElementState value)
    {
        JSON::ObjectBase::setString("customElementState"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setContentDocument(RefPtr<Inspector::Protocol::DOM::Node> value)
    {
        JSON::ObjectBase::setObject("contentDocument"_s, WTFMove(value));
    }

    void setShadowRoots(RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::Node>> value)
    {
        JSON::ObjectBase::setArray("shadowRoots"_s, WTFMove(value));
    }

    void setTemplateContent(RefPtr<Inspector::Protocol::DOM::Node> value)
    {
        JSON::ObjectBase::setObject("templateContent"_s, WTFMove(value));
    }

    void setPseudoElements(RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::Node>> value)
    {
        JSON::ObjectBase::setArray("pseudoElements"_s, WTFMove(value));
    }

    void setContentSecurityPolicyHash(const String& value)
    {
        JSON::ObjectBase::setString("contentSecurityPolicyHash"_s, value);
    }
};

/* Relationship between data that is associated with a node and the node itself. */
class DataBinding : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BindingSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (BindingSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DataBinding*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class DataBinding;
    public:

        Builder<STATE | BindingSet>& setBinding(const String& value)
        {
            COMPILE_ASSERT(!(STATE & BindingSet), property_binding_already_set);
            m_result->setString("binding"_s, value);
            return castState<BindingSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<DataBinding> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DataBinding) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DataBinding>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DataBinding> result = DataBinding::create()
     *     .setBinding(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(const String& value)
    {
        JSON::ObjectBase::setString("type"_s, value);
    }
};

class Rect : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Rect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Rect;
    public:

        Builder<STATE | XSet>& setX(int value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setInteger("x"_s, value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setInteger("y"_s, value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setInteger("width"_s, value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setInteger("height"_s, value);
            return castState<HeightSet>();
        }

        Ref<Rect> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Rect) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Rect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Rect> result = Rect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* A structure holding event listener properties. */
class EventListener : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        EventListenerIdSet = 1 << 0,
        TypeSet = 1 << 1,
        UseCaptureSet = 1 << 2,
        IsAttributeSet = 1 << 3,
        AllFieldsSet = (EventListenerIdSet | TypeSet | UseCaptureSet | IsAttributeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EventListener*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class EventListener;
    public:

        Builder<STATE | EventListenerIdSet>& setEventListenerId(int value)
        {
            COMPILE_ASSERT(!(STATE & EventListenerIdSet), property_eventListenerId_already_set);
            m_result->setInteger("eventListenerId"_s, value);
            return castState<EventListenerIdSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, value);
            return castState<TypeSet>();
        }

        Builder<STATE | UseCaptureSet>& setUseCapture(bool value)
        {
            COMPILE_ASSERT(!(STATE & UseCaptureSet), property_useCapture_already_set);
            m_result->setBoolean("useCapture"_s, value);
            return castState<UseCaptureSet>();
        }

        Builder<STATE | IsAttributeSet>& setIsAttribute(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsAttributeSet), property_isAttribute_already_set);
            m_result->setBoolean("isAttribute"_s, value);
            return castState<IsAttributeSet>();
        }

        Ref<EventListener> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EventListener) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<EventListener>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EventListener> result = EventListener::create()
     *     .setEventListenerId(...)
     *     .setType(...)
     *     .setUseCapture(...)
     *     .setIsAttribute(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int value)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, value);
    }

    void setOnWindow(bool value)
    {
        JSON::ObjectBase::setBoolean("onWindow"_s, value);
    }

    void setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
    {
        JSON::ObjectBase::setObject("location"_s, WTFMove(value));
    }

    void setHandlerName(const String& value)
    {
        JSON::ObjectBase::setString("handlerName"_s, value);
    }

    void setPassive(bool value)
    {
        JSON::ObjectBase::setBoolean("passive"_s, value);
    }

    void setOnce(bool value)
    {
        JSON::ObjectBase::setBoolean("once"_s, value);
    }

    void setDisabled(bool value)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, value);
    }

    void setHasBreakpoint(bool value)
    {
        JSON::ObjectBase::setBoolean("hasBreakpoint"_s, value);
    }
};

/* A structure holding accessibility properties. */
class AccessibilityProperties : public JSON::ObjectBase {
public:
    // Named after property name 'checked' while generating AccessibilityProperties.
    enum class Checked {
        True = 97,
        False = 98,
        Mixed = 99,
    }; // enum class Checked
    // Named after property name 'current' while generating AccessibilityProperties.
    enum class Current {
        True = 97,
        False = 98,
        Page = 100,
        Step = 101,
        Location = 102,
        Date = 103,
        Time = 104,
    }; // enum class Current
    // Named after property name 'invalid' while generating AccessibilityProperties.
    enum class Invalid {
        True = 97,
        False = 98,
        Grammar = 105,
        Spelling = 106,
    }; // enum class Invalid
    // Named after property name 'liveRegionStatus' while generating AccessibilityProperties.
    enum class LiveRegionStatus {
        Assertive = 107,
        Polite = 108,
        Off = 67,
    }; // enum class LiveRegionStatus
    enum {
        NoFieldsSet = 0,
        ExistsSet = 1 << 0,
        LabelSet = 1 << 1,
        NodeIdSet = 1 << 2,
        RoleSet = 1 << 3,
        AllFieldsSet = (ExistsSet | LabelSet | NodeIdSet | RoleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AccessibilityProperties*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class AccessibilityProperties;
    public:

        Builder<STATE | ExistsSet>& setExists(bool value)
        {
            COMPILE_ASSERT(!(STATE & ExistsSet), property_exists_already_set);
            m_result->setBoolean("exists"_s, value);
            return castState<ExistsSet>();
        }

        Builder<STATE | LabelSet>& setLabel(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LabelSet), property_label_already_set);
            m_result->setString("label"_s, value);
            return castState<LabelSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger("nodeId"_s, value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | RoleSet>& setRole(const String& value)
        {
            COMPILE_ASSERT(!(STATE & RoleSet), property_role_already_set);
            m_result->setString("role"_s, value);
            return castState<RoleSet>();
        }

        Ref<AccessibilityProperties> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(AccessibilityProperties) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AccessibilityProperties>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AccessibilityProperties> result = AccessibilityProperties::create()
     *     .setExists(...)
     *     .setLabel(...)
     *     .setNodeId(...)
     *     .setRole(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setActiveDescendantNodeId(int value)
    {
        JSON::ObjectBase::setInteger("activeDescendantNodeId"_s, value);
    }

    void setBusy(bool value)
    {
        JSON::ObjectBase::setBoolean("busy"_s, value);
    }

    void setChecked(Checked value)
    {
        JSON::ObjectBase::setString("checked"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setChildNodeIds(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("childNodeIds"_s, WTFMove(value));
    }

    void setControlledNodeIds(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("controlledNodeIds"_s, WTFMove(value));
    }

    void setCurrent(Current value)
    {
        JSON::ObjectBase::setString("current"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setDisabled(bool value)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, value);
    }

    void setHeadingLevel(double value)
    {
        JSON::ObjectBase::setDouble("headingLevel"_s, value);
    }

    void setHierarchyLevel(double value)
    {
        JSON::ObjectBase::setDouble("hierarchyLevel"_s, value);
    }

    void setIsPopUpButton(bool value)
    {
        JSON::ObjectBase::setBoolean("isPopUpButton"_s, value);
    }

    void setExpanded(bool value)
    {
        JSON::ObjectBase::setBoolean("expanded"_s, value);
    }

    void setFlowedNodeIds(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("flowedNodeIds"_s, WTFMove(value));
    }

    void setFocused(bool value)
    {
        JSON::ObjectBase::setBoolean("focused"_s, value);
    }

    void setIgnored(bool value)
    {
        JSON::ObjectBase::setBoolean("ignored"_s, value);
    }

    void setIgnoredByDefault(bool value)
    {
        JSON::ObjectBase::setBoolean("ignoredByDefault"_s, value);
    }

    void setInvalid(Invalid value)
    {
        JSON::ObjectBase::setString("invalid"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setHidden(bool value)
    {
        JSON::ObjectBase::setBoolean("hidden"_s, value);
    }

    void setLiveRegionAtomic(bool value)
    {
        JSON::ObjectBase::setBoolean("liveRegionAtomic"_s, value);
    }

    void setLiveRegionRelevant(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("liveRegionRelevant"_s, WTFMove(value));
    }

    void setLiveRegionStatus(LiveRegionStatus value)
    {
        JSON::ObjectBase::setString("liveRegionStatus"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setMouseEventNodeId(int value)
    {
        JSON::ObjectBase::setInteger("mouseEventNodeId"_s, value);
    }

    void setOwnedNodeIds(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("ownedNodeIds"_s, WTFMove(value));
    }

    void setParentNodeId(int value)
    {
        JSON::ObjectBase::setInteger("parentNodeId"_s, value);
    }

    void setPressed(bool value)
    {
        JSON::ObjectBase::setBoolean("pressed"_s, value);
    }

    void setReadonly(bool value)
    {
        JSON::ObjectBase::setBoolean("readonly"_s, value);
    }

    void setRequired(bool value)
    {
        JSON::ObjectBase::setBoolean("required"_s, value);
    }

    void setSelected(bool value)
    {
        JSON::ObjectBase::setBoolean("selected"_s, value);
    }

    void setSelectedChildNodeIds(RefPtr<JSON::ArrayOf<int>> value)
    {
        JSON::ObjectBase::setArray("selectedChildNodeIds"_s, WTFMove(value));
    }
};

/* A structure holding an RGBA color. */
class RGBAColor : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RSet = 1 << 0,
        GSet = 1 << 1,
        BSet = 1 << 2,
        AllFieldsSet = (RSet | GSet | BSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RGBAColor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RGBAColor;
    public:

        Builder<STATE | RSet>& setR(int value)
        {
            COMPILE_ASSERT(!(STATE & RSet), property_r_already_set);
            m_result->setInteger("r"_s, value);
            return castState<RSet>();
        }

        Builder<STATE | GSet>& setG(int value)
        {
            COMPILE_ASSERT(!(STATE & GSet), property_g_already_set);
            m_result->setInteger("g"_s, value);
            return castState<GSet>();
        }

        Builder<STATE | BSet>& setB(int value)
        {
            COMPILE_ASSERT(!(STATE & BSet), property_b_already_set);
            m_result->setInteger("b"_s, value);
            return castState<BSet>();
        }

        Ref<RGBAColor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RGBAColor) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RGBAColor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RGBAColor> result = RGBAColor::create()
     *     .setR(...)
     *     .setG(...)
     *     .setB(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setA(double value)
    {
        JSON::ObjectBase::setDouble("a"_s, value);
    }
};

/* Configuration data for the highlighting of page elements. */
class HighlightConfig : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*HighlightConfig*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class HighlightConfig;
    public:

        Ref<HighlightConfig> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(HighlightConfig) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<HighlightConfig>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<HighlightConfig> result = HighlightConfig::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setShowInfo(bool value)
    {
        JSON::ObjectBase::setBoolean("showInfo"_s, value);
    }

    void setContentColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        JSON::ObjectBase::setObject("contentColor"_s, WTFMove(value));
    }

    void setPaddingColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        JSON::ObjectBase::setObject("paddingColor"_s, WTFMove(value));
    }

    void setBorderColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        JSON::ObjectBase::setObject("borderColor"_s, WTFMove(value));
    }

    void setMarginColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        JSON::ObjectBase::setObject("marginColor"_s, WTFMove(value));
    }
};

/* Data to construct File object. */
class FilePayload : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        DataSet = 1 << 2,
        AllFieldsSet = (NameSet | TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FilePayload*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FilePayload;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, value);
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setString("data"_s, value);
            return castState<DataSet>();
        }

        Ref<FilePayload> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FilePayload) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FilePayload>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FilePayload> result = FilePayload::create()
     *     .setName(...)
     *     .setType(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // DOM

namespace DOMDebugger {

/* DOM breakpoint type. */
enum class DOMBreakpointType {
    SubtreeModified = 109,
    AttributeModified = 110,
    NodeRemoved = 111,
}; // enum class DOMBreakpointType

/* Event breakpoint type. */
enum class EventBreakpointType {
    AnimationFrame = 112,
    Interval = 113,
    Listener = 114,
    Timeout = 115,
}; // enum class EventBreakpointType

} // DOMDebugger

namespace DOMStorage {

/* DOM Storage identifier. */
class StorageId : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SecurityOriginSet = 1 << 0,
        IsLocalStorageSet = 1 << 1,
        AllFieldsSet = (SecurityOriginSet | IsLocalStorageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StorageId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StorageId;
    public:

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin"_s, value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | IsLocalStorageSet>& setIsLocalStorage(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsLocalStorageSet), property_isLocalStorage_already_set);
            m_result->setBoolean("isLocalStorage"_s, value);
            return castState<IsLocalStorageSet>();
        }

        Ref<StorageId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StorageId) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StorageId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StorageId> result = StorageId::create()
     *     .setSecurityOrigin(...)
     *     .setIsLocalStorage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // DOMStorage

namespace Database {

/* Database object. */
class Database : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DomainSet = 1 << 1,
        NameSet = 1 << 2,
        VersionSet = 1 << 3,
        AllFieldsSet = (IdSet | DomainSet | NameSet | VersionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Database*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Database;
    public:

        Builder<STATE | IdSet>& setId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id"_s, value);
            return castState<IdSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain"_s, value);
            return castState<DomainSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString("version"_s, value);
            return castState<VersionSet>();
        }

        Ref<Database> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Database) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Database>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Database> result = Database::create()
     *     .setId(...)
     *     .setDomain(...)
     *     .setName(...)
     *     .setVersion(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Database error. */
class Error : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MessageSet = 1 << 0,
        CodeSet = 1 << 1,
        AllFieldsSet = (MessageSet | CodeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Error*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Error;
    public:

        Builder<STATE | MessageSet>& setMessage(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MessageSet), property_message_already_set);
            m_result->setString("message"_s, value);
            return castState<MessageSet>();
        }

        Builder<STATE | CodeSet>& setCode(int value)
        {
            COMPILE_ASSERT(!(STATE & CodeSet), property_code_already_set);
            m_result->setInteger("code"_s, value);
            return castState<CodeSet>();
        }

        Ref<Error> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Error) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Error>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Error> result = Error::create()
     *     .setMessage(...)
     *     .setCode(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Database

namespace Debugger {

/* Location in the source code. */
class Location : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Location*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId"_s, value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setInteger("lineNumber"_s, value);
            return castState<LineNumberSet>();
        }

        Ref<Location> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Location) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Location>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setColumnNumber(int value)
    {
        JSON::ObjectBase::setInteger("columnNumber"_s, value);
    }
};

/* Action to perform when a breakpoint is triggered. */
class BreakpointAction : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating BreakpointAction.
    enum class Type {
        Log = 70,
        Evaluate = 116,
        Sound = 117,
        Probe = 118,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointAction*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointAction;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<BreakpointAction> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointAction) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointAction>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointAction> result = BreakpointAction::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setData(const String& value)
    {
        JSON::ObjectBase::setString("data"_s, value);
    }

    void setId(int value)
    {
        JSON::ObjectBase::setInteger("id"_s, value);
    }
};

/* Extra options that modify breakpoint behavior. */
class BreakpointOptions : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointOptions*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointOptions;
    public:

        Ref<BreakpointOptions> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointOptions) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointOptions>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointOptions> result = BreakpointOptions::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setCondition(const String& value)
    {
        JSON::ObjectBase::setString("condition"_s, value);
    }

    void setActions(RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::BreakpointAction>> value)
    {
        JSON::ObjectBase::setArray("actions"_s, WTFMove(value));
    }

    void setAutoContinue(bool value)
    {
        JSON::ObjectBase::setBoolean("autoContinue"_s, value);
    }

    void setIgnoreCount(int value)
    {
        JSON::ObjectBase::setInteger("ignoreCount"_s, value);
    }
};

/* Information about the function. */
class FunctionDetails : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        AllFieldsSet = (LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FunctionDetails*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setObject("location"_s, value);
            return castState<LocationSet>();
        }

        Ref<FunctionDetails> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FunctionDetails>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }

    void setDisplayName(const String& value)
    {
        JSON::ObjectBase::setString("displayName"_s, value);
    }

    void setScopeChain(RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::Scope>> value)
    {
        JSON::ObjectBase::setArray("scopeChain"_s, WTFMove(value));
    }
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        IsTailDeletedSet = 1 << 5,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet | IsTailDeletedSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & CallFrameIdSet), property_callFrameId_already_set);
            m_result->setString("callFrameId"_s, value);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName"_s, value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setObject("location"_s, value);
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::Scope>> value)
        {
            COMPILE_ASSERT(!(STATE & ScopeChainSet), property_scopeChain_already_set);
            m_result->setArray("scopeChain"_s, value);
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ThisSet), property_this_already_set);
            m_result->setObject("this"_s, value);
            return castState<ThisSet>();
        }

        Builder<STATE | IsTailDeletedSet>& setIsTailDeleted(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsTailDeletedSet), property_isTailDeleted_already_set);
            m_result->setBoolean("isTailDeleted"_s, value);
            return castState<IsTailDeletedSet>();
        }

        Ref<CallFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...)
     *     .setIsTailDeleted(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Scope description. */
class Scope : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    enum class Type {
        Global = 119,
        With = 120,
        Closure = 121,
        Catch = 122,
        FunctionName = 123,
        GlobalLexicalEnvironment = 124,
        NestedLexical = 125,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        ObjectSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (ObjectSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Scope*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Scope;
    public:

        Builder<STATE | ObjectSet>& setObject(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectSet), property_object_already_set);
            m_result->setObject("object"_s, value);
            return castState<ObjectSet>();
        }

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<Scope> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Scope) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Scope>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Scope> result = Scope::create()
     *     .setObject(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }

    void setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
    {
        JSON::ObjectBase::setObject("location"_s, WTFMove(value));
    }

    void setEmpty(bool value)
    {
        JSON::ObjectBase::setBoolean("empty"_s, value);
    }
};

/* A sample collected by evaluating a probe breakpoint action. */
class ProbeSample : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProbeIdSet = 1 << 0,
        SampleIdSet = 1 << 1,
        BatchIdSet = 1 << 2,
        TimestampSet = 1 << 3,
        PayloadSet = 1 << 4,
        AllFieldsSet = (ProbeIdSet | SampleIdSet | BatchIdSet | TimestampSet | PayloadSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ProbeSample*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ProbeSample;
    public:

        Builder<STATE | ProbeIdSet>& setProbeId(int value)
        {
            COMPILE_ASSERT(!(STATE & ProbeIdSet), property_probeId_already_set);
            m_result->setInteger("probeId"_s, value);
            return castState<ProbeIdSet>();
        }

        Builder<STATE | SampleIdSet>& setSampleId(int value)
        {
            COMPILE_ASSERT(!(STATE & SampleIdSet), property_sampleId_already_set);
            m_result->setInteger("sampleId"_s, value);
            return castState<SampleIdSet>();
        }

        Builder<STATE | BatchIdSet>& setBatchId(int value)
        {
            COMPILE_ASSERT(!(STATE & BatchIdSet), property_batchId_already_set);
            m_result->setInteger("batchId"_s, value);
            return castState<BatchIdSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble("timestamp"_s, value);
            return castState<TimestampSet>();
        }

        Builder<STATE | PayloadSet>& setPayload(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PayloadSet), property_payload_already_set);
            m_result->setObject("payload"_s, value);
            return castState<PayloadSet>();
        }

        Ref<ProbeSample> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ProbeSample) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ProbeSample>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ProbeSample> result = ProbeSample::create()
     *     .setProbeId(...)
     *     .setSampleId(...)
     *     .setBatchId(...)
     *     .setTimestamp(...)
     *     .setPayload(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The pause reason auxiliary data when paused because of an assertion. */
class AssertPauseReason : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AssertPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class AssertPauseReason;
    public:

        Ref<AssertPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(AssertPauseReason) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AssertPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AssertPauseReason> result = AssertPauseReason::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setMessage(const String& value)
    {
        JSON::ObjectBase::setString("message"_s, value);
    }
};

/* The pause reason auxiliary data when paused because of hitting a breakpoint. */
class BreakpointPauseReason : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BreakpointIdSet = 1 << 0,
        AllFieldsSet = (BreakpointIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointPauseReason;
    public:

        Builder<STATE | BreakpointIdSet>& setBreakpointId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & BreakpointIdSet), property_breakpointId_already_set);
            m_result->setString("breakpointId"_s, value);
            return castState<BreakpointIdSet>();
        }

        Ref<BreakpointPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointPauseReason) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointPauseReason> result = BreakpointPauseReason::create()
     *     .setBreakpointId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The pause reason auxiliary data when paused because of a Content Security Policy directive. */
class CSPViolationPauseReason : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DirectiveSet = 1 << 0,
        AllFieldsSet = (DirectiveSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSPViolationPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSPViolationPauseReason;
    public:

        Builder<STATE | DirectiveSet>& setDirective(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DirectiveSet), property_directive_already_set);
            m_result->setString("directive"_s, value);
            return castState<DirectiveSet>();
        }

        Ref<CSPViolationPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSPViolationPauseReason) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSPViolationPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSPViolationPauseReason> result = CSPViolationPauseReason::create()
     *     .setDirective(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Debugger

namespace GenericTypes {

/* Search match in a resource. */
class SearchMatch : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchMatch*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setDouble("lineNumber"_s, value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LineContentSet), property_lineContent_already_set);
            m_result->setString("lineContent"_s, value);
            return castState<LineContentSet>();
        }

        Ref<SearchMatch> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchMatch) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SearchMatch>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // GenericTypes

namespace Heap {

/* Information about a garbage collection. */
class GarbageCollection : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating GarbageCollection.
    enum class Type {
        Full = 126,
        Partial = 127,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        StartTimeSet = 1 << 1,
        EndTimeSet = 1 << 2,
        AllFieldsSet = (TypeSet | StartTimeSet | EndTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*GarbageCollection*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class GarbageCollection;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble("startTime"_s, value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setDouble("endTime"_s, value);
            return castState<EndTimeSet>();
        }

        Ref<GarbageCollection> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(GarbageCollection) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<GarbageCollection>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<GarbageCollection> result = GarbageCollection::create()
     *     .setType(...)
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Heap

#if defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE
namespace IndexedDB {

/* Database with an array of object stores. */
class DatabaseWithObjectStores : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        VersionSet = 1 << 1,
        ObjectStoresSet = 1 << 2,
        AllFieldsSet = (NameSet | VersionSet | ObjectStoresSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DatabaseWithObjectStores*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class DatabaseWithObjectStores;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(double value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setDouble("version"_s, value);
            return castState<VersionSet>();
        }

        Builder<STATE | ObjectStoresSet>& setObjectStores(RefPtr<JSON::ArrayOf<Inspector::Protocol::IndexedDB::ObjectStore>> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectStoresSet), property_objectStores_already_set);
            m_result->setArray("objectStores"_s, value);
            return castState<ObjectStoresSet>();
        }

        Ref<DatabaseWithObjectStores> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DatabaseWithObjectStores) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DatabaseWithObjectStores>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DatabaseWithObjectStores> result = DatabaseWithObjectStores::create()
     *     .setName(...)
     *     .setVersion(...)
     *     .setObjectStores(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Object store. */
class ObjectStore : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        AutoIncrementSet = 1 << 2,
        IndexesSet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStore*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectStore;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(RefPtr<Inspector::Protocol::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setObject("keyPath"_s, value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | AutoIncrementSet>& setAutoIncrement(bool value)
        {
            COMPILE_ASSERT(!(STATE & AutoIncrementSet), property_autoIncrement_already_set);
            m_result->setBoolean("autoIncrement"_s, value);
            return castState<AutoIncrementSet>();
        }

        Builder<STATE | IndexesSet>& setIndexes(RefPtr<JSON::ArrayOf<Inspector::Protocol::IndexedDB::ObjectStoreIndex>> value)
        {
            COMPILE_ASSERT(!(STATE & IndexesSet), property_indexes_already_set);
            m_result->setArray("indexes"_s, value);
            return castState<IndexesSet>();
        }

        Ref<ObjectStore> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStore) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectStore>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStore> result = ObjectStore::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setAutoIncrement(...)
     *     .setIndexes(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Object store index. */
class ObjectStoreIndex : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        UniqueSet = 1 << 2,
        MultiEntrySet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStoreIndex*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectStoreIndex;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(RefPtr<Inspector::Protocol::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setObject("keyPath"_s, value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | UniqueSet>& setUnique(bool value)
        {
            COMPILE_ASSERT(!(STATE & UniqueSet), property_unique_already_set);
            m_result->setBoolean("unique"_s, value);
            return castState<UniqueSet>();
        }

        Builder<STATE | MultiEntrySet>& setMultiEntry(bool value)
        {
            COMPILE_ASSERT(!(STATE & MultiEntrySet), property_multiEntry_already_set);
            m_result->setBoolean("multiEntry"_s, value);
            return castState<MultiEntrySet>();
        }

        Ref<ObjectStoreIndex> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStoreIndex) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectStoreIndex>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStoreIndex> result = ObjectStoreIndex::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setUnique(...)
     *     .setMultiEntry(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Key. */
class Key : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Key.
    enum class Type {
        Number = 128,
        String = 129,
        Date = 103,
        Array = 130,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Key*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Key;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<Key> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Key) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Key>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Key> result = Key::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNumber(double value)
    {
        JSON::ObjectBase::setDouble("number"_s, value);
    }

    void setString(const String& value)
    {
        JSON::ObjectBase::setString("string"_s, value);
    }

    void setDate(double value)
    {
        JSON::ObjectBase::setDouble("date"_s, value);
    }

    void setArray(RefPtr<JSON::ArrayOf<Inspector::Protocol::IndexedDB::Key>> value)
    {
        JSON::ObjectBase::setArray("array"_s, WTFMove(value));
    }
};

/* Key range. */
class KeyRange : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LowerOpenSet = 1 << 0,
        UpperOpenSet = 1 << 1,
        AllFieldsSet = (LowerOpenSet | UpperOpenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class KeyRange;
    public:

        Builder<STATE | LowerOpenSet>& setLowerOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & LowerOpenSet), property_lowerOpen_already_set);
            m_result->setBoolean("lowerOpen"_s, value);
            return castState<LowerOpenSet>();
        }

        Builder<STATE | UpperOpenSet>& setUpperOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & UpperOpenSet), property_upperOpen_already_set);
            m_result->setBoolean("upperOpen"_s, value);
            return castState<UpperOpenSet>();
        }

        Ref<KeyRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyRange) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<KeyRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyRange> result = KeyRange::create()
     *     .setLowerOpen(...)
     *     .setUpperOpen(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setLower(RefPtr<Inspector::Protocol::IndexedDB::Key> value)
    {
        JSON::ObjectBase::setObject("lower"_s, WTFMove(value));
    }

    void setUpper(RefPtr<Inspector::Protocol::IndexedDB::Key> value)
    {
        JSON::ObjectBase::setObject("upper"_s, WTFMove(value));
    }
};

/* Data entry. */
class DataEntry : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        KeySet = 1 << 0,
        PrimaryKeySet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DataEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class DataEntry;
    public:

        Builder<STATE | KeySet>& setKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & KeySet), property_key_already_set);
            m_result->setObject("key"_s, value);
            return castState<KeySet>();
        }

        Builder<STATE | PrimaryKeySet>& setPrimaryKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PrimaryKeySet), property_primaryKey_already_set);
            m_result->setObject("primaryKey"_s, value);
            return castState<PrimaryKeySet>();
        }

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<DataEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DataEntry) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DataEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DataEntry> result = DataEntry::create()
     *     .setKey(...)
     *     .setPrimaryKey(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Key path. */
class KeyPath : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating KeyPath.
    enum class Type {
        Null = 131,
        String = 129,
        Array = 130,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyPath*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class KeyPath;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<KeyPath> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyPath) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<KeyPath>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyPath> result = KeyPath::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setString(const String& value)
    {
        JSON::ObjectBase::setString("string"_s, value);
    }

    void setArray(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("array"_s, WTFMove(value));
    }
};

} // IndexedDB
#endif // defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE

namespace LayerTree {

/* A rectangle. */
class IntRect : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*IntRect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class IntRect;
    public:

        Builder<STATE | XSet>& setX(int value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setInteger("x"_s, value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setInteger("y"_s, value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setInteger("width"_s, value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setInteger("height"_s, value);
            return castState<HeightSet>();
        }

        Ref<IntRect> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(IntRect) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<IntRect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<IntRect> result = IntRect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Information about a compositing layer. */
class Layer : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LayerIdSet = 1 << 0,
        NodeIdSet = 1 << 1,
        BoundsSet = 1 << 2,
        PaintCountSet = 1 << 3,
        MemorySet = 1 << 4,
        CompositedBoundsSet = 1 << 5,
        AllFieldsSet = (LayerIdSet | NodeIdSet | BoundsSet | PaintCountSet | MemorySet | CompositedBoundsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Layer*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Layer;
    public:

        Builder<STATE | LayerIdSet>& setLayerId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LayerIdSet), property_layerId_already_set);
            m_result->setString("layerId"_s, value);
            return castState<LayerIdSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger("nodeId"_s, value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | BoundsSet>& setBounds(RefPtr<Inspector::Protocol::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & BoundsSet), property_bounds_already_set);
            m_result->setObject("bounds"_s, value);
            return castState<BoundsSet>();
        }

        Builder<STATE | PaintCountSet>& setPaintCount(int value)
        {
            COMPILE_ASSERT(!(STATE & PaintCountSet), property_paintCount_already_set);
            m_result->setInteger("paintCount"_s, value);
            return castState<PaintCountSet>();
        }

        Builder<STATE | MemorySet>& setMemory(int value)
        {
            COMPILE_ASSERT(!(STATE & MemorySet), property_memory_already_set);
            m_result->setInteger("memory"_s, value);
            return castState<MemorySet>();
        }

        Builder<STATE | CompositedBoundsSet>& setCompositedBounds(RefPtr<Inspector::Protocol::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & CompositedBoundsSet), property_compositedBounds_already_set);
            m_result->setObject("compositedBounds"_s, value);
            return castState<CompositedBoundsSet>();
        }

        Ref<Layer> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Layer) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Layer>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Layer> result = Layer::create()
     *     .setLayerId(...)
     *     .setNodeId(...)
     *     .setBounds(...)
     *     .setPaintCount(...)
     *     .setMemory(...)
     *     .setCompositedBounds(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setIsInShadowTree(bool value)
    {
        JSON::ObjectBase::setBoolean("isInShadowTree"_s, value);
    }

    void setIsReflection(bool value)
    {
        JSON::ObjectBase::setBoolean("isReflection"_s, value);
    }

    void setIsGeneratedContent(bool value)
    {
        JSON::ObjectBase::setBoolean("isGeneratedContent"_s, value);
    }

    void setIsAnonymous(bool value)
    {
        JSON::ObjectBase::setBoolean("isAnonymous"_s, value);
    }

    void setPseudoElementId(const String& value)
    {
        JSON::ObjectBase::setString("pseudoElementId"_s, value);
    }

    void setPseudoElement(const String& value)
    {
        JSON::ObjectBase::setString("pseudoElement"_s, value);
    }
};

/* An object containing the reasons why the layer was composited as properties. */
class CompositingReasons : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CompositingReasons*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CompositingReasons;
    public:

        Ref<CompositingReasons> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CompositingReasons) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CompositingReasons>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CompositingReasons> result = CompositingReasons::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setTransform3D(bool value)
    {
        JSON::ObjectBase::setBoolean("transform3D"_s, value);
    }

    void setVideo(bool value)
    {
        JSON::ObjectBase::setBoolean("video"_s, value);
    }

    void setCanvas(bool value)
    {
        JSON::ObjectBase::setBoolean("canvas"_s, value);
    }

    void setPlugin(bool value)
    {
        JSON::ObjectBase::setBoolean("plugin"_s, value);
    }

    void setIFrame(bool value)
    {
        JSON::ObjectBase::setBoolean("iFrame"_s, value);
    }

    void setBackfaceVisibilityHidden(bool value)
    {
        JSON::ObjectBase::setBoolean("backfaceVisibilityHidden"_s, value);
    }

    void setClipsCompositingDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("clipsCompositingDescendants"_s, value);
    }

    void setAnimation(bool value)
    {
        JSON::ObjectBase::setBoolean("animation"_s, value);
    }

    void setFilters(bool value)
    {
        JSON::ObjectBase::setBoolean("filters"_s, value);
    }

    void setPositionFixed(bool value)
    {
        JSON::ObjectBase::setBoolean("positionFixed"_s, value);
    }

    void setPositionSticky(bool value)
    {
        JSON::ObjectBase::setBoolean("positionSticky"_s, value);
    }

    void setOverflowScrollingTouch(bool value)
    {
        JSON::ObjectBase::setBoolean("overflowScrollingTouch"_s, value);
    }

    void setStacking(bool value)
    {
        JSON::ObjectBase::setBoolean("stacking"_s, value);
    }

    void setOverlap(bool value)
    {
        JSON::ObjectBase::setBoolean("overlap"_s, value);
    }

    void setNegativeZIndexChildren(bool value)
    {
        JSON::ObjectBase::setBoolean("negativeZIndexChildren"_s, value);
    }

    void setTransformWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("transformWithCompositedDescendants"_s, value);
    }

    void setOpacityWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("opacityWithCompositedDescendants"_s, value);
    }

    void setMaskWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("maskWithCompositedDescendants"_s, value);
    }

    void setReflectionWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("reflectionWithCompositedDescendants"_s, value);
    }

    void setFilterWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("filterWithCompositedDescendants"_s, value);
    }

    void setBlendingWithCompositedDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("blendingWithCompositedDescendants"_s, value);
    }

    void setIsolatesCompositedBlendingDescendants(bool value)
    {
        JSON::ObjectBase::setBoolean("isolatesCompositedBlendingDescendants"_s, value);
    }

    void setPerspective(bool value)
    {
        JSON::ObjectBase::setBoolean("perspective"_s, value);
    }

    void setPreserve3D(bool value)
    {
        JSON::ObjectBase::setBoolean("preserve3D"_s, value);
    }

    void setWillChange(bool value)
    {
        JSON::ObjectBase::setBoolean("willChange"_s, value);
    }

    void setRoot(bool value)
    {
        JSON::ObjectBase::setBoolean("root"_s, value);
    }

    void setBlending(bool value)
    {
        JSON::ObjectBase::setBoolean("blending"_s, value);
    }
};

} // LayerTree

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace Memory {

class Event : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        CategoriesSet = 1 << 1,
        AllFieldsSet = (TimestampSet | CategoriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Event;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble("timestamp"_s, value);
            return castState<TimestampSet>();
        }

        Builder<STATE | CategoriesSet>& setCategories(RefPtr<JSON::ArrayOf<Inspector::Protocol::Memory::CategoryData>> value)
        {
            COMPILE_ASSERT(!(STATE & CategoriesSet), property_categories_already_set);
            m_result->setArray("categories"_s, value);
            return castState<CategoriesSet>();
        }

        Ref<Event> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Event) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setTimestamp(...)
     *     .setCategories(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class CategoryData : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating CategoryData.
    enum class Type {
        JavaScript = 52,
        JIT = 132,
        Images = 133,
        Layers = 134,
        Page = 100,
        Other = 66,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        SizeSet = 1 << 1,
        AllFieldsSet = (TypeSet | SizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CategoryData*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CategoryData;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setDouble("size"_s, value);
            return castState<SizeSet>();
        }

        Ref<CategoryData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CategoryData) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CategoryData>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CategoryData> result = CategoryData::create()
     *     .setType(...)
     *     .setSize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Memory
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace Network {

/* Timing information for the request. */
class ResourceTiming : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartTimeSet = 1 << 0,
        RedirectStartSet = 1 << 1,
        RedirectEndSet = 1 << 2,
        FetchStartSet = 1 << 3,
        DomainLookupStartSet = 1 << 4,
        DomainLookupEndSet = 1 << 5,
        ConnectStartSet = 1 << 6,
        ConnectEndSet = 1 << 7,
        SecureConnectionStartSet = 1 << 8,
        RequestStartSet = 1 << 9,
        ResponseStartSet = 1 << 10,
        ResponseEndSet = 1 << 11,
        AllFieldsSet = (StartTimeSet | RedirectStartSet | RedirectEndSet | FetchStartSet | DomainLookupStartSet | DomainLookupEndSet | ConnectStartSet | ConnectEndSet | SecureConnectionStartSet | RequestStartSet | ResponseStartSet | ResponseEndSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ResourceTiming*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ResourceTiming;
    public:

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble("startTime"_s, value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | RedirectStartSet>& setRedirectStart(double value)
        {
            COMPILE_ASSERT(!(STATE & RedirectStartSet), property_redirectStart_already_set);
            m_result->setDouble("redirectStart"_s, value);
            return castState<RedirectStartSet>();
        }

        Builder<STATE | RedirectEndSet>& setRedirectEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & RedirectEndSet), property_redirectEnd_already_set);
            m_result->setDouble("redirectEnd"_s, value);
            return castState<RedirectEndSet>();
        }

        Builder<STATE | FetchStartSet>& setFetchStart(double value)
        {
            COMPILE_ASSERT(!(STATE & FetchStartSet), property_fetchStart_already_set);
            m_result->setDouble("fetchStart"_s, value);
            return castState<FetchStartSet>();
        }

        Builder<STATE | DomainLookupStartSet>& setDomainLookupStart(double value)
        {
            COMPILE_ASSERT(!(STATE & DomainLookupStartSet), property_domainLookupStart_already_set);
            m_result->setDouble("domainLookupStart"_s, value);
            return castState<DomainLookupStartSet>();
        }

        Builder<STATE | DomainLookupEndSet>& setDomainLookupEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & DomainLookupEndSet), property_domainLookupEnd_already_set);
            m_result->setDouble("domainLookupEnd"_s, value);
            return castState<DomainLookupEndSet>();
        }

        Builder<STATE | ConnectStartSet>& setConnectStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectStartSet), property_connectStart_already_set);
            m_result->setDouble("connectStart"_s, value);
            return castState<ConnectStartSet>();
        }

        Builder<STATE | ConnectEndSet>& setConnectEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectEndSet), property_connectEnd_already_set);
            m_result->setDouble("connectEnd"_s, value);
            return castState<ConnectEndSet>();
        }

        Builder<STATE | SecureConnectionStartSet>& setSecureConnectionStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SecureConnectionStartSet), property_secureConnectionStart_already_set);
            m_result->setDouble("secureConnectionStart"_s, value);
            return castState<SecureConnectionStartSet>();
        }

        Builder<STATE | RequestStartSet>& setRequestStart(double value)
        {
            COMPILE_ASSERT(!(STATE & RequestStartSet), property_requestStart_already_set);
            m_result->setDouble("requestStart"_s, value);
            return castState<RequestStartSet>();
        }

        Builder<STATE | ResponseStartSet>& setResponseStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ResponseStartSet), property_responseStart_already_set);
            m_result->setDouble("responseStart"_s, value);
            return castState<ResponseStartSet>();
        }

        Builder<STATE | ResponseEndSet>& setResponseEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ResponseEndSet), property_responseEnd_already_set);
            m_result->setDouble("responseEnd"_s, value);
            return castState<ResponseEndSet>();
        }

        Ref<ResourceTiming> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceTiming) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ResourceTiming>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ResourceTiming> result = ResourceTiming::create()
     *     .setStartTime(...)
     *     .setRedirectStart(...)
     *     .setRedirectEnd(...)
     *     .setFetchStart(...)
     *     .setDomainLookupStart(...)
     *     .setDomainLookupEnd(...)
     *     .setConnectStart(...)
     *     .setConnectEnd(...)
     *     .setSecureConnectionStart(...)
     *     .setRequestStart(...)
     *     .setResponseStart(...)
     *     .setResponseEnd(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* HTTP request data. */
class Request : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        MethodSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (UrlSet | MethodSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Request*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Request;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | MethodSet>& setMethod(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MethodSet), property_method_already_set);
            m_result->setString("method"_s, value);
            return castState<MethodSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<JSON::Object> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject("headers"_s, value);
            return castState<HeadersSet>();
        }

        Ref<Request> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Request) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Request>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Request> result = Request::create()
     *     .setUrl(...)
     *     .setMethod(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPostData(const String& value)
    {
        JSON::ObjectBase::setString("postData"_s, value);
    }
};

/* HTTP response data. */
class Response : public JSON::Object {
public:
    // Named after property name 'source' while generating Response.
    enum class Source {
        Unknown = 135,
        Network = 53,
        MemoryCache = 136,
        DiskCache = 137,
        ServiceWorker = 138,
        InspectorOverride = 139,
    }; // enum class Source
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        StatusSet = 1 << 1,
        StatusTextSet = 1 << 2,
        HeadersSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        SourceSet = 1 << 5,
        AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | SourceSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Response*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Response;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setInteger("status"_s, value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText"_s, value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<JSON::Object> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject("headers"_s, value);
            return castState<HeadersSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType"_s, value);
            return castState<MimeTypeSet>();
        }

        Builder<STATE | SourceSet>& setSource(Source value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        Ref<Response> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Response) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Response>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Response> result = Response::create()
     *     .setUrl(...)
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .setMimeType(...)
     *     .setSource(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRequestHeaders(RefPtr<JSON::Object> value)
    {
        JSON::ObjectBase::setObject("requestHeaders"_s, WTFMove(value));
    }

    void setTiming(RefPtr<Inspector::Protocol::Network::ResourceTiming> value)
    {
        JSON::ObjectBase::setObject("timing"_s, WTFMove(value));
    }

    void setSecurity(RefPtr<Inspector::Protocol::Security::Security> value)
    {
        JSON::ObjectBase::setObject("security"_s, WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* MimeType;
};

/* Network load metrics. */
class Metrics : public JSON::ObjectBase {
public:
    // Named after property name 'priority' while generating Metrics.
    enum class Priority {
        Low = 140,
        Medium = 141,
        High = 142,
    }; // enum class Priority
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Metrics*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Metrics;
    public:

        Ref<Metrics> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Metrics) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Metrics>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Metrics> result = Metrics::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setProtocol(const String& value)
    {
        JSON::ObjectBase::setString("protocol"_s, value);
    }

    void setPriority(Priority value)
    {
        JSON::ObjectBase::setString("priority"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setConnectionIdentifier(const String& value)
    {
        JSON::ObjectBase::setString("connectionIdentifier"_s, value);
    }

    void setRemoteAddress(const String& value)
    {
        JSON::ObjectBase::setString("remoteAddress"_s, value);
    }

    void setRequestHeaders(RefPtr<JSON::Object> value)
    {
        JSON::ObjectBase::setObject("requestHeaders"_s, WTFMove(value));
    }

    void setRequestHeaderBytesSent(double value)
    {
        JSON::ObjectBase::setDouble("requestHeaderBytesSent"_s, value);
    }

    void setRequestBodyBytesSent(double value)
    {
        JSON::ObjectBase::setDouble("requestBodyBytesSent"_s, value);
    }

    void setResponseHeaderBytesReceived(double value)
    {
        JSON::ObjectBase::setDouble("responseHeaderBytesReceived"_s, value);
    }

    void setResponseBodyBytesReceived(double value)
    {
        JSON::ObjectBase::setDouble("responseBodyBytesReceived"_s, value);
    }

    void setResponseBodyDecodedSize(double value)
    {
        JSON::ObjectBase::setDouble("responseBodyDecodedSize"_s, value);
    }

    void setSecurityConnection(RefPtr<Inspector::Protocol::Security::Connection> value)
    {
        JSON::ObjectBase::setObject("securityConnection"_s, WTFMove(value));
    }
};

/* WebSocket request data. */
class WebSocketRequest : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadersSet = 1 << 0,
        AllFieldsSet = (HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketRequest*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketRequest;
    public:

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<JSON::Object> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject("headers"_s, value);
            return castState<HeadersSet>();
        }

        Ref<WebSocketRequest> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketRequest) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketRequest>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketRequest> result = WebSocketRequest::create()
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* WebSocket response data. */
class WebSocketResponse : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StatusSet = 1 << 0,
        StatusTextSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketResponse*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketResponse;
    public:

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setInteger("status"_s, value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText"_s, value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<JSON::Object> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject("headers"_s, value);
            return castState<HeadersSet>();
        }

        Ref<WebSocketResponse> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketResponse) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketResponse>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketResponse> result = WebSocketResponse::create()
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* WebSocket frame data. */
class WebSocketFrame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OpcodeSet = 1 << 0,
        MaskSet = 1 << 1,
        PayloadDataSet = 1 << 2,
        PayloadLengthSet = 1 << 3,
        AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet | PayloadLengthSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketFrame;
    public:

        Builder<STATE | OpcodeSet>& setOpcode(double value)
        {
            COMPILE_ASSERT(!(STATE & OpcodeSet), property_opcode_already_set);
            m_result->setDouble("opcode"_s, value);
            return castState<OpcodeSet>();
        }

        Builder<STATE | MaskSet>& setMask(bool value)
        {
            COMPILE_ASSERT(!(STATE & MaskSet), property_mask_already_set);
            m_result->setBoolean("mask"_s, value);
            return castState<MaskSet>();
        }

        Builder<STATE | PayloadDataSet>& setPayloadData(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PayloadDataSet), property_payloadData_already_set);
            m_result->setString("payloadData"_s, value);
            return castState<PayloadDataSet>();
        }

        Builder<STATE | PayloadLengthSet>& setPayloadLength(double value)
        {
            COMPILE_ASSERT(!(STATE & PayloadLengthSet), property_payloadLength_already_set);
            m_result->setDouble("payloadLength"_s, value);
            return castState<PayloadLengthSet>();
        }

        Ref<WebSocketFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketFrame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketFrame> result = WebSocketFrame::create()
     *     .setOpcode(...)
     *     .setMask(...)
     *     .setPayloadData(...)
     *     .setPayloadLength(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Information about the cached resource. */
class CachedResource : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        BodySizeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | BodySizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CachedResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CachedResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Page::ResourceType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | BodySizeSet>& setBodySize(double value)
        {
            COMPILE_ASSERT(!(STATE & BodySizeSet), property_bodySize_already_set);
            m_result->setDouble("bodySize"_s, value);
            return castState<BodySizeSet>();
        }

        Ref<CachedResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CachedResource) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CachedResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CachedResource> result = CachedResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setBodySize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setResponse(RefPtr<Inspector::Protocol::Network::Response> value)
    {
        JSON::ObjectBase::setObject("response"_s, WTFMove(value));
    }

    void setSourceMapURL(const String& value)
    {
        JSON::ObjectBase::setString("sourceMapURL"_s, value);
    }
};

/* Information about the request initiator. */
class Initiator : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Initiator.
    enum class Type {
        Parser = 155,
        Script = 156,
        Other = 66,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Initiator*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Initiator;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<Initiator> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Initiator) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Initiator>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Initiator> result = Initiator::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStackTrace(RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::CallFrame>> value)
    {
        JSON::ObjectBase::setArray("stackTrace"_s, WTFMove(value));
    }

    void setUrl(const String& value)
    {
        JSON::ObjectBase::setString("url"_s, value);
    }

    void setLineNumber(double value)
    {
        JSON::ObjectBase::setDouble("lineNumber"_s, value);
    }

    void setNodeId(int value)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, value);
    }
};

/* Different stages of a network request. */
enum class NetworkStage {
    Request = 157,
    Response = 158,
}; // enum class NetworkStage

/* Different stages of a network request. */
enum class ResourceErrorType {
    General = 159,
    AccessControl = 160,
    Cancellation = 161,
    Timeout = 162,
}; // enum class ResourceErrorType

} // Network

namespace Page {

/* List of settings able to be overridden by WebInspector. */
enum class Setting {
    AdClickAttributionDebugModeEnabled = 163,
    AuthorAndUserStylesEnabled = 164,
    ICECandidateFilteringEnabled = 165,
    ITPDebugModeEnabled = 166,
    ImagesEnabled = 167,
    MediaCaptureRequiresSecureConnection = 168,
    MockCaptureDevicesEnabled = 169,
    NeedsSiteSpecificQuirks = 170,
    ScriptEnabled = 171,
    ShowDebugBorders = 172,
    ShowRepaintCounter = 173,
    WebRTCEncryptionEnabled = 174,
    WebSecurityEnabled = 175,
}; // enum class Setting

/* Resource type as it was perceived by the rendering engine. */
enum class ResourceType {
    Document = 143,
    StyleSheet = 144,
    Image = 145,
    Font = 146,
    Script = 147,
    XHR = 148,
    Fetch = 149,
    Ping = 150,
    Beacon = 151,
    WebSocket = 152,
    EventSource = 153,
    Other = 154,
}; // enum class ResourceType

/* Coordinate system used by supplied coordinates. */
enum class CoordinateSystem {
    Viewport = 176,
    Page = 177,
}; // enum class CoordinateSystem

/* Same-Site policy of a cookie. */
enum class CookieSameSitePolicy {
    None = 178,
    Lax = 179,
    Strict = 180,
}; // enum class CookieSameSitePolicy

#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
/* Page appearance name. */
enum class Appearance {
    Light = 181,
    Dark = 182,
}; // enum class Appearance
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)

/* Information about the Frame on the page. */
class Frame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        LoaderIdSet = 1 << 1,
        UrlSet = 1 << 2,
        SecurityOriginSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | SecurityOriginSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Frame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Frame;
    public:

        Builder<STATE | IdSet>& setId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id"_s, value);
            return castState<IdSet>();
        }

        Builder<STATE | LoaderIdSet>& setLoaderId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LoaderIdSet), property_loaderId_already_set);
            m_result->setString("loaderId"_s, value);
            return castState<LoaderIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin"_s, value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType"_s, value);
            return castState<MimeTypeSet>();
        }

        Ref<Frame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Frame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Frame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Frame> result = Frame::create()
     *     .setId(...)
     *     .setLoaderId(...)
     *     .setUrl(...)
     *     .setSecurityOrigin(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setParentId(const String& value)
    {
        JSON::ObjectBase::setString("parentId"_s, value);
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }
};

class FrameResource : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        MimeTypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Page::ResourceType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType"_s, value);
            return castState<MimeTypeSet>();
        }

        Ref<FrameResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResource) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResource> result = FrameResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFailed(bool value)
    {
        JSON::ObjectBase::setBoolean("failed"_s, value);
    }

    void setCanceled(bool value)
    {
        JSON::ObjectBase::setBoolean("canceled"_s, value);
    }

    void setSourceMapURL(const String& value)
    {
        JSON::ObjectBase::setString("sourceMapURL"_s, value);
    }

    void setTargetId(const String& value)
    {
        JSON::ObjectBase::setString("targetId"_s, value);
    }
};

/* Information about the Frame hierarchy along with their cached resources. */
class FrameResourceTree : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameSet = 1 << 0,
        ResourcesSet = 1 << 1,
        AllFieldsSet = (FrameSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResourceTree*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameResourceTree;
    public:

        Builder<STATE | FrameSet>& setFrame(RefPtr<Inspector::Protocol::Page::Frame> value)
        {
            COMPILE_ASSERT(!(STATE & FrameSet), property_frame_already_set);
            m_result->setObject("frame"_s, value);
            return castState<FrameSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(RefPtr<JSON::ArrayOf<Inspector::Protocol::Page::FrameResource>> value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setArray("resources"_s, value);
            return castState<ResourcesSet>();
        }

        Ref<FrameResourceTree> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResourceTree) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameResourceTree>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResourceTree> result = FrameResourceTree::create()
     *     .setFrame(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setChildFrames(RefPtr<JSON::ArrayOf<Inspector::Protocol::Page::FrameResourceTree>> value)
    {
        JSON::ObjectBase::setArray("childFrames"_s, WTFMove(value));
    }
};

/* Search result for resource. */
class SearchResult : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        FrameIdSet = 1 << 1,
        MatchesCountSet = 1 << 2,
        AllFieldsSet = (UrlSet | FrameIdSet | MatchesCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchResult*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SearchResult;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId"_s, value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | MatchesCountSet>& setMatchesCount(double value)
        {
            COMPILE_ASSERT(!(STATE & MatchesCountSet), property_matchesCount_already_set);
            m_result->setDouble("matchesCount"_s, value);
            return castState<MatchesCountSet>();
        }

        Ref<SearchResult> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchResult) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SearchResult>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchResult> result = SearchResult::create()
     *     .setUrl(...)
     *     .setFrameId(...)
     *     .setMatchesCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRequestId(const String& value)
    {
        JSON::ObjectBase::setString("requestId"_s, value);
    }
};

/* Cookie object */
class Cookie : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SessionSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SameSiteSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SessionSet | HttpOnlySet | SecureSet | SameSiteSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain"_s, value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString("path"_s, value);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double value)
        {
            COMPILE_ASSERT(!(STATE & ExpiresSet), property_expires_already_set);
            m_result->setDouble("expires"_s, value);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool value)
        {
            COMPILE_ASSERT(!(STATE & SessionSet), property_session_already_set);
            m_result->setBoolean("session"_s, value);
            return castState<SessionSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            COMPILE_ASSERT(!(STATE & HttpOnlySet), property_httpOnly_already_set);
            m_result->setBoolean("httpOnly"_s, value);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool value)
        {
            COMPILE_ASSERT(!(STATE & SecureSet), property_secure_already_set);
            m_result->setBoolean("secure"_s, value);
            return castState<SecureSet>();
        }

        Builder<STATE | SameSiteSet>& setSameSite(Inspector::Protocol::Page::CookieSameSitePolicy value)
        {
            COMPILE_ASSERT(!(STATE & SameSiteSet), property_sameSite_already_set);
            m_result->setString("sameSite"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<SameSiteSet>();
        }

        Ref<Cookie> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Cookie) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Cookie>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSession(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSameSite(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Accessibility Node */
class AXNode : public JSON::ObjectBase {
public:
    // Named after property name 'checked' while generating AXNode.
    enum class Checked {
        True = 97,
        False = 98,
        Mixed = 99,
    }; // enum class Checked
    // Named after property name 'pressed' while generating AXNode.
    enum class Pressed {
        True = 97,
        False = 98,
        Mixed = 99,
    }; // enum class Pressed
    // Named after property name 'invalid' while generating AXNode.
    enum class Invalid {
        True = 97,
        False = 98,
        Grammar = 105,
        Spelling = 106,
    }; // enum class Invalid
    enum {
        NoFieldsSet = 0,
        RoleSet = 1 << 0,
        AllFieldsSet = (RoleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AXNode*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class AXNode;
    public:

        Builder<STATE | RoleSet>& setRole(const String& value)
        {
            COMPILE_ASSERT(!(STATE & RoleSet), property_role_already_set);
            m_result->setString("role"_s, value);
            return castState<RoleSet>();
        }

        Ref<AXNode> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(AXNode) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AXNode>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AXNode> result = AXNode::create()
     *     .setRole(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }

    void setValue(RefPtr<JSON::Value> value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(value));
    }

    void setDescription(const String& value)
    {
        JSON::ObjectBase::setString("description"_s, value);
    }

    void setKeyshortcuts(const String& value)
    {
        JSON::ObjectBase::setString("keyshortcuts"_s, value);
    }

    void setRoledescription(const String& value)
    {
        JSON::ObjectBase::setString("roledescription"_s, value);
    }

    void setValuetext(const String& value)
    {
        JSON::ObjectBase::setString("valuetext"_s, value);
    }

    void setDisabled(bool value)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, value);
    }

    void setExpanded(bool value)
    {
        JSON::ObjectBase::setBoolean("expanded"_s, value);
    }

    void setFocused(bool value)
    {
        JSON::ObjectBase::setBoolean("focused"_s, value);
    }

    void setModal(bool value)
    {
        JSON::ObjectBase::setBoolean("modal"_s, value);
    }

    void setMultiline(bool value)
    {
        JSON::ObjectBase::setBoolean("multiline"_s, value);
    }

    void setMultiselectable(bool value)
    {
        JSON::ObjectBase::setBoolean("multiselectable"_s, value);
    }

    void setReadonly(bool value)
    {
        JSON::ObjectBase::setBoolean("readonly"_s, value);
    }

    void setRequired(bool value)
    {
        JSON::ObjectBase::setBoolean("required"_s, value);
    }

    void setSelected(bool value)
    {
        JSON::ObjectBase::setBoolean("selected"_s, value);
    }

    void setChecked(Checked value)
    {
        JSON::ObjectBase::setString("checked"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setPressed(Pressed value)
    {
        JSON::ObjectBase::setString("pressed"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setLevel(int value)
    {
        JSON::ObjectBase::setInteger("level"_s, value);
    }

    void setValuemin(double value)
    {
        JSON::ObjectBase::setDouble("valuemin"_s, value);
    }

    void setValuemax(double value)
    {
        JSON::ObjectBase::setDouble("valuemax"_s, value);
    }

    void setAutocomplete(const String& value)
    {
        JSON::ObjectBase::setString("autocomplete"_s, value);
    }

    void setHaspopup(const String& value)
    {
        JSON::ObjectBase::setString("haspopup"_s, value);
    }

    void setInvalid(Invalid value)
    {
        JSON::ObjectBase::setString("invalid"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setOrientation(const String& value)
    {
        JSON::ObjectBase::setString("orientation"_s, value);
    }

    void setFocusable(bool value)
    {
        JSON::ObjectBase::setBoolean("focusable"_s, value);
    }

    void setChildren(RefPtr<JSON::ArrayOf<Inspector::Protocol::Page::AXNode>> value)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(value));
    }

    void setFound(bool value)
    {
        JSON::ObjectBase::setBoolean("found"_s, value);
    }
};

} // Page

namespace Playwright {

/* Same-Site policy of a cookie. */
enum class CookieSameSitePolicy {
    None = 178,
    Lax = 179,
    Strict = 180,
}; // enum class CookieSameSitePolicy

/* Cookie object */
class Cookie : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        HttpOnlySet = 1 << 5,
        SecureSet = 1 << 6,
        SessionSet = 1 << 7,
        SameSiteSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | HttpOnlySet | SecureSet | SessionSet | SameSiteSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain"_s, value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString("path"_s, value);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double value)
        {
            COMPILE_ASSERT(!(STATE & ExpiresSet), property_expires_already_set);
            m_result->setDouble("expires"_s, value);
            return castState<ExpiresSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            COMPILE_ASSERT(!(STATE & HttpOnlySet), property_httpOnly_already_set);
            m_result->setBoolean("httpOnly"_s, value);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool value)
        {
            COMPILE_ASSERT(!(STATE & SecureSet), property_secure_already_set);
            m_result->setBoolean("secure"_s, value);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool value)
        {
            COMPILE_ASSERT(!(STATE & SessionSet), property_session_already_set);
            m_result->setBoolean("session"_s, value);
            return castState<SessionSet>();
        }

        Builder<STATE | SameSiteSet>& setSameSite(Inspector::Protocol::Playwright::CookieSameSitePolicy value)
        {
            COMPILE_ASSERT(!(STATE & SameSiteSet), property_sameSite_already_set);
            m_result->setString("sameSite"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<SameSiteSet>();
        }

        Ref<Cookie> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Cookie) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Cookie>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...)
     *     .setSameSite(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Cookie object */
class SetCookieParam : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SetCookieParam*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SetCookieParam;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value"_s, value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain"_s, value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString("path"_s, value);
            return castState<PathSet>();
        }

        Ref<SetCookieParam> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SetCookieParam) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SetCookieParam>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SetCookieParam> result = SetCookieParam::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setExpires(double value)
    {
        JSON::ObjectBase::setDouble("expires"_s, value);
    }

    void setHttpOnly(bool value)
    {
        JSON::ObjectBase::setBoolean("httpOnly"_s, value);
    }

    void setSecure(bool value)
    {
        JSON::ObjectBase::setBoolean("secure"_s, value);
    }

    void setSession(bool value)
    {
        JSON::ObjectBase::setBoolean("session"_s, value);
    }

    void setSameSite(Inspector::Protocol::Playwright::CookieSameSitePolicy value)
    {
        JSON::ObjectBase::setString("sameSite"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }
};

/* Geolocation */
class Geolocation : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        LatitudeSet = 1 << 1,
        LongitudeSet = 1 << 2,
        AccuracySet = 1 << 3,
        AllFieldsSet = (TimestampSet | LatitudeSet | LongitudeSet | AccuracySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Geolocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Geolocation;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble("timestamp"_s, value);
            return castState<TimestampSet>();
        }

        Builder<STATE | LatitudeSet>& setLatitude(double value)
        {
            COMPILE_ASSERT(!(STATE & LatitudeSet), property_latitude_already_set);
            m_result->setDouble("latitude"_s, value);
            return castState<LatitudeSet>();
        }

        Builder<STATE | LongitudeSet>& setLongitude(double value)
        {
            COMPILE_ASSERT(!(STATE & LongitudeSet), property_longitude_already_set);
            m_result->setDouble("longitude"_s, value);
            return castState<LongitudeSet>();
        }

        Builder<STATE | AccuracySet>& setAccuracy(double value)
        {
            COMPILE_ASSERT(!(STATE & AccuracySet), property_accuracy_already_set);
            m_result->setDouble("accuracy"_s, value);
            return castState<AccuracySet>();
        }

        Ref<Geolocation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Geolocation) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Geolocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Geolocation> result = Geolocation::create()
     *     .setTimestamp(...)
     *     .setLatitude(...)
     *     .setLongitude(...)
     *     .setAccuracy(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Playwright

namespace Recording {

/* The type of the recording. */
enum class Type {
    Canvas2D = 42,
    CanvasBitmapRenderer = 183,
    CanvasWebGL = 184,
    CanvasWebGL2 = 185,
}; // enum class Type

enum class Initiator {
    Frontend = 186,
    Console = 187,
    AutoCapture = 188,
}; // enum class Initiator

/* Information about the initial state of the recorded object. */
class InitialState : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InitialState*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class InitialState;
    public:

        Ref<InitialState> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InitialState) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InitialState>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InitialState> result = InitialState::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAttributes(RefPtr<JSON::Object> value)
    {
        JSON::ObjectBase::setObject("attributes"_s, WTFMove(value));
    }

    void setStates(RefPtr<JSON::ArrayOf<JSON::Object>> value)
    {
        JSON::ObjectBase::setArray("states"_s, WTFMove(value));
    }

    void setParameters(RefPtr<JSON::ArrayOf<JSON::Value>> value)
    {
        JSON::ObjectBase::setArray("parameters"_s, WTFMove(value));
    }

    void setContent(const String& value)
    {
        JSON::ObjectBase::setString("content"_s, value);
    }
};

/* Container object for a single frame of the recording. */
class Frame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ActionsSet = 1 << 0,
        AllFieldsSet = (ActionsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Frame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Frame;
    public:

        Builder<STATE | ActionsSet>& setActions(RefPtr<JSON::ArrayOf<JSON::Value>> value)
        {
            COMPILE_ASSERT(!(STATE & ActionsSet), property_actions_already_set);
            m_result->setArray("actions"_s, value);
            return castState<ActionsSet>();
        }

        Ref<Frame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Frame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Frame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Frame> result = Frame::create()
     *     .setActions(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setDuration(double value)
    {
        JSON::ObjectBase::setDouble("duration"_s, value);
    }

    void setIncomplete(bool value)
    {
        JSON::ObjectBase::setBoolean("incomplete"_s, value);
    }
};

class Recording : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        VersionSet = 1 << 0,
        TypeSet = 1 << 1,
        InitialStateSet = 1 << 2,
        DataSet = 1 << 3,
        AllFieldsSet = (VersionSet | TypeSet | InitialStateSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Recording*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Recording;
    public:

        Builder<STATE | VersionSet>& setVersion(int value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setInteger("version"_s, value);
            return castState<VersionSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Recording::Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | InitialStateSet>& setInitialState(RefPtr<Inspector::Protocol::Recording::InitialState> value)
        {
            COMPILE_ASSERT(!(STATE & InitialStateSet), property_initialState_already_set);
            m_result->setObject("initialState"_s, value);
            return castState<InitialStateSet>();
        }

        Builder<STATE | DataSet>& setData(RefPtr<JSON::ArrayOf<JSON::Value>> value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setArray("data"_s, value);
            return castState<DataSet>();
        }

        Ref<Recording> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Recording) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Recording>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Recording> result = Recording::create()
     *     .setVersion(...)
     *     .setType(...)
     *     .setInitialState(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& value)
    {
        JSON::ObjectBase::setString("name"_s, value);
    }
};

} // Recording

namespace Runtime {

/* Mirror object referencing original JavaScript object. */
class RemoteObject : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    enum class Type {
        Object = 189,
        Function = 190,
        Undefined = 191,
        String = 129,
        Number = 128,
        Boolean = 192,
        Symbol = 193,
        Bigint = 194,
    }; // enum class Type
    // Named after property name 'subtype' while generating RemoteObject.
    enum class Subtype {
        Array = 130,
        Null = 131,
        Node = 195,
        Regexp = 196,
        Date = 103,
        Error = 73,
        Map = 197,
        Set = 198,
        Weakmap = 199,
        Weakset = 200,
        Iterator = 201,
        Class = 202,
        Proxy = 203,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RemoteObject*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<RemoteObject> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RemoteObject>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RemoteObject> result = RemoteObject::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype value)
    {
        JSON::ObjectBase::setString("subtype"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setClassName(const String& value)
    {
        JSON::ObjectBase::setString("className"_s, value);
    }

    void setValue(RefPtr<JSON::Value> value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(value));
    }

    void setDescription(const String& value)
    {
        JSON::ObjectBase::setString("description"_s, value);
    }

    void setObjectId(const String& value)
    {
        JSON::ObjectBase::setString("objectId"_s, value);
    }

    void setSize(int value)
    {
        JSON::ObjectBase::setInteger("size"_s, value);
    }

    void setClassPrototype(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("classPrototype"_s, WTFMove(value));
    }

    void setPreview(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        JSON::ObjectBase::setObject("preview"_s, WTFMove(value));
    }
};

/* Object containing abbreviated remote object value. */
class ObjectPreview : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating ObjectPreview.
    enum class Type {
        Object = 189,
        Function = 190,
        Undefined = 191,
        String = 129,
        Number = 128,
        Boolean = 192,
        Symbol = 193,
        Bigint = 194,
    }; // enum class Type
    // Named after property name 'subtype' while generating ObjectPreview.
    enum class Subtype {
        Array = 130,
        Null = 131,
        Node = 195,
        Regexp = 196,
        Date = 103,
        Error = 73,
        Map = 197,
        Set = 198,
        Weakmap = 199,
        Weakset = 200,
        Iterator = 201,
        Class = 202,
        Proxy = 203,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        LosslessSet = 1 << 1,
        AllFieldsSet = (TypeSet | LosslessSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | LosslessSet>& setLossless(bool value)
        {
            COMPILE_ASSERT(!(STATE & LosslessSet), property_lossless_already_set);
            m_result->setBoolean("lossless"_s, value);
            return castState<LosslessSet>();
        }

        Ref<ObjectPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectPreview) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectPreview> result = ObjectPreview::create()
     *     .setType(...)
     *     .setLossless(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype value)
    {
        JSON::ObjectBase::setString("subtype"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setDescription(const String& value)
    {
        JSON::ObjectBase::setString("description"_s, value);
    }

    void setOverflow(bool value)
    {
        JSON::ObjectBase::setBoolean("overflow"_s, value);
    }

    void setProperties(RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::PropertyPreview>> value)
    {
        JSON::ObjectBase::setArray("properties"_s, WTFMove(value));
    }

    void setEntries(RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::EntryPreview>> value)
    {
        JSON::ObjectBase::setArray("entries"_s, WTFMove(value));
    }

    void setSize(int value)
    {
        JSON::ObjectBase::setInteger("size"_s, value);
    }
};

class PropertyPreview : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    enum class Type {
        Object = 189,
        Function = 190,
        Undefined = 191,
        String = 129,
        Number = 128,
        Boolean = 192,
        Symbol = 193,
        Bigint = 194,
        Accessor = 204,
    }; // enum class Type
    // Named after property name 'subtype' while generating PropertyPreview.
    enum class Subtype {
        Array = 130,
        Null = 131,
        Node = 195,
        Regexp = 196,
        Date = 103,
        Error = 73,
        Map = 197,
        Set = 198,
        Weakmap = 199,
        Weakset = 200,
        Iterator = 201,
        Class = 202,
        Proxy = 203,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<PropertyPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyPreview) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PropertyPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype value)
    {
        JSON::ObjectBase::setString("subtype"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
    }

    void setValue(const String& value)
    {
        JSON::ObjectBase::setString("value"_s, value);
    }

    void setValuePreview(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        JSON::ObjectBase::setObject("valuePreview"_s, WTFMove(value));
    }

    void setInternal(bool value)
    {
        JSON::ObjectBase::setBoolean("internal"_s, value);
    }
};

class EntryPreview : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EntryPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class EntryPreview;
    public:

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<EntryPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EntryPreview) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<EntryPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EntryPreview> result = EntryPreview::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setKey(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        JSON::ObjectBase::setObject("key"_s, WTFMove(value));
    }
};

class CollectionEntry : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CollectionEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CollectionEntry;
    public:

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject("value"_s, value);
            return castState<ValueSet>();
        }

        Ref<CollectionEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CollectionEntry) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CollectionEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CollectionEntry> result = CollectionEntry::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("key"_s, WTFMove(value));
    }
};

/* Object property descriptor. */
class PropertyDescriptor : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyDescriptor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Ref<PropertyDescriptor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PropertyDescriptor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("value"_s, WTFMove(value));
    }

    void setWritable(bool value)
    {
        JSON::ObjectBase::setBoolean("writable"_s, value);
    }

    void setGet(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("get"_s, WTFMove(value));
    }

    void setSet(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("set"_s, WTFMove(value));
    }

    void setWasThrown(bool value)
    {
        JSON::ObjectBase::setBoolean("wasThrown"_s, value);
    }

    void setConfigurable(bool value)
    {
        JSON::ObjectBase::setBoolean("configurable"_s, value);
    }

    void setEnumerable(bool value)
    {
        JSON::ObjectBase::setBoolean("enumerable"_s, value);
    }

    void setIsOwn(bool value)
    {
        JSON::ObjectBase::setBoolean("isOwn"_s, value);
    }

    void setSymbol(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("symbol"_s, WTFMove(value));
    }

    void setNativeGetter(bool value)
    {
        JSON::ObjectBase::setBoolean("nativeGetter"_s, value);
    }
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InternalPropertyDescriptor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Ref<InternalPropertyDescriptor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InternalPropertyDescriptor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        JSON::ObjectBase::setObject("value"_s, WTFMove(value));
    }
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallArgument*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallArgument;
    public:

        Ref<CallArgument> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallArgument>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallArgument> result = CallArgument::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(RefPtr<JSON::Value> value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(value));
    }

    void setObjectId(const String& value)
    {
        JSON::ObjectBase::setString("objectId"_s, value);
    }
};

/* Type of the execution context. */
enum class ExecutionContextType {
    Normal = 5,
    User = 16,
    Internal = 205,
}; // enum class ExecutionContextType

/* Description of an isolated world. */
class ExecutionContextDescription : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        TypeSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | TypeSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExecutionContextDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setInteger("id"_s, value);
            return castState<IdSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Runtime::ExecutionContextType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId"_s, value);
            return castState<FrameIdSet>();
        }

        Ref<ExecutionContextDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExecutionContextDescription) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ExecutionContextDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setType(...)
     *     .setName(...)
     *     .setFrameId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Syntax error type: "none" for no error, "irrecoverable" for unrecoverable errors, "unterminated-literal" for when there is an unterminated literal, "recoverable" for when the expression is unfinished but valid so far. */
enum class SyntaxErrorType {
    None = 9,
    Irrecoverable = 206,
    UnterminatedLiteral = 207,
    Recoverable = 208,
}; // enum class SyntaxErrorType

/* Range of an error in source code. */
class ErrorRange : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ErrorRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ErrorRange;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setInteger("startOffset"_s, value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setInteger("endOffset"_s, value);
            return castState<EndOffsetSet>();
        }

        Ref<ErrorRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ErrorRange) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ErrorRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ErrorRange> result = ErrorRange::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class StructureDescription : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StructureDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StructureDescription;
    public:

        Ref<StructureDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StructureDescription) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StructureDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StructureDescription> result = StructureDescription::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFields(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("fields"_s, WTFMove(value));
    }

    void setOptionalFields(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("optionalFields"_s, WTFMove(value));
    }

    void setConstructorName(const String& value)
    {
        JSON::ObjectBase::setString("constructorName"_s, value);
    }

    void setPrototypeStructure(RefPtr<Inspector::Protocol::Runtime::StructureDescription> value)
    {
        JSON::ObjectBase::setObject("prototypeStructure"_s, WTFMove(value));
    }

    void setIsImprecise(bool value)
    {
        JSON::ObjectBase::setBoolean("isImprecise"_s, value);
    }
};

class TypeSet : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsFunctionSet = 1 << 0,
        IsUndefinedSet = 1 << 1,
        IsNullSet = 1 << 2,
        IsBooleanSet = 1 << 3,
        IsIntegerSet = 1 << 4,
        IsNumberSet = 1 << 5,
        IsStringSet = 1 << 6,
        IsObjectSet = 1 << 7,
        IsSymbolSet = 1 << 8,
        IsBigIntSet = 1 << 9,
        AllFieldsSet = (IsFunctionSet | IsUndefinedSet | IsNullSet | IsBooleanSet | IsIntegerSet | IsNumberSet | IsStringSet | IsObjectSet | IsSymbolSet | IsBigIntSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeSet*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeSet;
    public:

        Builder<STATE | IsFunctionSet>& setIsFunction(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsFunctionSet), property_isFunction_already_set);
            m_result->setBoolean("isFunction"_s, value);
            return castState<IsFunctionSet>();
        }

        Builder<STATE | IsUndefinedSet>& setIsUndefined(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsUndefinedSet), property_isUndefined_already_set);
            m_result->setBoolean("isUndefined"_s, value);
            return castState<IsUndefinedSet>();
        }

        Builder<STATE | IsNullSet>& setIsNull(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsNullSet), property_isNull_already_set);
            m_result->setBoolean("isNull"_s, value);
            return castState<IsNullSet>();
        }

        Builder<STATE | IsBooleanSet>& setIsBoolean(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsBooleanSet), property_isBoolean_already_set);
            m_result->setBoolean("isBoolean"_s, value);
            return castState<IsBooleanSet>();
        }

        Builder<STATE | IsIntegerSet>& setIsInteger(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsIntegerSet), property_isInteger_already_set);
            m_result->setBoolean("isInteger"_s, value);
            return castState<IsIntegerSet>();
        }

        Builder<STATE | IsNumberSet>& setIsNumber(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsNumberSet), property_isNumber_already_set);
            m_result->setBoolean("isNumber"_s, value);
            return castState<IsNumberSet>();
        }

        Builder<STATE | IsStringSet>& setIsString(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsStringSet), property_isString_already_set);
            m_result->setBoolean("isString"_s, value);
            return castState<IsStringSet>();
        }

        Builder<STATE | IsObjectSet>& setIsObject(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsObjectSet), property_isObject_already_set);
            m_result->setBoolean("isObject"_s, value);
            return castState<IsObjectSet>();
        }

        Builder<STATE | IsSymbolSet>& setIsSymbol(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsSymbolSet), property_isSymbol_already_set);
            m_result->setBoolean("isSymbol"_s, value);
            return castState<IsSymbolSet>();
        }

        Builder<STATE | IsBigIntSet>& setIsBigInt(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsBigIntSet), property_isBigInt_already_set);
            m_result->setBoolean("isBigInt"_s, value);
            return castState<IsBigIntSet>();
        }

        Ref<TypeSet> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeSet) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeSet>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeSet> result = TypeSet::create()
     *     .setIsFunction(...)
     *     .setIsUndefined(...)
     *     .setIsNull(...)
     *     .setIsBoolean(...)
     *     .setIsInteger(...)
     *     .setIsNumber(...)
     *     .setIsString(...)
     *     .setIsObject(...)
     *     .setIsSymbol(...)
     *     .setIsBigInt(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Container for type information that has been gathered. */
class TypeDescription : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsValidSet = 1 << 0,
        AllFieldsSet = (IsValidSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeDescription;
    public:

        Builder<STATE | IsValidSet>& setIsValid(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsValidSet), property_isValid_already_set);
            m_result->setBoolean("isValid"_s, value);
            return castState<IsValidSet>();
        }

        Ref<TypeDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeDescription) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeDescription> result = TypeDescription::create()
     *     .setIsValid(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setLeastCommonAncestor(const String& value)
    {
        JSON::ObjectBase::setString("leastCommonAncestor"_s, value);
    }

    void setTypeSet(RefPtr<Inspector::Protocol::Runtime::TypeSet> value)
    {
        JSON::ObjectBase::setObject("typeSet"_s, WTFMove(value));
    }

    void setStructures(RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::StructureDescription>> value)
    {
        JSON::ObjectBase::setArray("structures"_s, WTFMove(value));
    }

    void setIsTruncated(bool value)
    {
        JSON::ObjectBase::setBoolean("isTruncated"_s, value);
    }
};

/* Describes the location of an expression we want type information for. */
class TypeLocation : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeInformationDescriptorSet = 1 << 0,
        SourceIDSet = 1 << 1,
        DivotSet = 1 << 2,
        AllFieldsSet = (TypeInformationDescriptorSet | SourceIDSet | DivotSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeLocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeLocation;
    public:

        Builder<STATE | TypeInformationDescriptorSet>& setTypeInformationDescriptor(int value)
        {
            COMPILE_ASSERT(!(STATE & TypeInformationDescriptorSet), property_typeInformationDescriptor_already_set);
            m_result->setInteger("typeInformationDescriptor"_s, value);
            return castState<TypeInformationDescriptorSet>();
        }

        Builder<STATE | SourceIDSet>& setSourceID(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceIDSet), property_sourceID_already_set);
            m_result->setString("sourceID"_s, value);
            return castState<SourceIDSet>();
        }

        Builder<STATE | DivotSet>& setDivot(int value)
        {
            COMPILE_ASSERT(!(STATE & DivotSet), property_divot_already_set);
            m_result->setInteger("divot"_s, value);
            return castState<DivotSet>();
        }

        Ref<TypeLocation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeLocation) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeLocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeLocation> result = TypeLocation::create()
     *     .setTypeInformationDescriptor(...)
     *     .setSourceID(...)
     *     .setDivot(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* From Wikipedia: a basic block is a portion of the code within a program with only one entry point and only one exit point. This type gives the location of a basic block and if that basic block has executed. */
class BasicBlock : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        HasExecutedSet = 1 << 2,
        ExecutionCountSet = 1 << 3,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet | HasExecutedSet | ExecutionCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BasicBlock*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BasicBlock;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setInteger("startOffset"_s, value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setInteger("endOffset"_s, value);
            return castState<EndOffsetSet>();
        }

        Builder<STATE | HasExecutedSet>& setHasExecuted(bool value)
        {
            COMPILE_ASSERT(!(STATE & HasExecutedSet), property_hasExecuted_already_set);
            m_result->setBoolean("hasExecuted"_s, value);
            return castState<HasExecutedSet>();
        }

        Builder<STATE | ExecutionCountSet>& setExecutionCount(int value)
        {
            COMPILE_ASSERT(!(STATE & ExecutionCountSet), property_executionCount_already_set);
            m_result->setInteger("executionCount"_s, value);
            return castState<ExecutionCountSet>();
        }

        Ref<BasicBlock> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BasicBlock) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BasicBlock>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BasicBlock> result = BasicBlock::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .setHasExecuted(...)
     *     .setExecutionCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Runtime

namespace ScriptProfiler {

enum class EventType {
    API = 209,
    Microtask = 210,
    Other = 154,
}; // enum class EventType

class Event : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartTimeSet = 1 << 0,
        EndTimeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (StartTimeSet | EndTimeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Event;
    public:

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble("startTime"_s, value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setDouble("endTime"_s, value);
            return castState<EndTimeSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::ScriptProfiler::EventType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<Event> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Event) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class ExpressionLocation : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineSet = 1 << 0,
        ColumnSet = 1 << 1,
        AllFieldsSet = (LineSet | ColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExpressionLocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ExpressionLocation;
    public:

        Builder<STATE | LineSet>& setLine(int value)
        {
            COMPILE_ASSERT(!(STATE & LineSet), property_line_already_set);
            m_result->setInteger("line"_s, value);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnSet), property_column_already_set);
            m_result->setInteger("column"_s, value);
            return castState<ColumnSet>();
        }

        Ref<ExpressionLocation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExpressionLocation) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ExpressionLocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExpressionLocation> result = ExpressionLocation::create()
     *     .setLine(...)
     *     .setColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class StackFrame : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceIDSet = 1 << 0,
        NameSet = 1 << 1,
        LineSet = 1 << 2,
        ColumnSet = 1 << 3,
        UrlSet = 1 << 4,
        AllFieldsSet = (SourceIDSet | NameSet | LineSet | ColumnSet | UrlSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StackFrame;
    public:

        Builder<STATE | SourceIDSet>& setSourceID(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceIDSet), property_sourceID_already_set);
            m_result->setString("sourceID"_s, value);
            return castState<SourceIDSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name"_s, value);
            return castState<NameSet>();
        }

        Builder<STATE | LineSet>& setLine(int value)
        {
            COMPILE_ASSERT(!(STATE & LineSet), property_line_already_set);
            m_result->setInteger("line"_s, value);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnSet), property_column_already_set);
            m_result->setInteger("column"_s, value);
            return castState<ColumnSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Ref<StackFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackFrame) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackFrame> result = StackFrame::create()
     *     .setSourceID(...)
     *     .setName(...)
     *     .setLine(...)
     *     .setColumn(...)
     *     .setUrl(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setExpressionLocation(RefPtr<Inspector::Protocol::ScriptProfiler::ExpressionLocation> value)
    {
        JSON::ObjectBase::setObject("expressionLocation"_s, WTFMove(value));
    }
};

class StackTrace : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        StackFramesSet = 1 << 1,
        AllFieldsSet = (TimestampSet | StackFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackTrace*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StackTrace;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble("timestamp"_s, value);
            return castState<TimestampSet>();
        }

        Builder<STATE | StackFramesSet>& setStackFrames(RefPtr<JSON::ArrayOf<Inspector::Protocol::ScriptProfiler::StackFrame>> value)
        {
            COMPILE_ASSERT(!(STATE & StackFramesSet), property_stackFrames_already_set);
            m_result->setArray("stackFrames"_s, value);
            return castState<StackFramesSet>();
        }

        Ref<StackTrace> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackTrace) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackTrace>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackTrace> result = StackTrace::create()
     *     .setTimestamp(...)
     *     .setStackFrames(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class Samples : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StackTracesSet = 1 << 0,
        AllFieldsSet = (StackTracesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Samples*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Samples;
    public:

        Builder<STATE | StackTracesSet>& setStackTraces(RefPtr<JSON::ArrayOf<Inspector::Protocol::ScriptProfiler::StackTrace>> value)
        {
            COMPILE_ASSERT(!(STATE & StackTracesSet), property_stackTraces_already_set);
            m_result->setArray("stackTraces"_s, value);
            return castState<StackTracesSet>();
        }

        Ref<Samples> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Samples) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Samples>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Samples> result = Samples::create()
     *     .setStackTraces(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ScriptProfiler

namespace Security {

/* Information about a SSL connection to display in the frontend. */
class Connection : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Connection*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Connection;
    public:

        Ref<Connection> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Connection) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Connection>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Connection> result = Connection::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setProtocol(const String& value)
    {
        JSON::ObjectBase::setString("protocol"_s, value);
    }

    void setCipher(const String& value)
    {
        JSON::ObjectBase::setString("cipher"_s, value);
    }
};

/* Information about a SSL certificate to display in the frontend. */
class Certificate : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Certificate*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Certificate;
    public:

        Ref<Certificate> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Certificate) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Certificate>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Certificate> result = Certificate::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubject(const String& value)
    {
        JSON::ObjectBase::setString("subject"_s, value);
    }

    void setValidFrom(double value)
    {
        JSON::ObjectBase::setDouble("validFrom"_s, value);
    }

    void setValidUntil(double value)
    {
        JSON::ObjectBase::setDouble("validUntil"_s, value);
    }

    void setDnsNames(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("dnsNames"_s, WTFMove(value));
    }

    void setIpAddresses(RefPtr<JSON::ArrayOf<String>> value)
    {
        JSON::ObjectBase::setArray("ipAddresses"_s, WTFMove(value));
    }
};

/* Security information for a given Network.Response. */
class Security : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Security*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Security;
    public:

        Ref<Security> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Security) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Security>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Security> result = Security::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setConnection(RefPtr<Inspector::Protocol::Security::Connection> value)
    {
        JSON::ObjectBase::setObject("connection"_s, WTFMove(value));
    }

    void setCertificate(RefPtr<Inspector::Protocol::Security::Certificate> value)
    {
        JSON::ObjectBase::setObject("certificate"_s, WTFMove(value));
    }
};

} // Security

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
namespace ServiceWorker {

/* ServiceWorker metadata and initial state. */
class Configuration : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TargetIdSet = 1 << 0,
        SecurityOriginSet = 1 << 1,
        UrlSet = 1 << 2,
        ContentSet = 1 << 3,
        AllFieldsSet = (TargetIdSet | SecurityOriginSet | UrlSet | ContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Configuration*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Configuration;
    public:

        Builder<STATE | TargetIdSet>& setTargetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TargetIdSet), property_targetId_already_set);
            m_result->setString("targetId"_s, value);
            return castState<TargetIdSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin"_s, value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url"_s, value);
            return castState<UrlSet>();
        }

        Builder<STATE | ContentSet>& setContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ContentSet), property_content_already_set);
            m_result->setString("content"_s, value);
            return castState<ContentSet>();
        }

        Ref<Configuration> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Configuration) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Configuration>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Configuration> result = Configuration::create()
     *     .setTargetId(...)
     *     .setSecurityOrigin(...)
     *     .setUrl(...)
     *     .setContent(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ServiceWorker
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

namespace Target {

/* Description of a target. */
class TargetInfo : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating TargetInfo.
    enum class Type {
        Page = 100,
        ServiceWorker = 138,
        Worker = 211,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TargetIdSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (TargetIdSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TargetInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TargetInfo;
    public:

        Builder<STATE | TargetIdSet>& setTargetId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TargetIdSet), property_targetId_already_set);
            m_result->setString("targetId"_s, value);
            return castState<TargetIdSet>();
        }

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Ref<TargetInfo> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TargetInfo) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TargetInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TargetInfo> result = TargetInfo::create()
     *     .setTargetId(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setIsProvisional(bool value)
    {
        JSON::ObjectBase::setBoolean("isProvisional"_s, value);
    }

    void setIsPaused(bool value)
    {
        JSON::ObjectBase::setBoolean("isPaused"_s, value);
    }
};

} // Target

namespace Timeline {

/* Timeline record type. */
enum class EventType {
    EventDispatch = 212,
    ScheduleStyleRecalculation = 213,
    RecalculateStyles = 214,
    InvalidateLayout = 215,
    Layout = 216,
    Paint = 217,
    Composite = 218,
    RenderingFrame = 219,
    TimerInstall = 220,
    TimerRemove = 221,
    TimerFire = 222,
    EvaluateScript = 223,
    TimeStamp = 224,
    Time = 225,
    TimeEnd = 226,
    FunctionCall = 227,
    ProbeSample = 228,
    ConsoleProfile = 229,
    RequestAnimationFrame = 230,
    CancelAnimationFrame = 231,
    FireAnimationFrame = 232,
    ObserverCallback = 233,
}; // enum class EventType

/* Instrument types. */
enum class Instrument {
    ScriptProfiler = 234,
    Timeline = 235,
    CPU = 236,
    Memory = 237,
    Heap = 238,
    Animation = 239,
}; // enum class Instrument

/* Timeline record contains information about the recorded activity. */
class TimelineEvent : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        DataSet = 1 << 1,
        AllFieldsSet = (TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TimelineEvent*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TimelineEvent;
    public:

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Timeline::EventType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(RefPtr<JSON::Object> value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setObject("data"_s, value);
            return castState<DataSet>();
        }

        Ref<TimelineEvent> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TimelineEvent) == sizeof(JSON::Object), cannot_cast);

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TimelineEvent>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TimelineEvent> result = TimelineEvent::create()
     *     .setType(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setChildren(RefPtr<JSON::ArrayOf<Inspector::Protocol::Timeline::TimelineEvent>> value)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* Type;
    JS_EXPORT_PRIVATE static const char* Data;
    JS_EXPORT_PRIVATE static const char* Children;
};

} // Timeline

template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Location> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::FunctionDetails> {
static RefPtr<Inspector::Protocol::Debugger::FunctionDetails> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::CallFrame> {
static RefPtr<Inspector::Protocol::Debugger::CallFrame> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Scope::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Scope> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject> {
static RefPtr<Inspector::Protocol::Runtime::RemoteObject> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview> {
static RefPtr<Inspector::Protocol::Runtime::ObjectPreview> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::EntryPreview> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::CollectionEntry> {
static RefPtr<Inspector::Protocol::Runtime::CollectionEntry> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor> {
static RefPtr<Inspector::Protocol::Runtime::PropertyDescriptor> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor> {
static RefPtr<Inspector::Protocol::Runtime::InternalPropertyDescriptor> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Timeline::EventType> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Timeline::TimelineEvent> {
static RefPtr<Inspector::Protocol::Timeline::TimelineEvent> runtimeCast(RefPtr<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};

namespace InspectorHelpers {

template<typename ProtocolEnumType>
Optional<ProtocolEnumType> parseEnumValueFromString(const String&);

// Enums in the 'Animation' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Animation::AnimationState> parseEnumValueFromString<Inspector::Protocol::Animation::AnimationState>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Animation::PlaybackDirection> parseEnumValueFromString<Inspector::Protocol::Animation::PlaybackDirection>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Animation::FillMode> parseEnumValueFromString<Inspector::Protocol::Animation::FillMode>(const String&);

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'CPUProfiler' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::CPUProfiler::ThreadInfo::Type> parseEnumValueFromString<Inspector::Protocol::CPUProfiler::ThreadInfo::Type>(const String&);
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'CSS' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::CSS::StyleSheetOrigin> parseEnumValueFromString<Inspector::Protocol::CSS::StyleSheetOrigin>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::CSS::PseudoId> parseEnumValueFromString<Inspector::Protocol::CSS::PseudoId>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::CSS::CSSPropertyStatus> parseEnumValueFromString<Inspector::Protocol::CSS::CSSPropertyStatus>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::CSS::Grouping::Type> parseEnumValueFromString<Inspector::Protocol::CSS::Grouping::Type>(const String&);

// Enums in the 'Canvas' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Canvas::ContextType> parseEnumValueFromString<Inspector::Protocol::Canvas::ContextType>(const String&);
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Canvas::ProgramType> parseEnumValueFromString<Inspector::Protocol::Canvas::ProgramType>(const String&);
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Canvas::ShaderType> parseEnumValueFromString<Inspector::Protocol::Canvas::ShaderType>(const String&);
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)

// Enums in the 'Console' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Console::ChannelSource> parseEnumValueFromString<Inspector::Protocol::Console::ChannelSource>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Console::ChannelLevel> parseEnumValueFromString<Inspector::Protocol::Console::ChannelLevel>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Console::ConsoleMessage::Level> parseEnumValueFromString<Inspector::Protocol::Console::ConsoleMessage::Level>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Console::ConsoleMessage::Type> parseEnumValueFromString<Inspector::Protocol::Console::ConsoleMessage::Type>(const String&);

// Enums in the 'DOM' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::PseudoType> parseEnumValueFromString<Inspector::Protocol::DOM::PseudoType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::ShadowRootType> parseEnumValueFromString<Inspector::Protocol::DOM::ShadowRootType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::CustomElementState> parseEnumValueFromString<Inspector::Protocol::DOM::CustomElementState>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::LiveRegionRelevant> parseEnumValueFromString<Inspector::Protocol::DOM::LiveRegionRelevant>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::AccessibilityProperties::Checked> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Checked>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::AccessibilityProperties::Current> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Current>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::AccessibilityProperties::Invalid> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Invalid>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus>(const String&);

// Enums in the 'DOMDebugger' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOMDebugger::DOMBreakpointType> parseEnumValueFromString<Inspector::Protocol::DOMDebugger::DOMBreakpointType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::DOMDebugger::EventBreakpointType> parseEnumValueFromString<Inspector::Protocol::DOMDebugger::EventBreakpointType>(const String&);

// Enums in the 'Debugger' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Debugger::BreakpointAction::Type> parseEnumValueFromString<Inspector::Protocol::Debugger::BreakpointAction::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Debugger::Scope::Type> parseEnumValueFromString<Inspector::Protocol::Debugger::Scope::Type>(const String&);

// Enums in the 'Heap' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Heap::GarbageCollection::Type> parseEnumValueFromString<Inspector::Protocol::Heap::GarbageCollection::Type>(const String&);

#if defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE
// Enums in the 'IndexedDB' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::IndexedDB::Key::Type> parseEnumValueFromString<Inspector::Protocol::IndexedDB::Key::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::IndexedDB::KeyPath::Type> parseEnumValueFromString<Inspector::Protocol::IndexedDB::KeyPath::Type>(const String&);
#endif // defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'Memory' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Memory::CategoryData::Type> parseEnumValueFromString<Inspector::Protocol::Memory::CategoryData::Type>(const String&);
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'Network' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Network::NetworkStage> parseEnumValueFromString<Inspector::Protocol::Network::NetworkStage>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Network::ResourceErrorType> parseEnumValueFromString<Inspector::Protocol::Network::ResourceErrorType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Network::Response::Source> parseEnumValueFromString<Inspector::Protocol::Network::Response::Source>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Network::Metrics::Priority> parseEnumValueFromString<Inspector::Protocol::Network::Metrics::Priority>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Network::Initiator::Type> parseEnumValueFromString<Inspector::Protocol::Network::Initiator::Type>(const String&);

// Enums in the 'Page' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::Setting> parseEnumValueFromString<Inspector::Protocol::Page::Setting>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::ResourceType> parseEnumValueFromString<Inspector::Protocol::Page::ResourceType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::CoordinateSystem> parseEnumValueFromString<Inspector::Protocol::Page::CoordinateSystem>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::CookieSameSitePolicy> parseEnumValueFromString<Inspector::Protocol::Page::CookieSameSitePolicy>(const String&);
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::Appearance> parseEnumValueFromString<Inspector::Protocol::Page::Appearance>(const String&);
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::AXNode::Checked> parseEnumValueFromString<Inspector::Protocol::Page::AXNode::Checked>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::AXNode::Pressed> parseEnumValueFromString<Inspector::Protocol::Page::AXNode::Pressed>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Page::AXNode::Invalid> parseEnumValueFromString<Inspector::Protocol::Page::AXNode::Invalid>(const String&);

// Enums in the 'Playwright' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Playwright::CookieSameSitePolicy> parseEnumValueFromString<Inspector::Protocol::Playwright::CookieSameSitePolicy>(const String&);

// Enums in the 'Recording' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Recording::Type> parseEnumValueFromString<Inspector::Protocol::Recording::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Recording::Initiator> parseEnumValueFromString<Inspector::Protocol::Recording::Initiator>(const String&);

// Enums in the 'Runtime' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::ExecutionContextType> parseEnumValueFromString<Inspector::Protocol::Runtime::ExecutionContextType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::SyntaxErrorType> parseEnumValueFromString<Inspector::Protocol::Runtime::SyntaxErrorType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::RemoteObject::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::RemoteObject::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::RemoteObject::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::RemoteObject::Subtype>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::ObjectPreview::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::ObjectPreview::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::ObjectPreview::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::ObjectPreview::Subtype>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::PropertyPreview::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::PropertyPreview::Type>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Runtime::PropertyPreview::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::PropertyPreview::Subtype>(const String&);

// Enums in the 'ScriptProfiler' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::ScriptProfiler::EventType> parseEnumValueFromString<Inspector::Protocol::ScriptProfiler::EventType>(const String&);

// Enums in the 'Target' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Target::TargetInfo::Type> parseEnumValueFromString<Inspector::Protocol::Target::TargetInfo::Type>(const String&);

// Enums in the 'Timeline' Domain
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Timeline::EventType> parseEnumValueFromString<Inspector::Protocol::Timeline::EventType>(const String&);
template<>
JS_EXPORT_PRIVATE Optional<Inspector::Protocol::Timeline::Instrument> parseEnumValueFromString<Inspector::Protocol::Timeline::Instrument>(const String&);

} // namespace InspectorHelpers

} // namespace Protocol

} // namespace Inspector

namespace WTF {

template<typename T> struct DefaultHash;

// Hash declarations in the 'Animation' Domain
template<>
struct DefaultHash<Inspector::Protocol::Animation::AnimationState> : IntHash<Inspector::Protocol::Animation::AnimationState> { };
template<>
struct DefaultHash<Inspector::Protocol::Animation::PlaybackDirection> : IntHash<Inspector::Protocol::Animation::PlaybackDirection> { };
template<>
struct DefaultHash<Inspector::Protocol::Animation::FillMode> : IntHash<Inspector::Protocol::Animation::FillMode> { };

// Hash declarations in the 'CSS' Domain
template<>
struct DefaultHash<Inspector::Protocol::CSS::StyleSheetOrigin> : IntHash<Inspector::Protocol::CSS::StyleSheetOrigin> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::PseudoId> : IntHash<Inspector::Protocol::CSS::PseudoId> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::CSSPropertyStatus> : IntHash<Inspector::Protocol::CSS::CSSPropertyStatus> { };

// Hash declarations in the 'Canvas' Domain
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ContextType> : IntHash<Inspector::Protocol::Canvas::ContextType> { };
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ProgramType> : IntHash<Inspector::Protocol::Canvas::ProgramType> { };
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ShaderType> : IntHash<Inspector::Protocol::Canvas::ShaderType> { };
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)

// Hash declarations in the 'Console' Domain
template<>
struct DefaultHash<Inspector::Protocol::Console::ChannelSource> : IntHash<Inspector::Protocol::Console::ChannelSource> { };
template<>
struct DefaultHash<Inspector::Protocol::Console::ChannelLevel> : IntHash<Inspector::Protocol::Console::ChannelLevel> { };

// Hash declarations in the 'DOM' Domain
template<>
struct DefaultHash<Inspector::Protocol::DOM::PseudoType> : IntHash<Inspector::Protocol::DOM::PseudoType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::ShadowRootType> : IntHash<Inspector::Protocol::DOM::ShadowRootType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::CustomElementState> : IntHash<Inspector::Protocol::DOM::CustomElementState> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::LiveRegionRelevant> : IntHash<Inspector::Protocol::DOM::LiveRegionRelevant> { };

// Hash declarations in the 'DOMDebugger' Domain
template<>
struct DefaultHash<Inspector::Protocol::DOMDebugger::DOMBreakpointType> : IntHash<Inspector::Protocol::DOMDebugger::DOMBreakpointType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOMDebugger::EventBreakpointType> : IntHash<Inspector::Protocol::DOMDebugger::EventBreakpointType> { };

// Hash declarations in the 'Network' Domain
template<>
struct DefaultHash<Inspector::Protocol::Network::NetworkStage> : IntHash<Inspector::Protocol::Network::NetworkStage> { };
template<>
struct DefaultHash<Inspector::Protocol::Network::ResourceErrorType> : IntHash<Inspector::Protocol::Network::ResourceErrorType> { };

// Hash declarations in the 'Page' Domain
template<>
struct DefaultHash<Inspector::Protocol::Page::Setting> : IntHash<Inspector::Protocol::Page::Setting> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::ResourceType> : IntHash<Inspector::Protocol::Page::ResourceType> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::CoordinateSystem> : IntHash<Inspector::Protocol::Page::CoordinateSystem> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::CookieSameSitePolicy> : IntHash<Inspector::Protocol::Page::CookieSameSitePolicy> { };
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
template<>
struct DefaultHash<Inspector::Protocol::Page::Appearance> : IntHash<Inspector::Protocol::Page::Appearance> { };
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)

// Hash declarations in the 'Playwright' Domain
template<>
struct DefaultHash<Inspector::Protocol::Playwright::CookieSameSitePolicy> : IntHash<Inspector::Protocol::Playwright::CookieSameSitePolicy> { };

// Hash declarations in the 'Recording' Domain
template<>
struct DefaultHash<Inspector::Protocol::Recording::Type> : IntHash<Inspector::Protocol::Recording::Type> { };
template<>
struct DefaultHash<Inspector::Protocol::Recording::Initiator> : IntHash<Inspector::Protocol::Recording::Initiator> { };

// Hash declarations in the 'Runtime' Domain
template<>
struct DefaultHash<Inspector::Protocol::Runtime::ExecutionContextType> : IntHash<Inspector::Protocol::Runtime::ExecutionContextType> { };
template<>
struct DefaultHash<Inspector::Protocol::Runtime::SyntaxErrorType> : IntHash<Inspector::Protocol::Runtime::SyntaxErrorType> { };

// Hash declarations in the 'ScriptProfiler' Domain
template<>
struct DefaultHash<Inspector::Protocol::ScriptProfiler::EventType> : IntHash<Inspector::Protocol::ScriptProfiler::EventType> { };

// Hash declarations in the 'Timeline' Domain
template<>
struct DefaultHash<Inspector::Protocol::Timeline::EventType> : IntHash<Inspector::Protocol::Timeline::EventType> { };
template<>
struct DefaultHash<Inspector::Protocol::Timeline::Instrument> : IntHash<Inspector::Protocol::Timeline::Instrument> { };

} // namespace WTF
