/*
 * Copyright (C) 2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <wtf/HashTraits.h>
#include <wtf/OptionSet.h>
#include <wtf/text/ASCIILiteral.h>

namespace WebCore {

enum class AdvancedPrivacyProtections : uint16_t;

enum class ScriptTelemetryCategory : uint8_t {
    Unspecified = 0,
    Audio,
    Canvas,
    Cookies,
    HardwareConcurrency,
    LocalStorage,
    Payments,
    QueryParameters,
    Referrer,
    ScreenOrViewport,
    Speech,
    FormControls,
};

String makeLogMessage(const URL&, ScriptTelemetryCategory);
ASCIILiteral description(ScriptTelemetryCategory);

bool shouldEnableScriptTelemetry(ScriptTelemetryCategory, OptionSet<AdvancedPrivacyProtections>);

} // namespace WebCore

namespace WTF {

template<typename T> struct DefaultHash;
template<> struct DefaultHash<WebCore::ScriptTelemetryCategory> : public IntHash<WebCore::ScriptTelemetryCategory> { };

template<typename T> struct HashTraits;
template<> struct HashTraits<WebCore::ScriptTelemetryCategory> : public StrongEnumHashTraits<WebCore::ScriptTelemetryCategory> { };

} // namespace WTF
