(function(){'use strict';window.viewportSize={width:800,height:600};window.deviceScaleFactor=1;window.emulationScaleFactor=1;window.pageScaleFactor=1;window.pageZoomFactor=1;window.scrollX=0;window.scrollY=0;function reset(resetData){window.viewportSize=resetData.viewportSize;window.deviceScaleFactor=resetData.deviceScaleFactor;window.pageScaleFactor=resetData.pageScaleFactor;window.pageZoomFactor=resetData.pageZoomFactor;window.emulationScaleFactor=resetData.emulationScaleFactor;window.scrollX=Math.round(resetData.scrollX);window.scrollY=Math.round(resetData.scrollY);window.canvas=document.getElementById('canvas');if(window.canvas){window.canvas.width=deviceScaleFactor*viewportSize.width;window.canvas.height=deviceScaleFactor*viewportSize.height;window.canvas.style.width=viewportSize.width+'px';window.canvas.style.height=viewportSize.height+'px';window.context=canvas.getContext('2d');window.context.scale(deviceScaleFactor,deviceScaleFactor);window.canvasWidth=viewportSize.width;window.canvasHeight=viewportSize.height;}}
function setPlatform(platform){window.platform=platform;document.body.classList.add('platform-'+platform);}
function dispatch(message){const functionName=message.shift();window[functionName].apply(null,message);}
Element.prototype.createChild=function(tagName,className){const element=createElement(tagName,className);element.addEventListener('click',function(e){e.stopPropagation();},false);this.appendChild(element);return element;};Element.prototype.createTextChild=function(text){const element=document.createTextNode(text);this.appendChild(element);return element;};Element.prototype.removeChildren=function(){if(this.firstChild){this.textContent='';}};function createElement(tagName,className){const element=document.createElement(tagName);if(className){element.className=className;}
return element;}
String.prototype.trimEnd=function(maxLength){if(this.length<=maxLength){return String(this);}
return this.substr(0,maxLength-1)+'\u2026';};Number.constrain=function(num,min,max){if(num<min){num=min;}else if(num>max){num=max;}
return num;};function buildPath(commands,bounds){let commandsIndex=0;function extractPoints(count){const points=[];for(let i=0;i<count;++i){const x=Math.round(commands[commandsIndex++]*emulationScaleFactor);bounds.maxX=Math.max(bounds.maxX,x);bounds.minX=Math.min(bounds.minX,x);const y=Math.round(commands[commandsIndex++]*emulationScaleFactor);bounds.maxY=Math.max(bounds.maxY,y);bounds.minY=Math.min(bounds.minY,y);bounds.leftmostXForY[y]=Math.min(bounds.leftmostXForY[y]||Number.MAX_VALUE,x);bounds.rightmostXForY[y]=Math.max(bounds.rightmostXForY[y]||Number.MIN_VALUE,x);bounds.topmostYForX[x]=Math.min(bounds.topmostYForX[x]||Number.MAX_VALUE,y);bounds.bottommostYForX[x]=Math.max(bounds.bottommostYForX[x]||Number.MIN_VALUE,y);points.push(x,y);}
return points;}
const commandsLength=commands.length;const path=new Path2D();while(commandsIndex<commandsLength){switch(commands[commandsIndex++]){case'M':path.moveTo.apply(path,extractPoints(1));break;case'L':path.lineTo.apply(path,extractPoints(1));break;case'C':path.bezierCurveTo.apply(path,extractPoints(3));break;case'Q':path.quadraticCurveTo.apply(path,extractPoints(2));break;case'Z':path.closePath();break;}}
return path;}
function emptyBounds(){const bounds={minX:Number.MAX_VALUE,minY:Number.MAX_VALUE,maxX:Number.MIN_VALUE,maxY:Number.MIN_VALUE,leftmostXForY:{},rightmostXForY:{},topmostYForX:{},bottommostYForX:{}};return bounds;}
const MAX_CHILD_ELEMENTS_THRESHOLD=300;const LabelTypes={topCorner:'top-corner',aboveElement:'above-element',belowElement:'below-element',aboveElementWider:'above-element-wider',belowElementWider:'below-element-wider',bottomCornerWider:'bottom-corner-wider',bottomCornerTaller:'bottom-corner-taller',bottomCornerWiderTaller:'bottom-corner-wider-taller',};function doReset(){document.getElementById('source-order-container').removeChildren();}
function _getPositionFromLabelType(positionType,bounds,labelHeight){let contentTop;switch(positionType){case LabelTypes.topCorner:contentTop=bounds.minY;break;case LabelTypes.aboveElement:case LabelTypes.aboveElementWider:contentTop=bounds.minY-labelHeight;break;case LabelTypes.belowElement:case LabelTypes.belowElementWider:contentTop=bounds.maxY;break;case LabelTypes.bottomCornerWider:case LabelTypes.bottomCornerTaller:case LabelTypes.bottomCornerWiderTaller:contentTop=bounds.maxY-labelHeight;break;}
return{contentTop,contentLeft:bounds.minX,};}
function _getLabelType(bounds,labelHeight,labelWidth,otherLabels){let labelType;const widerThanElement=bounds.minX+labelWidth>bounds.maxX;const tallerThanElement=bounds.minY+labelHeight>bounds.maxY;if((!widerThanElement&&!tallerThanElement)||otherLabels.length>=MAX_CHILD_ELEMENTS_THRESHOLD){return LabelTypes.topCorner;}
let overlaps=false;for(let i=0;i<otherLabels.length;i++){const currentLabel=otherLabels[i];const rect=currentLabel.getBoundingClientRect();if(currentLabel.style.top===''&&currentLabel.style.left===''){continue;}
const topOverlaps=bounds.minY-labelHeight<=rect.top+rect.height&&bounds.minY-labelHeight>=rect.top;const bottomOverlaps=bounds.minY<=rect.top+rect.height&&bounds.minY>=rect.top;const leftOverlaps=bounds.minX>=rect.left&&bounds.minX<=rect.left+rect.width;const rightOverlaps=bounds.minX+labelWidth>=rect.left&&bounds.minX+labelWidth<=rect.left+rect.width;const sideOverlaps=leftOverlaps||rightOverlaps;if(sideOverlaps&&(topOverlaps||bottomOverlaps)){overlaps=true;break;}}
if(bounds.minY-labelHeight>0&&!overlaps){labelType=LabelTypes.aboveElement;if(widerThanElement){labelType=LabelTypes.aboveElementWider;}}else if(bounds.maxY+labelHeight<window.canvasHeight){labelType=LabelTypes.belowElement;if(widerThanElement){labelType=LabelTypes.belowElementWider;}}else{if(widerThanElement&&tallerThanElement){labelType=LabelTypes.bottomCornerWiderTaller;}else if(widerThanElement){labelType=LabelTypes.bottomCornerWider;}else{labelType=LabelTypes.bottomCornerTaller;}}
return labelType;}
function _drawSourceOrderLabel(sourceOrder,color,bounds){const sourceOrderContainer=document.getElementById('source-order-container');const otherLabels=sourceOrderContainer.children;const labelContainer=sourceOrderContainer.createChild('div','source-order-label-container');labelContainer.style.color=color;labelContainer.textContent=sourceOrder;const labelHeight=labelContainer.offsetHeight;const labelWidth=labelContainer.offsetWidth;const labelType=_getLabelType(bounds,labelHeight,labelWidth,otherLabels);const labelPosition=_getPositionFromLabelType(labelType,bounds,labelHeight);labelContainer.classList.add(labelType);labelContainer.style.top=labelPosition.contentTop+'px';labelContainer.style.left=labelPosition.contentLeft+'px';}
function _drawPath(context,commands,outlineColor,isChild,bounds){context.save();const path=buildPath(commands,bounds);if(outlineColor){context.strokeStyle=outlineColor;context.lineWidth=2;if(!isChild){context.setLineDash([3,3]);}
context.stroke(path);}
context.restore();return path;}
function drawSourceOrder(highlight,context){context=context||window.context;context.save();const bounds=emptyBounds();const sourceOrder=highlight.sourceOrder||0;const path=highlight.paths.slice().pop();const outlineColor=path.outlineColor;context.save();_drawPath(context,path.path,outlineColor,!!sourceOrder,bounds);context.restore();context.save();if(!!sourceOrder){_drawSourceOrderLabel(sourceOrder,outlineColor,bounds);}
context.restore();return{bounds:bounds};}
const style=`
:root {
    --border-radius: 4px;
}

.source-order-label-container {
    display: block;
    min-width: 20px;
    position: absolute;
    text-align: center;
    align-items: center;
    background-color: white;
    font-family: Menlo, Consolas, monospace;
    font-size: 12px;
    font-weight: bold;
    padding: 2px;
    border: 1.5px solid;
}

.top-corner {
    border-bottom-right-radius: var(--border-radius);
}

.bottom-corner {
    border-top-right-radius: var(--border-radius);
}

.above-element {
    border-top-right-radius: var(--border-radius);
    border-top-left-radius: var(--border-radius);
}

.below-element {
    border-bottom-right-radius: var(--border-radius);
    border-bottom-left-radius: var(--border-radius);
}

.above-element-wider {
    border-top-right-radius: var(--border-radius);
    border-top-left-radius: var(--border-radius);
    border-bottom-right-radius: var(--border-radius);
}

.below-element-wider {
    border-bottom-right-radius: var(--border-radius);
    border-bottom-left-radius: var(--border-radius);
    border-top-right-radius: var(--border-radius);
}

.bottom-corner-wider {
    border-top-right-radius: var(--border-radius);
    border-bottom-right-radius: var(--border-radius);
}

.bottom-corner-taller {
    border-top-right-radius: var(--border-radius);
    border-top-left-radius: var(--border-radius);
}

.bottom-corner-wider-taller {
    border-top-left-radius: var(--border-radius);
    border-top-right-radius: var(--border-radius);
    border-bottom-right-radius: var(--border-radius);
}
`;window.setPlatform=function(platform){const styleTag=document.createElement('style');styleTag.innerHTML=style;document.head.append(styleTag);document.body.classList.add('fill');const canvas=document.createElement('canvas');canvas.id='canvas';canvas.classList.add('fill');document.body.append(canvas);const sourceOrder=document.createElement('div');sourceOrder.id='source-order-container';document.body.append(sourceOrder);setPlatform(platform);};window.reset=function(data){reset(data);doReset();};window.drawSourceOrder=drawSourceOrder;window.dispatch=dispatch;}());