pragma Singleton
import QtQuick

QtObject {
    readonly property int width: 1920
    readonly property int height: 720

    property alias fontDirectory: fontLoaders.fontDirectory
    property alias relativeFontDirectory: fontLoaders.relativeFontDirectory

    /* Edit this comment to add your custom font */
    readonly property font font: Qt.font({
                                             family: Qt.application.font.family,
                                             pixelSize: Qt.application.font.pixelSize
                                         })
    readonly property font largeFont: Qt.font({
                                                  family: Qt.application.font.family,
                                                  pixelSize: Qt.application.font.pixelSize * 1.6
                                              })

    readonly property color backgroundColor: "#c2c2c2"

    property ListModel fontFilesModel : ListModel {
        ListElement { filename: "Exo2-Bold.ttf" }
        ListElement { filename: "Exo2-ExtraBold.ttf" }
        ListElement { filename: "Exo2-Medium.ttf" }
        ListElement { filename: "OpenSans-Bold.ttf" }
        ListElement { filename: "OpenSans-BoldItalic.ttf" }
        ListElement { filename: "OpenSans-ExtraBold.ttf" }
        ListElement { filename: "OpenSans-ExtraBoldItalic.ttf" }
        ListElement { filename: "OpenSans-Italic.ttf" }
        ListElement { filename: "OpenSans-Light.ttf" }
        ListElement { filename: "OpenSans-LightItalic.ttf" }
        ListElement { filename: "OpenSans-Medium.ttf" }
        ListElement { filename: "OpenSans-MediumItalic.ttf" }
        ListElement { filename: "OpenSans-Regular.ttf" }
        ListElement { filename: "OpenSans-SemiBold.ttf" }
        ListElement { filename: "OpenSans-SemiBoldItalic.ttf" }
    }

    property Instantiator fontLoaders : Instantiator{
        id: fontLoaders

        property url fontDirectory: Qt.resolvedUrl("../" + relativeFontDirectory)
        property string relativeFontDirectory: "fonts"

        model: fontFilesModel
        asynchronous: false
        Component{
            FontLoader{
                source:  Qt.resolvedUrl("../" + relativeFontDirectory + "/" + model.filename)
            }
        }
    }

}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/
