/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import Generated.QtQuick3D.Cluster 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0
import Generated.QtQuick3D.Demo_City_Buildings 1.0
import Generated.QtQuick3D.Demo_City_Ground 1.0
import Generated.QtQuick3D.AdasPlane2 1.0

Rectangle {

    id: safetyDistance
    width: 466
    height: 179
    color: "#00ffffff"

    property real dist: 25

    Text {
        id: text1
        x: 8
        y: 21
        width: 153
        height: 84
        color: "#000000"
        text: 110 - dist.toFixed() + " m"

        font.pixelSize: 70
        horizontalAlignment: Text.AlignLeft
        //font.styleName: "ExtraBold"
        font.bold: true
        font.family: "Exo 2"
    }

    Text {
        id: text2
        x: 104
        y: 14
        visible: false
        color: "#000000"
        text: qsTr("m")
        font.pixelSize: 70
        font.bold: true
        font.family: "Exo 2"
    }

    Text {
        id: text3
        x: 8
        y: 127
        width: 290
        height: 52
        color: "#000000"
        text: qsTr("Safety distance")
        font.pixelSize: 30
        font.styleName: "Medium"
        font.family: "Exo 2"
    }

    MySafety {
        id: safety
        antialiasing: true
        fillMode: Image.PreserveAspectFit
        height: 119
        stateValue: dist
        visible: true
        width: 147
        x: 228
        y: 30
    }
    states: [
        State {
            name: "State1"

            PropertyChanges {
                target: text1
                color: "#000000"
            }

            PropertyChanges {
                target: text2
                color: "#000000"
            }

            PropertyChanges {
                target: text3
                color: "#000000"
            }
        },
        State {
            name: "State2"
            when: globalNightMode

            PropertyChanges {
                target: text1
                color: "#ffffff"
            }

            PropertyChanges {
                target: text3
                color: "#ffffff"
            }
        }
    ]

}

/*##^##
Designer {
    D{i:0;height:179;width:466}
}
##^##*/
