import QtQuick
import QtQuick.Controls
import WelcomeScreen 1.0
import QtQuick.Layouts
import StudioControls 1.0 as StudioControls
import projectmodel 1.0

Item {
    id: blogBanner
    height: 200
    width: 300

     Image {
        id: bridging_the_gap
        y: 30
        source: "images/bloglogo.png"
        anchors.horizontalCenter: parent.horizontalCenter
        sourceSize.height: 140
        sourceSize.width: 220
        fillMode: Image.PreserveAspectFit
        Text {
            color: "#ffffff"
            text: "Qt Design Studio 4.8.1"
            font.pixelSize: 14
            font.bold: false
            anchors.top: parent.top
            anchors.topMargin: 82
            anchors.horizontalCenter: parent.horizontalCenter
        }
        Text {
            color: "#ffffff"
            text: "Released"
            font.pixelSize: 12
            font.bold: true
            anchors.top: parent.top
            anchors.topMargin: 106
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Rectangle {
        id: rectangle
        x: 8
        y: 97

        anchors.fill: parent
        z: -1
        border.color: Constants.currentBrand
        color: linkArea.containsMouse ? Constants.currentPushButtonHoverBackground : Constants.currentPushButtonNormalBackground

        MouseArea {
            id: linkArea
            x: 8
            y: 42
            hoverEnabled: true
            anchors.fill: parent
            onClicked: Qt.openUrlExternally("https://www.qt.io/blog/qt-design-studio-4.8.1-released")
        }
    }
}