/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.SparseArray;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class QtSensors
implements SensorEventListener {
    static final QtSensors m_sensorsListener = new QtSensors();
    static SensorManager m_sensorManager = null;
    static SparseArray<Sensor> m_registeredSensors = new SparseArray();
    static Object m_syncObject = new Object();
    private static float[] mRotation = new float[9];
    private static float[] mOrientation = new float[3];
    private static float[] mAcc = new float[3];
    private static float[] mMag = new float[3];

    public static void setContext(Context context) {
        try {
            m_sensorManager = (SensorManager)context.getSystemService("sensor");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getSensorDescription(int n) {
        try {
            Sensor sensor = m_sensorManager.getDefaultSensor(n);
            if (sensor == null) {
                return null;
            }
            return sensor.getName() + " " + sensor.getVendor() + " v" + sensor.getVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static int[] getSensorList() {
        try {
            List list = m_sensorManager.getSensorList(-1);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Sensor sensor : list) {
                hashSet.add(sensor.getType());
            }
            Object object = new int[hashSet.size()];
            int n = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                object[n++] = n2;
            }
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static float getSensorMaximumRange(int n) {
        try {
            Sensor sensor = m_sensorManager.getDefaultSensor(n);
            return sensor.getMaximumRange();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerSensor(int n, int n2) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Sensor sensor = m_sensorManager.getDefaultSensor(n);
                m_sensorManager.registerListener((SensorEventListener)m_sensorsListener, sensor, n2);
                m_registeredSensors.put(n, (Object)sensor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterSensor(int n) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Sensor sensor = (Sensor)m_registeredSensors.get(n);
                if (sensor != null) {
                    m_sensorManager.unregisterListener((SensorEventListener)m_sensorsListener, (Sensor)m_registeredSensors.get(n));
                    m_registeredSensors.remove(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static float[] convertQuaternionToEuler(float[] fArray) {
        float[] fArray2 = new float[9];
        SensorManager.getRotationMatrixFromVector((float[])fArray2, (float[])fArray);
        float[] fArray3 = new float[3];
        SensorManager.getOrientation((float[])fArray2, (float[])fArray3);
        return fArray3;
    }

    private static float getCompassAzimuth(float f, float f2, float f3, float f4, float f5, float f6) {
        QtSensors.mAcc[0] = f;
        QtSensors.mAcc[1] = f2;
        QtSensors.mAcc[2] = f3;
        QtSensors.mMag[0] = f4;
        QtSensors.mMag[1] = f5;
        QtSensors.mMag[2] = f6;
        SensorManager.getRotationMatrix((float[])mRotation, null, (float[])mAcc, (float[])mMag);
        SensorManager.getOrientation((float[])mRotation, (float[])mOrientation);
        return mOrientation[0];
    }

    public static native void accuracyChanged(int var0, int var1);

    public static native void sensorChanged(int var0, long var1, float[] var3);

    public void onAccuracyChanged(Sensor sensor, int n) {
        QtSensors.accuracyChanged(sensor.getType(), n);
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 11) {
            QtSensors.sensorChanged(sensorEvent.sensor.getType(), sensorEvent.timestamp, QtSensors.convertQuaternionToEuler(sensorEvent.values));
        } else {
            QtSensors.sensorChanged(sensorEvent.sensor.getType(), sensorEvent.timestamp, sensorEvent.values);
        }
    }
}

