/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    newHostData = "HostData=../ios";

    // Set path to QT to a variable
    var pathToQt = qtPathUnixSeparators("/6.7.1/ios");

    // patch qmake (.bat)
    component.addOperation("Replace", pathToQt + qmakeScript_671(), originalQmakePath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQmakePath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", pathToQt + qtCMakeScript_671(), originalSetCmakePath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newSetCMakePath_671(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", pathToQt + qtCMakePrivateScript_671(), originalSetCmakePath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newSetCMakePath_671(), "regex");

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64") == true) {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_671());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_671());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_671());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_671());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_671());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_671());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("671" == "dev" || 67 >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_671());
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_671());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", pathToQt + targetQtConf_671(), originalHostPrefix_671(), newHostPrefix_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

    component.addOperation("Replace", pathToQt + targetQtConf_671(), originalHostData_671(), newHostData);

    component.addOperation("Replace", pathToQt + targetQtConf_671(), originalHostSpec_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newHostSpec_671());

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", pathToQt + targetQtConf_671(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_671());

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", pathToQt + targetQtConf_671(), targetQtConfDocumentation_671("6.7.1"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", pathToQt + targetQtConf_671(), "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", pathToQt + targetQtConf_671(), "\n");
    }
    component.addOperation("AppendFile", pathToQt + targetQtConf_671(), targetQtConfExamples_671("6.7.1"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", pathToQt + qtToolchainCmake_671(), originalQtHostPath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQtHostPath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_671(), originalBIPrefix_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), installer.value("TargetDir"));

    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_671(), originalHostTargetPath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), pathToQt);

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", pathToQt + qtPathsScript_671(), originalQtPathsPath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQtPathsPath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

    if ("671" == "dev" || 67 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_671(), originalQtHostPath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQtHostPath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qmake6Script_671(), originalQmakePath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQmakePath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qtPaths6Script_671(), originalQtPathsPath_671("MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"), newQtPathsPath_671("6.7.1", "MacOS-MacOS_13-Clang-IOS-IOS_ANY-ARM64"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", pathToQt + qdeviceFile_671(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_671());

    addInitQtPatchOperation(component, platformIdentification_671(), pathToQt, pathToQt + qmakeScript_671(), "qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for iOS",
                            "--type", "Qt4ProjectManager.QtVersion.Ios",
                            "--qmake", pathToQt + qmakeScript_671(),
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.7.1/ios", "Qt-6.7.1");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", pathToQt + qconfigFile_671(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

