/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Add dynamic dependency for mingw TC for Android packages on Windows.
    if (installer.value("os") == "win") {
        var mingw_tc_component = "qt.tools.win64_mingw900"
        component.addDependency(mingw_tc_component);
    }

    // add automatic dependency to Android main node if it's selected
    dependencyStr = "qt.qt6.632.android"
    // For release builds set the dependency directly to the host binary
    var hostDependencyStr = "";
    var hostDependency = component.value("Dependencies");
    if (hostDependency) {
        if (installer.value("os") == "x11") {
            hostDependencyStr = "qt.qt6.632.gcc_64"
        }
        if (installer.value("os") == "mac") {
            hostDependencyStr = "qt.qt6.632.clang_64"
        }
        if (installer.value("os") == "win") {
            hostDependencyStr = "qt.qt6.632.win64_mingw"
        }
        component.addDependency(hostDependencyStr);
    }

    // Set automatic dependencies
    // - for release builds add dependency to the main Android node
    component.addAutoDependOn(dependencyStr);
}

function originalQtHostPath()
{
    if (installer.value("os") == "x11") {
        return "/home/qt/work/install";
    }
    else {
        return "/Users/qt/work/install";
    }
}

function newQtHostPath()
{
    if (installer.value("os") == "x11") {
        return "@TargetDir@" + "/6.3.2/gcc_64";
    }
    else if (installer.value("os") == "mac") {
        return "@TargetDir@" + "/6.3.2/macos";
    }
    else {
        return "@TargetDir@" + "/6.3.2/mingw_64";
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var targetDir = installer.toNativeSeparators(installer.value("TargetDir"));
    var qtPath = installer.toNativeSeparators(targetDir + "/6.3.2/android_armv7");
    var cmakeBinary = "";
    var platform = "";
    var qmakeScript = "";
    var qtCMakeScript = "";
    var targetQtConf = "";
    var targetQtConf_documentation = "Documentation=../../Docs/Qt-6.3.2";
    var targetQtConf_examples = "Examples=../../Examples/Qt-6.3.2";
    var originalQmakePath = "";
    var newQmakePath = "";
    var originalSetCMakePath ="";
    var newSetCMakePath = "";
    var originalHostPrefix = "HostPrefix=../../";
    var newHostPrefix = "";
    var originalHostData = "HostData=target";
    var newHostData = "";
    var qtToolchainCmake = "";
    var qtBuildInternalsExtraCmake = "";
    var originalQtHostTargetPath = "";
    var newQtHostTargetPath = "";
    var originalQtPathsPath = "";
    var newQtPathsPath = "";

    if (installer.value("os") == "x11") {
        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake/bin/cmake";
        platform = "linux";

        qmakeScript = qtPath + "/bin/qmake";
        qtCMakeScript = qtPath + "/bin/qt-cmake";
        qtCMakePrivateScript = qtPath + "/bin/qt-cmake-private";
        targetQtConf = qtPath + "/bin/target_qt.conf";
        qtToolchainCmake = qtPath + "/lib/cmake/Qt6/qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";
        qtPaths = qtPath + "/bin/qtpaths";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = originalQtHostPath() + "/bin/qmake";
        newQmakePath = targetDir + "/6.3.2/gcc_64/bin/qmake";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "/opt/cmake-3.21.3/bin/cmake";
        newSetCMakePath = cmakeBinary;

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../gcc_64";
        newHostData = "HostData=../android_armv7";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = originalQtHostPath() + "/target";
        newQtHostTargetPath = qtPath;

        // Set new patched values for qtpaths
        originalQtPathsPath = originalQtHostPath();
        newQtPathsPath = qtPath;
    }

    if (installer.value("os") == "mac") {
        var macOSTargetInstallBase = "macos";

        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake/bin/cmake";
        platform = "mac";

        qmakeScript = qtPath + "/bin/qmake";
        qtCMakeScript = qtPath + "/bin/qt-cmake";
        qtCMakePrivateScript = qtPath + "/bin/qt-cmake-private";
        targetQtConf = qtPath + "/bin/target_qt.conf";
        qtToolchainCmake = qtPath + "/lib/cmake/Qt6/qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";
        qtPaths = qtPath + "/bin/qtpaths";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = originalQtHostPath() + "/bin/qmake";
        newQmakePath = targetDir + "/6.3.2/" + macOSTargetInstallBase + "/bin/qmake";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "/Applications/CMake.app/Contents/bin/cmake";
        newSetCMakePath = cmakeBinary;

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../" + macOSTargetInstallBase;
        newHostData = "HostData=../android_armv7";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = originalQtHostPath() + "/target";
        newQtHostTargetPath = qtPath;

        // Set new patched values for qtpaths
        originalQtPathsPath = originalQtHostPath();
        newQtPathsPath = qtPath;
    }

    if (installer.value("os") == "win") {
        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake_64/bin/cmake.exe";
        platform = "windows";

        qmakeScript = qtPath + "\\bin\\qmake.bat";
        qtCMakeScript = qtPath + "\\bin\\qt-cmake.bat";
        qtCMakePrivateScript = qtPath + "\\bin\\qt-cmake-private.bat";
        targetQtConf = qtPath + "\\bin\\target_qt.conf";
        qtToolchainCmake = qtPath + "\\lib\\cmake\\Qt6\\qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "\\lib\\cmake\\Qt6BuildInternals\\QtBuildInternalsExtra.cmake";
        qtPaths = qtPath + "\\bin\\qtpaths.bat";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = originalQtHostPath() + "/bin\\qmake.exe";
        newQmakePath = targetDir + "\\6.3.2\\mingw_64\\bin\\qmake.exe";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "C:/CMake/bin/cmake.exe";
        newSetCMakePath = cmakeBinary.replace(/\\/g, "/");

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../mingw_64";
        newHostData = "HostData=../android_armv7";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = originalQtHostPath() + "/target";
        newQtHostTargetPath = qtPath;

        // Set new patched values for qtpaths.bat
        originalQtPathsPath = originalQtHostPath() + "/";
        newQtPathsPath = qtPath + "\\"
    }
    // Patch build time paths from target\bin\qmake(.bat) script
    console.log("Patching qmake script: " + qmakeScript);
    console.log("  from originalQmakePath: " + originalQmakePath);
    console.log("  to newQmakePath: " + newQmakePath);
    component.addOperation("Replace", qmakeScript, originalQmakePath, newQmakePath);

    // Patch build time CMake path from qt-cmake(.bat) script
    console.log("Patching CMake path from qt-cmake script: " + qtCMakeScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakeScript, originalSetCMakePath, newSetCMakePath);

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    console.log("Patching CMake path from qt-cmake-private script: " + qtCMakePrivateScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakePrivateScript, originalSetCMakePath, newSetCMakePath);

    // Patch Host Prefix and Host Data paths from target_qt.conf
    console.log("Patching Host Prefix and Host Data from target_qt.conf: " + targetQtConf);
    console.log("  from originalHostPrefix: " + originalHostPrefix);
    console.log("  to newHostPrefix: " + newHostPrefix);
    console.log("  from originalHostData: " + originalHostData);
    console.log("  to newHostData: " + newHostData);
    component.addOperation("Replace", targetQtConf, originalHostPrefix, newHostPrefix);
    component.addOperation("Replace", targetQtConf , originalHostData, newHostData);

    // Append target_qt.conf with relative paths to documentation and examples
    console.log("Appending " + targetQtConf_documentation + " and " + targetQtConf_examples + " to targetQtConf" + targetQtConf);
    component.addOperation("AppendFile", targetQtConf, targetQtConf_documentation);
    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", targetQtConf, "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", targetQtConf, "\n");
    }
    component.addOperation("AppendFile", targetQtConf, targetQtConf_examples);

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", qtToolchainCmake, originalQtHostPath(), newQtHostPath());

    // Patch Qt install path from QtBuildInternalsExtra.cmake
    console.log("Patching install path from QtBuildInternalsExtra.cmake : " + qtBuildInternalsExtraCmake);
    console.log("  from originalQtHostTargetPath: " + originalQtHostTargetPath);
    console.log("  to newQtHostTargetPath: " + newQtHostTargetPath);
    component.addOperation("Replace", qtBuildInternalsExtraCmake, originalQtHostTargetPath, newQtHostTargetPath);

    // Patch Qt install path from qtpaths(.bat)
    console.log("Patching install path from qtpaths(.bat) : " + qtPaths);
    console.log("  from original path: " + originalQtPathsPath);
    console.log("  to new path: " + newQtPathsPath);
    component.addOperation("Replace", qtPaths, originalQtPathsPath, newQtPathsPath);

    addInitQtPatchOperation(component, platform, qtPath, qmakeScript, "emb-arm-qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for Android ARMv7",
                            "--type", "Qt4ProjectManager.QtVersion.Android",
                            "--qmake", qmakeScript,
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.3.2/android_armv7", "Qt-6.3.2");

    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        // patch qconfig.pri
        var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
        component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
        if (installer.value("os") == "x11") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck64", "QT_LICHECK =");
        }
        else if (installer.value("os") == "mac") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        }
        else {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck.exe", "QT_LICHECK =");
        }
    }
}

Component.prototype.onInstallationFinished = function()
{
    component.onInstallationFinished();

    var qt6DependenciesCmake = installer.toNativeSeparators(installer.toNativeSeparators(installer.value("TargetDir") +
                                                            "/6.3.2/android_armv7") +
                                                            "/lib/cmake/Qt6/Qt6Dependencies.cmake");

    // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't guaranteed the file exists
    if (installer.fileExists(qt6DependenciesCmake)) {
        installer.performOperation("Replace", qt6DependenciesCmake, originalQtHostPath(), newQtHostPath());
    }
    else {
        console.log("File not found: " + qt6DependenciesCmake);
    }
}
