/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    // Set new host data.
    // Maybe this part "msvc2019_arm64" could be added to a substitute for this component?
    var newHostData = "HostData=../msvc2019_arm64";

    // Set path to QT to a variable
    var pathToQt = qtPathUnixSeparators("/6.8.0/msvc2019_arm64");

    // patch qmake (.bat)
    component.addOperation("Replace", pathToQt + qmakeScript_dev(), originalQmakePath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQmakePath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", pathToQt + qtCMakeScript_dev(), originalSetCmakePath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newSetCMakePath_dev(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", pathToQt + qtCMakePrivateScript_dev(), originalSetCmakePath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newSetCMakePath_dev(), "regex");

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64") == true) {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_dev());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_dev());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_dev());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_dev());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_dev());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_dev());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("dev" == "dev" || 68 >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_dev());
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_dev());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", pathToQt + targetQtConf_dev(), originalHostPrefix_dev(), newHostPrefix_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

    component.addOperation("Replace", pathToQt + targetQtConf_dev(), originalHostData_dev(), newHostData);

    component.addOperation("Replace", pathToQt + targetQtConf_dev(), originalHostSpec_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newHostSpec_dev());

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", pathToQt + targetQtConf_dev(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_dev());

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", pathToQt + targetQtConf_dev(), targetQtConfDocumentation_dev("6.8.0"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", pathToQt + targetQtConf_dev(), "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", pathToQt + targetQtConf_dev(), "\n");
    }
    component.addOperation("AppendFile", pathToQt + targetQtConf_dev(), targetQtConfExamples_dev("6.8.0"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", pathToQt + qtToolchainCmake_dev(), originalQtHostPath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQtHostPath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_dev(), originalBIPrefix_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), installer.value("TargetDir"));

    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_dev(), originalHostTargetPath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), pathToQt);

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", pathToQt + qtPathsScript_dev(), originalQtPathsPath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQtPathsPath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

    if ("dev" == "dev" || 68 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_dev(), originalQtHostPath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQtHostPath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qmake6Script_dev(), originalQmakePath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQmakePath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qtPaths6Script_dev(), originalQtPathsPath_dev("Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"), newQtPathsPath_dev("6.8.0", "Windows-Windows_10_22H2-MSVC2019-Windows-Windows_10_22H2-ARM64"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", pathToQt + qdeviceFile_dev(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_dev());

    addInitQtPatchOperation(component, platformIdentification_dev(), pathToQt, pathToQt + qmakeScript_dev(), "qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", component.name,
                                "--name", "Qt %{Qt:Version} MSVC2019 ARM64",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", pathToQt + qmakeScript_dev(),
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmQt", "--id", component.name]);

        var kitName = component.name + "_kit";
        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Desktop Qt %{Qt:Version} MSVC2019 ARM64",
                                "--Ctoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--Cxxtoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--qt", component.name,
                                "--debuggerengine", "4",
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.8.0/msvc2019_arm64", "Qt-6.8.0");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", pathToQt + qconfigFile_dev(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

