// Copyright (C) 2016 Dmitry Savchenko
// Copyright (C) 2016 Vasiliy Sorokin
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#include "keyword.h"
#include <utils/theme/theme.h>

namespace Todo::Internal {

Keyword::Keyword()
    : color(Utils::creatorColor(Utils::Theme::TextColorNormal))
{}

bool Keyword::equals(const Keyword &other) const
{
    return name == other.name && iconType == other.iconType && color == other.color;
}

bool operator ==(const Keyword &k1, const Keyword &k2)
{
    return k1.equals(k2);
}

bool operator !=(const Keyword &k1, const Keyword &k2)
{
    return !k1.equals(k2);
}

} // namespace Todo::Internal
