<a name="Top"></a>

[![Logo](https://i.imgur.com/33zw5CH.png)](http://www.gridskin.net/)

[About](#About) | [License](#License) | [Compatibility](#Compatibility) | [Language Support](#Language) | [Download](#Download) | [Support](#Support) | [Add-ons](#Add-ons) | [Contribute](#Contribute) | [Credits](#Credits) | [FAQ](#FAQ) | [Stats](#Stats)

<a name="About"></a>
## About
Grid is a graphical user interface for Kodi. The goal for Grid is to provide an elegant and intuitive way of enjoying all the wonderful features that Kodi provides. The design and development focuses on feature quality rather than quantity with a lot of attention spent on the little details that matter.

<a name="License"></a>
## License
This software is licensed under a [Attribution-NonCommercial-ShareAlike 3.0 Unported](http://creativecommons.org/licenses/by-nc-sa/3.0/) license

[![badge-license](http://forthebadge.com/images/badges/cc-nc-sa.svg)](http://creativecommons.org/licenses/by-nc-sa/3.0/)

excerpt:
"NonCommercial — You may *not* use the material for commercial purposes."

**To Kodi box sellers / streambox sellers, etc:**
This means you are **not** allowed to sell products with Grid (pre)installed without my **prior written consent**!

Any redistribution of this software (or modifications / derivatives of it) must include the original license files and an unmodified copy of [this readme](https://github.com/jeroenpardon/skin.grid/edit/master/README.md) file. You cannot remove me, the original author, from the provider-name field in the addon.xml file.

<a name="Compatibility"></a>
## Compatibility
Currently Grid is compatible with Kodi 17 Krypton only. A branch is available for Kodi 18 Leia, but it is to be considered incomplete and unstable. Please do not report issues encountered on the Kodi 18 Leia version.

<a name="Language"></a>
## Language support
Grid currently supports these character sets:

* Cyrillic (extended)
* Greek (extended)
* Hebrew
* Latin (extended)
* Vietnamese

Any other language is supported through the Unicode (Arial) fontset, but this comes with compromises on looks and usability.
If you are interested in providing a translation of Grid into your language(s), you are more than welcome to. Join a language team or add a new language at Grid's Transifex [project page](https://www.transifex.com/grid)

<a name="Download"></a>
## Download

[![badge-release](
https://img.shields.io/badge/Downloads-Official-brightgreen.svg?style=flat-square
)](https://github.com/jeroenpardon/skin.grid/releases) [![badge-beta](https://img.shields.io/badge/Downloads-Beta-brightgreen.svg?style=flat-square)](https://gitlab.com/jeroenpardon/repository.jeroen) [![badge-snapshot](
https://img.shields.io/badge/Downloads-Snapshot-brightgreen.svg?style=flat-square
)](https://github.com/jeroenpardon/skin.grid/archive/master.zip) [![badge-install](https://img.shields.io/badge/Wiki-Install-blue.svg?style=flat-square)](https://github.com/jeroenpardon/skin.grid/wiki/Download-&-Installation)

**Official releases**

Official, stable releases of Grid can be installed through the official Kodi repository. If you don't know how, check [this guide](http://kodi.wiki/view/HOW-TO:Change_skins). Any dependencies should be installed automatically.

**Beta releases**

These are released on a regular basis when preparing for an official release. While they are checked before upload, these builds are still to be considered as unstable. You can get these builds by installing my repository add-on, which can be downloaded [here](https://gitlab.com/jeroenpardon/repository.jeroen). Please refer to [this guide](http://kodi.wiki/view/HOW-TO:Install_add-ons_from_zip_files) if you don't know how to manually install add-ons in Kodi. Depending on your Kodi settings future updates to Grid will now be installed automatically, or you will be notified of the update.

**Snapshot builds**

These are generated by Github and contain the most recent changes at the time of downloading. They should be considered unstable and likely to contain bugs or broken / missing functionality.
After you have downloaded [this zip file](https://github.com/jeroenpardon/skin.grid/archive/master.zip), please refer to [this guide](http://wiki.kodi.tv/index.php?title=HOW-TO:Install_an_Add-on_from_a_zip_file) if you don't know how to manually install skins in Kodi. Please make sure you have all [required dependencies](#Add-ons) installed on your system before you attempt to install Grid.

<a name="Support"></a>
## Support
For any questions, discussion and support, please check the Grid section on the Kodi forums [here](https://forum.kodi.tv/forumdisplay.php?fid=280)

<a name="Add-ons"></a>
## Add-ons

**Required add-ons**
These add-ons are required by Grid. If you are missing one or more, Kodi will display a "Dependencies not met" error message when attempting to install. It is also possible you do not have the minimum required version of one of these add-ons. 
If you are using an official public release of Grid, these add-ons should be installed automatically by Kodi If you are manually installing Grid from Github, you may need to install one or more of these add-ons. Below is where you can find them.

* [resource.uisounds.grid](https://github.com/jeroenpardon/resource.uisounds.grid)
* [script.grab.fanart](https://github.com/robweber/script.grab.fanart)
* [script.skin.helper.service](https://github.com/marcelveldt/script.skin.helper.service)
* [script.skin.helper.widgets](https://github.com/marcelveldt/script.skin.helper.widgets)
* [script.skinshortcuts](https://github.com/BigNoid/script.skinshortcuts)
* [script.watchlist](https://github.com/jeroenpardon/script.watchlist)

**Supported add-ons**
These add-ons are not required for installation but are needed for certain skin features. You will be prompted to install an add-on when you select such a feature.

* [script.artistslideshow](https://github.com/pkscout/script.artistslideshow)
* [script.artwork.downloader](https://github.com/XBMC-Addons/script.artwork.downloader)
* [script.cinemavision](https://github.com/CinemaVision/script.cinemavision)
* [script.colorbox](https://github.com/BADMS/script.colorbox)
* [script.skin.helper.colorpicker](https://github.com/marcelveldt/script.skin.helper.colorpicker)
* [script.skin.helper.skinbackup](https://github.com/marcelveldt/script.skin.helper.skinbackup)
* [service.library.data.provider](https://github.com/BigNoid/service.library.data.provider)
* [script.tv.show.next.aired](https://github.com/marcelveldt/script.tv.show.next.aired)

<a name="Contribute"></a>
## Contribute
Even though I enjoy working on Grid greatly, a lot of time and effort is invested in it's development. If you enjoy my work and would like to buy me a beer to show your appreciation, any donation is appreciated greatly.

[![Image](https://www.paypalobjects.com/images/shared/paypal-logo-129x32.svg "Donate Link") ](http://bit.ly/2nXuTGN "Grid donation button")

<a name="Credits"></a>
## Credits

**Grid beta testers**

- [BigDaddyRal](https://github.com/bigdaddyral)
- [FrissonReynald](https://github.com/FrissonReynald)
- [KOKONUTCREME](https://github.com/KOKONUTCREME)
- [loggio](https://github.com/loggio)
- [lstar337](https://github.com/lstar337)
- [monkeyboyohyeah](https://github.com/monkeyboyohyeah)
- [Rafał Wójcik](https://github.com/Ostrymiecz)
- [Slurrrp](https://github.com/Slurrrp)

<a name="FAQ"></a>
## Frequently asked questions
> ZOMG!#$ this skin haz no filemanager! And the menu doesn't have shortcuts to X or Y!

Grid's main menu is completely customizable, meaning you can add any location or function to it's main menu. The items you see after installing Grid are merely defaults you can adjust to your liking. Go to System, Skin Settings, Menus to customize the main menu.

> When installing, I get an error message saying "dependencies not met"

The cause for this is **always** one or more of the [required add-ons](#Add-ons) not being installed on your system, or you're using a different (outdated) version of one or more of these add-ons. Make sure your add-ons are all updated.

> I want to make modifications to Grid, can you tell me how?

I can point you in the right direction if I can, but I can't and won't talk you through it step by step. You will need to bring some self reliance, effort and willingness to learn. I am releasing Grid for free and my available time is limited, so don't be offended by me not offering you free skinning lessons too.

> I only see unwatched status indicators. Is there an option to display watched status indicators as well?

No, there isn't and there never will be. There is an indicator if the item is unwatched or when it's partly watched. If there is no indicator, the item is not watched. I find this obvious and logical, and thus feel there is no added value in placing an indicator on files that have been watched. If you are reading a book, you place a bookmark where you stopped reading. You don't put a bookmark on every page you've read so far.

<a name="faq_verticalmenu"></a>
> Can you make the main menu items in the vertical menu not open the submenu first?

No, that is not the way the menu works or can work. Any main menu item that has one or more submenu items will open the submenu first so you can get to it if needed. Press the main menu item one more time to open whatever the main menu's target is set at. Any main menu item without one or more submenu items will open the main menu item's target right away.

> In that case, can you make the submenu open by pressing left? Then the main menu can open it's target right away

Aside from the fact that the vertical menu would have to be rewritten completely, this is not something I'll consider. There is nothing intuitive about pressing left to open a menu (on the right hand side even). In an application unfamiliar to someone the first instinctive thing is to press / click / tap the button, menu or any other control. Not moving or swiping to the left. Other than that opening a submenu is faster than when having to perform two different keypresses. And double clicking something isn't exactly unheard of in UX...

> Will you add discarts ?

No, I find them incredibly tacky. Presenting digital media as physical media is just silly.

> Make it an option!?

Still no.

> Can you add feature X or Y?

Maybe. But don't get mad when I don't. As much as I hope people will enjoy using Grid, development is also driven by my own preferences. Also, please note that "because other skins have this feature too" is not a good reason for me to add it to Grid.

I have to stress that I am not a crowd pleaser. If someone has a great idea it would be stupid for me to ignore it, but I don’t make “Swiss army knife” type skins, nor design by commitee. As such I carefully select which features can be added in a way that fit in with the skin and my vision. That design / development principle makes my skins what they are, for better or for worse.

> But if you don't want the features, why not just make it optional?

'Just make it an option' is short for 'I can't make design decisions'. It pollutes the UI and focus of the skin. Grid is not and will never be a swiss army knife type of skin. Apart from that, I just have no motivation to add features I wouldn't ever use myself.

<a name="Stats"></a>
## Geeky stats
[![badge-commits](https://img.shields.io/github/commits-since/jeroenpardon/skin.grid/0.9.0.0.svg?style=flat-square)](https://github.com/jeroenpardon/skin.grid/commits/master) [![badge-issues](https://img.shields.io/github/issues-raw/jeroenpardon/skin.grid.svg?maxAge=60&style=flat-square)](https://github.com/jeroenpardon/skin.grid/issues) [![badge-issues](https://img.shields.io/github/issues-closed-raw/jeroenpardon/skin.grid.svg?maxAge=60&style=flat-square)](https://github.com/jeroenpardon/skin.grid/issues?q=is%3Aissue+is%3Aclosed) [![badge-tag](https://img.shields.io/github/tag/jeroenpardon/skin.grid.svg?style=flat-square)]() [![badge-release](https://img.shields.io/github/release/jeroenpardon/skin.grid.svg?style=flat-square)]()

[Back to top](#Top)
