        TITLE   FPU.ASM

DGROUP  GROUP   _DATA
        ASSUME  CS:_TEXT, DS:DGROUP

_DATA   SEGMENT WORD PUBLIC 'DATA'
        extrn   fpu_type:byte          ; Holds the FPU type (8087, 80287, etc.)
        extrn   cputype:byte           ; Holds the current CPU type
        extrn   fp_status:word         ; Hold the FPU status word
_DATA   ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'

        public iscyrixfpu
        public get_fpu_type

iscyrixfpu proc far
  push bp
  mov bp,sp
  sub sp,4                             ; get stack space
  push si                              ; use as temp
  push di                              ; use as temp
  finit                                ; inialize fpu
  fldpi                                ; fpu loads pi
  f2xm1                                ; square pi
  fstp dword ptr [bp-4]                ; get pi squared
  lea ax, word ptr [bp-2]              ; get address of pi squared value
  mov si, ax
  cmp word ptr [si], 3FC9h             ; compare pi squared to Cyrix
  jne not_cyrix
  mov di, 1                            ; True Cyrix FPU present
  jmp done
not_cyrix:
  mov di, 0                            ; FALSE Cyrix FPU not present
done:
  mov ax, di                           ; return findings
  pop di
  pop si
  mov sp,bp
  pop bp
  ret
iscyrixfpu endp

get_fpu_type proc far
  fninit
  mov fp_status, 5a5ah
  fnstsw fp_status
  mov ax, fp_status
  cmp al, 0
  mov fpu_type, 0
  jne end_get_fpuid
check_control_word:
  fnstcw fp_status
  mov ax, fp_status
  and ax, 0103fh
  cmp ax, 3fh
  mov fpu_type, 0
  jne end_get_fpuid
  mov fpu_type, 1
check_infinity:
  cmp cputype, 3
  jne end_get_fpuid
  fld1
  fldz
  fdiv
  fld st
  fchs
  fcompp
  fstsw fp_status
  mov ax, fp_status
  mov fpu_type, 2
  sahf
  jz end_get_fpuid
  mov fpu_type, 3
end_get_fpuid:

get_fpu_type endp

_TEXT   ENDS
  end
