; Mouse wheel test program
; Copyright (c) 1997-2002 Nagy Daniel <nagyd@users.sourceforge.net>
;
; Description: This program should print a 'd' for wheel downward and 'u'
;		for wheel upward movement
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;
; History:
;
; 2002-02-12 First public release
;

WARN
%NOINCL
LOCALS
.model tiny


;

.data

S_nodriver	db	'Mouse driver$'
S_nohardware	db	'Mouse hardware$'
S_doesnt	db	' does not support Wheel API',0dh,0ah,'$'
S_anykey	db	'Move wheel now or press a key to quit...',0dh,0ah,'$'


;

.code
		org	100h

;---------- check for wheel support presence

start:		mov	ax,11h
		int	33h		; check for Wheel support
		mov	dx,offset DGROUP:S_nodriver
		cmp	ax,'WM'		; error if no proper driver installed
		jne	nowheel
		mov	dx,offset DGROUP:S_nohardware
		test	cl,1
		jnz	oktest		; jump if hardware is OK

nowheel:	mov	ah,9		; print 1st part of error
		int	21h
		mov	dx,offset DGROUP:S_doesnt
		int	21h		; print end part of error
		int	20h		; exit

;---------- run test program if wheel is OK

oktest:		mov	dx,offset DGROUP:S_anykey
		mov	ah,9		; print message
		int	21h

wheelloop:	mov	ax,3		; get position, button and wheel
		int	33h
		test	bh,bh		; check wheel counter since last call
		jz	checkstop	; jump if wheel not moved

		mov	al,'u'		; print 'u' if moved up
		js	showchar	; jump if wheel moved upward
		mov	al,'d'		; else print a 'd' character
showchar:	mov	bh,0
		mov	ah,0Eh
		int	10h		; print character
		jmp	wheelloop	; and continue loop

checkstop:	mov	ah,1
		int	16h		; else check keyboard
		jz	wheelloop	; continue until key pressed

		mov	ah,0		; remove last key
		int	16h
		int	20h		; exit

;

		end	start
