#ifndef BOOT_H_
#define BOOT_H_

struct BootSectorStruct
{
   char     Jump[3];                 /* Jump instruction in boot routine. */
   char     Identification[8];       /* Identification code.              */
   unsigned short BytesPerSector;    /* bytes per sector.                 */
   unsigned char  SectorsPerCluster; /* sectors per cluster.              */
   unsigned short ReservedSectors;   /* number of reserved sectors.       */
   unsigned char  Fats;              /* number of fats.                   */
   unsigned short NumberOfFiles;     /* number of files or directories in */
                                     /* the root directory.               */
   unsigned short NumberOfSectors;   /* number of sectors in the volume.  */
   unsigned char  descriptor;        /* media descriptor.                 */
   unsigned short SectorsPerFat;     /* number of sectors per fat.        */
   unsigned short SectorsPerTrack;   /* sectors per track.                */
   unsigned short Heads;             /* number of read/write heads.       */
   unsigned short Divider;
   char  BootRoutine[482];           /* bootroutine.                      */
};

int ReadBootSector(RDWRHandle handle, struct BootSectorStruct* buffer);
int WriteBootSector(RDWRHandle handle, struct BootSectorStruct* buffer);

unsigned char  GetSectorsPerCluster(RDWRHandle handle);
unsigned short GetReservedSectors(RDWRHandle handle);
unsigned char  GetNumberOfFats(RDWRHandle handle);
unsigned short GetNumberOfRootEntries(RDWRHandle handle);
unsigned char  GetMediaDescriptor(RDWRHandle handle);
unsigned short GetNumberOfSectors(RDWRHandle handle);
unsigned short GetSectorsPerFat(RDWRHandle handle);
unsigned short GetSectorsPerTrack(RDWRHandle handle);
unsigned short GetReadWriteHeads(RDWRHandle handle);
unsigned short GetClustersInDataArea(RDWRHandle handle);

#endif

