/*

PUSHD v.1.0  Adds desired directories to a stack.
Copyright (C) 1998 Robert Lake

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Robert Lake can be contacted at
email: rlake@cs.mun.ca
Snail Mail: 29 Carlton Drive, Mt. Pearl, NF, A1N 2X4

*/

#include "pushd.h"
#include "../misc.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h> 

int main(int argc, char *argv[])
{
	char dir_to_add[MAXPATH];
	int result;

	/* Check for valid number of args */
	/* those after two are ignored, for now */
	if(argc == 1) {
		print_header(argv[0], USAGE, NAME, VERSION,
				AUTHOR);
		return 0;
        } else if(argc >= 3) {
                printf("Too many parameters - %s", argv[2]);
                return 0;
        }
	dir_to_add[0] = 0;
	strcpy(dir_to_add, get_dir(argv[1], &result));

	if(!result)
		return 0;
	add_dir(dir_to_add);
	return 1;
}

/* Get the real name of the directory */
/* soon will be a dos call */
char *get_dir(char *dir_name, int *result)
{
	char real_name[MAXPATH], pwd[MAXPATH];
        unsigned disk, maxdrives;

	_dos_getdrive(&disk);
	getcwd(pwd, 128);
	*result = 1;

	if(chdir(dir_name) == -1) {
		perror("get_dir");
		*result = 0;
		return 0;
	}
	if(dir_name[1] == ':')
		_dos_setdrive(toupper(dir_name[0]) - 'A' + 1, &maxdrives);

	getcwd(real_name, MAXPATH);
	_dos_setdrive(disk, &maxdrives);
	chdir(pwd);
	return &real_name[0];
}

/* Add the dir to the stack file */
int add_dir(char *dir_to_add)
{
	int fhandle, result, created;
	unsigned written;

	result = _dos_open(FN, O_WRONLY, &fhandle);
	created = 0;
	if(result != 0) {
		created = 1;
		result = _dos_creat(FN, _A_NORMAL, &fhandle);
	}
	if(result != 0)
		perror("add_dir: ");

	lseek(fhandle, 0L, SEEK_END);
	if(!created)
		_dos_write(fhandle, CRLF, strlen(CRLF), &written);

	result = _dos_write(fhandle, dir_to_add, strlen(dir_to_add), &written);
	if(result != 0)
		perror("add_dir: ");

	_dos_close(fhandle);

	return 1;
}
