; Flat Real Mode Initializer -
;    A tiny ASM app to initialize the undocumented x86 addressing

; Copyright (C) 1999 by Louis P. Santillan
;    Parts taken from bootsector code of Jeff Weeks, John Fine, and
;    Flat Real Mode demonstration code of ASM Gems and Robert Collins
;    (rcollins@x86.org).  HelpPC 2.11 & TechView 6.0 were also used
;    as references

; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to

; the Free Software Foundation, Inc.
; 59 Temple Place
; Suite 330
; Boston, MA  02111-1307
; USA

[BITS 16]

%ifndef _FRM_OUTPUT_

%define _FRM_OUTPUT_

; _puts writes an EOS-terminated (null-terminated) string using BIOS

;    _puts expects that [ ES : SI ] is a pointer to a null-terminated
;       string
;    _puts is JMP-recursive allowing it to print 64K sized strings or
;       until a null byte is found
_puts:

   ; Set BIOS function to print a character
   MOV AH, BIOSprintCharacter

   ; Use screen 0, print the character in off white on a black background
   MOV BX, Screen0_BG_Black_FG_OffWhite

   puts_00:
      ; Load A Single byte in from string @ [ ES : SI ] into AL
      LODSB

      ; Did we read a null byte?
      OR AL, AL

      ; If AL == 0, we read a null byte
      JZ puts_01

         ; Call on BIOS to print ASCII character in AL
         INT 0x10

         ; JMP-recursion; do this until we find a null byte
         JMP puts_00

   ; We found a null byte, so we exit
   puts_01:
      RET
;//////////////////////////////////////////////////////////////////////
   %define ENDL 13, 10

   %define EOS 0

   %define version 'v0.0pre3'

   introMessage:
      DB 'FRM.COM ', version, ' - ', 'GPL Copyright (C) 1999, Louis P. Santillan', ENDL
      DB 'This program uses FRM-Lib which is copyrighted under the LGPL'
      DB ENDL
      DB ENDL, EOS

;//////////////////////////////////////////////////////////////////////
   %define checkMark 0xFB

   BIOSprintCharacter EQU 0x0E

   Screen0_BG_Black_FG_OffWhite EQU 0x0007

   checked:
      DB ' [', checkMark, ']', ENDL, EOS

   unChecked:
      DB ' [ ]', ENDL, EOS
      
;//////////////////////////////////////////////////////////////////////
   enableA20String:
      DB 'Enabling A20 Line', EOS

;   A20EnabledString:
;      DB '   A20 Line has been ENABLED', ENDL
;      DB ENDL, EOS

;//////////////////////////////////////////////////////////////////////
   check386plus:
      DB 'Checking for 386+ CPU', EOS

;   found386plus:
;      DB '   A 386+ CPU has been found', ENDL
;      DB ENDL, EOS

   missing386plus:
      DB '   Exiting without a 386+ CPU being found', ENDL
      DB ENDL, EOS

;//////////////////////////////////////////////////////////////////////
   checkingCR0:
      DB 'Checking CR0', APOSTROPHE, 's PE Bit', EOS

   isSetPEbit:
      DB '   Exiting with the PE bit in CR0 found set', ENDL
      DB ENDL, EOS

;   isNotSetPEbit:
;      DB '   The PE and PG bits in CR0 are not set', ENDL
;      DB ENDL, EOS

   APOSTROPHE EQU 0x27

;//////////////////////////////////////////////////////////////////////
   initializingFRMString:
      DB 'Entering Flat Real Mode', EOS

;   FRMInitializedString:
;      DB '   Flat Real Mode has been entered', ENDL, EOS

%endif
