/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __HDTBL_H__
#define __HDTBL_H__

#include "CExt.h"

//////////// PART 2:  HD TABLE //////////////////////////////////////////


typedef struct data hdtbl;
struct data {
	BYTE letter;           /* 1=A:,2=B:,3=C:,...   */
	BYTE drv_type;         /* see isHardDrive(...) */
	unsigned long size;    /* available/free space */
	unsigned long total;   /* total size/space     */
	char label[12];        /* volume label         */
	hdtbl *next;
};

/* To allow testing with all 26 drives, uncomment this line,
   Note: it will hard code all drives to DRV_EXISTS and
   fixed free size of 0xFD
*/
// #define TEST_ALLDRVS


/* this will remove all entries in the list & reset it to NULL */
void clearlist (void);

/* adds an entry to the list */
BOOL hdadd (BYTE dl, BYTE drv_type);

hdtbl *gethdrec (BYTE num, hdtbl *u);

#if 1
#define gethd(num) gethdrec(num, list)
#else
hdtbl *gethd (BYTE num);
#endif

#endif /* __HDTBL_H__ */
