/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.timestamp.impl;

import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.tsp.Accuracy;
import iaik.tsp.MessageImprint;
import iaik.tsp.TSTInfo;
import iaik.tsp.TimeStampToken;
import iaik.tsp.TspVerificationException;
import iaik.xml.crypto.xades.timestamp.TSPTimeStampToken;
import iaik.xml.crypto.xades.timestamp.TimeStampTokenException;
import iaik.xml.crypto.xades.timestamp.impl.TimeStampTokenImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.xml.crypto.OctetStreamData;

public class TSPTimeStampTokenImpl
extends TimeStampTokenImpl
implements TSPTimeStampToken {
    protected TimeStampToken token_;

    public boolean validateSignature(X509Certificate x509Certificate) throws TimeStampTokenException {
        if (x509Certificate == null) {
            throw new NullPointerException("Argument 'cert' must not be null");
        }
        try {
            this.token_.verifyTimeStampToken(x509Certificate);
            return true;
        }
        catch (TspVerificationException tspVerificationException) {
            return false;
        }
    }

    public boolean validateHashValue(OctetStreamData octetStreamData) throws TimeStampTokenException {
        TSTInfo tSTInfo = this.token_.getTSTInfo();
        if (tSTInfo != null) {
            byte[] byArray;
            MessageDigest messageDigest;
            MessageImprint messageImprint = tSTInfo.getMessageImprint();
            AlgorithmID algorithmID = messageImprint.getHashAlgorithm();
            try {
                messageDigest = algorithmID.getMessageDigestInstance();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new TimeStampTokenException("The hash algorithm '" + algorithmID.getName() + " is not supported.", noSuchAlgorithmException);
            }
            DigestInputStream digestInputStream = new DigestInputStream(octetStreamData.getOctetStream(), messageDigest);
            try {
                byArray = new byte[4096];
                while (digestInputStream.read(byArray) != -1) {
                }
            }
            catch (IOException iOException) {
                throw new TimeStampTokenException("Failed to calculate digest from given input", iOException);
            }
            byArray = messageDigest.digest();
            byte[] byArray2 = messageImprint.getHashedMessage();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        return false;
    }

    public TimeStampToken getTimeStampToken() {
        return this.token_;
    }

    public Date getTime() {
        TSTInfo tSTInfo = this.token_.getTSTInfo();
        if (tSTInfo != null) {
            return tSTInfo.getGenTime();
        }
        return null;
    }

    public String getTSAIdentifier() {
        TSTInfo tSTInfo = this.token_.getTSTInfo();
        if (tSTInfo != null) {
            GeneralName generalName = tSTInfo.getTsa();
            return generalName == null ? "" : generalName.toString();
        }
        return null;
    }

    public X509Certificate getTSACertificate() {
        return this.token_.getSigningCertificate();
    }

    public BigInteger getSerialNumber() {
        TSTInfo tSTInfo = this.token_.getTSTInfo();
        if (tSTInfo != null) {
            return tSTInfo.getSerialNumber();
        }
        return null;
    }

    public byte[] getDEREncoded() throws TimeStampTokenException {
        try {
            return this.token_.getEncoded();
        }
        catch (CMSException cMSException) {
            throw new TimeStampTokenException("Failed to encode time-stamp token , " + cMSException.getMessage(), cMSException);
        }
    }

    public long getAccuracy() {
        TSTInfo tSTInfo = this.token_.getTSTInfo();
        if (tSTInfo != null) {
            Accuracy accuracy = tSTInfo.getAccuracy();
            return accuracy.getSeconds() * 1000 + accuracy.getMillis() + accuracy.getMicros() / 1000;
        }
        return -1L;
    }

    public TSPTimeStampTokenImpl(byte[] byArray) throws TimeStampTokenException {
        if (byArray == null) {
            throw new NullPointerException("Argument 'token' must not be null");
        }
        try {
            this.token_ = new TimeStampToken(byArray);
            X509Certificate x509Certificate = this.token_.getSigningCertificate();
            if (x509Certificate != null) {
                this.token_.verifyTimeStampToken(x509Certificate);
            }
        }
        catch (CMSParsingException cMSParsingException) {
            throw new TimeStampTokenException("Failed to parse time-stamp token, " + cMSParsingException.getMessage(), cMSParsingException);
        }
        catch (CodingException codingException) {
            throw new TimeStampTokenException("Failed to parse time-stamp token, " + codingException.getMessage(), codingException);
        }
        catch (TspVerificationException tspVerificationException) {
            throw new TimeStampTokenException("Signature of time-stamp token is invalid, " + tspVerificationException.getMessage(), tspVerificationException);
        }
    }

    public TSPTimeStampTokenImpl(TimeStampToken timeStampToken) {
        if (timeStampToken == null) {
            throw new NullPointerException("Argument 'token' must not be null");
        }
        this.token_ = timeStampToken;
    }
}

