/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.rmid;

import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

public final class ExecPermission
extends Permission {
    private static final long serialVersionUID = -6208470287358147919L;
    private transient FilePermission fp;

    public ExecPermission(String string) {
        super(string);
        this.init(string);
    }

    public ExecPermission(String string, String string2) {
        this(string);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ExecPermission)) {
            return false;
        }
        ExecPermission execPermission = (ExecPermission)permission;
        return this.fp.implies(execPermission.fp);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExecPermission)) {
            return false;
        }
        ExecPermission execPermission = (ExecPermission)object;
        return this.fp.equals(execPermission.fp);
    }

    @Override
    public int hashCode() {
        return this.fp.hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ExecPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }

    private void init(String string) {
        this.fp = new FilePermission(string, "execute");
    }

    private static class ExecPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private Vector permissions = new Vector();
        private static final long serialVersionUID = -3352558508888368273L;

        @Override
        public void add(Permission permission) {
            if (!(permission instanceof ExecPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            this.permissions.addElement(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            if (!(permission instanceof ExecPermission)) {
                return false;
            }
            Enumeration enumeration = this.permissions.elements();
            while (enumeration.hasMoreElements()) {
                ExecPermission execPermission = (ExecPermission)enumeration.nextElement();
                if (!execPermission.implies(permission)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return this.permissions.elements();
        }
    }
}

