/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2005;

import finanze.IDTE.generale2005.BaseTelem;
import finanze.IDTE.generale2005.Modello;
import finanze.IDTE.generale2005.Util;
import java.util.Enumeration;
import java.util.Vector;

public class PF {
    Modello modello;
    public Vector CFfamiliariScartati;
    public boolean detrazioneConiuge;
    boolean assistenza = BaseTelem.currentSystem == 0;

    public PF(Modello modello) {
        this.modello = modello;
    }

    public boolean agevolazioneLavoroAutonomo() {
        boolean detrazione4;
        boolean detrazione3;
        boolean detrazione2;
        boolean detrazione1;
        String miaRiga;
        String mioModello;
        block15: {
            String mod1;
            block14: {
                block13: {
                    block12: {
                        mod1 = "00000001";
                        mioModello = "";
                        miaRiga = "";
                        detrazione1 = false;
                        detrazione2 = false;
                        detrazione3 = false;
                        detrazione4 = false;
                        if (this.modello.D("RE023002" + mod1) != 0.0 || this.modello.D("RE024001" + mod1) != 0.0 || this.modello.D("RG032001" + mod1) != 0.0 || this.modello.D("RG036002" + mod1) != 0.0 || this.modello.D("RH020001" + mod1) != 0.0) {
                            detrazione1 = true;
                        }
                        if (this.modello.D("RE005001" + mod1) > 0.0) break block12;
                        StringBuffer stringBuffer = new StringBuffer("RE019001");
                        if (!(this.modello.D(stringBuffer.append(mod1).toString()) > 0.0)) break block13;
                    }
                    if (this.modello.D("RE022001" + mod1) != 3.0 && this.modello.D("RE022001" + mod1) != 4.0) {
                        detrazione2 = true;
                    }
                }
                if (this.modello.D("RG011001" + mod1) > 0.0) break block14;
                StringBuffer stringBuffer = new StringBuffer("RG024001");
                if (!(this.modello.D(stringBuffer.append(mod1).toString()) > 0.0)) break block15;
            }
            if (this.modello.D("RG030001" + mod1) != 3.0 && this.modello.D("RG030001" + mod1) != 4.0) {
                detrazione3 = true;
            }
        }
        int numMaxModRH = this.modello.getDichiarazione().maxModuliDaQuadro("RH");
        int indmod = 1;
        while (indmod <= numMaxModRH) {
            mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= 4) {
                miaRiga = Util.formNum(3, indriga);
                if (this.modello.D("RH" + miaRiga + "008" + mioModello) != 0.0) {
                    detrazione4 = true;
                }
                ++indriga;
            }
            ++indmod;
        }
        return detrazione1 || detrazione2 || detrazione3 || detrazione4;
    }

    public double liquidaAddizionaleRegionale(String tipoModello, double imponibile) {
        return this.liquidaAddizionaleRegionale(tipoModello, imponibile, true);
    }

    public double liquidaAddizionaleRegionale(String tipoModello, double imponibile, boolean agevolazioneAutomatica) {
        double comodo = 0.0;
        double imposta = 0.0;
        double casiPart = 0.0;
        double redditoComplessivo = 0.0;
        double oneriDeducibili = 0.0;
        double deduzioneAbitazionePrincipale = 0.0;
        String mod1 = "00000001";
        String QuadroC = "";
        String regione = " ";
        int numRigheQuadroC = 3;
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            regione = this.restituisciRegione(this.modello.BS(32));
            casiPart = this.modello.BD(34);
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            deduzioneAbitazionePrincipale = this.modello.D("PL008001" + mod1);
            oneriDeducibili = this.modello.D("PL009001" + mod1);
        } else if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            regione = this.restituisciRegione(this.modello.BS(80));
            casiPart = this.modello.BD(82);
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            deduzioneAbitazionePrincipale = this.modello.D("PL008002" + mod1);
            oneriDeducibili = this.modello.D("PL009002" + mod1);
        } else if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            regione = this.restituisciRegione(this.modello.BS(55));
            casiPart = this.modello.D("RV002001" + mod1);
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            deduzioneAbitazionePrincipale = this.modello.D("RN003001" + mod1);
            oneriDeducibili = this.modello.D("RN004001" + mod1);
            numRigheQuadroC = 4;
        }
        if (regione.equals("01") || regione.equals("02") || regione.equals("03") || regione.equals("05") || regione.equals("06") || regione.equals("07") || regione.equals("08") || regione.equals("09") || regione.equals("12") || regione.equals("15") || regione.equals("16") || regione.equals("17") || regione.equals("18") || regione.equals("20")) {
            imposta = Math.round(0.009 * imponibile);
            return imposta;
        }
        if (regione.equals("04")) {
            imposta = Math.round(0.014 * imponibile);
            return imposta;
        }
        if (regione.equals("13")) {
            if (imponibile > 10329.14) {
                imposta = Math.round(0.014 * imponibile);
                return imposta;
            }
            imposta = Math.round(0.009 * imponibile);
            return imposta;
        }
        if (regione.equals("19")) {
            if (imponibile > 15000.0) {
                imposta = Math.round(0.011 * imponibile);
                return imposta;
            }
            imposta = Math.round(0.009 * imponibile);
            return imposta;
        }
        if (regione.equals("11")) {
            imposta = 0.0;
            if (imponibile <= 15493.71) {
                imposta = Math.round(0.009 * imponibile);
            } else if (imponibile > 15493.71 && imponibile <= 30987.41) {
                imposta = Math.round(139.44 + 0.0191 * (imponibile - 15493.71));
            } else if (imponibile > 30987.41 && imponibile <= 69721.68) {
                imposta = Math.round(435.37 + 0.036 * (imponibile - 30987.41));
            } else if (imponibile > 69721.68) {
                imposta = Math.round(1829.8 + 0.04 * (imponibile - 69721.68));
            }
            return imposta;
        }
        if (regione.equals("14")) {
            imposta = 0.0;
            if (casiPart == 1.0) {
                imposta = Math.round(0.009 * imponibile);
                return imposta;
            }
            imposta = Math.round(0.012 * imponibile);
            return imposta;
        }
        if (regione.equals("21")) {
            imposta = 0.0;
            if (casiPart == 1.0 && imponibile <= 32600.0) {
                imposta = Math.round(0.009 * imponibile);
                return imposta;
            }
            if (imponibile <= 10400.0) {
                imposta = Math.round(0.009 * imponibile);
                return imposta;
            }
            if (imponibile <= 15000.0) {
                imposta = Math.round(0.012 * imponibile);
            } else if (imponibile > 15000.0 && imponibile <= 29000.0) {
                imposta = Math.round(180.0 + 0.013 * (imponibile - 15000.0));
            } else if (imponibile > 29000.0) {
                imposta = Math.round(362.0 + 0.014 * (imponibile - 29000.0));
            }
            return imposta;
        }
        if (regione.equals("10")) {
            imposta = 0.0;
            int numMaxMod = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroC);
            double dipCod1 = 0.0;
            double dipSenzaCod = 0.0;
            int indmod = 1;
            while (indmod <= numMaxMod) {
                String mioModello = Util.formNum(8, indmod);
                int indriga = 1;
                while (indriga <= numRigheQuadroC) {
                    String miaRiga = Util.formNum(3, indriga);
                    String quadroRiga = String.valueOf(QuadroC) + miaRiga;
                    if (this.modello.D(String.valueOf(quadroRiga) + "001" + mioModello) == 1.0) {
                        dipCod1 += (double)this.modello.L(String.valueOf(quadroRiga) + "003" + mioModello);
                    }
                    if (this.modello.D(String.valueOf(quadroRiga) + "001" + mioModello) == 0.0 || this.modello.D(String.valueOf(quadroRiga) + "001" + mioModello) == 1.0) {
                        dipSenzaCod += (double)this.modello.L(String.valueOf(quadroRiga) + "003" + mioModello);
                    }
                    ++indriga;
                }
                ++indmod;
            }
            if (agevolazioneAutomatica && redditoComplessivo - oneriDeducibili <= 10329.14 && redditoComplessivo - deduzioneAbitazionePrincipale - dipCod1 <= 0.0 && dipCod1 > 0.0) {
                imposta = Math.round(0.009 * imponibile);
                return imposta;
            }
            if (casiPart == 1.0 && redditoComplessivo - oneriDeducibili <= 10329.14 && redditoComplessivo - deduzioneAbitazionePrincipale - dipSenzaCod <= 0.0 && dipSenzaCod > 0.0) {
                imposta = Math.round(0.009 * imponibile);
                return imposta;
            }
            if (imponibile <= 15493.71) {
                imposta = Math.round(0.012 * imponibile);
            } else if (imponibile > 15493.71 && imponibile <= 30987.41) {
                imposta = Math.round(185.92 + 0.013 * (imponibile - 15493.71));
            } else if (imponibile > 30987.41) {
                imposta = Math.round(387.34 + 0.014 * (imponibile - 30987.41));
            }
            return imposta;
        }
        return 0.0;
    }

    public double liquidaCreditoRedditiEsteri(String tipoModello) {
        String mod1 = "00000001";
        String quadro = "";
        String riga = "";
        double comodo = 0.0;
        double CR_anno = 0.0;
        double CR_redditoEstero = 0.0;
        double CR_impostaEstera = 0.0;
        double CR_aliquotaConvenzionale = 0.0;
        double CR_redditoComplessivo = 0.0;
        double CR_impostaLorda = 0.0;
        double creditoMax = 0.0;
        double creditoMaxTot = 0.0;
        double redditoComplessivo = 0.0;
        double creditiImpostaDividendi = 0.0;
        double impostaLorda = 0.0;
        double impostaNetta = 0.0;
        int rigaInizio = 0;
        int rigaFine = 0;
        if (tipoModello.equals("730001")) {
            quadro = "FD";
            rigaInizio = 8;
            rigaFine = 8;
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            creditiImpostaDividendi = this.modello.D("PL007001" + mod1);
            impostaLorda = this.modello.D("PL013001" + mod1);
            impostaNetta = this.modello.D("PL023001" + mod1);
        } else if (tipoModello.equals("730002")) {
            quadro = "FC";
            rigaInizio = 8;
            rigaFine = 8;
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            creditiImpostaDividendi = this.modello.D("PL007002" + mod1);
            impostaLorda = this.modello.D("PL013002" + mod1);
            impostaNetta = this.modello.D("PL023002" + mod1);
        } else if (tipoModello.equals("UPF")) {
            quadro = "CR";
            rigaInizio = 1;
            rigaFine = 5;
            impostaNetta = this.modello.D("ZN020001" + mod1);
        }
        int numMaxMod = this.modello.getDichiarazione().maxModuliDaQuadro(quadro);
        int indmod = 1;
        while (indmod <= numMaxMod) {
            String mioModello = Util.formNum(8, indmod);
            int indriga = rigaInizio;
            while (indriga <= rigaFine) {
                riga = Util.formNum(3, indriga);
                if (this.modello.getDichiarazione().esisteQuadroRigaModello(quadro, riga, mioModello)) {
                    CR_anno = this.modello.D(String.valueOf(quadro) + riga + "001" + mioModello);
                    CR_redditoEstero = this.modello.D(String.valueOf(quadro) + riga + "002" + mioModello);
                    CR_impostaEstera = this.modello.D(String.valueOf(quadro) + riga + "003" + mioModello);
                    CR_redditoComplessivo = this.modello.D(String.valueOf(quadro) + riga + "004" + mioModello);
                    CR_impostaLorda = this.modello.D(String.valueOf(quadro) + riga + "005" + mioModello);
                    if (tipoModello.equals("UPF") && (CR_aliquotaConvenzionale = this.modello.D("MR" + riga + "003" + mioModello)) > 0.0) {
                        CR_impostaEstera = Math.min(CR_impostaEstera, (double)Math.round(CR_redditoEstero * CR_aliquotaConvenzionale / 100.0));
                    }
                    if (CR_anno == 2003.0 && !tipoModello.equals("UPF")) {
                        CR_redditoComplessivo = redditoComplessivo + creditiImpostaDividendi;
                        CR_impostaLorda = impostaLorda;
                    }
                    if (CR_redditoComplessivo > 0.0) {
                        creditoMax = CR_redditoEstero / CR_redditoComplessivo * CR_impostaLorda;
                        creditoMax = Math.round(Math.min(creditoMax, CR_impostaEstera));
                    } else {
                        creditoMax = 0.0;
                    }
                    creditoMaxTot += creditoMax;
                }
                ++indriga;
            }
            ++indmod;
        }
        if (!tipoModello.equals("UPF")) {
            creditoMaxTot = Math.min(creditoMaxTot, impostaNetta);
        }
        return creditoMaxTot;
    }

    public double liquidaDeduzioneProgressivita(String tipoModello) {
        String QuadroC = "";
        String XC = "";
        boolean rc = false;
        String mod1 = "00000001";
        boolean redditoLavAut = false;
        double giorniPens = 0.0;
        double giornilavDip = 0.0;
        double deduzioneTeoricaLavDip = 0.0;
        double deduzioneTeoricaPensione = 0.0;
        double deduzioneTeoricaLavAut = 0.0;
        double deduzioneTeorica = 0.0;
        double deduzioneSpettante = 0.0;
        double coefficiente = 0.0;
        double coefficienteTroncato = 0.0;
        double deduzioneAbitazione = 0.0;
        double oneriDeducibili = 0.0;
        double redditoComplessivo = 0.0;
        double creditiDividendi = 0.0;
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            XC = "XC";
            giornilavDip = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            giorniPens = this.modello.D(String.valueOf(QuadroC) + "004002" + mod1);
            redditoComplessivo = this.modello.D("ZN006001" + mod1);
            creditiDividendi = this.modello.D("ZN007001" + mod1);
            deduzioneAbitazione = this.modello.D("ZN008001" + mod1);
            oneriDeducibili = this.modello.D("ZN009001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            XC = "YC";
            giornilavDip = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            giorniPens = this.modello.D(String.valueOf(QuadroC) + "004002" + mod1);
            redditoComplessivo = this.modello.D("ZN006002" + mod1);
            creditiDividendi = this.modello.D("ZN007002" + mod1);
            deduzioneAbitazione = this.modello.D("ZN008002" + mod1);
            oneriDeducibili = this.modello.D("ZN009002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            XC = "XC";
            giornilavDip = this.modello.D(String.valueOf(QuadroC) + "006001" + mod1);
            giorniPens = this.modello.D(String.valueOf(QuadroC) + "006002" + mod1);
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            creditiDividendi = this.modello.D("RN002001" + mod1);
            deduzioneAbitazione = this.modello.D("RN003001" + mod1);
            oneriDeducibili = this.modello.D("RN004001" + mod1);
            redditoLavAut = this.agevolazioneLavoroAutonomo();
        }
        if (!tipoModello.equals("UPF") && redditoComplessivo <= 0.0 && creditiDividendi == 0.0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(XC));
        if (this.modello.D(stringBuffer.append("005005").append(mod1).toString()) > 0.0) {
            deduzioneTeoricaLavDip = 4500.0 * (giornilavDip / 365.0);
        }
        StringBuffer stringBuffer2 = new StringBuffer(String.valueOf(XC));
        if (this.modello.D(stringBuffer2.append("005004").append(mod1).toString()) > 0.0) {
            deduzioneTeoricaPensione = 4000.0 * (giorniPens / 365.0);
        }
        if (redditoLavAut) {
            deduzioneTeoricaLavAut = 1500.0;
        }
        if ((coefficiente = (26000.0 + (deduzioneTeorica = 3000.0 + Math.max(deduzioneTeoricaLavDip + deduzioneTeoricaPensione, deduzioneTeoricaLavAut)) + deduzioneAbitazione + oneriDeducibili - redditoComplessivo - creditiDividendi) / 26000.0) <= 0.0) {
            coefficiente = 0.0;
        } else if (coefficiente >= 1.0) {
            coefficiente = 1.0;
        } else {
            coefficienteTroncato = this.troncaCoefficienteDeducibilita(coefficiente);
            if (Math.abs(coefficiente - coefficienteTroncato) <= 1.0E-4) {
                coefficiente = coefficienteTroncato;
            }
        }
        deduzioneSpettante = deduzioneTeorica * coefficiente;
        if (deduzioneSpettante > 7500.0) {
            deduzioneSpettante = 7500.0;
        }
        return Math.round(deduzioneSpettante);
    }

    public double liquidaDetrazioneDeterOld(String tipoModello) {
        String QuadroC = "";
        String RC = "";
        String XC = "";
        double redditoComplessivo = 0.0;
        double abitazionePrincipale = 0.0;
        double giorni = 0.0;
        double totaleFabbricati = 0.0;
        int rigaFineSezI = 0;
        int rigaInizioSezII = 0;
        int rigaFineSezII = 0;
        boolean rc = false;
        String mod1 = "00000001";
        String modulo = "";
        double comodo = 0.0;
        double detrazione1 = 0.0;
        double QCsezI = 0.0;
        double[] scaglioniDetrazioniTempoDeterminato = new double[]{0.0, 4700.0, 5165.0, 5681.0, 6197.0};
        double[] detrazioniTempoDeterminato = new double[]{0.0, 207.0, 155.0, 103.0, 52.0};
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            abitazionePrincipale = this.modello.D("PL008001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            totaleFabbricati = this.modello.D("PL003001" + mod1);
            rigaFineSezI = 3;
            rigaInizioSezII = 5;
            rigaFineSezII = 7;
            RC = "RC";
            XC = "XC";
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            abitazionePrincipale = this.modello.D("PL008002" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            totaleFabbricati = this.modello.D("PL003002" + mod1);
            rigaFineSezI = 3;
            rigaInizioSezII = 5;
            rigaFineSezII = 7;
            RC = "SC";
            XC = "YC";
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            abitazionePrincipale = this.modello.D("RN003001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "006001" + mod1);
            totaleFabbricati = this.modello.D("RB011008" + mod1);
            rigaFineSezI = 4;
            rigaInizioSezII = 7;
            rigaFineSezII = 8;
            RC = "RC";
            XC = "XC";
        }
        int numMaxModRC = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroC);
        if (totaleFabbricati != abitazionePrincipale) {
            return 0.0;
        }
        if (totaleFabbricati == redditoComplessivo) {
            return 0.0;
        }
        if (giorni >= 365.0) {
            return 0.0;
        }
        int indmod = 1;
        while (indmod <= numMaxModRC) {
            String miaRiga;
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= rigaFineSezI) {
                miaRiga = Util.formNum(3, indriga);
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(QuadroC));
                if (this.modello.D(stringBuffer.append(miaRiga).append("003").append(mioModello).toString()) > 0.0 && (this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 0.0 || this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 1.0)) {
                    return 0.0;
                }
                ++indriga;
            }
            indriga = rigaInizioSezII;
            while (indriga <= rigaFineSezII) {
                miaRiga = Util.formNum(3, indriga);
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(QuadroC));
                if (this.modello.D(stringBuffer.append(miaRiga).append("002").append(mioModello).toString()) > 0.0 && this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) != 1.0) {
                    return 0.0;
                }
                ++indriga;
            }
            ++indmod;
        }
        QCsezI = this.modello.D(String.valueOf(XC) + "005001" + mod1) == 1.0 ? this.modello.D(String.valueOf(RC) + "005002" + mod1) - this.modello.D(String.valueOf(RC) + "005001" + mod1) : this.modello.D(String.valueOf(RC) + "005002" + mod1);
        comodo = QCsezI + this.modello.D(String.valueOf(RC) + "009001" + mod1) + totaleFabbricati;
        if (comodo != redditoComplessivo) {
            return 0.0;
        }
        if (QCsezI + abitazionePrincipale == redditoComplessivo && QCsezI > 0.0 && giorni == 0.0) {
            return 0.0;
        }
        if (comodo > 6197.0) {
            return 0.0;
        }
        comodo = Util.restituisciValoreIntervallo(redditoComplessivo, scaglioniDetrazioniTempoDeterminato, detrazioniTempoDeterminato);
        return comodo;
    }

    public double liquidaDetrazioneIndeterOld(String tipoModello) {
        String QuadroC = "";
        String RC = "";
        String XC = "";
        double redditoComplessivo = 0.0;
        double abitazionePrincipale = 0.0;
        double giorni = 0.0;
        double totaleFabbricati = 0.0;
        int rigaFineSezI = 0;
        int rigaInizioSezII = 0;
        int rigaFineSezII = 0;
        boolean rc = false;
        String mod1 = "00000001";
        String modulo = "";
        double comodo = 0.0;
        double limite9600 = 0.0;
        double QCsezI = 0.0;
        double[] scaglioniDetrazioniTempoIndeterminato = new double[]{0.0, 4700.0, 4803.0, 4958.0};
        double[] detrazioniTempoIndeterminato = new double[]{0.0, 155.0, 103.0, 52.0};
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            abitazionePrincipale = this.modello.D("PL008001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            totaleFabbricati = this.modello.D("PL003001" + mod1);
            rigaFineSezI = 3;
            rigaInizioSezII = 5;
            rigaFineSezII = 7;
            RC = "RC";
            XC = "XC";
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            abitazionePrincipale = this.modello.D("PL008002" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004001" + mod1);
            totaleFabbricati = this.modello.D("PL003002" + mod1);
            rigaFineSezI = 3;
            rigaInizioSezII = 5;
            rigaFineSezII = 7;
            RC = "SC";
            XC = "YC";
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            abitazionePrincipale = this.modello.D("RN003001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "006001" + mod1);
            totaleFabbricati = this.modello.D("RB011008" + mod1);
            rigaFineSezI = 4;
            rigaInizioSezII = 7;
            rigaFineSezII = 8;
            RC = "RC";
            XC = "XC";
        }
        int numMaxModRC = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroC);
        if (totaleFabbricati != abitazionePrincipale) {
            return 0.0;
        }
        if (totaleFabbricati == redditoComplessivo) {
            return 0.0;
        }
        if (giorni >= 365.0 || giorni == 0.0) {
            return 0.0;
        }
        int indmod = 1;
        while (indmod <= numMaxModRC) {
            String miaRiga;
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= rigaFineSezI) {
                miaRiga = Util.formNum(3, indriga);
                if (this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 1.0 || this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 2.0) {
                    return 0.0;
                }
                ++indriga;
            }
            indriga = rigaInizioSezII;
            while (indriga <= rigaFineSezII) {
                miaRiga = Util.formNum(3, indriga);
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(QuadroC));
                if (this.modello.D(stringBuffer.append(miaRiga).append("002").append(mioModello).toString()) > 0.0) {
                    return 0.0;
                }
                ++indriga;
            }
            ++indmod;
        }
        QCsezI = this.modello.D(String.valueOf(XC) + "005001" + mod1) == 1.0 ? this.modello.D(String.valueOf(RC) + "005002" + mod1) - this.modello.D(String.valueOf(RC) + "005001" + mod1) : this.modello.D(String.valueOf(RC) + "005002" + mod1);
        comodo = QCsezI + totaleFabbricati;
        if (comodo != redditoComplessivo) {
            return 0.0;
        }
        if (comodo > 4958.0) {
            return 0.0;
        }
        comodo = Util.restituisciValoreIntervallo(redditoComplessivo, scaglioniDetrazioniTempoIndeterminato, detrazioniTempoIndeterminato);
        return comodo;
    }

    public double liquidaDetrazioneLavDipOld(String tipoModello) {
        String quadro = "RC";
        double comodo = 0.0;
        double comodo1 = 0.0;
        double giorni = 0.0;
        double detrazioneMax = 0.0;
        double l_RN09 = 0.0;
        String mod1 = "00000001";
        String QuadroC = "";
        String RC = "";
        String XC = "";
        double[] scaglioniDetrazioniLavDip = new double[]{0.0, 6197.0, 6352.0, 6507.0, 7747.0, 7902.0, 8057.0, 8212.0, 8263.0, 8780.0, 9296.0, 9813.0, 15494.0, 20658.0, 25823.0, 30987.0, 31142.0, 36152.0, 41317.0, 46481.0, 46688.0, 51646.0, 0.0};
        double[] detrazioniLavDip = new double[]{0.0, 1146.53, 1084.56, 1032.91, 981.27, 903.8, 826.33, 748.86, 686.89, 650.74, 614.58, 578.43, 542.28, 490.63, 438.99, 387.34, 335.7, 284.05, 232.41, 180.76, 129.11, 77.47, 51.65};
        if (tipoModello.equals("730001")) {
            giorni = this.modello.D("CD004001" + mod1) + this.modello.D("CD004002" + mod1);
            RC = "RC";
            XC = "XC";
        }
        if (tipoModello.equals("730002")) {
            giorni = this.modello.D("CC004001" + mod1) + this.modello.D("CC004002" + mod1);
            RC = "SC";
            XC = "YC";
        }
        if (tipoModello.equals("UPF")) {
            giorni = this.modello.D("RC006001" + mod1) + this.modello.D("RC006002" + mod1);
            RC = "RC";
            XC = "XC";
        }
        if (giorni > 365.0) {
            giorni = 365.0;
        }
        comodo = this.modello.D(String.valueOf(XC) + "005001" + mod1) == 1.0 ? this.modello.D(String.valueOf(RC) + "005002" + mod1) - this.modello.D(String.valueOf(RC) + "005001" + mod1) : this.modello.D(String.valueOf(RC) + "005002" + mod1);
        detrazioneMax = Util.restituisciValoreIntervallo(comodo, scaglioniDetrazioniLavDip, detrazioniLavDip);
        comodo = detrazioneMax * giorni / 365.0;
        return Math.round(comodo);
    }

    public double liquidaDetrazioneLavDipPensNew(String tipoModello) {
        double comodo = 0.0;
        String mod1 = "00000001";
        String XC = "";
        double redditoComplessivoNetto = 0.0;
        double detrazLavDip = 0.0;
        double detrazPens = 0.0;
        double detrazLavAut = 0.0;
        boolean lavoroAutonomo = false;
        if (tipoModello.equals("730001")) {
            XC = "XC";
            redditoComplessivoNetto = this.modello.D("ZN006001" + mod1) - this.modello.D("ZN008001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            XC = "YC";
            redditoComplessivoNetto = this.modello.D("ZN006002" + mod1) - this.modello.D("ZN008002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            XC = "XC";
            redditoComplessivoNetto = this.modello.D("RN001004" + mod1) - this.modello.D("RN003001" + mod1);
            lavoroAutonomo = this.agevolazioneLavoroAutonomo();
        }
        double lavDip = this.modello.D(String.valueOf(XC) + "005005" + mod1);
        double Pens = this.modello.D(String.valueOf(XC) + "005004" + mod1);
        if (lavDip > 0.0) {
            if (redditoComplessivoNetto > 27000.0 && redditoComplessivoNetto <= 29500.0) {
                detrazLavDip = 130.0;
            } else if (redditoComplessivoNetto > 29500.0 && redditoComplessivoNetto <= 36500.0) {
                detrazLavDip = 235.0;
            } else if (redditoComplessivoNetto > 36500.0 && redditoComplessivoNetto <= 41500.0) {
                detrazLavDip = 180.0;
            } else if (redditoComplessivoNetto > 41500.0 && redditoComplessivoNetto <= 46700.0) {
                detrazLavDip = 130.0;
            } else if (redditoComplessivoNetto > 46700.0 && redditoComplessivoNetto <= 52000.0) {
                detrazLavDip = 25.0;
            }
        }
        if (Pens > 0.0) {
            if (redditoComplessivoNetto > 24500.0 && redditoComplessivoNetto <= 27000.0) {
                detrazPens = 70.0;
            } else if (redditoComplessivoNetto > 27000.0 && redditoComplessivoNetto <= 29000.0) {
                detrazPens = 170.0;
            } else if (redditoComplessivoNetto > 29000.0 && redditoComplessivoNetto <= 31000.0) {
                detrazPens = 290.0;
            } else if (redditoComplessivoNetto > 31000.0 && redditoComplessivoNetto <= 36500.0) {
                detrazPens = 230.0;
            } else if (redditoComplessivoNetto > 36500.0 && redditoComplessivoNetto <= 41500.0) {
                detrazPens = 180.0;
            } else if (redditoComplessivoNetto > 41500.0 && redditoComplessivoNetto <= 46700.0) {
                detrazPens = 130.0;
            } else if (redditoComplessivoNetto > 46700.0 && redditoComplessivoNetto <= 52000.0) {
                detrazPens = 25.0;
            }
        }
        if (lavoroAutonomo) {
            if (redditoComplessivoNetto > 25500.0 && redditoComplessivoNetto <= 29400.0) {
                detrazLavAut = 80.0;
            } else if (redditoComplessivoNetto > 29400.0 && redditoComplessivoNetto <= 31000.0) {
                detrazLavAut = 126.0;
            } else if (redditoComplessivoNetto > 31000.0 && redditoComplessivoNetto <= 32000.0) {
                detrazLavAut = 80.0;
            }
        }
        return Math.max(Math.max(detrazLavDip, detrazPens), detrazLavAut);
    }

    public double liquidaDetrazionePensioneOld(String tipoModello) {
        double[] detrazioniPens;
        double[] scaglioniDetrazioniPens;
        double comodo = 0.0;
        double pensione = 0.0;
        double limite18_19 = 0.0;
        double detrazioneMax = 0.0;
        double l_RN11 = 0.0;
        double anni = 0.0;
        String mod1 = "00000001";
        String QuadroC = "";
        String dataNascita = "";
        double redditoComplessivo = 0.0;
        double deduzioneAbitazione = 0.0;
        double giorni = 0.0;
        double totaleFabbricati = 0.0;
        double totaleTerreni = 0.0;
        int rigaFineSezI = 0;
        double[] scaglioniDetrazioniPensSopraEuro = new double[]{0.0, 4855.0, 9296.0, 9554.0, 9813.0};
        double[] detrazioniPensSopraEuro = new double[]{0.0, 222.08, 185.92, 92.96, 46.48};
        double[] scaglioniDetrazioniPensSottoEuro = new double[]{0.0, 4855.0, 9296.0};
        double[] detrazioniPensSottoEuro = new double[]{0.0, 98.13, 61.97};
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            deduzioneAbitazione = this.modello.D("PL008001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004002" + mod1);
            totaleFabbricati = this.modello.D("PL003001" + mod1);
            totaleTerreni = this.modello.D("PL001001" + mod1) + this.modello.D("PL002001" + mod1);
            rigaFineSezI = 3;
            dataNascita = this.modello.BS(20).trim();
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            deduzioneAbitazione = this.modello.D("PL008002" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "004002" + mod1);
            totaleFabbricati = this.modello.D("PL003002" + mod1);
            totaleTerreni = this.modello.D("PL001002" + mod1) + this.modello.D("PL002002" + mod1);
            rigaFineSezI = 3;
            dataNascita = this.modello.BS(68).trim();
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            deduzioneAbitazione = this.modello.D("RN003001" + mod1);
            giorni = this.modello.D(String.valueOf(QuadroC) + "006002" + mod1);
            totaleFabbricati = this.modello.D("RB011008" + mod1);
            totaleTerreni = this.modello.D("RA011009" + mod1) + this.modello.D("RA011010" + mod1);
            rigaFineSezI = 4;
            dataNascita = this.modello.BS(40).trim();
        }
        if ((anni = dataNascita.length() == 8 && Util.isNumericoAssoluto(dataNascita) ? Util.valoreDouble(dataNascita.substring(4, 8)) : 1930.0) > 1928.0) {
            scaglioniDetrazioniPens = scaglioniDetrazioniPensSottoEuro;
            detrazioniPens = detrazioniPensSottoEuro;
            limite18_19 = 9296.0;
        } else {
            scaglioniDetrazioniPens = scaglioniDetrazioniPensSopraEuro;
            detrazioniPens = detrazioniPensSopraEuro;
            limite18_19 = 9813.0;
        }
        int numMaxModRC = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroC);
        if (totaleFabbricati != deduzioneAbitazione || totaleTerreni > 186.0) {
            return 0.0;
        }
        int indmod = 1;
        while (indmod <= numMaxModRC) {
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= rigaFineSezI) {
                String riga = Util.formNum(3, indriga);
                if (this.modello.D(String.valueOf(QuadroC) + riga + "001" + mioModello) == 1.0) {
                    pensione += this.modello.D(String.valueOf(QuadroC) + riga + "003" + mioModello);
                }
                ++indriga;
            }
            ++indmod;
        }
        if (pensione > limite18_19) {
            return 0.0;
        }
        comodo = pensione + totaleFabbricati + totaleTerreni;
        if (comodo != redditoComplessivo) {
            return 0.0;
        }
        detrazioneMax = Util.restituisciValoreIntervallo(pensione, scaglioniDetrazioniPens, detrazioniPens);
        comodo = detrazioneMax * giorni / 365.0;
        return Math.round(comodo);
    }

    public double[] liquidaDetrazioniFamiliari(String tipoModello) {
        String QuadroFam = "GD";
        String mod1 = "00000001";
        String CF2 = "";
        String colonnaConiuge = "";
        String tipo = "";
        String cfFam = "";
        double redditoComplessivo = 0.0;
        double numeroFigli = 0.0;
        double presunzione = 0.0;
        double mesi = 0.0;
        double anni3 = 0.0;
        double percentuale = 0.0;
        String percentualeCon = "";
        int[] comodo2 = new int[2];
        boolean rc = false;
        double comodo = 0.0;
        double detrazFiglioConiuge = 0.0;
        double detrazione3Anni = 0.0;
        double detrazioneMaxConiuge = 0.0;
        double detrazioneMaxAltroFamiliare = 0.0;
        double detrazioneFiglio = 0.0;
        double detrazioneMaxPrimoFiglio = 0.0;
        double detrazioneMaxSuccessivoFiglio = 0.0;
        double PL13 = 0.0;
        double PL14_Con = 0.0;
        double PL14_Fam = 0.0;
        double PL14 = 0.0;
        double[] detrazioni = new double[]{0.0, 0.0};
        boolean detrazione516 = false;
        if (tipoModello.equals("730001")) {
            CF2 = this.modello.BS(65);
            QuadroFam = "GD";
            colonnaConiuge = "002";
            redditoComplessivo = this.modello.D("ZN006001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            CF2 = this.modello.BS(2);
            QuadroFam = "GC";
            colonnaConiuge = "001";
            redditoComplessivo = this.modello.D("ZN006002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            CF2 = this.modello.BS(2);
            QuadroFam = "FA";
            redditoComplessivo = this.modello.D("RN001004" + mod1);
        }
        int numMaxMod = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroFam);
        double[] scaglioniDetrazioniConiuge = new double[]{0.0, 15494.0, 30987.0, 51646.0, 0.0};
        double[] detrazioniConiuge = new double[]{0.0, 546.18, 496.6, 459.42, 422.23};
        detrazioneMaxConiuge = redditoComplessivo <= 0.0 ? 546.18 : Util.restituisciValoreIntervallo(redditoComplessivo, scaglioniDetrazioniConiuge, detrazioniConiuge);
        if (this.assistenza && this.modello.D("XN009000" + mod1) != 0.0) {
            numeroFigli = this.modello.D("XN009000" + mod1);
        } else {
            comodo2 = this.restituisciNumFigli(QuadroFam);
            numeroFigli = comodo2[0];
        }
        if (numeroFigli == 0.0 || numeroFigli == 1.0) {
            if (redditoComplessivo <= 36152.0) {
                detrazioneMaxPrimoFiglio = 516.46;
            }
            if (redditoComplessivo > 36152.0 && redditoComplessivo <= 51646.0) {
                detrazioneMaxPrimoFiglio = 303.68;
            }
            if (redditoComplessivo > 51646.0) {
                detrazioneMaxPrimoFiglio = 285.08;
            }
        }
        if (numeroFigli == 2.0) {
            if (redditoComplessivo <= 41317.0) {
                detrazioneMaxPrimoFiglio = 516.46;
                detrazioneMaxSuccessivoFiglio = 516.46;
            }
            if (redditoComplessivo > 41317.0 && redditoComplessivo <= 51646.0) {
                detrazioneMaxPrimoFiglio = 303.68;
                detrazioneMaxSuccessivoFiglio = 336.73;
            }
            if (redditoComplessivo > 51646.0) {
                detrazioneMaxPrimoFiglio = 285.08;
                detrazioneMaxSuccessivoFiglio = 285.08;
            }
        }
        if (numeroFigli == 3.0) {
            if (redditoComplessivo <= 46481.0) {
                detrazioneMaxPrimoFiglio = 516.46;
                detrazioneMaxSuccessivoFiglio = 516.46;
            }
            if (redditoComplessivo > 46481.0 && redditoComplessivo <= 51646.0) {
                detrazioneMaxPrimoFiglio = 303.68;
                detrazioneMaxSuccessivoFiglio = 336.73;
            }
            if (redditoComplessivo > 51646.0) {
                detrazioneMaxPrimoFiglio = 285.08;
                detrazioneMaxSuccessivoFiglio = 285.08;
            }
        }
        if (numeroFigli >= 4.0) {
            detrazioneMaxPrimoFiglio = 516.46;
            detrazioneMaxSuccessivoFiglio = 516.46;
        }
        if (detrazioneMaxPrimoFiglio == 516.46) {
            detrazione516 = true;
        }
        detrazioneMaxAltroFamiliare = redditoComplessivo > 51646.0 ? 285.08 : 303.68;
        int indmod = 1;
        while (indmod <= numMaxMod) {
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= 6) {
                String riga = Util.formNum(3, indriga);
                tipo = this.modello.S(String.valueOf(QuadroFam) + riga + "001" + mioModello);
                cfFam = this.modello.S(String.valueOf(QuadroFam) + riga + "004" + mioModello);
                mesi = this.modello.D(String.valueOf(QuadroFam) + riga + "005" + mioModello);
                anni3 = this.modello.D(String.valueOf(QuadroFam) + riga + "006" + mioModello);
                percentuale = this.modello.D(String.valueOf(QuadroFam) + riga + "A07" + mioModello);
                percentualeCon = this.modello.S(String.valueOf(QuadroFam) + riga + "B07" + mioModello);
                comodo = 0.0;
                detrazFiglioConiuge = 0.0;
                detrazione3Anni = 0.0;
                if (this.modello.getDichiarazione().esisteQuadroRigaModello(QuadroFam, riga, mioModello) && (this.assistenza || !this.restituisciCFfamiliariScartati(this.modello.S(String.valueOf(QuadroFam) + riga + "004" + mioModello)))) {
                    if (indriga == 1 && (PL13 += (comodo = detrazioneMaxConiuge * mesi / 12.0)) > detrazioneMaxConiuge) {
                        PL13 = detrazioneMaxConiuge;
                    }
                    if (indriga > 1) {
                        if (indriga == 2) {
                            detrazioneFiglio = detrazioneMaxPrimoFiglio;
                        } else {
                            detrazioneFiglio = detrazioneMaxSuccessivoFiglio;
                            if (indriga == 3 && percentualeCon.equals("C") && cfFam.length() > 0 && this.modello.S(String.valueOf(QuadroFam) + "002004" + mioModello).length() > 0 && cfFam.equals(this.modello.S(String.valueOf(QuadroFam) + "002004" + mioModello))) {
                                detrazioneFiglio = detrazioneMaxPrimoFiglio;
                            }
                        }
                        if (tipo.equals("A")) {
                            comodo = detrazioneMaxAltroFamiliare * (mesi / 12.0) * (percentuale / 100.0);
                            if (comodo > detrazioneMaxAltroFamiliare) {
                                comodo = detrazioneMaxAltroFamiliare;
                            }
                            PL14_Fam += comodo;
                        }
                        if (tipo.equals("D")) {
                            comodo = percentualeCon.equals("C") ? 774.69 * (mesi / 12.0) : 774.69 * (mesi / 12.0) * (percentuale / 100.0);
                            if (comodo > 774.69) {
                                comodo = 774.69;
                            }
                            PL14_Fam += comodo;
                        }
                        if (tipo.equals("F") && !percentualeCon.equals("C")) {
                            comodo = detrazioneFiglio * (mesi / 12.0) * (percentuale / 100.0);
                            if (comodo > detrazioneFiglio) {
                                comodo = detrazioneFiglio;
                            }
                            if (!detrazione516) {
                                detrazione3Anni = 123.95 * (anni3 / 12.0) * (percentuale / 100.0);
                            }
                            if (detrazione3Anni > 123.95) {
                                detrazione3Anni = 123.95;
                            }
                            PL14_Fam = PL14_Fam + comodo + detrazione3Anni;
                        }
                        if (tipo.equals("F") && percentualeCon.equals("C")) {
                            comodo = detrazioneFiglio * (mesi / 12.0);
                            if (comodo > detrazioneFiglio) {
                                comodo = detrazioneFiglio;
                            }
                            if (!detrazione516) {
                                detrazione3Anni = 123.95 * (anni3 / 12.0) * (percentuale / 100.0);
                            }
                            if (detrazione3Anni > 123.95) {
                                detrazione3Anni = 123.95;
                            }
                            if ((comodo += detrazione3Anni) > (detrazFiglioConiuge = detrazioneMaxConiuge * mesi / 12.0)) {
                                PL14_Fam += comodo;
                            } else {
                                PL14_Con += detrazFiglioConiuge;
                            }
                        }
                    }
                }
                ++indriga;
            }
            ++indmod;
        }
        if (PL13 + PL14_Con > detrazioneMaxConiuge) {
            PL14_Con = detrazioneMaxConiuge - PL13;
        }
        if (PL14_Con < 0.0) {
            PL14_Con = 0.0;
        }
        if (tipoModello.equals("730001") || tipoModello.equals("730002")) {
            if (!this.detrazioneConiuge) {
                PL13 = 0.0;
                PL14_Con = 0.0;
            }
            if (CF2.equals(this.modello.S(String.valueOf(QuadroFam) + "001004" + mod1))) {
                StringBuffer stringBuffer = new StringBuffer("ZN006");
                if (this.modello.D(stringBuffer.append(colonnaConiuge).append(mod1).toString()) > 2841.0) {
                    PL13 = 0.0;
                }
            }
        }
        PL14 = PL14_Con + PL14_Fam;
        detrazioni[0] = Math.round(PL13);
        detrazioni[1] = Math.round(PL14);
        return detrazioni;
    }

    public double liquidaImpostaDaScaglioniNew(double imponibile) {
        double imposta = 0.0;
        if (imponibile <= 15000.0) {
            imposta = Math.round(0.23 * imponibile);
        }
        if (imponibile > 15000.0 && imponibile <= 29000.0) {
            imposta = Math.round(3450.0 + 0.29 * (imponibile - 15000.0));
        }
        if (imponibile > 29000.0 && imponibile <= 32600.0) {
            imposta = Math.round(7510.0 + 0.31 * (imponibile - 29000.0));
        }
        if (imponibile > 32600.0 && imponibile <= 70000.0) {
            imposta = Math.round(8626.0 + 0.39 * (imponibile - 32600.0));
        }
        if (imponibile > 70000.0) {
            imposta = Math.round(23212.0 + 0.45 * (imponibile - 70000.0));
        }
        return imposta;
    }

    public double liquidaImpostaLordaNew(String tipoModello) {
        return this.liquidaImpostaLordaNew(tipoModello, 0.0);
    }

    public double liquidaImpostaLordaNew(String tipoModello, double imponibile) {
        double Pens;
        String QuadroC = "";
        String XC = "";
        boolean rc = false;
        String mod1 = "00000001";
        double totaleTerreni = 0.0;
        double totaleFabbricati = 0.0;
        double redditoComplessivo = 0.0;
        double deduzioneAbitazione = 0.0;
        double redditoImponibile = 0.0;
        double sportiviTitoloImposta = 0.0;
        double comodo = 0.0;
        double DIT = 0.0;
        double impostaLorda = 0.0;
        double impostaLordaC3 = 0.0;
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            XC = "XC";
            totaleTerreni = this.modello.D("ZN001001" + mod1) + this.modello.D("ZN002001" + mod1);
            totaleFabbricati = this.modello.D("ZN003001" + mod1);
            redditoComplessivo = this.modello.D("ZN006001" + mod1);
            deduzioneAbitazione = this.modello.D("ZN008001" + mod1);
            redditoImponibile = this.modello.D("ZN011001" + mod1);
            sportiviTitoloImposta = this.modello.D("ZN012001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            XC = "YC";
            totaleTerreni = this.modello.D("ZN001002" + mod1) + this.modello.D("ZN002002" + mod1);
            totaleFabbricati = this.modello.D("ZN003002" + mod1);
            redditoComplessivo = this.modello.D("ZN006002" + mod1);
            deduzioneAbitazione = this.modello.D("ZN008002" + mod1);
            redditoImponibile = this.modello.D("ZN011002" + mod1);
            sportiviTitoloImposta = this.modello.D("ZN012002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            XC = "XC";
            totaleTerreni = this.modello.D("RA011009" + mod1) + this.modello.D("RA011010" + mod1);
            totaleFabbricati = this.modello.D("RB011008" + mod1);
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            deduzioneAbitazione = this.modello.D("RN003001" + mod1);
            sportiviTitoloImposta = this.modello.D("RL025001" + mod1);
            DIT = this.modello.D("RJ012001" + mod1) > 0.0 ? this.modello.D("RJ012001" + mod1) : this.modello.D("RH015002" + mod1);
            if (DIT > 15000.0) {
                DIT = 15000.0;
            }
            redditoImponibile = imponibile > 0.0 ? imponibile : this.modello.D("RN006004" + mod1);
        }
        if ((Pens = this.modello.D(String.valueOf(XC) + "005004" + mod1)) > 0.0 && Pens <= 7500.0 && redditoComplessivo == totaleTerreni + deduzioneAbitazione + Pens && totaleTerreni <= 186.0) {
            return 0.0;
        }
        impostaLorda = this.liquidaImpostaDaScaglioniNew(redditoImponibile + sportiviTitoloImposta + DIT);
        comodo = impostaLorda - (impostaLordaC3 = this.liquidaImpostaDaScaglioniNew(sportiviTitoloImposta + DIT));
        if (comodo < 0.0) {
            comodo = 0.0;
        }
        return comodo;
    }

    public double liquidaImpostaLordaOld(double imponibile) {
        double imposta = 0.0;
        if (imponibile <= 10329.14) {
            imposta = Math.round(0.18 * imponibile);
        }
        if (imponibile > 10329.14 && imponibile <= 15493.71) {
            imposta = Math.round(1859.25 + 0.24 * (imponibile - 10329.14));
        }
        if (imponibile > 15493.71 && imponibile <= 30987.41) {
            imposta = Math.round(3098.75 + 0.32 * (imponibile - 15493.71));
        }
        if (imponibile > 30987.41 && imponibile <= 69721.68) {
            imposta = Math.round(8056.73 + 0.39 * (imponibile - 30987.41));
        }
        if (imponibile > 69721.68) {
            imposta = Math.round(23163.1 + 0.45 * (imponibile - 69721.68));
        }
        return imposta;
    }

    public double liquidaImpostaNettaNew(String tipoModello, String quadro) {
        double Pens;
        String QuadroC = "";
        String XC = "";
        boolean rc = false;
        String mod1 = "00000001";
        double totaleTerreni = 0.0;
        double redditoComplessivo = 0.0;
        double deduzioneAbitazione = 0.0;
        double redditoImponibile = 0.0;
        double impostaLorda = 0.0;
        double totaleDetrazioni = 0.0;
        double maxImposta = 0.0;
        double impostaNetta = 0.0;
        String QQ = "ZN";
        if (quadro.equals("PL")) {
            QQ = quadro;
        }
        if (tipoModello.equals("730001")) {
            QuadroC = "CD";
            XC = "XC";
            totaleTerreni = this.modello.D(String.valueOf(QQ) + "001001" + mod1) + this.modello.D(String.valueOf(QQ) + "002001" + mod1);
            redditoComplessivo = this.modello.D(String.valueOf(QQ) + "006001" + mod1);
            deduzioneAbitazione = this.modello.D(String.valueOf(QQ) + "008001" + mod1);
            redditoImponibile = this.modello.D(String.valueOf(QQ) + "011001" + mod1);
            impostaLorda = this.modello.D(String.valueOf(QQ) + "013001" + mod1);
            totaleDetrazioni = this.modello.D(String.valueOf(QQ) + "022001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            QuadroC = "CC";
            XC = "YC";
            totaleTerreni = this.modello.D(String.valueOf(QQ) + "001002" + mod1) + this.modello.D(String.valueOf(QQ) + "002002" + mod1);
            redditoComplessivo = this.modello.D(String.valueOf(QQ) + "006002" + mod1);
            deduzioneAbitazione = this.modello.D(String.valueOf(QQ) + "008002" + mod1);
            redditoImponibile = this.modello.D(String.valueOf(QQ) + "011002" + mod1);
            impostaLorda = this.modello.D(String.valueOf(QQ) + "013002" + mod1);
            totaleDetrazioni = this.modello.D(String.valueOf(QQ) + "022002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            QuadroC = "RC";
            XC = "XC";
            totaleTerreni = this.modello.D("RA011009" + mod1) + this.modello.D("RA011010" + mod1);
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            deduzioneAbitazione = this.modello.D("RN003001" + mod1);
            impostaLorda = this.modello.D(String.valueOf(quadro) + "007004" + mod1);
            totaleDetrazioni = this.modello.D(String.valueOf(quadro) + "015001" + mod1) + this.modello.D("RN019001" + mod1);
        }
        if ((impostaNetta = impostaLorda - totaleDetrazioni) < 0.0) {
            impostaNetta = 0.0;
        }
        if ((Pens = this.modello.D(String.valueOf(XC) + "005004" + mod1)) > 7500.0 && Pens <= 7800.0 && redditoComplessivo == totaleTerreni + deduzioneAbitazione + Pens && totaleTerreni <= 186.0) {
            maxImposta = redditoComplessivo - (totaleTerreni + deduzioneAbitazione) - 7500.0;
            if (maxImposta < 0.0) {
                maxImposta = 0.0;
            }
            impostaNetta = Math.min(impostaNetta, maxImposta);
        }
        return impostaNetta;
    }

    public double[] liquidaPrevidenzaComplementare(String tipoModello) {
        String mod1 = "00000001";
        double[] rigoE23 = new double[]{0.0, 0.0};
        double redditoComplessivo = 0.0;
        if (tipoModello.equals("730001")) {
            redditoComplessivo = this.modello.D("PL006001" + mod1);
        }
        if (tipoModello.equals("730002")) {
            redditoComplessivo = this.modello.D("PL006002" + mod1);
        }
        if (tipoModello.equals("UPF")) {
            redditoComplessivo = this.modello.D("RN001004" + mod1);
        }
        if (redditoComplessivo <= 2841.0) {
            return rigoE23;
        }
        rigoE23 = this.liquidaPrevidenzaComplementareNonCarico(tipoModello);
        return rigoE23;
    }

    public double[] liquidaPrevidenzaComplementareNonCarico(String tipoModello) {
        String mod1 = "00000001";
        String quadro = "";
        String QuadroC = "";
        String XC = "";
        String rigaPrevidenza = "";
        int numRigheQuadroC = 0;
        double comodo = 0.0;
        double A = 0.0;
        double B = 0.0;
        double C = 0.0;
        double[] rigoE23 = new double[]{0.0, 0.0};
        double[] comodo2 = new double[]{0.0, 0.0};
        double redditoComplessivo = 0.0;
        double redditiLavDipconTFR = 0.0;
        double tettoMassimo = 0.0;
        double deduzioneMassima = 0.0;
        double quotaPersonaleMassima = 0.0;
        double R1 = 0.0;
        double R2 = 0.0;
        double limiteRedditualeComplessivo = 0.0;
        double quotaPersonaleDeducibile = 0.0;
        double tettoMassimoFamiliare = 0.0;
        double comodoFamiliareA = 0.0;
        double comodoFamiliareB = 0.0;
        double quotaFamiliare = 0.0;
        if (tipoModello.equals("730001")) {
            quadro = "ED";
            QuadroC = "CD";
            rigaPrevidenza = "023";
            redditoComplessivo = this.modello.D("PL006001" + mod1);
            numRigheQuadroC = 3;
            XC = "XC";
        }
        if (tipoModello.equals("730002")) {
            quadro = "EC";
            QuadroC = "CC";
            rigaPrevidenza = "023";
            redditoComplessivo = this.modello.D("PL006002" + mod1);
            numRigheQuadroC = 3;
            XC = "YC";
        }
        if (tipoModello.equals("UPF")) {
            quadro = "RP";
            QuadroC = "RC";
            rigaPrevidenza = "024";
            redditoComplessivo = this.modello.D("RN001004" + mod1);
            numRigheQuadroC = 4;
            XC = "XC";
        }
        double colonna1 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "001" + mod1);
        double colonna2 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "002" + mod1);
        double colonna3 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "003" + mod1);
        double colonna4 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "004" + mod1);
        double colonna5 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "005" + mod1);
        double colonna6 = this.modello.D(String.valueOf(quadro) + rigaPrevidenza + "006" + mod1);
        boolean LavSocConcorrono = this.modello.D(String.valueOf(XC) + "005001" + mod1) == 0.0;
        int numMaxMod = this.modello.getDichiarazione().maxModuliDaQuadro(QuadroC);
        int indmod = 1;
        while (indmod <= numMaxMod) {
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= numRigheQuadroC) {
                String miaRiga = Util.formNum(3, indriga);
                if ((this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 0.0 || this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 2.0 || this.modello.D(String.valueOf(QuadroC) + miaRiga + "001" + mioModello) == 3.0 && LavSocConcorrono) && this.modello.D(String.valueOf(QuadroC) + miaRiga + "002" + mioModello) != 1.0) {
                    redditiLavDipconTFR += this.modello.D(String.valueOf(QuadroC) + miaRiga + "003" + mioModello);
                }
                ++indriga;
            }
            ++indmod;
        }
        if (colonna1 == 0.0 || colonna1 == 3.0 || colonna1 == 4.0) {
            A = 5165.0 - colonna4;
            if (A < 0.0) {
                A = 0.0;
            }
            if ((B = 0.12 * redditoComplessivo - colonna4) < 0.0) {
                B = 0.0;
            }
            tettoMassimo = Math.min(A, B);
        }
        if (colonna1 == 1.0) {
            A = Math.max(5165.0, colonna6);
            B = A - colonna4;
            if (B < 0.0) {
                B = 0.0;
            }
            if ((C = 0.12 * redditoComplessivo - colonna4) < 0.0) {
                C = 0.0;
            }
            tettoMassimo = Math.min(B, C);
        }
        if (colonna1 == 2.0) {
            tettoMassimo = colonna3;
        }
        deduzioneMassima = Math.min(tettoMassimo, colonna3);
        comodo = colonna3 - colonna2;
        if (comodo < 0.0) {
            comodo = 0.0;
        }
        quotaPersonaleMassima = Math.min(deduzioneMassima, comodo);
        R1 = redditiLavDipconTFR - colonna4;
        if (R1 < 0.0) {
            R1 = 0.0;
        }
        if (colonna5 > 0.0 && (colonna1 == 0.0 || colonna1 == 3.0 || colonna1 == 4.0) && (R1 = (comodo = Math.min(redditiLavDipconTFR, colonna5 * 2.0)) - colonna4) < 0.0) {
            R1 = 0.0;
        }
        if (colonna5 == 0.0 && colonna1 == 4.0) {
            R1 = 0.0;
        }
        if ((R2 = redditoComplessivo - redditiLavDipconTFR) < 0.0) {
            R2 = 0.0;
        }
        limiteRedditualeComplessivo = R1 + R2;
        quotaPersonaleDeducibile = Math.min(limiteRedditualeComplessivo, quotaPersonaleMassima);
        A = 5165.0 - colonna4;
        if (A < 0.0) {
            A = 0.0;
        }
        if ((B = 0.12 * redditoComplessivo - colonna4) < 0.0) {
            B = 0.0;
        }
        if ((comodoFamiliareB = (comodoFamiliareA = Math.min(tettoMassimoFamiliare = Math.min(A, B), deduzioneMassima)) - quotaPersonaleDeducibile) < 0.0) {
            comodoFamiliareB = 0.0;
        }
        rigoE23[0] = quotaFamiliare = Math.min(colonna2, comodoFamiliareB);
        rigoE23[1] = quotaFamiliare + quotaPersonaleDeducibile;
        return rigoE23;
    }

    public String liquidaScelte(int scelta1) {
        String diagnostico = "";
        int no_scelta = this.modello.BI(scelta1 + 7);
        int anomalia = this.modello.BI(scelta1 + 8);
        int firme = Util.contaCampiPresenti(this.modello.recordB, scelta1, scelta1 + 6);
        if (firme == 0 && no_scelta == 0) {
            diagnostico = "1346";
        }
        if (firme != 0 && no_scelta == 1) {
            diagnostico = "1347";
        }
        if (firme == 0 && anomalia != 0 && anomalia != 4) {
            diagnostico = "1348";
        }
        if (firme == 1 && anomalia != 0 && anomalia != 3) {
            diagnostico = "1349";
        }
        if (firme > 1 && anomalia != 1 && anomalia != 2 && anomalia != 3) {
            diagnostico = "1350";
        }
        return diagnostico;
    }

    public int[] restituisciCasiAmmessiRistrutturazione(int eta, int anno, int codice, boolean rideterminazione) {
        boolean boschi = codice == 3;
        int[] rate_ammesse = new int[2];
        rate_ammesse[0] = eta >= 75 && rideterminazione ? 1 : 2004 - anno;
        rate_ammesse[1] = eta < 75 ? (anno < 2002 ? 5 : (boschi ? 5 : 10)) : (eta < 80 ? (anno < 2002 ? 5 : (anno == 2002 ? (boschi || rideterminazione ? 5 : 10) : 5)) : (anno < 2002 ? (rideterminazione ? 3 : 5) : (anno == 2002 ? (rideterminazione ? 3 : (boschi ? 5 : 10)) : 3)));
        return rate_ammesse;
    }

    public boolean restituisciCFfamiliariScartati(String CF2) {
        String mioCF = "";
        Enumeration listaCF = this.CFfamiliariScartati.elements();
        while (listaCF.hasMoreElements()) {
            mioCF = (String)listaCF.nextElement();
            if (!mioCF.equals(CF2)) continue;
            return true;
        }
        return false;
    }

    public int[] restituisciNumFigli(String quadro) {
        int[] comodo2 = new int[2];
        String mod1 = "00000001";
        String tipo = "";
        String cfFam = "";
        double mesi = 0.0;
        double anni3 = 0.0;
        double percentuale = 0.0;
        String[] cfPresenti = new String[30];
        int ind = 0;
        int ctrCfAssenti = 0;
        int ctrCfPresenti = 0;
        boolean usaTabella = false;
        boolean trovato = false;
        double comodo = 0.0;
        double totMesi = 0.0;
        int numMaxMod = this.modello.getDichiarazione().maxModuliDaQuadro(quadro);
        int indmod = 1;
        while (indmod <= numMaxMod) {
            String mioModello = Util.formNum(8, indmod);
            int indriga = 1;
            while (indriga <= 6) {
                String riga = Util.formNum(3, indriga);
                tipo = this.modello.S(String.valueOf(quadro) + riga + "001" + mioModello);
                cfFam = this.modello.S(String.valueOf(quadro) + riga + "004" + mioModello);
                mesi = this.modello.D(String.valueOf(quadro) + riga + "005" + mioModello);
                anni3 = this.modello.D(String.valueOf(quadro) + riga + "006" + mioModello);
                percentuale = this.modello.D(String.valueOf(quadro) + riga + "A07" + mioModello);
                if (tipo.equals("F") || tipo.equals("D")) {
                    if (!cfFam.equals("0")) {
                        trovato = false;
                        int indCf = 1;
                        while (indCf < cfPresenti.length) {
                            if (cfFam.equals(cfPresenti[indCf])) {
                                trovato = true;
                                break;
                            }
                            ++indCf;
                        }
                        if (!trovato) {
                            cfPresenti[++ind] = cfFam;
                        }
                    } else {
                        ++ctrCfAssenti;
                        totMesi += mesi;
                        if (mesi < 12.0 && percentuale != 100.0 && anni3 == 0.0) {
                            usaTabella = true;
                        }
                    }
                }
                ++indriga;
            }
            ++indmod;
        }
        ctrCfPresenti = ind;
        int presunzione = 0;
        if (ctrCfAssenti > 1 && usaTabella) {
            presunzione = 1;
        }
        if (!this.assistenza && presunzione == 1) {
            ctrCfAssenti = totMesi <= 12.0 ? 1 : (totMesi <= 24.0 ? 2 : (totMesi <= 36.0 ? 3 : 4));
        }
        comodo2[0] = ctrCfPresenti + ctrCfAssenti;
        comodo2[1] = presunzione;
        return comodo2;
    }

    public String restituisciRegione(String prov) {
        boolean trovato = false;
        String[] provincia = new String[]{"AG", "AL", "AN", "AO", "AR", "AP", "AT", "AV", "BA", "BL", "BN", "BG", "BO", "BZ", "BS", "BR", "CA", "CL", "CB", "CE", "CT", "CZ", "CH", "CO", "CS", "CR", "CN", "EN", "FE", "FI", "FG", "FR", "GE", "GO", "GR", "IM", "IS", "AQ", "SP", "LT", "LE", "LI", "LU", "MC", "MN", "OR", "MS", "MT", "ME", "MI", "MO", "NA", "NO", "NU", "PD", "PA", "BI", "PR", "PV", "PG", "PE", "PC", "PI", "PT", "PN", "PZ", "RG", "RA", "RC", "RE", "RI", "RM", "RO", "SA", "SS", "SV", "SI", "SR", "SO", "TA", "TE", "TR", "TO", "TP", "TN", "TV", "TS", "UD", "VA", "VE", "VC", "VR", "VI", "VT", "KR", "LC", "LO", "PO", "RN", "VB", "VV", "FC", "PU", "FO", "PS"};
        String[] regione = new String[]{"16", "13", "11", "20", "17", "11", "13", "05", "14", "21", "05", "10", "06", "03", "10", "14", "15", "16", "12", "05", "16", "04", "01", "10", "04", "10", "13", "16", "06", "17", "14", "08", "09", "07", "17", "09", "12", "01", "09", "08", "14", "17", "17", "11", "10", "15", "17", "02", "16", "10", "06", "05", "13", "15", "21", "16", "13", "06", "10", "19", "01", "06", "17", "17", "07", "02", "16", "06", "04", "06", "08", "08", "21", "05", "15", "09", "17", "16", "10", "14", "01", "19", "13", "16", "18", "21", "07", "07", "10", "21", "13", "21", "21", "08", "04", "10", "10", "17", "06", "13", "04", "06", "11", "06", "11"};
        int i = 0;
        while (i < provincia.length) {
            if (prov.equals(provincia[i])) {
                return regione[i];
            }
            ++i;
        }
        return "99";
    }

    public double troncaCoefficienteDeducibilita(double coefficiente) {
        double coefficienteTroncato = 0.0;
        if (coefficiente <= 0.0) {
            coefficienteTroncato = 0.0;
        } else if (coefficiente > 0.0 && coefficiente < 1.0) {
            String coefficienteString = String.valueOf(coefficiente);
            int i = coefficienteString.indexOf("E-");
            if (i > 0) {
                int fattore = Integer.parseInt(coefficienteString.substring(i + 2));
                String numero = coefficienteString.substring(0, i);
                String out = "0.";
                int c = 0;
                while (c < fattore - 1) {
                    out = String.valueOf(out) + "0";
                    ++c;
                }
                coefficienteString = String.valueOf(out) + Util.replaceString(numero, ".", "");
            }
            try {
                coefficienteTroncato = new Double(coefficienteString.substring(0, 6));
            }
            catch (StringIndexOutOfBoundsException e) {
                coefficienteTroncato = coefficiente;
            }
        } else if (coefficiente >= 1.0) {
            coefficienteTroncato = 1.0;
        }
        return coefficienteTroncato;
    }
}

