/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile14
extends JarFile
implements ResourceObject {
    private Reference manifestRef = null;
    private Reference signingDataRef = null;
    private URL resourceURL;
    private String resourceVersion;
    private File indexFile;
    private static Enumeration emptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            CachedJarFile14 cachedJarFile14 = new CachedJarFile14(new File(super.getName()), this.manifestRef, this.signingDataRef, this.resourceURL, this.resourceVersion, this.indexFile);
            MemoryCache.addResourceReference(cachedJarFile14, this.resourceURL.toString());
            return cachedJarFile14;
        }
        catch (IOException iOException) {
            throw new CloneNotSupportedException();
        }
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    private CachedJarFile14(File file, Reference reference, Reference reference2, URL uRL, String string, File file2) throws IOException {
        super(file, false);
        this.manifestRef = reference;
        this.signingDataRef = reference2;
        this.resourceURL = uRL;
        this.resourceVersion = string;
        this.indexFile = file2;
    }

    protected CachedJarFile14(CacheEntry cacheEntry) throws IOException {
        this(new File(cacheEntry.getResourceFilename()), new SoftReference<Object>(null), new SoftReference<Object>(null), new URL(cacheEntry.getURL()), cacheEntry.getVersion(), cacheEntry.getIndexFile());
    }

    public void doClose() throws IOException {
        super.close();
    }

    public void close() throws IOException {
        if (!this.isReferencedTo()) {
            Trace.println("Closing CachedJarFile " + this.getName(), TraceLevel.CACHE);
            super.close();
        }
    }

    private boolean isReferencedTo() {
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL.toString());
        return cacheEntry != null && this.indexFile != null && this.indexFile.equals(cacheEntry.getIndexFile());
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL.toString());
        if (cacheEntry == null || !this.indexFile.equals(cacheEntry.getIndexFile())) {
            String string = cacheEntry == null ? "No memory CacheEntry: " + this.resourceURL : "CachedJarFile.getCacheEntry: " + this.indexFile + " != " + cacheEntry.getIndexFile() + " for " + this.resourceURL;
            Trace.println(string, TraceLevel.CACHE);
            cacheEntry = CachedJarFile.recoverCacheEntry(this.indexFile, this.resourceURL, this.resourceVersion);
            if (cacheEntry != null) {
                this.clearReferences();
            }
        }
        return cacheEntry;
    }

    public synchronized Manifest getManifest() throws IOException {
        if (this.manifestRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manifestRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                manifest = cacheEntry.getManifest();
            } else {
                Trace.println("Warning: NULL cache entry for loaded resource!", TraceLevel.CACHE);
            }
            this.manifestRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
        }
        return manifest;
    }

    private synchronized JarSigningData getSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = (JarSigningData)this.signingDataRef.get();
        if (jarSigningData == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                jarSigningData = cacheEntry.getJarSigningData();
                this.signingDataRef = jarSigningData != null ? new SoftReference<JarSigningData>(jarSigningData) : null;
            } else {
                Trace.println("getSignerMap failed to get CacheEntry for " + this.resourceURL, TraceLevel.CACHE);
            }
        }
        return jarSigningData;
    }

    private synchronized void clearReferences() {
        CachedJarFile.clear(new Reference[]{this.manifestRef, this.signingDataRef});
    }

    Enumeration entryNames(CodeSource[] codeSourceArray) {
        JarSigningData jarSigningData = this.getSigningData();
        if (jarSigningData != null && jarSigningData.matchStrictSingleSigning(codeSourceArray)) {
            return this.unsignedEntryNames(null);
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        if (jarSigningData != null) {
            bl = jarSigningData.collectEntryNamesBySigners(codeSourceArray, arrayList);
        }
        Map map = jarSigningData != null ? jarSigningData.getSignerMap() : null;
        final Iterator iterator = arrayList.iterator();
        final Enumeration enumeration = bl ? this.unsignedEntryNames(map) : emptyEnumeration;
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                if (iterator.hasNext()) {
                    this.name = (String)iterator.next();
                    return true;
                }
                if (enumeration.hasMoreElements()) {
                    this.name = (String)enumeration.nextElement();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration unsignedEntryNames(final Map map) {
        final Enumeration enumeration = this.entries();
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || JarUtil.isSigningRelated(string) || map != null && map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    synchronized CodeSource[] getCodeSources(URL uRL) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSources(uRL) : null;
    }

    synchronized CodeSource getCodeSource(URL uRL, String string) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSource(uRL, string) : null;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile14.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            return CachedJarFile14.this.getSigningData().getCertificates(this.getName());
        }
    }
}

