/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.c;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContentInfo {
    static /* synthetic */ Class h;
    static /* synthetic */ Class f;
    static /* synthetic */ Class g;
    static /* synthetic */ Class e;
    static /* synthetic */ Class i;
    static /* synthetic */ Class j;
    byte[] b;
    Content d;
    ObjectID c;
    private static c a = new c();

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws PKCSException, IOException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.c.getName() + " {\n");
        if (this.d == null) {
            stringBuffer.append("No content!\n");
        } else {
            stringBuffer.append(String.valueOf(this.d.toString(bl)) + "\n}");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.c == null) {
            throw new PKCSException("Cannot create ASN.1 object. At least the content type must be set!");
        }
        boolean bl = true;
        bl = this.d == null ? false : this.d.getBlockSize() > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent(this.c);
        if (this.d != null) {
            CON_SPEC cON_SPEC = new CON_SPEC(0, this.d.toASN1Object());
            cON_SPEC.setIndefiniteLength(bl);
            sEQUENCE.addComponent(cON_SPEC);
        }
        return sEQUENCE;
    }

    public void setContent(Content content) {
        this.c = content.getContentType();
        this.d = content;
    }

    public static void register(ObjectID objectID, Class clazz) {
        a.register(objectID, clazz);
    }

    public boolean hasContent() {
        return this.d != null;
    }

    public ObjectID getContentType() {
        return this.c;
    }

    public InputStream getContentInputStream() {
        if (this.b == null) {
            return null;
        }
        return new ByteArrayInputStream(this.b);
    }

    public Content getContent() {
        return this.d;
    }

    public void destroyCriticalData() {
    }

    protected void decode(DerInputStream derInputStream) throws PKCSParsingException, IOException {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.c = derInputStream2.readObjectID();
        if (derInputStream2.nextTag() == -1) {
            this.d = null;
            return;
        }
        DerInputStream derInputStream3 = derInputStream2.readContextSpecific();
        try {
            this.d = ContentInfo.create(this.c);
        }
        catch (PKCSException pKCSException) {
            throw new PKCSParsingException(pKCSException.getMessage());
        }
        TracedInputStream tracedInputStream = new TracedInputStream(derInputStream3);
        this.d.decode(tracedInputStream);
        this.b = tracedInputStream.getTracedData();
        derInputStream3.readEOC();
    }

    public static Content create(ObjectID objectID, ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            Content content = ContentInfo.create(objectID);
            content.decode(aSN1Object);
            return content;
        }
        catch (PKCSException pKCSException) {
            throw new PKCSParsingException(pKCSException.getMessage());
        }
    }

    public static Content create(ObjectID objectID) throws PKCSException {
        try {
            return (Content)a.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            throw new PKCSException("No PKCS#7 type registered for the given object ID!");
        }
    }

    public ContentInfo(InputStream inputStream) throws PKCSParsingException, IOException {
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
            return;
        }
        this.decode(new DerInputStream(inputStream));
    }

    public ContentInfo(Content content) {
        this.c = content.getContentType();
        this.d = content;
    }

    public ContentInfo(ObjectID objectID) {
        this.c = objectID;
        this.d = null;
    }

    public ContentInfo(ASN1Object aSN1Object) throws PKCSParsingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DerCoder.encode(aSN1Object));
        try {
            this.decode(new DerInputStream(byteArrayInputStream));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException("Error parsing ContentInfo: " + iOException.getMessage());
        }
    }

    private ContentInfo() {
    }

    static {
        ContentInfo.register(ObjectID.pkcs7_data, j != null ? j : (j = ContentInfo.a("iaik.pkcs.pkcs7.Data")));
        ContentInfo.register(ObjectID.pkcs7_digestedData, i != null ? i : (i = ContentInfo.a("iaik.pkcs.pkcs7.DigestedData")));
        ContentInfo.register(ObjectID.pkcs7_signedData, e != null ? e : (e = ContentInfo.a("iaik.pkcs.pkcs7.SignedData")));
        ContentInfo.register(ObjectID.pkcs7_envelopedData, g != null ? g : (g = ContentInfo.a("iaik.pkcs.pkcs7.EnvelopedData")));
        ContentInfo.register(ObjectID.pkcs7_signedAndEnvelopedData, f != null ? f : (f = ContentInfo.a("iaik.pkcs.pkcs7.SignedAndEnvelopedData")));
        ContentInfo.register(ObjectID.pkcs7_encryptedData, h != null ? h : (h = ContentInfo.a("iaik.pkcs.pkcs7.EncryptedData")));
    }
}

