/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSCharsetRuleImpl;
import com.sun.webpane.webkit.dom.CSSFontFaceRuleImpl;
import com.sun.webpane.webkit.dom.CSSImportRuleImpl;
import com.sun.webpane.webkit.dom.CSSMediaRuleImpl;
import com.sun.webpane.webkit.dom.CSSPageRuleImpl;
import com.sun.webpane.webkit.dom.CSSStyleRuleImpl;
import com.sun.webpane.webkit.dom.CSSStyleSheetImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSRuleImpl
implements CSSRule {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;
    public static final int UNKNOWN_RULE = 0;
    public static final int STYLE_RULE = 1;
    public static final int CHARSET_RULE = 2;
    public static final int IMPORT_RULE = 3;
    public static final int MEDIA_RULE = 4;
    public static final int FONT_FACE_RULE = 5;
    public static final int PAGE_RULE = 6;
    public static final int WEBKIT_KEYFRAMES_RULE = 8;
    public static final int WEBKIT_KEYFRAME_RULE = 9;
    public static final int WEBKIT_REGION_RULE = 10;

    CSSRuleImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static CSSRule create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        switch (CSSRuleImpl.getTypeImpl(peer)) {
            case 1: {
                return new CSSStyleRuleImpl(peer, contextPeer, rootPeer);
            }
            case 2: {
                return new CSSCharsetRuleImpl(peer, contextPeer, rootPeer);
            }
            case 3: {
                return new CSSImportRuleImpl(peer, contextPeer, rootPeer);
            }
            case 4: {
                return new CSSMediaRuleImpl(peer, contextPeer, rootPeer);
            }
            case 5: {
                return new CSSFontFaceRuleImpl(peer, contextPeer, rootPeer);
            }
            case 6: {
                return new CSSPageRuleImpl(peer, contextPeer, rootPeer);
            }
        }
        return new CSSRuleImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(CSSRule arg) {
        return arg == null ? 0L : ((CSSRuleImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof CSSRuleImpl && this.peer == ((CSSRuleImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static CSSRule getImpl(long peer, long contextPeer, long rootPeer) {
        return CSSRuleImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public short getType() {
        return CSSRuleImpl.getTypeImpl(this.getPeer());
    }

    static native short getTypeImpl(long var0);

    @Override
    public String getCssText() {
        return CSSRuleImpl.getCssTextImpl(this.getPeer());
    }

    static native String getCssTextImpl(long var0);

    @Override
    public void setCssText(String value) throws DOMException {
        CSSRuleImpl.setCssTextImpl(this.getPeer(), value);
    }

    static native void setCssTextImpl(long var0, String var2);

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return CSSStyleSheetImpl.getImpl(CSSRuleImpl.getParentStyleSheetImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getParentStyleSheetImpl(long var0);

    @Override
    public CSSRule getParentRule() {
        return CSSRuleImpl.getImpl(CSSRuleImpl.getParentRuleImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getParentRuleImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            CSSRuleImpl.dispose(this.peer);
        }
    }
}

