/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.Utils;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.Area;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.layout.region.ShapeChangeListener;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public abstract class Shape
extends Node {
    @Deprecated
    protected PGShape.Mode impl_mode = PGShape.Mode.FILL;
    private ObjectProperty<Paint> fill;
    private ObjectProperty<Paint> stroke;
    private BooleanProperty smooth;
    private static final double MIN_STROKE_WIDTH = 0.0;
    private static final double MIN_STROKE_MITER_LIMIT = 1.0;
    private ShapeChangeListener shapeChangeListener;
    private boolean strokeAttributesDirty = true;
    private StrokeAttributes strokeAttributes;
    private static final StrokeType DEFAULT_STROKE_TYPE = StrokeType.CENTERED;
    private static final double DEFAULT_STROKE_WIDTH = 1.0;
    private static final StrokeLineJoin DEFAULT_STROKE_LINE_JOIN = StrokeLineJoin.MITER;
    private static final StrokeLineCap DEFAULT_STROKE_LINE_CAP = StrokeLineCap.SQUARE;
    private static final double DEFAULT_STROKE_MITER_LIMIT = 10.0;
    private static final double DEFAULT_STROKE_DASH_OFFSET = 0.0;
    private static final float[] DEFAULT_PG_STROKE_DASH_ARRAY = new float[0];

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        throw new AssertionError((Object)"Subclasses of Shape must implement impl_createPGNode");
    }

    PGShape getPGShape() {
        return (PGShape)this.impl_getPGNode();
    }

    PGShape.StrokeType toPGStrokeType(StrokeType strokeType) {
        if (strokeType == StrokeType.INSIDE) {
            return PGShape.StrokeType.INSIDE;
        }
        if (strokeType == StrokeType.OUTSIDE) {
            return PGShape.StrokeType.OUTSIDE;
        }
        return PGShape.StrokeType.CENTERED;
    }

    PGShape.StrokeLineCap toPGLineCap(StrokeLineCap strokeLineCap) {
        if (strokeLineCap == StrokeLineCap.SQUARE) {
            return PGShape.StrokeLineCap.SQUARE;
        }
        if (strokeLineCap == StrokeLineCap.BUTT) {
            return PGShape.StrokeLineCap.BUTT;
        }
        return PGShape.StrokeLineCap.ROUND;
    }

    @Deprecated
    protected PGShape.StrokeLineJoin toPGLineJoin(StrokeLineJoin strokeLineJoin) {
        if (strokeLineJoin == StrokeLineJoin.MITER) {
            return PGShape.StrokeLineJoin.MITER;
        }
        if (strokeLineJoin == StrokeLineJoin.BEVEL) {
            return PGShape.StrokeLineJoin.BEVEL;
        }
        return PGShape.StrokeLineJoin.ROUND;
    }

    public final void setStrokeType(StrokeType strokeType) {
        this.strokeTypeProperty().set(strokeType);
    }

    public final StrokeType getStrokeType() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_TYPE : this.strokeAttributes.getType();
    }

    public final ObjectProperty<StrokeType> strokeTypeProperty() {
        return this.getStrokeAttributes().typeProperty();
    }

    public final void setStrokeWidth(double d) {
        this.strokeWidthProperty().set(d);
    }

    public final double getStrokeWidth() {
        return this.strokeAttributes == null ? 1.0 : this.strokeAttributes.getWidth();
    }

    public final DoubleProperty strokeWidthProperty() {
        return this.getStrokeAttributes().widthProperty();
    }

    public final void setStrokeLineJoin(StrokeLineJoin strokeLineJoin) {
        this.strokeLineJoinProperty().set(strokeLineJoin);
    }

    public final StrokeLineJoin getStrokeLineJoin() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_LINE_JOIN : this.strokeAttributes.getLineJoin();
    }

    public final ObjectProperty<StrokeLineJoin> strokeLineJoinProperty() {
        return this.getStrokeAttributes().lineJoinProperty();
    }

    public final void setStrokeLineCap(StrokeLineCap strokeLineCap) {
        this.strokeLineCapProperty().set(strokeLineCap);
    }

    public final StrokeLineCap getStrokeLineCap() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_LINE_CAP : this.strokeAttributes.getLineCap();
    }

    public final ObjectProperty<StrokeLineCap> strokeLineCapProperty() {
        return this.getStrokeAttributes().lineCapProperty();
    }

    public final void setStrokeMiterLimit(double d) {
        this.strokeMiterLimitProperty().set(d);
    }

    public final double getStrokeMiterLimit() {
        return this.strokeAttributes == null ? 10.0 : this.strokeAttributes.getMiterLimit();
    }

    public final DoubleProperty strokeMiterLimitProperty() {
        return this.getStrokeAttributes().miterLimitProperty();
    }

    public final void setStrokeDashOffset(double d) {
        this.strokeDashOffsetProperty().set(d);
    }

    public final double getStrokeDashOffset() {
        return this.strokeAttributes == null ? 0.0 : this.strokeAttributes.getDashOffset();
    }

    public final DoubleProperty strokeDashOffsetProperty() {
        return this.getStrokeAttributes().dashOffsetProperty();
    }

    public final ObservableList<Double> getStrokeDashArray() {
        return this.getStrokeAttributes().dashArrayProperty();
    }

    private PGShape.Mode computeMode() {
        if (this.getFill() != null && this.getStroke() != null) {
            return PGShape.Mode.STROKE_FILL;
        }
        if (this.getFill() != null) {
            return PGShape.Mode.FILL;
        }
        if (this.getStroke() != null) {
            return PGShape.Mode.STROKE;
        }
        return PGShape.Mode.EMPTY;
    }

    private void checkModeChanged() {
        PGShape.Mode mode = this.computeMode();
        if (this.impl_mode != mode) {
            this.impl_mode = mode;
            this.impl_markDirty(DirtyBits.SHAPE_MODE);
            this.impl_geomChanged();
        }
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        return this.fill == null ? Color.BLACK : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                @Override
                public void invalidated() {
                    Shape.this.impl_markDirty(DirtyBits.SHAPE_FILL);
                    Shape.this.checkModeChanged();
                    Shape.this.impl_strokeOrFillChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FILL;
                }

                @Override
                public Object getBean() {
                    return Shape.this;
                }

                @Override
                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    public final void setStroke(Paint paint) {
        this.strokeProperty().set(paint);
    }

    public final Paint getStroke() {
        return this.stroke == null ? null : (Paint)this.stroke.get();
    }

    public final ObjectProperty<Paint> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new StyleableObjectProperty<Paint>(){

                @Override
                public void invalidated() {
                    Shape.this.impl_markDirty(DirtyBits.SHAPE_STROKE);
                    Shape.this.checkModeChanged();
                    Shape.this.impl_strokeOrFillChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.STROKE;
                }

                @Override
                public Object getBean() {
                    return Shape.this;
                }

                @Override
                public String getName() {
                    return "stroke";
                }
            };
        }
        return this.stroke;
    }

    @Deprecated
    protected void impl_strokeOrFillChanged() {
    }

    public final void setSmooth(boolean bl) {
        this.smoothProperty().set(bl);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? true : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Shape.this.impl_markDirty(DirtyBits.NODE_SMOOTH);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SMOOTH;
                }

                @Override
                public Object getBean() {
                    return Shape.this;
                }

                @Override
                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    @Deprecated
    protected Paint impl_cssGetFillInitialValue() {
        return Color.BLACK;
    }

    @Deprecated
    protected Paint impl_cssGetStrokeInitialValue() {
        return null;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Shape.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        return this.computeShapeBounds(baseBounds, baseTransform, this.impl_configShape());
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return this.computeShapeContains(d, d2, this.impl_configShape());
    }

    @Deprecated
    public abstract com.sun.javafx.geom.Shape impl_configShape();

    private void updatePGShape() {
        Object object;
        if (this.strokeAttributesDirty && this.getStroke() != null) {
            object = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
            this.getPGShape().setDrawStroke((float)Utils.clampMin(this.getStrokeWidth(), 0.0), this.toPGStrokeType(this.getStrokeType()), this.toPGLineCap(this.getStrokeLineCap()), this.toPGLineJoin(this.getStrokeLineJoin()), (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0), (float[])object, (float)this.getStrokeDashOffset());
            this.strokeAttributesDirty = false;
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_MODE)) {
            this.getPGShape().setMode(this.impl_mode);
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_FILL)) {
            object = this.getFill();
            this.getPGShape().setFillPaint(object == null ? null : ((Paint)object).impl_getPlatformPaint());
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_STROKE)) {
            object = this.getStroke();
            this.getPGShape().setDrawPaint(object == null ? null : ((Paint)object).impl_getPlatformPaint());
        }
        if (this.impl_isDirty(DirtyBits.NODE_SMOOTH)) {
            this.getPGShape().setAntialiased(this.isSmooth());
        }
    }

    @Override
    @Deprecated
    protected void impl_markDirty(DirtyBits dirtyBits) {
        if (this.shapeChangeListener != null && this.impl_isDirtyEmpty()) {
            this.shapeChangeListener.changed();
        }
        super.impl_markDirty(dirtyBits);
    }

    @Deprecated
    public void impl_setShapeChangeListener(ShapeChangeListener shapeChangeListener) {
        this.shapeChangeListener = shapeChangeListener;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        this.updatePGShape();
    }

    BaseBounds computeBounds(BaseBounds baseBounds, BaseTransform baseTransform, double d, double d2, double d3, double d4, double d5, double d6) {
        if (d5 < 0.0 || d6 < 0.0) {
            return baseBounds.makeEmpty();
        }
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        double d10 = d6;
        double d11 = d2;
        if (baseTransform.isTranslateOrIdentity()) {
            d9 += d7;
            d10 += d8;
            if (baseTransform.getType() == 1) {
                double d12 = baseTransform.getMxt();
                double d13 = baseTransform.getMyt();
                d7 += d12;
                d8 += d13;
                d9 += d12;
                d10 += d13;
            }
            d11 += d;
        } else {
            d7 -= d;
            d8 -= d;
            d9 += d * 2.0;
            d10 += d * 2.0;
            double d14 = baseTransform.getMxx();
            double d15 = baseTransform.getMxy();
            double d16 = baseTransform.getMyx();
            double d17 = baseTransform.getMyy();
            double d18 = d7 * d14 + d8 * d15 + baseTransform.getMxt();
            double d19 = d7 * d16 + d8 * d17 + baseTransform.getMyt();
            d7 = Math.min(Math.min(0.0, d14 *= d9), Math.min(d15 *= d10, d14 + d15)) + d18;
            d8 = Math.min(Math.min(0.0, d16 *= d9), Math.min(d17 *= d10, d16 + d17)) + d19;
            d9 = Math.max(Math.max(0.0, d14), Math.max(d15, d14 + d15)) + d18;
            d10 = Math.max(Math.max(0.0, d16), Math.max(d17, d16 + d17)) + d19;
        }
        baseBounds = baseBounds.deriveWithNewBounds((float)(d7 -= d11), (float)(d8 -= d11), 0.0f, (float)(d9 += d11), (float)(d10 += d11), 0.0f);
        return baseBounds;
    }

    BaseBounds computeShapeBounds(BaseBounds baseBounds, BaseTransform baseTransform, com.sun.javafx.geom.Shape shape) {
        boolean bl;
        if (this.impl_mode == PGShape.Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        boolean bl2 = this.impl_mode != PGShape.Mode.STROKE;
        boolean bl3 = bl = this.impl_mode != PGShape.Mode.FILL;
        if (bl && this.getStrokeType() == StrokeType.INSIDE) {
            bl2 = true;
            bl = false;
        }
        if (bl) {
            PGShape.StrokeType strokeType = this.toPGStrokeType(this.getStrokeType());
            double d = Utils.clampMin(this.getStrokeWidth(), 0.0);
            PGShape.StrokeLineCap strokeLineCap = this.toPGLineCap(this.getStrokeLineCap());
            PGShape.StrokeLineJoin strokeLineJoin = this.toPGLineJoin(this.getStrokeLineJoin());
            float f = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            Toolkit.getToolkit().accumulateStrokeBounds(shape, fArray, strokeType, d, strokeLineCap, strokeLineJoin, f, baseTransform);
            fArray[0] = (float)((double)fArray[0] - 0.5);
            fArray[1] = (float)((double)fArray[1] - 0.5);
            fArray[2] = (float)((double)fArray[2] + 0.5);
            fArray[3] = (float)((double)fArray[3] + 0.5);
        } else if (bl2) {
            com.sun.javafx.geom.Shape.accumulate(fArray, shape, baseTransform);
        }
        if (fArray[2] < fArray[0] || fArray[3] < fArray[1]) {
            return baseBounds.makeEmpty();
        }
        baseBounds = baseBounds.deriveWithNewBounds(fArray[0], fArray[1], 0.0f, fArray[2], fArray[3], 0.0f);
        return baseBounds;
    }

    boolean computeShapeContains(double d, double d2, com.sun.javafx.geom.Shape shape) {
        boolean bl;
        if (this.impl_mode == PGShape.Mode.EMPTY) {
            return false;
        }
        boolean bl2 = this.impl_mode != PGShape.Mode.STROKE;
        boolean bl3 = bl = this.impl_mode != PGShape.Mode.FILL;
        if (bl && bl2 && this.getStrokeType() == StrokeType.INSIDE) {
            bl = false;
        }
        if (bl2 && shape.contains((float)d, (float)d2)) {
            return true;
        }
        if (bl) {
            PGShape.StrokeType strokeType = this.toPGStrokeType(this.getStrokeType());
            double d3 = Utils.clampMin(this.getStrokeWidth(), 0.0);
            PGShape.StrokeLineCap strokeLineCap = this.toPGLineCap(this.getStrokeLineCap());
            PGShape.StrokeLineJoin strokeLineJoin = this.toPGLineJoin(this.getStrokeLineJoin());
            float f = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            return Toolkit.getToolkit().strokeContains(shape, d, d2, strokeType, d3, strokeLineCap, strokeLineJoin, f);
        }
        return false;
    }

    private StrokeAttributes getStrokeAttributes() {
        if (this.strokeAttributes == null) {
            this.strokeAttributes = new StrokeAttributes();
        }
        return this.strokeAttributes;
    }

    private boolean hasStrokeDashArray() {
        return this.strokeAttributes != null && this.strokeAttributes.hasDashArray();
    }

    private static float[] toPGDashArray(List<Double> list) {
        int n = list.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = list.get(i).floatValue();
        }
        return fArray;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processLeafNode(this, mXNodeAlgorithmContext);
    }

    public static Shape union(Shape shape, Shape shape2) {
        Area area = shape.getTransformedArea();
        area.add(shape2.getTransformedArea());
        return Shape.createFromGeomShape(area);
    }

    public static Shape subtract(Shape shape, Shape shape2) {
        Area area = shape.getTransformedArea();
        area.subtract(shape2.getTransformedArea());
        return Shape.createFromGeomShape(area);
    }

    public static Shape intersect(Shape shape, Shape shape2) {
        Area area = shape.getTransformedArea();
        area.intersect(shape2.getTransformedArea());
        return Shape.createFromGeomShape(area);
    }

    private Area getTransformedArea() {
        return this.getTransformedArea(Shape.calculateNodeToSceneTransform(this));
    }

    private Area getTransformedArea(BaseTransform baseTransform) {
        if (this.impl_mode == PGShape.Mode.EMPTY) {
            return new Area();
        }
        com.sun.javafx.geom.Shape shape = this.impl_configShape();
        if (this.impl_mode == PGShape.Mode.FILL || this.impl_mode == PGShape.Mode.STROKE_FILL && this.getStrokeType() == StrokeType.INSIDE) {
            return Shape.createTransformedArea(shape, baseTransform);
        }
        PGShape.StrokeType strokeType = this.toPGStrokeType(this.getStrokeType());
        double d = Utils.clampMin(this.getStrokeWidth(), 0.0);
        PGShape.StrokeLineCap strokeLineCap = this.toPGLineCap(this.getStrokeLineCap());
        PGShape.StrokeLineJoin strokeLineJoin = this.toPGLineJoin(this.getStrokeLineJoin());
        float f = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
        float[] fArray = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
        com.sun.javafx.geom.Shape shape2 = Toolkit.getToolkit().createStrokedShape(shape, strokeType, d, strokeLineCap, strokeLineJoin, f, fArray, (float)this.getStrokeDashOffset());
        if (this.impl_mode == PGShape.Mode.STROKE) {
            return Shape.createTransformedArea(shape2, baseTransform);
        }
        Area area = new Area(shape);
        area.add(new Area(shape2));
        return Shape.createTransformedArea(area, baseTransform);
    }

    private static BaseTransform calculateNodeToSceneTransform(Node node) {
        Affine3D affine3D = new Affine3D();
        do {
            affine3D.preConcatenate(node.impl_getLeafTransform());
        } while ((node = node.getParent()) != null);
        return affine3D;
    }

    private static Area createTransformedArea(com.sun.javafx.geom.Shape shape, BaseTransform baseTransform) {
        return baseTransform.isIdentity() ? new Area(shape) : new Area(shape.getPathIterator(baseTransform));
    }

    private static Path createFromGeomShape(com.sun.javafx.geom.Shape shape) {
        Path path = new Path();
        ObservableList<PathElement> observableList = path.getElements();
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    observableList.add(new MoveTo(fArray[0], fArray[1]));
                    break;
                }
                case 1: {
                    observableList.add(new LineTo(fArray[0], fArray[1]));
                    break;
                }
                case 2: {
                    observableList.add(new QuadCurveTo(fArray[0], fArray[1], fArray[2], fArray[3]));
                    break;
                }
                case 3: {
                    observableList.add(new CubicCurveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]));
                    break;
                }
                case 4: {
                    observableList.add(new ClosePath());
                }
            }
            pathIterator.next();
        }
        path.setFillRule(pathIterator.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        path.setFill(Color.BLACK);
        path.setStroke(null);
        return path;
    }

    private final class StrokeAttributes {
        private ObjectProperty<StrokeType> type;
        private DoubleProperty width;
        private ObjectProperty<StrokeLineJoin> lineJoin;
        private ObjectProperty<StrokeLineCap> lineCap;
        private DoubleProperty miterLimit;
        private DoubleProperty dashOffset;
        private ObservableList<Double> dashArray;
        private ObjectProperty<Double[]> cssDashArray = null;

        private StrokeAttributes() {
        }

        public final StrokeType getType() {
            return this.type == null ? DEFAULT_STROKE_TYPE : (StrokeType)((Object)this.type.get());
        }

        public final ObjectProperty<StrokeType> typeProperty() {
            if (this.type == null) {
                this.type = new StyleableObjectProperty<StrokeType>(DEFAULT_STROKE_TYPE){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_TYPE);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_TYPE;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeType";
                    }
                };
            }
            return this.type;
        }

        public double getWidth() {
            return this.width == null ? 1.0 : this.width.get();
        }

        public final DoubleProperty widthProperty() {
            if (this.width == null) {
                this.width = new StyleableDoubleProperty(1.0){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_WIDTH);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_WIDTH;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeWidth";
                    }
                };
            }
            return this.width;
        }

        public StrokeLineJoin getLineJoin() {
            return this.lineJoin == null ? DEFAULT_STROKE_LINE_JOIN : (StrokeLineJoin)((Object)this.lineJoin.get());
        }

        public final ObjectProperty<StrokeLineJoin> lineJoinProperty() {
            if (this.lineJoin == null) {
                this.lineJoin = new StyleableObjectProperty<StrokeLineJoin>(DEFAULT_STROKE_LINE_JOIN){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_LINE_JOIN);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_LINE_JOIN;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeLineJoin";
                    }
                };
            }
            return this.lineJoin;
        }

        public StrokeLineCap getLineCap() {
            return this.lineCap == null ? DEFAULT_STROKE_LINE_CAP : (StrokeLineCap)((Object)this.lineCap.get());
        }

        public final ObjectProperty<StrokeLineCap> lineCapProperty() {
            if (this.lineCap == null) {
                this.lineCap = new StyleableObjectProperty<StrokeLineCap>(DEFAULT_STROKE_LINE_CAP){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_LINE_CAP);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_LINE_CAP;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeLineCap";
                    }
                };
            }
            return this.lineCap;
        }

        public double getMiterLimit() {
            return this.miterLimit == null ? 10.0 : this.miterLimit.get();
        }

        public final DoubleProperty miterLimitProperty() {
            if (this.miterLimit == null) {
                this.miterLimit = new StyleableDoubleProperty(10.0){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_MITER_LIMIT);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_MITER_LIMIT;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeMiterLimit";
                    }
                };
            }
            return this.miterLimit;
        }

        public double getDashOffset() {
            return this.dashOffset == null ? 0.0 : this.dashOffset.get();
        }

        public final DoubleProperty dashOffsetProperty() {
            if (this.dashOffset == null) {
                this.dashOffset = new StyleableDoubleProperty(0.0){

                    @Override
                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_DASH_OFFSET);
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_DASH_OFFSET;
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "strokeDashOffset";
                    }
                };
            }
            return this.dashOffset;
        }

        public ObservableList<Double> dashArrayProperty() {
            if (this.dashArray == null) {
                this.dashArray = new TrackableObservableList<Double>(){

                    @Override
                    protected void onChanged(ListChangeListener.Change<Double> change) {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_DASH_ARRAY);
                    }
                };
            }
            return this.dashArray;
        }

        private ObjectProperty<Double[]> cssDashArrayProperty() {
            if (this.cssDashArray == null) {
                this.cssDashArray = new StyleableObjectProperty<Double[]>(){

                    @Override
                    public void set(Double[] doubleArray) {
                        ObservableList<Double> observableList = StrokeAttributes.this.dashArrayProperty();
                        observableList.clear();
                        if (doubleArray != null && doubleArray.length > 0) {
                            observableList.addAll((Double[])doubleArray);
                        }
                    }

                    @Override
                    public Double[] get() {
                        ObservableList<Double> observableList = StrokeAttributes.this.dashArrayProperty();
                        return observableList.toArray(new Double[observableList.size()]);
                    }

                    @Override
                    public Object getBean() {
                        return Shape.this;
                    }

                    @Override
                    public String getName() {
                        return "cssDashArray";
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.STROKE_DASH_ARRAY;
                    }
                };
            }
            return this.cssDashArray;
        }

        public boolean canSetType() {
            return this.type == null || !this.type.isBound();
        }

        public boolean canSetWidth() {
            return this.width == null || !this.width.isBound();
        }

        public boolean canSetLineJoin() {
            return this.lineJoin == null || !this.lineJoin.isBound();
        }

        public boolean canSetLineCap() {
            return this.lineCap == null || !this.lineCap.isBound();
        }

        public boolean canSetMiterLimit() {
            return this.miterLimit == null || !this.miterLimit.isBound();
        }

        public boolean canSetDashOffset() {
            return this.dashOffset == null || !this.dashOffset.isBound();
        }

        public boolean hasDashArray() {
            return this.dashArray != null;
        }

        private void invalidated(StyleableProperty styleableProperty) {
            Shape.this.impl_markDirty(DirtyBits.SHAPE_STROKEATTRS);
            Shape.this.strokeAttributesDirty = true;
            if (styleableProperty != StyleableProperties.STROKE_DASH_OFFSET) {
                Shape.this.impl_geomChanged();
            }
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Shape, Paint> FILL = new StyleableProperty<Shape, Paint>("-fx-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.fill == null || !shape.fill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(Shape shape) {
                return shape.fillProperty();
            }

            @Override
            public Paint getInitialValue(Shape shape) {
                return shape.impl_cssGetFillInitialValue();
            }
        };
        private static final StyleableProperty<Shape, Boolean> SMOOTH = new StyleableProperty<Shape, Boolean>("-fx-smooth", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.smooth == null || !shape.smooth.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Shape shape) {
                return shape.smoothProperty();
            }
        };
        private static final StyleableProperty<Shape, Paint> STROKE = new StyleableProperty<Shape, Paint>("-fx-stroke", (StyleConverter)PaintConverter.getInstance()){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.stroke == null || !shape.stroke.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(Shape shape) {
                return shape.strokeProperty();
            }

            @Override
            public Paint getInitialValue(Shape shape) {
                return shape.impl_cssGetStrokeInitialValue();
            }
        };
        private static final StyleableProperty<Shape, Double[]> STROKE_DASH_ARRAY = new StyleableProperty<Shape, Double[]>("-fx-stroke-dash-array", (StyleConverter)SizeConverter.SequenceConverter.getInstance(), new Double[0]){

            @Override
            public boolean isSettable(Shape shape) {
                return true;
            }

            @Override
            public WritableValue<Double[]> getWritableValue(Shape shape) {
                return shape.getStrokeAttributes().cssDashArrayProperty();
            }
        };
        private static final StyleableProperty<Shape, Number> STROKE_DASH_OFFSET = new StyleableProperty<Shape, Number>("-fx-stroke-dash-offset", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetDashOffset();
            }

            @Override
            public WritableValue<Number> getWritableValue(Shape shape) {
                return shape.strokeDashOffsetProperty();
            }
        };
        private static final StyleableProperty<Shape, StrokeLineCap> STROKE_LINE_CAP = new StyleableProperty<Shape, StrokeLineCap>("-fx-stroke-line-cap", new EnumConverter(StrokeLineCap.class), StrokeLineCap.SQUARE){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetLineCap();
            }

            @Override
            public WritableValue<StrokeLineCap> getWritableValue(Shape shape) {
                return shape.strokeLineCapProperty();
            }
        };
        private static final StyleableProperty<Shape, StrokeLineJoin> STROKE_LINE_JOIN = new StyleableProperty<Shape, StrokeLineJoin>("-fx-stroke-line-join", new EnumConverter(StrokeLineJoin.class), StrokeLineJoin.MITER){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetLineJoin();
            }

            @Override
            public WritableValue<StrokeLineJoin> getWritableValue(Shape shape) {
                return shape.strokeLineJoinProperty();
            }
        };
        private static final StyleableProperty<Shape, StrokeType> STROKE_TYPE = new StyleableProperty<Shape, StrokeType>("-fx-stroke-type", new EnumConverter(StrokeType.class), StrokeType.CENTERED){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetType();
            }

            @Override
            public WritableValue<StrokeType> getWritableValue(Shape shape) {
                return shape.strokeTypeProperty();
            }
        };
        private static final StyleableProperty<Shape, Number> STROKE_MITER_LIMIT = new StyleableProperty<Shape, Number>("-fx-stroke-miter-limit", (StyleConverter)SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetMiterLimit();
            }

            @Override
            public WritableValue<Number> getWritableValue(Shape shape) {
                return shape.strokeMiterLimitProperty();
            }
        };
        private static final StyleableProperty STROKE_WIDTH = new StyleableProperty<Shape, Number>("-fx-stroke-width", (StyleConverter)SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Shape shape) {
                return shape.strokeAttributes == null || shape.strokeAttributes.canSetWidth();
            }

            @Override
            public WritableValue<Number> getWritableValue(Shape shape) {
                return shape.strokeWidthProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Node.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FILL, SMOOTH, STROKE, STROKE_DASH_ARRAY, STROKE_DASH_OFFSET, STROKE_LINE_CAP, STROKE_LINE_JOIN, STROKE_TYPE, STROKE_MITER_LIMIT, STROKE_WIDTH);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

