/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SyntheticRepository
implements Repository {
    private final Map<String, SoftReference<JavaClass>> loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository() {
    }

    public static SyntheticRepository getInstance() {
        return new SyntheticRepository();
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        SoftReference<JavaClass> ref = this.loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        IOException e = new IOException("Couldn't find: " + className + ".class");
        throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        JavaClass repositoryClass = this.findClass(className);
        if (repositoryClass != null) {
            return repositoryClass;
        }
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        JavaClass cls = null;
        try (InputStream clsStream = clazz.getResourceAsStream(name + ".class");){
            JavaClass javaClass = cls = this.loadClass(clsStream, className);
            return javaClass;
        }
        catch (IOException e) {
            return cls;
        }
    }

    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                JavaClass javaClass = clazz;
                return javaClass;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

